/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.ui.util;

import de.proveo.xml.fleet_management.meta_1.MetadataList;
import de.proveo.xml.fleet_management.statemodel_layer_mapping_1.ImageType;
import de.proveo.xml.fleet_management.statemodel_layer_mapping_1.StateModelLayerMapping;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.xml.sax.SAXException;

public class StatusModelSVGMapping {
    private static final Logger log = Logger.getLogger(StatusModelSVGMapping.class.getName());
    private List<ImageType> imageTypeList = this.getDefaults();
    private Map<String, Map<String, Integer>> mappings;
    private final String DEFAULT_UNIT_TYPE = "Default";
    private Map<String, String> svgIDs;

    public StatusModelSVGMapping() {
        this.index();
    }

    public void setStatusModelSVGMapping(String xml) {
        this.imageTypeList = this.getSvgMappingFromXML(xml);
        this.index();
    }

    public String getSvgId(String unitSymbol, int statusModelId) {
        String method = "getSvgId(): ";
        String svgId = "";
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "{0} for unit type ''{1}'' and status model ''{2}''", new Object[]{method, unitSymbol, statusModelId});
        }
        if ((unitSymbol = this.checkUnitSymbol(unitSymbol)).isEmpty()) {
            return svgId;
        }
        String key = unitSymbol + statusModelId;
        if (!this.svgIDs.containsKey(key)) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0} unit type ''{1}'' has no SVG mapping for status model ''{2}''", new Object[]{method, unitSymbol, statusModelId});
            }
            return "";
        }
        return this.svgIDs.get(key);
    }

    public Map<String, Integer> getMapping(String unitSymbol) {
        String method = "getMapping(): ";
        if ((unitSymbol = this.checkUnitSymbol(unitSymbol)).isEmpty()) {
            return new HashMap<String, Integer>();
        }
        Map<String, Integer> mapping = this.mappings.get(unitSymbol);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "{0} mapping for unit symbol ''{1}'' contains {2} entries", new Object[]{method, unitSymbol, mapping.size()});
        }
        return mapping;
    }

    private void index() {
        String method = "index(): ";
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "{0}START", method);
        }
        this.mappings = new HashMap<String, Map<String, Integer>>();
        this.svgIDs = new HashMap<String, String>();
        for (ImageType type : this.imageTypeList) {
            List mappingSet = type.getMapping();
            String unitSymbol = type.getId();
            HashMap<String, Integer> singleSymbolMapping = new HashMap<String, Integer>();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}found unit symbol ''{1}'' containing {2} SVG mappings:", new Object[]{method, unitSymbol, mappingSet.size()});
            }
            for (ImageType.Mapping mapping : mappingSet) {
                int statusModelId = mapping.getStateModelId();
                String svgId = mapping.getLayerId();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "{0}    SVG ID ''{1}'' shows state model ID ''{2}''", new Object[]{method, svgId, statusModelId});
                }
                this.svgIDs.put(unitSymbol + statusModelId, svgId);
                singleSymbolMapping.put(svgId, statusModelId);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}  add mapping for unit symbol ''{1}'' to ''mappings'', size={2}", new Object[]{method, unitSymbol, singleSymbolMapping.size()});
            }
            this.mappings.put(unitSymbol, singleSymbolMapping);
        }
    }

    public Set<String> getUnitSymbolSet() {
        return this.mappings.keySet();
    }

    private String checkUnitSymbol(String unitSymbol) {
        String method = "checkUnitSymbol(): ";
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "{0} for unit symbol ''{1}''", new Object[]{method, unitSymbol});
        }
        if (!this.mappings.keySet().contains(unitSymbol)) {
            log.log(Level.WARNING, "{0} unknown unit symbol ''{1}'', switch to default unit type ''Default''!", new Object[]{method, unitSymbol});
            unitSymbol = "Default";
            if (!this.mappings.keySet().contains(unitSymbol)) {
                log.log(Level.SEVERE, "{0} there is no default unit symbol''{1}''!", new Object[]{method, unitSymbol});
                unitSymbol = "";
            }
        }
        return unitSymbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImageType> getSvgMappingFromXML(String xml) {
        String method = "getSvgMappingFromXML(): ";
        StringReader xmlReader = new StringReader(xml);
        try {
            List<ImageType> list = this.unmarshalXml(new StreamSource(xmlReader));
            return list;
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, method + "Could not convert given state models svg mappings xml: " + xml, ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)xmlReader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImageType> getDefaults() {
        String method = "getDefaults(): ";
        InputStream is = StateModelLayerMapping.class.getResourceAsStream("statemodel-layer-mapping-1.0.xml");
        try {
            List<ImageType> list = this.unmarshalXml(new StreamSource(is));
            return list;
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, method + "Could not convert state model svg mapping defaults xml", ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return null;
    }

    private List<ImageType> unmarshalXml(StreamSource xmlSource) throws JAXBException, SAXException {
        String method = "unmarshalXml(): ";
        if (xmlSource == null) {
            log.log(Level.SEVERE, "{0}Can not convert null or empty source. Break", method);
            return null;
        }
        Source[] xsdSources = new Source[]{new StreamSource(MetadataList.class.getResourceAsStream("meta-1.0.xsd")), new StreamSource(StateModelLayerMapping.class.getResourceAsStream("statemodel-layer-mapping-1.0.xsd"))};
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(xsdSources);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{StateModelLayerMapping.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setSchema(schema);
        StateModelLayerMapping allMappings = (StateModelLayerMapping)StateModelLayerMapping.class.cast(unmarshaller.unmarshal((Source)xmlSource));
        return allMappings.getImageType();
    }
}

