/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.ui.util;

import de.proveo.xml.fleet_management.measurement_1.MeasurementDefn;
import de.proveo.xml.fleet_management.measurement_1.MeasurementType;
import de.proveo.xml.fleet_management.measurement_1.Measurements;
import de.proveo.xml.fleet_management.meta_1.MetadataList;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.xml.sax.SAXException;

public class MeasurementsHelper {
    private static final Logger log = Logger.getLogger(MeasurementsHelper.class.getName());
    private List<MeasurementType> measurementTypesList = this.getDefaults();
    private HashMap<Integer, MeasurementDefn> measurementDefnsByID;
    private List<Integer> measurementDefnIdsSorted;

    public MeasurementsHelper() {
        this.index();
    }

    public void setMeasurements(String xml) {
        this.measurementTypesList = this.getMeasurementsFromXML(xml);
        this.index();
    }

    public MeasurementDefn getMeasurementDefn(int id) {
        return this.measurementDefnsByID.get(id);
    }

    public String getMeasurementDefnName(int id) {
        return this.measurementDefnsByID.get(id).getName();
    }

    public String getMeasurementDefnUnit(int id) {
        return this.measurementDefnsByID.get(id).getMeasurementUnit().getName();
    }

    public List<Integer> getMeasurementDefnIdsSorted() {
        return this.measurementDefnIdsSorted;
    }

    public String getMeasurementFormatPattern(int id) {
        String pattern = this.measurementDefnsByID.get(id).getCustomFormatPattern();
        if (pattern != null && pattern.length() > 0) {
            return pattern;
        }
        return this.measurementDefnsByID.get(id).getMeasurementUnit().getFormatPattern();
    }

    private void index() {
        String method = "index(): ";
        this.measurementDefnsByID = new HashMap();
        this.measurementDefnIdsSorted = new ArrayList<Integer>();
        if (this.measurementTypesList == null) {
            log.log(Level.SEVERE, "{0}no measurement types defined!", method);
            this.measurementTypesList = new ArrayList<MeasurementType>();
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "{0}START indexing...", method);
        }
        for (MeasurementType type : this.measurementTypesList) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}found measurement type ''{1}'' (ID {2}) containing {3} definitions...", new Object[]{method, type.getName(), type.getId(), type.getMeasurementDefns().getMeasurementDefn().size()});
            }
            for (MeasurementDefn defn : type.getMeasurementDefns().getMeasurementDefn()) {
                int defnId = defn.getId();
                this.measurementDefnsByID.put(defnId, defn);
                this.measurementDefnIdsSorted.add(defnId);
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "{0}* found measurement defn ''{1}'' (ID {2}) measured in ''{3}''...", new Object[]{method, defn.getName(), defnId, defn.getMeasurementUnit().getName()});
            }
        }
        Collections.sort(this.measurementDefnIdsSorted);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "{0}indexing FINISHED.", method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MeasurementType> getMeasurementsFromXML(String xml) {
        String method = "getMeasurementsFromXML(): ";
        StringReader xmlReader = new StringReader(xml);
        try {
            List<MeasurementType> list = this.unmarshalXml(new StreamSource(xmlReader));
            return list;
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, method + "Could not convert given measurements xml: " + xml, ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)xmlReader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MeasurementType> getDefaults() {
        String method = "getDefaults(): ";
        InputStream is = Measurements.class.getResourceAsStream("measurement-1.0.xml");
        try {
            List<MeasurementType> list = this.unmarshalXml(new StreamSource(is));
            return list;
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, method + "Could not convert measurements defaults xml", ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return null;
    }

    private List<MeasurementType> unmarshalXml(StreamSource xmlSource) throws JAXBException, SAXException {
        String method = "unmarshalXml(): ";
        if (xmlSource == null) {
            log.log(Level.SEVERE, "{0}Can not convert null or empty source. Break", method);
            return null;
        }
        Source[] xsdSources = new Source[]{new StreamSource(MetadataList.class.getResourceAsStream("meta-1.0.xsd")), new StreamSource(Measurements.class.getResourceAsStream("measurement-1.0.xsd"))};
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(xsdSources);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Measurements.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setSchema(schema);
        Measurements measurements = (Measurements)Measurements.class.cast(unmarshaller.unmarshal((Source)xmlSource));
        return measurements.getMeasurementTypes().getMeasurementType();
    }
}

