/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.ui.renderer;

import de.proveo.client.configuration.ui.editor.JSpinnerPropertyEditor;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.lang.math.NumberUtils;

public class JSpinnerPropertyRenderer<T extends Number>
extends DefaultTableCellRenderer {
    private static final Logger log = Logger.getLogger(JSpinnerPropertyRenderer.class.getName());
    private JSpinnerPropertyEditor<T> editor;
    private Comparable<T> min;

    public JSpinnerPropertyRenderer(JSpinnerPropertyEditor<T> editor) {
        this.editor = editor;
        this.min = this.editor.getMin();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Object v;
        try {
            v = NumberUtils.createNumber((String)String.valueOf(this.editor.getValue()));
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, "Could not parse value ''{0}'' to int", value);
            v = this.min;
        }
        if (row < table.getRowCount() && row >= 0 && column < table.getColumnCount() && column >= 0) {
            table.setValueAt(v, row, column);
        }
        return super.getTableCellRendererComponent(table, v, isSelected, hasFocus, row, column);
    }
}

