/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.ui.model;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetTableModel;
import de.proveo.client.configuration.ui.PasswordProperty;
import de.proveo.client.configuration.ui.panel.AbstractPropertiesPanel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertySheetFilterTableModel
extends PropertySheetTableModel {
    private static final Logger log = Logger.getLogger(PropertySheetFilterTableModel.class.getName());
    private final Object lock = new Object();
    private AbstractPropertiesPanel panel;
    private Filter filter = null;
    private Property[] currentlyChangedProperties = null;

    public PropertySheetFilterTableModel(AbstractPropertiesPanel panel) {
        this.panel = panel;
    }

    public void clearFilter() {
        Property prop;
        int i;
        if (this.filter == null) {
            return;
        }
        this.filter = null;
        Property[] props = (Property[])super.getProperties().clone();
        for (i = 0; i < props.length; ++i) {
            prop = props[i];
            props[i] = this.clonePropertyDeep((DefaultProperty)prop);
        }
        this.panel.loadAll();
        if (this.currentlyChangedProperties != null) {
            for (i = 0; i < this.currentlyChangedProperties.length; ++i) {
                prop = this.currentlyChangedProperties[i];
                log.log(Level.INFO, "Synchronizing value for {0} ...", prop.getName());
                this.synchronizeValues(prop);
            }
        }
        this.currentlyChangedProperties = null;
        for (i = 0; i < props.length; ++i) {
            prop = props[i];
            log.log(Level.INFO, "Synchronizing value for {0} ...", prop.getName());
            this.synchronizeValues(prop);
        }
    }

    private void synchronizeValues(Property fProp) {
        Property[] subProps;
        boolean synchronizedProp = false;
        Property[] props = super.getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (!this.synchronizeValues(fProp, props[i])) continue;
            log.log(Level.INFO, "Value for {0} successfully synchronized", fProp.getName());
            synchronizedProp = true;
            break;
        }
        if (!synchronizedProp) {
            log.log(Level.WARNING, "Could not synchronize value for property {0}", fProp.getName());
        }
        if ((subProps = fProp.getSubProperties()) != null) {
            for (int i = 0; i < subProps.length; ++i) {
                this.synchronizeValues(subProps[i]);
            }
        }
    }

    private boolean synchronizeValues(Property fProp, Property prop) {
        if (prop.getName().equals(fProp.getName())) {
            if (prop instanceof PasswordProperty) {
                prop.setValue((Object)((PasswordProperty)fProp).getPassword().toString());
            } else {
                prop.setValue(fProp.getValue());
            }
            return true;
        }
        Property[] subProps = prop.getSubProperties();
        if (subProps != null) {
            for (int i = 0; i < subProps.length; ++i) {
                if (!this.synchronizeValues(fProp, subProps[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void setFilter(String text, boolean ignoreUpperLowerCase) {
        if (this.filter != null) {
            this.clearFilter();
        }
        if (text == null || text.equals("")) {
            return;
        }
        this.currentlyChangedProperties = (Property[])super.getProperties().clone();
        for (int i = 0; i < this.currentlyChangedProperties.length; ++i) {
            Property prop = this.currentlyChangedProperties[i];
            this.currentlyChangedProperties[i] = this.clonePropertyDeep((DefaultProperty)prop);
        }
        this.filter = new Filter();
        this.filter.setIgnoreUpperLowerCase(ignoreUpperLowerCase);
        this.filter.setFilterText(text);
        Property[] props = super.getProperties();
        for (int i = 0; i < props.length; ++i) {
            Property prop = props[i];
            boolean filterPassed = false;
            if (prop instanceof DefaultProperty) {
                filterPassed = this.filterPassed((DefaultProperty)prop);
            } else {
                log.log(Level.WARNING, "##### Found a non DefaultProperty in configuration dialog: {0}", prop.getName());
            }
            if (filterPassed) continue;
            super.removeProperty(prop);
        }
    }

    private DefaultProperty clonePropertyDeep(DefaultProperty fProp) {
        DefaultProperty clone = this.cloneProperty(fProp);
        Property[] subProps = fProp.getSubProperties();
        if (subProps != null) {
            for (int i = 0; i < subProps.length; ++i) {
                if (subProps[i] instanceof DefaultProperty) {
                    DefaultProperty subProp = (DefaultProperty)subProps[i];
                    DefaultProperty subClone = this.clonePropertyDeep(subProp);
                    clone.addSubProperty((Property)subClone);
                    continue;
                }
                log.log(Level.WARNING, "##### Found a non DefaultProperty in configuration dialog: {0}", fProp.getName());
            }
        }
        return clone;
    }

    private DefaultProperty cloneProperty(DefaultProperty fProp) {
        DefaultProperty clone = new DefaultProperty();
        Object value = fProp.getValue();
        clone.setValue(value);
        if (fProp instanceof PasswordProperty) {
            clone = new PasswordProperty();
            ((PasswordProperty)clone).setEchoChar(((PasswordProperty)fProp).getEchoChar());
            clone.setValue((Object)((PasswordProperty)fProp).getPassword().toString());
        }
        clone.setCategory(fProp.getCategory());
        clone.setDisplayName(fProp.getDisplayName());
        clone.setEditable(fProp.isEditable());
        clone.setName(fProp.getName());
        clone.setParentProperty(fProp.getParentProperty());
        clone.setShortDescription(fProp.getShortDescription());
        clone.setType(fProp.getType());
        return clone;
    }

    private boolean filterPassed(DefaultProperty prop) {
        boolean ret = this.filter.pass((Property)prop);
        if (!ret) {
            DefaultProperty subProp;
            int i;
            ArrayList<DefaultProperty> passedSubProperies = new ArrayList<DefaultProperty>();
            Property[] subProps = prop.getSubProperties();
            if (subProps != null) {
                for (i = 0; i < subProps.length; ++i) {
                    subProp = (DefaultProperty)subProps[i];
                    if (!this.filterPassed(subProp)) continue;
                    passedSubProperies.add(subProp);
                    ret = true;
                }
            }
            prop.clearSubProperties();
            for (i = 0; i < passedSubProperies.size(); ++i) {
                subProp = (DefaultProperty)passedSubProperies.get(i);
                prop.addSubProperty((Property)subProp);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        Object object = this.lock;
        synchronized (object) {
            return super.getRowCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertySheetTableModel.Item getPropertySheetElement(int rowIndex) {
        if (rowIndex < this.getRowCount() && rowIndex >= 0) {
            Object object = this.lock;
            synchronized (object) {
                return super.getPropertySheetElement(rowIndex);
            }
        }
        return null;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        PropertySheetTableModel.Item item = this.getPropertySheetElement(rowIndex);
        if (item != null && item.isProperty()) {
            switch (columnIndex) {
                case 0: {
                    result = item;
                    break;
                }
                case 1: {
                    try {
                        result = item.getProperty().getValue();
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "runs into", e);
                    }
                    break;
                }
            }
        } else {
            result = item;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visibilityChanged(boolean restoreOldStates) {
        Object object = this.lock;
        synchronized (object) {
            super.visibilityChanged(restoreOldStates);
        }
    }

    private class Filter {
        private String text = "";
        private boolean ignoreUpperLowerCase = false;

        private Filter() {
        }

        public void setFilterText(String text) {
            this.text = text;
        }

        public void setIgnoreUpperLowerCase(boolean ignore) {
            this.ignoreUpperLowerCase = ignore;
        }

        public boolean pass(Property prop) {
            if (this.text.length() <= 0) {
                return true;
            }
            String txt = this.text;
            String key = "";
            String name = "";
            if (prop != null) {
                key = prop.getName();
                name = prop.getDisplayName();
            }
            if (this.ignoreUpperLowerCase) {
                txt = txt.toLowerCase();
                key = key.toLowerCase();
                name = name.toLowerCase();
            }
            return PropertySheetFilterTableModel.this.panel.isAdminMode() && key.indexOf(txt) != -1 || name.indexOf(txt) != -1;
        }
    }
}

