/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.ui.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.propertysheet.PropertySheetTable;
import com.l2fprod.common.swing.ComponentFactory;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.PercentLayout;
import de.proveo.client.configuration.api.ConfigurationConstants;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.openide.util.ImageUtilities;

public class SoundsPropertyEditor
extends AbstractPropertyEditor {
    private static final Logger log = Logger.getLogger(SoundsPropertyEditor.class.getName());
    private static final ImageIcon playIcon = ImageUtilities.loadImageIcon((String)"de/proveo/client/configuration/resources/icons/play.png", (boolean)false);
    private JComboBox combobox = null;
    private JButton button = null;
    private List<ConfigurationConstants.SoundFile> items;
    private PropertySheetTable pst;

    public SoundsPropertyEditor(ConfigurationConstants.SoundFile selectedItem, ConfigurationConstants.SoundFile[] items, PropertySheetTable pst) throws UnsupportedOperationException {
        if (items == null) {
            throw new UnsupportedOperationException("items can not be null!");
        }
        this.pst = pst;
        this.items = new ArrayList<ConfigurationConstants.SoundFile>(items.length);
        this.items.addAll(Arrays.asList(items));
        this.init(selectedItem, this.items);
    }

    public SoundsPropertyEditor(ConfigurationConstants.SoundFile selectedItem, List<ConfigurationConstants.SoundFile> items, PropertySheetTable pst) throws UnsupportedOperationException {
        if (items == null) {
            throw new UnsupportedOperationException("items can not be null!");
        }
        this.pst = pst;
        this.init(selectedItem, items);
    }

    private void init(ConfigurationConstants.SoundFile selectedItem, List<ConfigurationConstants.SoundFile> items) {
        this.items = items;
        ConfigurationConstants.SoundFile[] i = new ConfigurationConstants.SoundFile[this.items.size()];
        this.combobox = ComponentFactory.Helper.getFactory().createComboBox();
        this.combobox.setModel(new DefaultComboBoxModel<ConfigurationConstants.SoundFile>(this.items.toArray(i)));
        if (this.pst != null) {
            this.combobox.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        SoundsPropertyEditor.this.pst.commitEditing();
                    }
                }
            });
            this.combobox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SoundsPropertyEditor.this.pst.commitEditing();
                }
            });
        }
        this.button = ComponentFactory.Helper.getFactory().createMiniButton();
        this.button.setText(null);
        this.button.setIcon(playIcon);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundsPropertyEditor.this.playSelectedSound();
            }
        });
        this.editor = new JPanel((LayoutManager)new PercentLayout(0, 0));
        ((JPanel)this.editor).setBorder(LookAndFeelTweaks.EMPTY_BORDER);
        ((JPanel)this.editor).setOpaque(false);
        ((JPanel)this.editor).add("*", this.combobox);
        ((JPanel)this.editor).add(this.button);
        if (selectedItem != null) {
            this.combobox.setSelectedItem(selectedItem);
        } else {
            this.combobox.setSelectedIndex(-1);
        }
    }

    public Object getValue() {
        return this.combobox.getSelectedItem();
    }

    public void setValue(Object value) {
        this.combobox.setSelectedItem(value);
        this.getCustomEditor().repaint();
        this.getCustomEditor().validate();
    }

    protected void playSelectedSound() {
        String method = "playSelectedSound(): ";
        Object selected = this.combobox.getSelectedItem();
        if (selected != null) {
            if (selected instanceof ConfigurationConstants.SoundFile) {
                ((ConfigurationConstants.SoundFile)selected).playBlocking();
            }
        } else {
            log.log(Level.SEVERE, "{0}Can not play a null value!", method);
        }
    }
}

