/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.ui.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.propertysheet.PropertySheetTable;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class JSpinnerPropertyEditor<T extends Number>
extends AbstractPropertyEditor {
    private static final Logger log = Logger.getLogger(JSpinnerPropertyEditor.class.getName());
    private final DecimalFormat format;
    private PropertySheetTable pst;
    private SpinnerNumberModel model;
    private Comparable<T> min;
    private Comparable<T> max;
    private T initVal;
    private T stepSize;

    public JSpinnerPropertyEditor(T initVal, Comparable<T> min, Comparable<T> max, T stepSize, Class<T> type, PropertySheetTable pst) {
        this.initVal = initVal;
        this.min = min;
        this.max = max;
        this.stepSize = stepSize;
        this.pst = pst;
        this.model = new SpinnerNumberModel((Number)this.initVal, this.min, this.max, (Number)this.stepSize);
        this.editor = new JSpinner(this.model);
        ((JSpinner)this.editor).setLocale(Locale.US);
        ((JSpinner)this.editor).setBorder(LookAndFeelTweaks.EMPTY_BORDER);
        ((JSpinner)this.editor).setOpaque(false);
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)((JSpinner)this.editor).getEditor();
        this.format = numberEditor.getFormat();
        this.format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        numberEditor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String text = ((JSpinner.DefaultEditor)((JSpinner)JSpinnerPropertyEditor.this.editor).getEditor()).getTextField().getText();
                Number value = JSpinnerPropertyEditor.this.initVal;
                try {
                    value = JSpinnerPropertyEditor.this.format.parse(text);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Could not format ''{0}''", text);
                }
                JSpinnerPropertyEditor.this.setValue(value);
            }
        });
        NumberFormatter numberFormatter = new NumberFormatter(this.format);
        numberFormatter.setValueClass(type);
        final JFormattedTextField textField = numberEditor.getTextField();
        textField.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                String text = textField.getText();
                Number value = JSpinnerPropertyEditor.this.initVal;
                try {
                    value = JSpinnerPropertyEditor.this.format.parse(text);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Could not format ''{0}''", text);
                }
                JSpinnerPropertyEditor.this.format.setMaximumFractionDigits(JSpinnerPropertyEditor.this.getNumberOfFractionDigits(value));
            }
        });
        this.setValue(this.initVal);
    }

    public Object getValue() {
        return ((JSpinner)this.editor).getValue();
    }

    public void setValue(Object value) {
        Object oldValue = this.getValue();
        if (value == null || ObjectUtils.equals((Object)value, (Object)oldValue)) {
            return;
        }
        try {
            Number number = (Number)value;
            this.format.setMaximumFractionDigits(this.getNumberOfFractionDigits(number));
            ((JSpinner)this.editor).setValue(number);
            super.setAsText(String.valueOf(value));
            ((JSpinner)this.editor).commitEdit();
        }
        catch (ParseException ex) {
            log.log(Level.WARNING, "Could not commit change ''{0}'' (min=''{1}'' max=''{2}'' stepSize=''{3}'')", new Object[]{value, this.min, this.max, this.stepSize});
            Number number = (Number)oldValue;
            this.format.setMaximumFractionDigits(this.getNumberOfFractionDigits(number));
            ((JSpinner)this.editor).setValue(number);
            super.setAsText(String.valueOf(oldValue));
            try {
                ((JSpinner)this.editor).commitEdit();
            }
            catch (ParseException ex2) {
                log.log(Level.WARNING, "Could not revert change ''{0}'' (min=''{1}'' max=''{2}'' stepSize=''{3}'')", new Object[]{oldValue, this.min, this.max, this.stepSize});
            }
        }
        if (this.pst != null) {
            this.pst.commitEditing();
        }
        super.getCustomEditor().repaint();
        super.getCustomEditor().invalidate();
    }

    public T getInitVal() {
        return this.initVal;
    }

    public Comparable<T> getMax() {
        return this.max;
    }

    public Comparable<T> getMin() {
        return this.min;
    }

    public T getStepSize() {
        return this.stepSize;
    }

    private int getNumberOfFractionDigits(Number number) {
        if (number == null) {
            return 0;
        }
        int ret = 0;
        String value = String.valueOf(number);
        if (value.contains(".")) {
            String[] values = StringUtils.split((String)value, (String)".");
            if (values.length == 2) {
                ret = values[1].length();
            } else {
                log.log(Level.WARNING, "Number contained more than one point: {0}", value);
            }
        }
        if (ret < 0) {
            ret = 0;
        }
        return ret;
    }
}

