/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.ui.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.propertysheet.PropertySheetTable;
import com.l2fprod.common.swing.ComponentFactory;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class JComboBoxPropertyEditor
extends AbstractPropertyEditor {
    private PropertySheetTable pst = null;
    private List<Object> items = null;

    public JComboBoxPropertyEditor(Object selectedItem, Object[] items, PropertySheetTable pst) throws UnsupportedOperationException {
        if (items == null) {
            throw new UnsupportedOperationException("items can not be null!");
        }
        this.pst = pst;
        this.items = new ArrayList<Object>(items.length);
        this.items.addAll(Arrays.asList(items));
        this.init(selectedItem, this.items);
    }

    public JComboBoxPropertyEditor(Object selectedItem, List<Object> items, PropertySheetTable pst) throws UnsupportedOperationException {
        if (items == null) {
            throw new UnsupportedOperationException("items can not be null!");
        }
        this.pst = pst;
        this.init(selectedItem, items);
    }

    private void init(Object selectedItem, List<Object> items) {
        this.items = items;
        Object[] i = new Object[this.items.size()];
        this.editor = ComponentFactory.Helper.getFactory().createComboBox();
        ((JComboBox)this.editor).setModel(new DefaultComboBoxModel<Object>(this.items.toArray(i)));
        ((JComboBox)this.editor).setBorder(LookAndFeelTweaks.EMPTY_BORDER);
        ((JComboBox)this.editor).setOpaque(false);
        if (selectedItem != null) {
            ((JComboBox)this.editor).setSelectedItem(selectedItem);
        } else {
            ((JComboBox)this.editor).setSelectedIndex(-1);
        }
        if (this.pst != null) {
            ((JComboBox)this.editor).addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        JComboBoxPropertyEditor.this.pst.commitEditing();
                    }
                }
            });
            ((JComboBox)this.editor).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JComboBoxPropertyEditor.this.pst.commitEditing();
                }
            });
        }
    }

    public Object getValue() {
        return ((JComboBox)this.editor).getSelectedItem();
    }

    public void setValue(Object value) {
        ((JComboBox)this.editor).setSelectedItem(value);
        this.getCustomEditor().repaint();
        this.getCustomEditor().validate();
    }
}

