/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.impl;

import de.proveo.client.configuration.api.ConfigurationParameters;
import de.proveo.client.configuration.api.parameter.Parameter;
import de.proveo.client.configuration.impl.AbstractConfiguration;
import de.proveo.client.configuration.util.ConfigurationUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.ObjectUtils;
import org.openide.util.NbBundle;

public class MemoryConfigurationImpl
extends AbstractConfiguration {
    private static final Logger log = Logger.getLogger(MemoryConfigurationImpl.class.getName());
    protected final Map<String, Object> storedMemoryConf = new HashMap<String, Object>();
    protected final Map<String, Object> conf = new HashMap<String, Object>();

    public MemoryConfigurationImpl() {
        this.init();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(MemoryConfigurationImpl.class, (String)"MemoryConfigurationImpl.name");
    }

    @Override
    public <T> T getValue(Parameter<T> parameter, String ... keyArgs) {
        Object value;
        Class<T> c = parameter.getType();
        String key = parameter.getKey();
        T defaultValue = parameter.getDefaultValue();
        if (keyArgs != null && keyArgs.length != 0) {
            key = String.format(key, keyArgs);
        }
        if (parameter.isTemporary()) {
            Object value2;
            if (this.temporaryConfigMap.containsKey(key) && (value2 = this.temporaryConfigMap.get(key)) != null) {
                if (c.isInstance(value2)) {
                    return (T)value2;
                }
                log.log(Level.SEVERE, "Value type of temporary property ''{0}'' is {1}, but value was {2}, will return default value: {3}", new Object[]{key, c.getName(), value2.getClass().getName(), defaultValue});
            }
        } else if (this.conf.containsKey(key) && (value = this.conf.get(key)) != null) {
            if (c.isInstance(value)) {
                return (T)value;
            }
            log.log(Level.SEVERE, "Value type of property ''{0}'' is {1}, but value was {2}, will return default value: {3}", new Object[]{key, c.getName(), value.getClass().getName(), defaultValue});
        }
        return defaultValue;
    }

    @Override
    public TreeMap<String, Object> getAllProperties() {
        TreeMap<String, Object> props = new TreeMap<String, Object>();
        for (String key : this.conf.keySet()) {
            props.put(key, this.conf.get(key));
        }
        return props;
    }

    protected <T> T getStoredValue(Parameter<T> parameter) {
        Object value;
        Class<T> c = parameter.getType();
        String key = parameter.getKey();
        T defaultValue = parameter.getDefaultValue();
        if (parameter.isTemporary()) {
            Object value2;
            if (this.temporaryConfigMap.containsKey(key) && (value2 = this.temporaryConfigMap.get(key)) != null) {
                if (c.isInstance(value2)) {
                    return (T)value2;
                }
                log.log(Level.SEVERE, "Value type of temporary property ''{0}'' is {1}, but value was {2}, will return default value: {3}", new Object[]{key, c.getName(), value2.getClass().getName(), defaultValue});
            }
        } else if (this.storedMemoryConf.containsKey(key) && (value = this.storedMemoryConf.get(key)) != null) {
            if (c.isInstance(value)) {
                return (T)value;
            }
            log.log(Level.SEVERE, "Value type of property ''{0}'' is {1}, but value was {2}, will return default value: {3}", new Object[]{key, c.getName(), value.getClass().getName(), defaultValue});
        }
        return defaultValue;
    }

    @Override
    public boolean isChanged() {
        if (!this.changedParametersMap.isEmpty()) {
            log.info("Configuration has changed:");
            Iterator ite = this.changedParametersMap.keySet().iterator();
            while (ite.hasNext()) {
                String key = (String)ite.next();
                Parameter param = (Parameter)this.changedParametersMap.get(key);
                if (param != null) {
                    String prevValue;
                    Class type = param.getType();
                    String value = ConfigurationUtils.getStoreableValue(type, this.getValue(param));
                    if (ObjectUtils.equals((Object)value, (Object)(prevValue = ConfigurationUtils.getStoreableValue(type, this.getStoredValue(param))))) {
                        ite.remove();
                        continue;
                    }
                    log.log(Level.INFO, "''{0}'' has changed from ''{1}'' to ''{2}''", new Object[]{key, prevValue, value});
                    continue;
                }
                log.log(Level.INFO, "''{0}'' was removed?!?", key);
            }
        }
        return !this.changedParametersMap.isEmpty();
    }

    private void init() {
        this.initParameters();
        try {
            this.load();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "init configuration runs into", ex);
        }
    }

    @Override
    public void load() throws Exception {
        this.conf.clear();
        this.conf.putAll(this.storedMemoryConf);
    }

    @Override
    public void removeKey(String key) {
        Object value = this.conf.remove(key);
        Parameter param = this.getParameterByKey(key);
        if (param != null && param.isTemporary()) {
            this.notifyObservers(param);
        } else if (param != null) {
            Object storedValue = this.getStoredValue(param);
            if (ObjectUtils.equals((Object)value, storedValue)) {
                this.changedParametersMap.remove(key);
            } else {
                this.changedParametersMap.put(key, param);
            }
        } else {
            this.changedParametersMap.remove(key);
        }
    }

    @Override
    public <T> void setValue(Parameter<T> parameter, T value) {
        String key = parameter.getKey();
        T defaultValue = parameter.getDefaultValue();
        if (parameter.isTemporary()) {
            if (ObjectUtils.equals(value, defaultValue)) {
                this.temporaryConfigMap.remove(key);
            } else {
                this.temporaryConfigMap.put(key, value);
            }
            this.notifyObservers(parameter);
        } else {
            if (ObjectUtils.equals(value, defaultValue)) {
                this.conf.remove(parameter.getKey());
            } else {
                this.conf.put(parameter.getKey(), value);
            }
            T storedValue = this.getStoredValue(parameter);
            if (ObjectUtils.equals(value, storedValue)) {
                this.changedParametersMap.remove(key);
            } else {
                this.changedParametersMap.put(key, parameter);
            }
        }
    }

    @Override
    protected void setValue(String key, String value) {
        this.conf.put(key, value);
    }

    @Override
    public boolean store() throws Exception {
        this.storedMemoryConf.clear();
        this.storedMemoryConf.putAll(this.conf);
        for (String key : this.changedParametersMap.keySet()) {
            Parameter param = (Parameter)this.changedParametersMap.get(key);
            if (param == null) continue;
            if (key.startsWith("toolbar.statusmodel.fontcolor.")) {
                this.notifyObservers(ConfigurationParameters.PARAM_PATTERN_TOOLBAR_STATUS_FONTCOLOR);
            }
            this.notifyObservers(param);
        }
        this.changedParametersMap.clear();
        return false;
    }
}

