/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.impl;

import de.proveo.client.configuration.api.ConfigurationParameters;
import de.proveo.client.configuration.api.parameter.DefaultGroupParameter;
import de.proveo.client.configuration.api.parameter.Parameter;
import de.proveo.client.configuration.impl.AbstractConfiguration;
import de.proveo.client.configuration.util.ConfigurationUtils;
import de.proveo.client.configuration.util.PathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class FileConfigurationImpl
extends AbstractConfiguration {
    private static final Logger log = Logger.getLogger(FileConfigurationImpl.class.getName());
    protected PropertiesConfiguration propsConf = null;
    protected String propertyFileName;
    protected File propertyFile;

    public FileConfigurationImpl(String propertyFileName) {
        this.propertyFileName = propertyFileName;
        if (this.propertyFileName != null) {
            this.init(new File(this.propertyFileName));
        }
    }

    public FileConfigurationImpl(File propertyFile) {
        this.init(propertyFile);
    }

    protected PropertiesConfiguration createDefaultPropertiesConfiguration() {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        pc.setEncoding("UTF-8");
        pc.setListDelimiter('\t');
        PropertiesConfiguration.setDefaultListDelimiter((char)'\t');
        pc.setDelimiterParsingDisabled(true);
        pc.setThrowExceptionOnMissing(false);
        return pc;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof FileConfigurationImpl) {
            FileConfigurationImpl other = (FileConfigurationImpl)obj;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((Object)this.propertyFile, (Object)other.propertyFile);
            eb.append((Object)this.propertyFileName, (Object)other.propertyFileName);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    public TreeMap<String, Object> getAllProperties() {
        TreeMap<String, Object> props = new TreeMap<String, Object>();
        Iterator ite = this.propsConf.getKeys();
        while (ite.hasNext()) {
            String key = ite.next().toString();
            props.put(key, this.propsConf.getString(key));
        }
        return props;
    }

    @Override
    public String getName() {
        if (this.propertyFile == null) {
            return NbBundle.getMessage(FileConfigurationImpl.class, (String)"FileConfigurationImpl.name.unknown");
        }
        return this.propertyFile.getParentFile().getName();
    }

    public File getPropertyFile() {
        return this.propertyFile;
    }

    @Override
    public <T> T getValue(Parameter<T> parameter, String ... keyArgs) {
        String value;
        Parameter param;
        if (parameter == null || parameter instanceof DefaultGroupParameter) {
            return null;
        }
        String key = parameter.getKey();
        if (keyArgs != null && keyArgs.length != 0 && (param = this.getParameterByKey(key = String.format(key, keyArgs))) != null) {
            parameter = param;
        }
        Class<T> c = parameter.getType();
        T defaultValue = parameter.getDefaultValue();
        if (parameter.isTemporary()) {
            Object value2;
            if (this.temporaryConfigMap.containsKey(key) && (value2 = this.temporaryConfigMap.get(key)) != null) {
                if (c.isInstance(value2)) {
                    return (T)value2;
                }
                log.log(Level.SEVERE, "Value type of temporary property ''{0}'' is {1}, but value was {2}, will return default value: {3}", new Object[]{key, c.getName(), value2.getClass().getName(), defaultValue});
            }
        } else if (this.propsConf.containsKey(key) && (value = this.propsConf.getString(key)) != null) {
            T visualValue;
            try {
                visualValue = ConfigurationUtils.getVisualValue(c, value);
            }
            catch (Exception ex) {
                visualValue = null;
            }
            T convertedValue = ConfigurationUtils.convertOldValueToNewValue(c, key, value);
            if (convertedValue != null) {
                visualValue = convertedValue;
            }
            if (visualValue != null) {
                if (c.isInstance(visualValue)) {
                    return visualValue;
                }
                log.log(Level.SEVERE, "Value type of property ''{0}'' is {1}, but value was {2}, will return default value: {3}", new Object[]{key, c.getName(), value.getClass().getName(), defaultValue});
            } else {
                log.log(Level.WARNING, "Got value for ''{0}'' from configuration ''{1}'', but could not parse it to its type Class ''{2}''", new Object[]{key, value, c != null ? c.getName() : null});
            }
        }
        return defaultValue;
    }

    protected <T> T getValueFromFile(Parameter<T> parameter) {
        String value;
        String key = parameter.getKey();
        T defaultValue = parameter.getDefaultValue();
        PropertiesConfiguration pc = this.createDefaultPropertiesConfiguration();
        try {
            this.load(pc);
        }
        catch (Exception ex) {
            return defaultValue;
        }
        if (pc.containsKey(key) && (value = pc.getString(key)) != null) {
            T visualValue;
            Class<T> c = parameter.getType();
            try {
                visualValue = ConfigurationUtils.getVisualValue(c, value);
            }
            catch (Exception ex) {
                visualValue = null;
            }
            T convertedValue = ConfigurationUtils.convertOldValueToNewValue(c, key, value);
            if (convertedValue != null) {
                visualValue = convertedValue;
            }
            if (visualValue != null) {
                if (c.isInstance(visualValue)) {
                    return visualValue;
                }
                log.log(Level.SEVERE, "Value type of property ''{0}'' is {1}, but value was {2}, will return default value: {3}", new Object[]{key, c.getName(), value.getClass().getName(), defaultValue});
            } else {
                log.log(Level.WARNING, "Got value for ''{0}'' from configuration ''{1}'', but could not parse it to its type Class ''{2}''", new Object[]{key, value, c != null ? c.getName() : null});
            }
        }
        return defaultValue;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)this.propertyFile);
        hcb.append((Object)this.propertyFileName);
        return hcb.toHashCode();
    }

    @Override
    public boolean isChanged() {
        if (!this.changedParametersMap.isEmpty()) {
            log.info("Configuration has changed:");
            Iterator ite = this.changedParametersMap.keySet().iterator();
            while (ite.hasNext()) {
                String key = (String)ite.next();
                Parameter param = (Parameter)this.changedParametersMap.get(key);
                if (param != null) {
                    String prevValue;
                    Class type = param.getType();
                    String value = ConfigurationUtils.getStoreableValue(type, this.getValue(param));
                    if (ObjectUtils.equals((Object)value, (Object)(prevValue = ConfigurationUtils.getStoreableValue(type, this.getValueFromFile(param))))) {
                        ite.remove();
                        continue;
                    }
                    log.log(Level.INFO, "''{0}'' has changed from ''{1}'' to ''{2}''", new Object[]{key, prevValue, value});
                    continue;
                }
                log.log(Level.INFO, "''{0}'' was removed", key);
            }
        }
        return !this.changedParametersMap.isEmpty();
    }

    @Override
    public void importConfigurationFile(File configurationFile) throws Exception {
        if (configurationFile == null) {
            return;
        }
        FileObject configFileObj = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)configurationFile));
        File tmpConfigFile = new File(configurationFile.getParentFile(), ".tmp_" + configFileObj.getName() + "." + configFileObj.getExt());
        tmpConfigFile.deleteOnExit();
        try {
            String content = FileUtils.readFileToString((File)FileUtil.toFile((FileObject)configFileObj));
            if (SystemUtils.IS_OS_UNIX) {
                content = StringUtils.replace((String)content, (String)"\r\n", (String)"\n");
            }
            FileUtils.writeStringToFile((File)tmpConfigFile, (String)content);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Could not create temporary file", ex);
            tmpConfigFile = configurationFile;
        }
        FileConfigurationImpl tmpConfig = new FileConfigurationImpl(tmpConfigFile);
        TreeMap<String, Object> allProps = tmpConfig.getAllProperties();
        for (String key : allProps.keySet()) {
            String value = allProps.get(key).toString();
            if (value == null) continue;
            Parameter param = tmpConfig.getParameterByKey(key);
            if (param != null && File.class.isAssignableFrom(param.getType())) {
                try {
                    File file;
                    String path = tmpConfigFile.getParentFile().getAbsolutePath();
                    if (!StringUtils.endsWith((CharSequence)path, (CharSequence)File.separator)) {
                        path = path + File.separator;
                    }
                    if (value.contains("\\")) {
                        value = value.replace("\\", File.separator);
                    }
                    if (value.contains("/")) {
                        value = value.replace("/", File.separator);
                    }
                    if (!(file = new File(path = path + value)).exists()) {
                        file = new File(value);
                    }
                    String fileName = file.getName();
                    File destFile = new File(this.propertyFile.getParent(), fileName);
                    FileUtils.copyFile((File)file, (File)destFile);
                    this.setValue(key, PathUtils.getRelativePath(destFile));
                }
                catch (Exception ex) {
                    log.log(Level.INFO, "Could not import file '" + value + "', assuming previous value from property file instead", ex);
                    this.setValue(key, value);
                }
                continue;
            }
            this.setValue(key, value);
        }
        this.store();
    }

    private void init(File propertyFile) {
        this.propertyFile = propertyFile;
        this.initParameters();
        this.propsConf = this.createDefaultPropertiesConfiguration();
        try {
            this.load();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "init configuration runs into", ex);
        }
    }

    protected boolean isFileBase64Encoded(File propertyFile) {
        try {
            String str = FileUtils.readFileToString((File)propertyFile);
            if (str.indexOf(61) == -1) {
                return true;
            }
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "isFileBase64Encoded() runs into", ex);
        }
        return false;
    }

    @Override
    public void load() throws Exception {
        this.load(this.propsConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(PropertiesConfiguration propsConf) throws Exception {
        block7: {
            if (this.propertyFile != null) {
                this.propertyFileName = this.propertyFile.getAbsolutePath();
                try {
                    if (this.propertyFile.exists()) {
                        propsConf.clear();
                        if (this.isFileBase64Encoded(this.propertyFile)) {
                            Base64InputStream in = null;
                            FileInputStream fis = null;
                            try {
                                fis = new FileInputStream(this.propertyFile);
                                in = new Base64InputStream((InputStream)fis);
                                propsConf.load((InputStream)in);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(fis);
                                IOUtils.closeQuietly(in);
                                throw throwable;
                            }
                            IOUtils.closeQuietly((InputStream)fis);
                            IOUtils.closeQuietly((InputStream)in);
                            break block7;
                        }
                        propsConf.load(this.propertyFileName);
                        break block7;
                    }
                    throw new IOException("Property file doesn't exist: " + this.propertyFileName);
                }
                catch (Exception ex) {
                    this.propertyFile = null;
                    this.propertyFileName = null;
                    throw ex;
                }
            }
        }
    }

    @Override
    public void removeKey(String key) {
        this.propsConf.clearProperty(key);
        Parameter param = this.getParameterByKey(key);
        if (param != null && param.isTemporary()) {
            this.notifyObservers(param);
        } else {
            this.changedParametersMap.put(key, param);
        }
    }

    @Override
    public <T> void setValue(Parameter<T> parameter, T value) {
        if (parameter == null || parameter instanceof DefaultGroupParameter) {
            return;
        }
        String key = parameter.getKey();
        if (parameter.isTemporary()) {
            T defaultValue = parameter.getDefaultValue();
            if (ObjectUtils.equals(value, defaultValue)) {
                this.temporaryConfigMap.remove(key);
            } else {
                this.temporaryConfigMap.put(key, value);
            }
            this.notifyObservers(parameter);
        } else {
            Class<T> type = parameter.getType();
            T previousValue = this.getValueFromFile(parameter);
            String storableValue = ConfigurationUtils.getStoreableValue(type, value);
            this.setValue(parameter.getKey(), storableValue);
            if (!ObjectUtils.equals((Object)ConfigurationUtils.getStoreableValue(type, previousValue), (Object)storableValue)) {
                this.changedParametersMap.put(key, parameter);
            } else {
                this.changedParametersMap.remove(key);
            }
        }
    }

    @Override
    protected void setValue(String key, String value) {
        Parameter param = this.getParameterByKey(key);
        if (param != null) {
            Object visualValue;
            Class type = param.getType();
            Object defaultValue = param.getDefaultValue();
            try {
                visualValue = ConfigurationUtils.getVisualValue(type, value);
            }
            catch (Exception ex) {
                visualValue = null;
            }
            if (ObjectUtils.equals(visualValue, defaultValue)) {
                if (this.propsConf.containsKey(key)) {
                    this.propsConf.clearProperty(key);
                }
                return;
            }
        }
        this.propsConf.setProperty(key, (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean store() throws Exception {
        block9: {
            block8: {
                if (this.propertyFile == null) {
                    return false;
                }
                Iterator ite = this.changedParametersMap.keySet().iterator();
                while (ite.hasNext()) {
                    String key = (String)ite.next();
                    Parameter param = (Parameter)this.changedParametersMap.get(key);
                    if (param != null) {
                        Object storedValue;
                        if (param instanceof DefaultGroupParameter) {
                            ite.remove();
                            continue;
                        }
                        Object currentValue = this.getValue(param);
                        if (!ObjectUtils.equals(currentValue, storedValue = this.getValueFromFile(param))) continue;
                        ite.remove();
                        continue;
                    }
                    ite.remove();
                }
                if (!this.getValue(ConfigurationParameters.PARAM_PROPERTIES_ENCRYPTION).booleanValue()) break block8;
                Base64OutputStream out = null;
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(this.propertyFile);
                    out = new Base64OutputStream((OutputStream)fos);
                    this.propsConf.save((OutputStream)out);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fos);
                IOUtils.closeQuietly((OutputStream)out);
                break block9;
            }
            this.propsConf.save(this.propertyFile);
        }
        boolean restartNeeded = false;
        for (String key : this.changedParametersMap.keySet()) {
            Parameter param = (Parameter)this.changedParametersMap.get(key);
            if (param == null) continue;
            if (key.startsWith("toolbar.statusmodel.fontcolor.")) {
                this.notifyObservers(ConfigurationParameters.PARAM_PATTERN_TOOLBAR_STATUS_FONTCOLOR);
            }
            this.notifyObservers(param);
            if (!param.isRestartNeeded()) continue;
            restartNeeded = true;
        }
        this.changedParametersMap.clear();
        return restartNeeded;
    }

    public boolean store(String propertyFileName) throws Exception {
        this.propertyFileName = propertyFileName;
        this.propertyFile = new File(this.propertyFileName);
        return this.store();
    }

    public boolean store(File propertyFile) throws Exception {
        this.propertyFile = propertyFile;
        this.propertyFileName = this.propertyFile.getAbsolutePath();
        return this.store();
    }
}

