/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.impl;

import de.proveo.client.configuration.api.Configuration;
import de.proveo.client.configuration.api.ConfigurationParameters;
import de.proveo.client.configuration.api.ConfigurationParametersProvider;
import de.proveo.client.configuration.api.parameter.Parameter;
import de.proveo.client.configuration.impl.FileConfigurationImpl;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public abstract class AbstractConfiguration
extends Observable
implements Configuration {
    private static final Logger log = Logger.getLogger(AbstractConfiguration.class.getName());
    protected final Map<String, Parameter> parametersMap = new LinkedHashMap<String, Parameter>();
    protected final Map<String, Parameter> changedParametersMap = new HashMap<String, Parameter>();
    protected final Map<String, Object> temporaryConfigMap = new HashMap<String, Object>();

    @Override
    public Map<String, Parameter> getAllParameters() {
        return new LinkedHashMap<String, Parameter>(this.parametersMap);
    }

    @Override
    public Parameter getParameterByKey(String key) {
        return this.parametersMap.get(key);
    }

    @Override
    public <T> T getValue(Parameter<T> parameter) {
        return this.getValue(parameter, new String[0]);
    }

    @Override
    public void importConfigurationFile(File configurationFile) throws Exception {
        if (configurationFile == null) {
            return;
        }
        FileObject configFileObj = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)configurationFile));
        File tmpConfigFile = new File(configurationFile.getParentFile(), ".tmp_" + configFileObj.getName() + "." + configFileObj.getExt());
        tmpConfigFile.deleteOnExit();
        try {
            String content = FileUtils.readFileToString((File)FileUtil.toFile((FileObject)configFileObj));
            if (SystemUtils.IS_OS_UNIX) {
                content = StringUtils.replace((String)content, (String)"\r\n", (String)"\n");
            }
            FileUtils.writeStringToFile((File)tmpConfigFile, (String)content);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Could not create temporary file", ex);
            tmpConfigFile = configurationFile;
        }
        FileConfigurationImpl tmpConfig = new FileConfigurationImpl(tmpConfigFile);
        TreeMap<String, Object> allProps = tmpConfig.getAllProperties();
        for (String key : allProps.keySet()) {
            Object value = allProps.get(key);
            if (value == null) continue;
            Parameter param = tmpConfig.getParameterByKey(key);
            if (param != null && File.class.isAssignableFrom(param.getType())) {
                try {
                    File tmp;
                    String path = tmpConfigFile.getParentFile().getAbsolutePath();
                    if (!StringUtils.endsWith((CharSequence)path, (CharSequence)File.separator)) {
                        path = path + File.separator;
                    }
                    if (!(tmp = new File(path = path + value.toString())).exists()) {
                        path = value.toString();
                    }
                    this.setValue(key, path);
                }
                catch (Exception ex) {
                    this.setValue(key, value.toString());
                }
                continue;
            }
            this.setValue(key, value.toString());
        }
        this.store();
    }

    protected void initParameters() {
        this.parametersMap.put(ConfigurationParameters.PARAM_USER_EXPERT_CONFIGURATION_ENABLED.getKey(), ConfigurationParameters.PARAM_USER_EXPERT_CONFIGURATION_ENABLED);
        this.parametersMap.put(ConfigurationParameters.PARAM_USER_CONFIGURATION_ENABLED.getKey(), ConfigurationParameters.PARAM_USER_CONFIGURATION_ENABLED);
        this.parametersMap.put(ConfigurationParameters.PARAM_PROPERTIES_ENCRYPTION.getKey(), ConfigurationParameters.PARAM_PROPERTIES_ENCRYPTION);
        this.parametersMap.put(ConfigurationParameters.PARAM_MOUSE_WHEEL_ACTION.getKey(), ConfigurationParameters.PARAM_MOUSE_WHEEL_ACTION);
        this.parametersMap.put(ConfigurationParameters.PARAM_MOUSE_WHEEL_ZOOM_HIGHLIGHT_ENABLED.getKey(), ConfigurationParameters.PARAM_MOUSE_WHEEL_ZOOM_HIGHLIGHT_ENABLED);
        this.parametersMap.put(ConfigurationParameters.PARAM_MOUSE_WHEEL_ZOOM_HIGHLIGHT_COLOR.getKey(), ConfigurationParameters.PARAM_MOUSE_WHEEL_ZOOM_HIGHLIGHT_COLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_MOUSE_WHEEL_ZOOM_HIGHLIGHT_STROKE_WIDTH.getKey(), ConfigurationParameters.PARAM_MOUSE_WHEEL_ZOOM_HIGHLIGHT_STROKE_WIDTH);
        this.parametersMap.put(ConfigurationParameters.PARAM_SHOW_ALERT_NOTIFYS.getKey(), ConfigurationParameters.PARAM_SHOW_ALERT_NOTIFYS);
        this.parametersMap.put(ConfigurationParameters.PARAM_TOOLBAR_SHOW_SERVER_TIME.getKey(), ConfigurationParameters.PARAM_TOOLBAR_SHOW_SERVER_TIME);
        this.parametersMap.put(ConfigurationParameters.PARAM_NTP_SERVER.getKey(), ConfigurationParameters.PARAM_NTP_SERVER);
        this.parametersMap.put(ConfigurationParameters.PARAM_WWT_UNIT_GROUP_ENTRY_ID.getKey(), ConfigurationParameters.PARAM_WWT_UNIT_GROUP_ENTRY_ID);
        this.parametersMap.put(ConfigurationParameters.PARAM_OBSERVABLE_TOPIC_SELECTOR_UNITS.getKey(), ConfigurationParameters.PARAM_OBSERVABLE_TOPIC_SELECTOR_UNITS);
        this.parametersMap.put(ConfigurationParameters.PARAM_OBSERVABLE_TOPIC_SELECTOR_STANDS.getKey(), ConfigurationParameters.PARAM_OBSERVABLE_TOPIC_SELECTOR_STANDS);
        this.parametersMap.put(ConfigurationParameters.PARAM_OBSERVABLE_TOPIC_SELECTOR_NOTIFIES.getKey(), ConfigurationParameters.PARAM_OBSERVABLE_TOPIC_SELECTOR_NOTIFIES);
        this.parametersMap.put(ConfigurationParameters.PARAM_OBSERVABLE_TOPIC_SELECTOR_USE_EVENTS.getKey(), ConfigurationParameters.PARAM_OBSERVABLE_TOPIC_SELECTOR_USE_EVENTS);
        this.parametersMap.put(ConfigurationParameters.PARAM_SYMBOL_FILE.getKey(), ConfigurationParameters.PARAM_SYMBOL_FILE);
        this.parametersMap.put(ConfigurationParameters.PARAM_MAP_SHOW_UNITS.getKey(), ConfigurationParameters.PARAM_MAP_SHOW_UNITS);
        this.parametersMap.put(ConfigurationParameters.PARAM_TOOLBAR_DRIVER_VISIBLE.getKey(), ConfigurationParameters.PARAM_TOOLBAR_DRIVER_VISIBLE);
        this.parametersMap.put(ConfigurationParameters.PARAM_TOOLBAR_AREA_VISIBLE.getKey(), ConfigurationParameters.PARAM_TOOLBAR_AREA_VISIBLE);
        this.parametersMap.put(ConfigurationParameters.PARAM_TOOLBAR_GPS_VISIBLE.getKey(), ConfigurationParameters.PARAM_TOOLBAR_GPS_VISIBLE);
        this.parametersMap.put(ConfigurationParameters.PARAM_TOOLBAR_SPEED_VISIBLE.getKey(), ConfigurationParameters.PARAM_TOOLBAR_SPEED_VISIBLE);
        this.parametersMap.put(ConfigurationParameters.PARAM_TOOLBAR_SPEED_UNIT_MPH.getKey(), ConfigurationParameters.PARAM_TOOLBAR_SPEED_UNIT_MPH);
        this.parametersMap.put(ConfigurationParameters.PARAM_TOOLBAR_ZERO_SPEED.getKey(), ConfigurationParameters.PARAM_TOOLBAR_ZERO_SPEED);
        this.parametersMap.put(ConfigurationParameters.PARAM_TOOLBAR_ZERO_SPEED_CONDITION.getKey(), ConfigurationParameters.PARAM_TOOLBAR_ZERO_SPEED_CONDITION);
        this.parametersMap.put(ConfigurationParameters.PARAM_TOOLBAR_COURSE_VISIBLE.getKey(), ConfigurationParameters.PARAM_TOOLBAR_COURSE_VISIBLE);
        this.parametersMap.put(ConfigurationParameters.PARAM_TOOLBAR_KEEPALIVE_VISIBLE.getKey(), ConfigurationParameters.PARAM_TOOLBAR_KEEPALIVE_VISIBLE);
        this.parametersMap.put(ConfigurationParameters.PARAM_PATTERN_TOOLBAR_STATUS_FONTCOLOR.getKey(), ConfigurationParameters.PARAM_PATTERN_TOOLBAR_STATUS_FONTCOLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_TOOLBAR_SHOW_MESSAGE_AMOUNT_UNITS_ON_MAP.getKey(), ConfigurationParameters.PARAM_TOOLBAR_SHOW_MESSAGE_AMOUNT_UNITS_ON_MAP);
        this.parametersMap.put(ConfigurationParameters.PARAM_TOOLBAR_FILTER_UNIT_TYPE_NAME_VISIBLE.getKey(), ConfigurationParameters.PARAM_TOOLBAR_FILTER_UNIT_TYPE_NAME_VISIBLE);
        this.parametersMap.put(ConfigurationParameters.PARAM_MAP_SHOW_NOTIFIES.getKey(), ConfigurationParameters.PARAM_MAP_SHOW_NOTIFIES);
        this.parametersMap.put(ConfigurationParameters.PARAM_MAP_SHOW_NOTIFIES_UNIT_IDS.getKey(), ConfigurationParameters.PARAM_MAP_SHOW_NOTIFIES_UNIT_IDS);
        this.parametersMap.put(ConfigurationParameters.PARAM_MAP_SHOW_STANDS.getKey(), ConfigurationParameters.PARAM_MAP_SHOW_STANDS);
        this.parametersMap.put(ConfigurationParameters.PARAM_MAP_SHOW_STANDS_PLANNED_STATUS.getKey(), ConfigurationParameters.PARAM_MAP_SHOW_STANDS_PLANNED_STATUS);
        this.parametersMap.put(ConfigurationParameters.PARAM_TOOLBAR_RUNNING_SECONDS.getKey(), ConfigurationParameters.PARAM_TOOLBAR_RUNNING_SECONDS);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_SELECTOR_BLINK_FREQUENCY.getKey(), ConfigurationParameters.PARAM_UNIT_SELECTOR_BLINK_FREQUENCY);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_LOCAL_KEEPALIVE_TIMEOUT.getKey(), ConfigurationParameters.PARAM_UNIT_LOCAL_KEEPALIVE_TIMEOUT);
        this.parametersMap.put(ConfigurationParameters.PARAM_SVGSYMBOL_UNITNAME_MAXLENGTH.getKey(), ConfigurationParameters.PARAM_SVGSYMBOL_UNITNAME_MAXLENGTH);
        this.parametersMap.put(ConfigurationParameters.PARAM_GROUP_ALERT_SIGNS.getKey(), ConfigurationParameters.PARAM_GROUP_ALERT_SIGNS);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_ON_OFF_SWITCH_VISIBLE.getKey(), ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_ON_OFF_SWITCH_VISIBLE);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_CLEAR_ON_CLICK.getKey(), ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_CLEAR_ON_CLICK);
        this.parametersMap.put(ConfigurationParameters.PARAM_GROUP_ALERT_SIGN_1.getKey(), ConfigurationParameters.PARAM_GROUP_ALERT_SIGN_1);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_1_MESSAGE_ID.getKey(), ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_1_MESSAGE_ID);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_1_COLOR.getKey(), ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_1_COLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_GROUP_ALERT_SIGN_2.getKey(), ConfigurationParameters.PARAM_GROUP_ALERT_SIGN_2);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_2_MESSAGE_ID.getKey(), ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_2_MESSAGE_ID);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_2_COLOR.getKey(), ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_2_COLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_GROUP_ALERT_SIGN_3.getKey(), ConfigurationParameters.PARAM_GROUP_ALERT_SIGN_3);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_3_MESSAGE_ID.getKey(), ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_3_MESSAGE_ID);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_3_COLOR.getKey(), ConfigurationParameters.PARAM_UNIT_ALERT_SIGN_3_COLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_TOOLTIP_VISIBLE.getKey(), ConfigurationParameters.PARAM_UNIT_TOOLTIP_VISIBLE);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_TOOLTIP_TEXT_COLOR.getKey(), ConfigurationParameters.PARAM_UNIT_TOOLTIP_TEXT_COLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_TOOLTIP_TEXT_SIZE.getKey(), ConfigurationParameters.PARAM_UNIT_TOOLTIP_TEXT_SIZE);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_TOOLTIP_BACKGROUND_COLOR.getKey(), ConfigurationParameters.PARAM_UNIT_TOOLTIP_BACKGROUND_COLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_TOOLTIP_BACKGROUND_STROKE_COLOR.getKey(), ConfigurationParameters.PARAM_UNIT_TOOLTIP_BACKGROUND_STROKE_COLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_TOOLTIP_SHOW_UNIT_TYPE.getKey(), ConfigurationParameters.PARAM_UNIT_TOOLTIP_SHOW_UNIT_TYPE);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_TOOLTIP_SHOW_AREA.getKey(), ConfigurationParameters.PARAM_UNIT_TOOLTIP_SHOW_AREA);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_TOOLTIP_SHOW_GPS_POSITION.getKey(), ConfigurationParameters.PARAM_UNIT_TOOLTIP_SHOW_GPS_POSITION);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_TOOLTIP_SHOW_SPEED.getKey(), ConfigurationParameters.PARAM_UNIT_TOOLTIP_SHOW_SPEED);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_TOOLTIP_SHOW_COURSE.getKey(), ConfigurationParameters.PARAM_UNIT_TOOLTIP_SHOW_COURSE);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_TOOLTIP_SHOW_KEEPALIVE.getKey(), ConfigurationParameters.PARAM_UNIT_TOOLTIP_SHOW_KEEPALIVE);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_CONTEXTMENU_GENERAL.getKey(), ConfigurationParameters.PARAM_UNIT_CONTEXTMENU_GENERAL);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_CONTEXTMENU_FOLLOW_ME.getKey(), ConfigurationParameters.PARAM_UNIT_CONTEXTMENU_FOLLOW_ME);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_CONTEXTMENU_SNAIL_TRAIL.getKey(), ConfigurationParameters.PARAM_UNIT_CONTEXTMENU_SNAIL_TRAIL);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_CONTEXTMENU_ADD_UNIT_TO_FILTER.getKey(), ConfigurationParameters.PARAM_UNIT_CONTEXTMENU_ADD_UNIT_TO_FILTER);
        this.parametersMap.put(ConfigurationParameters.PARAM_UNIT_CONTEXTMENU_FIX_POSITION_CONDITION.getKey(), ConfigurationParameters.PARAM_UNIT_CONTEXTMENU_FIX_POSITION_CONDITION);
        this.parametersMap.put(ConfigurationParameters.PARAM_GROUP_STAND_COLOR_STAND_ALLOCATION_STATUS.getKey(), ConfigurationParameters.PARAM_GROUP_STAND_COLOR_STAND_ALLOCATION_STATUS);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_COLOR_STAND_ALLOCATION_STATUS_EMPTY.getKey(), ConfigurationParameters.PARAM_STAND_COLOR_STAND_ALLOCATION_STATUS_EMPTY);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_COLOR_STAND_ALLOCATION_STATUS_TAKEN.getKey(), ConfigurationParameters.PARAM_STAND_COLOR_STAND_ALLOCATION_STATUS_TAKEN);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_COLOR_STAND_ALLOCATION_STATUS_UNKNOWN.getKey(), ConfigurationParameters.PARAM_STAND_COLOR_STAND_ALLOCATION_STATUS_UNKNOWN);
        this.parametersMap.put(ConfigurationParameters.PARAM_GROUP_STAND_COLOR_STAND_PLAN_STATUS.getKey(), ConfigurationParameters.PARAM_GROUP_STAND_COLOR_STAND_PLAN_STATUS);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_COLOR_STAND_PLAN_STATUS_NONE.getKey(), ConfigurationParameters.PARAM_STAND_COLOR_STAND_PLAN_STATUS_NONE);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_COLOR_STAND_PLAN_STATUS_PLANNED.getKey(), ConfigurationParameters.PARAM_STAND_COLOR_STAND_PLAN_STATUS_PLANNED);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_COLOR_STAND_PLAN_STATUS_UNKNOWN.getKey(), ConfigurationParameters.PARAM_STAND_COLOR_STAND_PLAN_STATUS_UNKNOWN);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_SELECTOR_BLINK_FREQUENCY.getKey(), ConfigurationParameters.PARAM_STAND_SELECTOR_BLINK_FREQUENCY);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_VISIBLE.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_VISIBLE);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_TEXT_COLOR.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_TEXT_COLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_TEXT_SIZE.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_TEXT_SIZE);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_BACKGROUND_COLOR.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_BACKGROUND_COLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_BACKGROUND_STROKE_COLOR.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_BACKGROUND_STROKE_COLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_STAND_NAME.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_STAND_NAME);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_ALLOCATION_STATUS.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_ALLOCATION_STATUS);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_REGISTRATION_NUMBER.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_REGISTRATION_NUMBER);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_CATEGORY.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_CATEGORY);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_AIRCRAFT_MODEL_TYPE.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_AIRCRAFT_MODEL_TYPE);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_INBOUND_FLIGHT_NUMBER.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_INBOUND_FLIGHT_NUMBER);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_INBOUND_FLIGHT_TYPE.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_INBOUND_FLIGHT_TYPE);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_INBOUND_ORIGIN.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_INBOUND_ORIGIN);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_INBOUND_STA.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_INBOUND_STA);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_INBOUND_ETA.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_INBOUND_ETA);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_INBOUND_ONBL.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_INBOUND_ONBL);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_OUTBOUND_FLIGHT_NUMBER.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_OUTBOUND_FLIGHT_NUMBER);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_OUTBOUND_FLIGHT_TYPE.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_OUTBOUND_FLIGHT_TYPE);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_OUTBOUND_DESTINATION.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_OUTBOUND_DESTINATION);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_OUTBOUND_STD.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_OUTBOUND_STD);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_OUTBOUND_ETD.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_OUTBOUND_ETD);
        this.parametersMap.put(ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_OUTBOUND_OFBL.getKey(), ConfigurationParameters.PARAM_STAND_TOOLTIP_SHOW_OUTBOUND_OFBL);
        this.parametersMap.put(ConfigurationParameters.PARAM_SNAILTRAIL_SEGMENTS_MAXIMUM.getKey(), ConfigurationParameters.PARAM_SNAILTRAIL_SEGMENTS_MAXIMUM);
        this.parametersMap.put(ConfigurationParameters.PARAM_SNAILTRAIL_LINE_COLOR.getKey(), ConfigurationParameters.PARAM_SNAILTRAIL_LINE_COLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_SNAILTRAIL_LINE_STROKE_WIDTH.getKey(), ConfigurationParameters.PARAM_SNAILTRAIL_LINE_STROKE_WIDTH);
        this.parametersMap.put(ConfigurationParameters.PARAM_SNAILTRAIL_CIRCLE_FILL_COLOR.getKey(), ConfigurationParameters.PARAM_SNAILTRAIL_CIRCLE_FILL_COLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_SNAILTRAIL_CIRCLE_STROKE_COLOR.getKey(), ConfigurationParameters.PARAM_SNAILTRAIL_CIRCLE_STROKE_COLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_SNAILTRAIL_CIRCLE_STROKE_WIDTH.getKey(), ConfigurationParameters.PARAM_SNAILTRAIL_CIRCLE_STROKE_WIDTH);
        this.parametersMap.put(ConfigurationParameters.PARAM_SNAILTRAIL_CIRCLE_RADIUS.getKey(), ConfigurationParameters.PARAM_SNAILTRAIL_CIRCLE_RADIUS);
        this.parametersMap.put(ConfigurationParameters.PARAM_SNAILTRAIL_RECT_FILL_COLOR.getKey(), ConfigurationParameters.PARAM_SNAILTRAIL_RECT_FILL_COLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_SNAILTRAIL_RECT_STROKE_COLOR.getKey(), ConfigurationParameters.PARAM_SNAILTRAIL_RECT_STROKE_COLOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_SNAILTRAIL_RECT_STROKE_WIDTH.getKey(), ConfigurationParameters.PARAM_SNAILTRAIL_RECT_STROKE_WIDTH);
        this.parametersMap.put(ConfigurationParameters.PARAM_SNAILTRAIL_TEXT_FONT_SIZE.getKey(), ConfigurationParameters.PARAM_SNAILTRAIL_TEXT_FONT_SIZE);
        this.parametersMap.put(ConfigurationParameters.PARAM_SNAILTRAIL_TOOLTIP_SPEED_VISIBLE.getKey(), ConfigurationParameters.PARAM_SNAILTRAIL_TOOLTIP_SPEED_VISIBLE);
        this.parametersMap.put(ConfigurationParameters.PARAM_SNAILTRAIL_TOOLTIP_DRIVER_VISIBLE.getKey(), ConfigurationParameters.PARAM_SNAILTRAIL_TOOLTIP_DRIVER_VISIBLE);
        this.parametersMap.put(ConfigurationParameters.PARAM_SNAILTRAIL_HIGHLIGHT_FACTOR.getKey(), ConfigurationParameters.PARAM_SNAILTRAIL_HIGHLIGHT_FACTOR);
        this.parametersMap.put(ConfigurationParameters.PARAM_SNAILTRAIL_COLOR_ATTACH_FOR_GROUPS.getKey(), ConfigurationParameters.PARAM_SNAILTRAIL_COLOR_ATTACH_FOR_GROUPS);
        Collection paramProviders = Lookup.getDefault().lookupAll(ConfigurationParametersProvider.class);
        for (ConfigurationParametersProvider paramProvider : paramProviders) {
            Map<String, Parameter> extraParams = paramProvider.getConfigurationParameters();
            if (extraParams == null || extraParams.isEmpty()) continue;
            this.parametersMap.putAll(extraParams);
        }
        this.parametersMap.put(ConfigurationParameters.PARAM_TEMP_APPLICATION_START_TIME.getKey(), ConfigurationParameters.PARAM_TEMP_APPLICATION_START_TIME);
        this.parametersMap.put(ConfigurationParameters.PARAM_TEMP_APPLICATION_LOGIN_TIME.getKey(), ConfigurationParameters.PARAM_TEMP_APPLICATION_LOGIN_TIME);
        this.parametersMap.put(ConfigurationParameters.PARAM_TEMP_APPLICATION_VERSION.getKey(), ConfigurationParameters.PARAM_TEMP_APPLICATION_VERSION);
        this.parametersMap.put(ConfigurationParameters.PARAM_TEMP_JAVA_RUNTIME_VERSION.getKey(), ConfigurationParameters.PARAM_TEMP_JAVA_RUNTIME_VERSION);
        this.parametersMap.put(ConfigurationParameters.PARAM_TEMP_JAVA_HOME.getKey(), ConfigurationParameters.PARAM_TEMP_JAVA_HOME);
        this.parametersMap.put(ConfigurationParameters.PARAM_TEMP_OS_HOST_NAME.getKey(), ConfigurationParameters.PARAM_TEMP_OS_HOST_NAME);
        this.parametersMap.put(ConfigurationParameters.PARAM_TEMP_OS_USER_NAME.getKey(), ConfigurationParameters.PARAM_TEMP_OS_USER_NAME);
        this.parametersMap.put(ConfigurationParameters.PARAM_TEMP_OS_NAME.getKey(), ConfigurationParameters.PARAM_TEMP_OS_NAME);
        this.parametersMap.put(ConfigurationParameters.PARAM_TEMP_SERVER_INFOMAN_KEEPALIVE_TIMEOUT.getKey(), ConfigurationParameters.PARAM_TEMP_SERVER_INFOMAN_KEEPALIVE_TIMEOUT);
        this.parametersMap.put(ConfigurationParameters.PARAM_TEMP_SERVER_OBSERVABLE_NOTIFIES_MAXIMUM_PER_UNIT_PER_DAY.getKey(), ConfigurationParameters.PARAM_TEMP_SERVER_OBSERVABLE_NOTIFIES_MAXIMUM_PER_UNIT_PER_DAY);
        this.parametersMap.put(ConfigurationParameters.PARAM_TEMP_WWT_CLIENT_ID.getKey(), ConfigurationParameters.PARAM_TEMP_WWT_CLIENT_ID);
        this.parametersMap.put(ConfigurationParameters.PARAM_TEMP_WWT_PASS_RESTORE.getKey(), ConfigurationParameters.PARAM_TEMP_WWT_PASS_RESTORE);
        this.parametersMap.put(ConfigurationParameters.PARAM_TEMP_SIMULATOR_MODE.getKey(), ConfigurationParameters.PARAM_TEMP_SIMULATOR_MODE);
        this.parametersMap.put(ConfigurationParameters.PARAM_TEMP_MAP_MONITOR_SERVER_VERSION.getKey(), ConfigurationParameters.PARAM_TEMP_MAP_MONITOR_SERVER_VERSION);
    }

    @Override
    public void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    @Override
    public void revertChanges() {
        try {
            this.load();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "revert changes runs into", ex);
        }
        this.changedParametersMap.clear();
    }

    protected abstract void setValue(String var1, String var2);

    public String toString() {
        return this.getName();
    }
}

