/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.api.parameter.type;

import de.proveo.client.configuration.ui.util.StatusModels;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class StateModel {
    private static StateModel[] stateModels = null;
    private int stateModelId;
    private int stateId;
    private String name;

    public StateModel(int stateModelId, int stateId) {
        this(stateModelId, stateId, null);
    }

    public StateModel(int stateModelId, int stateId, String name) {
        this.stateModelId = stateModelId;
        this.stateId = stateId;
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof StateModel) {
            StateModel other = (StateModel)obj;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.stateModelId, other.stateModelId);
            eb.append(this.stateId, other.stateId);
            return eb.isEquals();
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getStateId() {
        return this.stateId;
    }

    public int getStateModelId() {
        return this.stateModelId;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append(this.stateModelId);
        hcb.append(this.stateId);
        return hcb.toHashCode();
    }

    public static synchronized StateModel stateModelOf(String value) {
        String[] values;
        if (value != null && value.contains(".") && (values = StringUtils.split((String)value, (String)".")).length == 2) {
            int stateId;
            int stateModelId;
            try {
                stateModelId = Integer.parseInt(values[0]);
                stateId = Integer.parseInt(values[1]);
            }
            catch (Exception ex) {
                return null;
            }
            if (stateModels != null) {
                for (StateModel sm : stateModels) {
                    if (stateModelId != sm.getStateModelId() || stateId != sm.getStateId()) continue;
                    return sm;
                }
            }
            return new StateModel(stateModelId, stateId);
        }
        return null;
    }

    public static synchronized StateModel[] getStates(StatusModels statusModels) {
        stateModels = null;
        if (statusModels == null) {
            return new StateModel[0];
        }
        List<Integer> statusModelIds = statusModels.getStatusModelIdsSorted();
        ArrayList<StateModel> sm = new ArrayList<StateModel>();
        for (int i = 0; i < statusModelIds.size(); ++i) {
            int smId = statusModelIds.get(i);
            String statusModelName = statusModels.getStatusModelName(smId);
            List<Integer> statusIds = statusModels.getStatusIdsSorted(smId);
            for (int j = 0; j < statusIds.size(); ++j) {
                int sId = statusIds.get(j);
                sm.add(new StateModel(smId, sId, statusModelName + " - " + statusModels.getStatusName(smId, sId)));
            }
        }
        Object[] ret = new StateModel[sm.size()];
        ret = sm.toArray(ret);
        stateModels = (StateModel[])ArrayUtils.clone((Object[])ret);
        return ret;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return this.stateModelId + "." + this.stateId;
    }
}

