/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.api.parameter;

import de.proveo.client.configuration.api.ConfigurationConstants;
import de.proveo.client.configuration.api.parameter.Parameter;
import de.proveo.client.configuration.api.parameter.condition.Condition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DefaultParameter<T>
implements Parameter<T> {
    protected final List<Parameter> children = new ArrayList<Parameter>();
    protected final String key;
    protected final String displayName;
    protected final String shortDescription;
    protected final ConfigurationConstants.Category category;
    protected final T defaultValue;
    protected final Class<T> type;
    protected final ConfigurationConstants.DisplayCategory displayCategory;
    protected final Parameter parent;
    protected final boolean restartNeeded;
    protected final Condition[] conditions;
    protected boolean temporary;

    public DefaultParameter(String key, String displayName, String shortDescription, ConfigurationConstants.Category category, T defaultValue, Class<T> type, ConfigurationConstants.DisplayCategory displayCategory, Parameter parent, boolean restartNeeded) {
        this(key, displayName, shortDescription, category, defaultValue, type, displayCategory, parent, restartNeeded, new Condition[0]);
    }

    public DefaultParameter(String key, String displayName, String shortDescription, ConfigurationConstants.Category category, T defaultValue, Class<T> type, ConfigurationConstants.DisplayCategory displayCategory, Parameter parent, boolean restartNeeded, Condition ... conditions) {
        this.key = key;
        this.displayName = displayName;
        this.shortDescription = shortDescription;
        this.category = category;
        this.defaultValue = defaultValue;
        this.type = type;
        this.displayCategory = displayCategory;
        this.parent = parent;
        this.restartNeeded = restartNeeded;
        this.conditions = conditions;
        this.temporary = false;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    @Override
    public void addChild(Parameter parameter) {
        this.children.add(parameter);
    }

    @Override
    public ConfigurationConstants.Category getCategory() {
        return this.category;
    }

    @Override
    public List<Parameter> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public ConfigurationConstants.DisplayCategory getDisplayCategory() {
        return this.displayCategory;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Parameter getParent() {
        return this.parent;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Condition[] getConditions() {
        return this.conditions;
    }

    @Override
    public boolean isRestartNeeded() {
        return this.restartNeeded;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Parameter) {
            Parameter param = (Parameter)obj;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((Object)this.key, (Object)param.getKey());
            eb.append(this.temporary, param.isTemporary());
            return eb.isEquals();
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)this.key);
        hcb.append(this.temporary);
        return hcb.toHashCode();
    }
}

