/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.api;

import de.proveo.client.configuration.api.Configuration;
import de.proveo.client.configuration.api.ConfigurationChangedListener;
import de.proveo.client.configuration.api.ConfigurationsChangedListener;
import de.proveo.client.configuration.api.parameter.Parameter;
import de.proveo.client.configuration.impl.MemoryConfigurationImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Observer;
import org.apache.commons.lang3.ObjectUtils;

public class ConfigurationProvider {
    private final List<Observer> configurationObservers = new ArrayList<Observer>();
    private final List<ConfigurationChangedListener> configurationChangedListeners = new ArrayList<ConfigurationChangedListener>();
    private final List<ConfigurationsChangedListener> configurationsChangedListeners = new ArrayList<ConfigurationsChangedListener>();
    private final List<Configuration> availableConfigurations = Collections.synchronizedList(new ArrayList());
    private Configuration activeConfiguration = new MemoryConfigurationImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurationChangedListener(ConfigurationChangedListener l) {
        List<ConfigurationChangedListener> list = this.configurationChangedListeners;
        synchronized (list) {
            this.configurationChangedListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurationsChangedListener(ConfigurationsChangedListener l) {
        List<ConfigurationsChangedListener> list = this.configurationsChangedListeners;
        synchronized (list) {
            this.configurationsChangedListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurationObserver(Observer observer) {
        List<Observer> list = this.configurationObservers;
        synchronized (list) {
            this.configurationObservers.add(observer);
            this.activeConfiguration.addObserver(observer);
        }
    }

    public Configuration getActiveConfiguration() {
        return this.activeConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Configuration> getAvailableConfigurations() {
        List<Configuration> list = this.availableConfigurations;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Configuration>(this.availableConfigurations));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigurationChangedListener(ConfigurationChangedListener l) {
        List<ConfigurationChangedListener> list = this.configurationChangedListeners;
        synchronized (list) {
            this.configurationChangedListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigurationsChangedListener(ConfigurationsChangedListener l) {
        List<ConfigurationsChangedListener> list = this.configurationsChangedListeners;
        synchronized (list) {
            this.configurationsChangedListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigurationObserver(Observer observer) {
        List<Observer> list = this.configurationObservers;
        synchronized (list) {
            this.configurationObservers.remove(observer);
            this.activeConfiguration.deleteObserver(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveConfiguration(Configuration configuration) {
        if (this.activeConfiguration == configuration) {
            return;
        }
        Configuration oldConfig = this.activeConfiguration;
        oldConfig.deleteObservers();
        if (configuration == null) {
            configuration = new MemoryConfigurationImpl();
        } else {
            List<Configuration> oldConfigs = null;
            List<Object> list = this.availableConfigurations;
            synchronized (list) {
                if (!this.availableConfigurations.contains(configuration)) {
                    oldConfigs = this.getAvailableConfigurations();
                    this.availableConfigurations.add(configuration);
                }
            }
            if (oldConfigs != null) {
                list = this.configurationsChangedListeners;
                synchronized (list) {
                    List<Configuration> newConfigs = this.getAvailableConfigurations();
                    for (ConfigurationsChangedListener l : this.configurationsChangedListeners) {
                        l.configurationsChanged(oldConfigs, newConfigs);
                    }
                }
            }
        }
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        parameters.putAll(oldConfig.getAllParameters());
        for (Parameter param : parameters.values()) {
            if (!param.isTemporary()) continue;
            Object oldValue = oldConfig.getValue(param);
            configuration.setValue(param, oldValue);
        }
        ArrayList<Parameter> changedParameters = new ArrayList<Parameter>();
        parameters.putAll(configuration.getAllParameters());
        for (Parameter param : parameters.values()) {
            Object oldValue = oldConfig.getValue(param);
            Object newValue = configuration.getValue(param);
            if (param.isTemporary() || !ObjectUtils.notEqual(oldValue, newValue)) continue;
            changedParameters.add(param);
        }
        List<Object> list = this.configurationObservers;
        synchronized (list) {
            for (Observer o : this.configurationObservers) {
                configuration.addObserver(o);
            }
        }
        this.activeConfiguration = configuration;
        list = this.configurationChangedListeners;
        synchronized (list) {
            for (ConfigurationChangedListener l : this.configurationChangedListeners) {
                l.configurationChanged(oldConfig, this.activeConfiguration);
            }
        }
        list = this.configurationObservers;
        synchronized (list) {
            if (!changedParameters.isEmpty()) {
                for (Parameter param : changedParameters) {
                    configuration.notifyObservers(param);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailableConfigurations(List<Configuration> configurations) {
        List<Configuration> oldConfigs = this.getAvailableConfigurations();
        List<Configuration> list = this.availableConfigurations;
        synchronized (list) {
            this.availableConfigurations.clear();
            this.availableConfigurations.addAll(configurations);
        }
        List<Configuration> newConfigs = this.getAvailableConfigurations();
        if (ObjectUtils.notEqual(oldConfigs, newConfigs)) {
            List<ConfigurationsChangedListener> list2 = this.configurationsChangedListeners;
            synchronized (list2) {
                for (ConfigurationsChangedListener l : this.configurationsChangedListeners) {
                    l.configurationsChanged(oldConfigs, newConfigs);
                }
            }
        }
    }
}

