/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.client.configuration.api;

import de.proveo.client.configuration.util.PackageUtils;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public interface ConfigurationConstants {
    public static final Color[] MULTI_SNAILTRAIL_COLORS = new Color[]{new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 0, 255), new Color(255, 255, 0), new Color(255, 0, 255), new Color(0, 255, 255), new Color(255, 255, 255), new Color(0, 0, 0), new Color(255, 204, 0), new Color(204, 204, 255)};
    public static final int REPLAY_MAXIMUM_SPEED = 60;
    public static final String XML_SCHEMA_URL_PREFIX = "http://proveo.de/xml/fleet-management/";
    public static final String XML_META_SCHEMA_NAMESPACE = "meta";
    public static final String XML_META_SCHEMA_VERSION = "1.0";
    public static final String XML_RESOURCES_SCHEMA_NAMESPACE = "resources";
    public static final String XML_RESOURCES_SCHEMA_VERSION = "1.0";
    public static final String XML_STATEMODEL_SCHEMA_NAMESPACE = "statemodel";
    public static final String XML_STATEMODEL_SCHEMA_VERSION = "1.0";
    public static final String XML_STATEMODEL_SVG_MAPPING_SCHEMA_NAMESPACE = "statemodel-layer-mapping";
    public static final String XML_STATEMODEL_SVG_MAPPING_SCHEMA_VERSION = "1.0";
    public static final String XML_MEASUREMENT_SCHEMA_NAMESPACE = "measurement";
    public static final String XML_MEASUREMENT_SCHEMA_VERSION = "1.0";

    public static enum AlertNotify {
        NONE("none", "trayNotifyNone"),
        ALERTS("alerts", "trayNotifyAlerts"),
        ALL("all", "trayNotifyAll");

        private final String name;
        private final String resourceString;
        private String translatedName;

        private AlertNotify(String name, String resourceString) {
            this.name = name;
            this.resourceString = resourceString;
        }

        public String toString() {
            if (this.translatedName == null) {
                return this.name;
            }
            return this.translatedName;
        }

        public String getName() {
            return this.name;
        }

        public String getResourceString() {
            return this.resourceString;
        }

        public void setTranslatedName(String translatedName) {
            this.translatedName = translatedName;
        }

        public static AlertNotify nameOf(String name) {
            AlertNotify[] notifies;
            for (AlertNotify notify : notifies = AlertNotify.values()) {
                if (!notify.name.equalsIgnoreCase(name)) continue;
                return notify;
            }
            return null;
        }
    }

    public static final class SoundFile {
        private static final Logger log = Logger.getLogger(SoundFile.class.getName());
        private static final int EXTERNAL_BUFFER_SIZE = 524288;
        private String filename;

        public SoundFile(String filename) {
            this.filename = filename;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof SoundFile) {
                SoundFile other = (SoundFile)obj;
                EqualsBuilder eb = new EqualsBuilder();
                eb.append((Object)this.filename, (Object)other.filename);
                return eb.isEquals();
            }
            return false;
        }

        public String getFilename() {
            return this.filename;
        }

        public int hashCode() {
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append((Object)this.filename);
            return hcb.toHashCode();
        }

        public void play() {
            new Thread("PlaySoundFile(" + this.filename + ")"){

                @Override
                public void run() {
                    SoundFile.this.playBlocking();
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void playBlocking() {
            SourceDataLine dataLine;
            AudioInputStream audioInputStream;
            String method = "playBlocking(): ";
            try {
                InputStream in = ConfigurationConstants.class.getResourceAsStream("/de/proveo/client/configuration/resources/sounds/" + this.filename);
                audioInputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(in));
            }
            catch (Throwable ex) {
                log.log(Level.SEVERE, method + "Could not get AudioInputStream for '" + this.filename + "'", ex);
                return;
            }
            AudioFormat audioFormat = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            try {
                dataLine = (SourceDataLine)AudioSystem.getLine(info);
                dataLine.open(audioFormat, 524288);
            }
            catch (LineUnavailableException e1) {
                log.log(Level.SEVERE, method + "Could not open audio channel for '" + this.filename + "'", e1);
                return;
            }
            dataLine.start();
            int readBytes = 0;
            byte[] audioBuffer = new byte[524288];
            try {
                while (readBytes != -1) {
                    readBytes = audioInputStream.read(audioBuffer, 0, audioBuffer.length);
                    if (readBytes < 0) continue;
                    dataLine.write(audioBuffer, 0, readBytes);
                }
            }
            catch (IOException e1) {
                log.log(Level.SEVERE, method + "Error while reading audio stream and writing on data line for '" + this.filename + "'", e1);
            }
            finally {
                dataLine.drain();
                dataLine.close();
            }
        }

        public String toString() {
            return this.getFilename();
        }

        public static SoundFile[] values() {
            String packageName = "de.proveo.client.configuration.resources.sounds";
            List<String> list = PackageUtils.getFileNamesInPackage(packageName, "wav");
            SoundFile[] values = new SoundFile[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                values[i] = new SoundFile(list.get(i).replaceFirst(packageName + ".", ""));
            }
            return values;
        }
    }

    public static enum Protocol {
        HTTP("http"),
        HTTPS("https");

        private final String name;

        private Protocol(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Protocol nameOf(String name) {
            Protocol[] protocols;
            for (Protocol protocol : protocols = Protocol.values()) {
                if (!protocol.name.equalsIgnoreCase(name)) continue;
                return protocol;
            }
            return null;
        }
    }

    public static enum MouseWheelAction {
        ZOOM("zoom", "mouseWheelActionZoom"),
        SCROLL("scroll", "mouseWheelActionScroll"),
        NONE("none", "mouseWheelActionNone");

        private final String name;
        private final String resourceString;
        private String translatedName;

        private MouseWheelAction(String name, String resourceString) {
            this.name = name;
            this.resourceString = resourceString;
        }

        public String toString() {
            if (this.translatedName == null) {
                return this.name;
            }
            return this.translatedName;
        }

        public String getName() {
            return this.name;
        }

        public String getResourceString() {
            return this.resourceString;
        }

        public void setTranslatedName(String translatedName) {
            this.translatedName = translatedName;
        }

        public static MouseWheelAction nameOf(String name) {
            MouseWheelAction[] actions;
            for (MouseWheelAction action : actions = MouseWheelAction.values()) {
                if (!action.name.equalsIgnoreCase(name)) continue;
                return action;
            }
            return null;
        }
    }

    public static enum Language {
        GERMAN_GERMANY(Locale.GERMANY.getDisplayName(), "de-DE"),
        GERMAN_AUSTRIA(new Locale("de", "AT").getDisplayName(), "de-AT"),
        GERMAN_LUXEMBOURG(new Locale("de", "LU").getDisplayName(), "de-LU"),
        GERMAN_SWITZERLAND(new Locale("de", "CH").getDisplayName(), "de-CH"),
        ENGLISH_UNITED_STATES(Locale.US.getDisplayName(), "en-US"),
        ENGLISH_AUSTRALIA(new Locale("en", "AU").getDisplayName(), "en-AU"),
        ENGLISH_CANADA(new Locale("en", "CA").getDisplayName(), "en-CA"),
        ENGLISH_INDIA(new Locale("en", "IN").getDisplayName(), "en-IN"),
        ENGLISH_IRELAND(new Locale("en", "IE").getDisplayName(), "en-IE"),
        ENGLISH_MALTA(new Locale("en", "MT").getDisplayName(), "en-MT"),
        ENGLISH_NEW_ZEALAND(new Locale("en", "NZ").getDisplayName(), "en-NZ"),
        ENGLISH_PHILIPPINES(new Locale("en", "PH").getDisplayName(), "en-PH"),
        ENGLISH_SINGAPORE(new Locale("en", "SG").getDisplayName(), "en-SG"),
        ENGLISH_SOUTH_AFRICA(new Locale("en", "ZA").getDisplayName(), "en-ZA"),
        ENGLISH_UNITED_KINGDOM(new Locale("en", "GB").getDisplayName(), "en-GB"),
        RUSSIAN_RUSSIA(new Locale("ru", "RU").getDisplayName(), "ru-RU");

        private final String displayName;
        private final String languageCode;

        private Language(String displayName, String languageCode) {
            this.displayName = displayName;
            this.languageCode = languageCode;
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        public String toString() {
            return this.displayName;
        }

        public static Language nameOf(String language) {
            Language[] languages;
            for (Language lang : languages = Language.values()) {
                if (!lang.languageCode.equalsIgnoreCase(language)) continue;
                return lang;
            }
            return null;
        }

        public static Language codeOf(String languageCode) {
            Language[] languages;
            for (Language lang : languages = Language.values()) {
                if (!lang.languageCode.equalsIgnoreCase(languageCode)) continue;
                return lang;
            }
            return null;
        }
    }

    public static enum FunctionKey {
        F1,
        F2,
        F3,
        F4,
        F5,
        F6,
        F7,
        F8,
        F9,
        F10,
        F11,
        F12;

    }

    public static enum DisplayCategory {
        MINIMUM,
        USER,
        HIDDEN,
        EXPERT,
        ADMIN;

    }

    public static enum Category {
        GENERAL("confCatGeneral"),
        AUTHENTICATION("confCatAuth"),
        STAND_STATE_COLORS("confCatStandStateColors"),
        MAP("confCatMap"),
        SNAILTRAIL("confCatSnailTrail"),
        TOOLBAR_APPERANCE("confCatToolbarAppearance"),
        USER_LIMITATIONS("confCatUserLimitations"),
        OBSERVABLE("confCatObservable"),
        REPLAY("confCatReplay"),
        CONTEXT_MENU("confCatContextMenu"),
        UNIT_APPEARANCE("confCatAppearance"),
        STANDS("confCatStands"),
        MENU_BAR("confCatMenuBar"),
        ERROR_HANDLING("confCatErrorHandling"),
        DEBUG("confCatDebug"),
        USAGE("txtCatUsage");

        private final String resString;

        private Category(String resString) {
            this.resString = resString;
        }

        public String toString() {
            return this.resString;
        }

        public static Category resourceStringOf(String resString) {
            Category[] categories;
            for (Category cat : categories = Category.values()) {
                if (!cat.resString.equalsIgnoreCase(resString)) continue;
                return cat;
            }
            return null;
        }
    }
}

