/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.KeyEventBlocker;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkManager;
import org.netbeans.modules.editor.bookmarks.BookmarkUtils;
import org.netbeans.modules.editor.bookmarks.ui.BookmarkKeyChooser;
import org.openide.actions.GotoAction;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class GotoLineOrBookmarkPanel
extends JPanel
implements ActionListener,
FocusListener,
WindowListener {
    static final long serialVersionUID = 1L;
    private static final List<String> history = new GapList();
    private static Rectangle lastBounds;
    private static final ResourceBundle bundle;
    private static final int MAX_HISTORY_ITEMS = 20;
    private JButton[] buttons;
    private static Dialog dialog;
    private WeakReference<JTextComponent> targetComponent;
    private KeyEventBlocker blocker;
    protected JComboBox gotoCombo;
    protected JLabel gotoLabel;

    public GotoLineOrBookmarkPanel() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleName(bundle.getString("ACSD_gotoDialogTitle"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_gotoDialogDescription"));
        this.gotoCombo.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_gotoDialogGotoCombo"));
        this.updateCombo();
        JButton gotoButton = new JButton(bundle.getString("CTL_gotoDialogGotoButton"));
        JButton closeButton = new JButton(bundle.getString("CTL_gotoDialogCloseButton"));
        gotoButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_gotoDialogGotoButton"));
        closeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_gotoDialogCloseButton"));
        this.buttons = new JButton[]{gotoButton, closeButton};
    }

    private JTextComponent getTargetComponent() {
        return this.targetComponent != null ? (JTextComponent)this.targetComponent.get() : EditorRegistry.lastFocusedComponent();
    }

    public void setTargetComponent(JTextComponent targetComponent) {
        this.targetComponent = new WeakReference<JTextComponent>(targetComponent);
    }

    private void initComponents() {
        this.gotoLabel = new JLabel();
        this.gotoCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.gotoLabel.setLabelFor(this.gotoCombo);
        Mnemonics.setLocalizedText((JLabel)this.gotoLabel, (String)bundle.getString("CTL_gotoDialogGotoLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.gotoLabel, gridBagConstraints);
        this.gotoCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        this.add((Component)this.gotoCombo, gridBagConstraints);
    }

    public void showDialog(JTextComponent target, KeyEventBlocker blocker) {
        this.setTargetComponent(target);
        this.blocker = blocker;
        if (dialog == null) {
            this.initDialog();
        }
        dialog.setVisible(true);
        this.gotoCombo.getEditor().getEditorComponent().addFocusListener(this);
        this.gotoCombo.getEditor().selectAll();
        this.gotoCombo.getEditor().getEditorComponent().requestFocus();
        this.gotoCombo.addActionListener(this);
        dialog.addWindowListener(this);
    }

    private Dialog initDialog() {
        dialog = DialogSupport.createDialog((String)bundle.getString("CTL_gotoDialogTitle"), (JPanel)this, (boolean)false, (JButton[])this.buttons, (boolean)false, (int)0, (int)1, (ActionListener)this);
        if (dialog instanceof JDialog) {
            KeyStroke ks;
            JRootPane rootPane = ((JDialog)dialog).getRootPane();
            Container contentPane = rootPane.getContentPane();
            KeyBindingSettings kbs = (KeyBindingSettings)MimeLookup.getLookup((String)"").lookup(KeyBindingSettings.class);
            GotoAction gotoAction = (GotoAction)SystemAction.get(GotoAction.class);
            if (contentPane.getLayout() instanceof BorderLayout && gotoAction != null && (ks = (KeyStroke)gotoAction.getValue("AcceleratorKey")) != null) {
                BorderLayout layout = (BorderLayout)contentPane.getLayout();
                Component buttonBar = layout.getLayoutComponent("South");
                contentPane.remove(buttonBar);
                JPanel southPanel = new JPanel();
                southPanel.setLayout(new GridBagLayout());
                JLabel keyChooserLabel = new JLabel();
                String ksText = KeyEvent.getKeyModifiersText(ks.getModifiers()) + "+" + KeyEvent.getKeyText(ks.getKeyCode());
                keyChooserLabel.setText(NbBundle.getMessage(GotoLineOrBookmarkPanel.class, (String)"CTL_gotoDialogBookmarkKeyChooserLabel", (Object)ksText));
                InputMap inputMap = rootPane.getInputMap(1);
                inputMap.put(ks, "openKeyChooser");
                rootPane.getActionMap().put("openKeyChooser", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BookmarkKeyChooser.get().show(dialog, new Runnable(){

                            @Override
                            public void run() {
                                BookmarkInfo bookmark = BookmarkKeyChooser.get().getandClearResult();
                                if (bookmark != null) {
                                    GotoLineOrBookmarkPanel.this.disposeDialog();
                                    BookmarkUtils.postOpenEditor(bookmark);
                                }
                            }
                        });
                    }
                });
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.fill = 2;
                constraints.weightx = 1.0;
                constraints.gridx = 0;
                constraints.gridy = 0;
                constraints.anchor = 16;
                constraints.insets = new Insets(0, 5, 0, 0);
                southPanel.add((Component)keyChooserLabel, constraints);
                constraints = new GridBagConstraints();
                constraints.fill = 2;
                constraints.weightx = 1.0;
                constraints.gridx = -1;
                constraints.gridy = 0;
                constraints.anchor = 13;
                southPanel.add(buttonBar, constraints);
                contentPane.add((Component)southPanel, "South");
                Font font = keyChooserLabel.getFont().deriveFont(Math.max(1, Math.round(0.8f * (float)keyChooserLabel.getFont().getSize())));
                keyChooserLabel.setFont(font);
            }
        }
        dialog.pack();
        if (lastBounds != null) {
            dialog.setBounds(lastBounds);
        } else {
            int y;
            int x;
            Window w;
            Dimension dim = dialog.getPreferredSize();
            JTextComponent c = this.getTargetComponent();
            Window window = w = c != null ? SwingUtilities.getWindowAncestor(c) : null;
            if (w != null) {
                x = Math.max(0, w.getX() + (w.getWidth() - dim.width) / 2);
                y = Math.max(0, w.getY() + (w.getHeight() - dim.height) / 2);
            } else {
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                x = Math.max(0, (screen.width - dim.width) / 2);
                y = Math.max(0, (screen.height - dim.height) / 2);
            }
            dialog.setLocation(x, y);
        }
        return dialog;
    }

    public void disposeDialog() {
        if (dialog != null) {
            dialog.removeWindowListener(this);
            lastBounds = dialog.getBounds();
            dialog.dispose();
            dialog = null;
            this.buttons = null;
            this.blocker = null;
            Utilities.returnFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.gotoCombo || this.buttons != null && src == this.buttons[0]) {
            if (this.performGoto()) {
                this.updateHistory();
                this.disposeDialog();
            }
        } else {
            this.disposeDialog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performGoto() {
        JTextComponent c = this.getTargetComponent();
        String text = (String)this.gotoCombo.getEditor().getItem();
        if (c != null) {
            try {
                int lineNumber = Integer.parseInt(text);
                if (lineNumber == 0) {
                    lineNumber = 1;
                }
                int lineIndex = lineNumber - 1;
                Document doc = c.getDocument();
                Element rootElem = doc.getDefaultRootElement();
                int lineCount = rootElem.getElementCount();
                if (lineIndex >= 0) {
                    if (lineIndex >= lineCount) {
                        lineIndex = lineCount - 1;
                    }
                    int offset = rootElem.getElement(lineIndex).getStartOffset();
                    c.setCaretPosition(offset);
                    return true;
                }
            }
            catch (NumberFormatException e) {
                BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
                try {
                    BookmarkInfo bookmark = lockedBookmarkManager.findBookmarkByNameOrKey(text, false);
                    if (bookmark != null) {
                        BookmarkUtils.postOpenEditor(bookmark);
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    lockedBookmarkManager.unlock();
                }
            }
        }
        c.getToolkit().beep();
        return false;
    }

    private void updateCombo() {
        this.gotoCombo.setModel(new DefaultComboBoxModel<String>(history.toArray(new String[history.size()])));
    }

    private String getValue() {
        return (String)this.gotoCombo.getEditor().getItem();
    }

    private void updateHistory() {
        String value = this.getValue();
        if (history.contains(value)) {
            history.remove(value);
        }
        history.add(0, value);
        if (history.size() > 20) {
            history.remove(20);
        }
        this.updateCombo();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.blocker != null) {
            this.blocker.stopBlocking();
        }
        ((JComponent)e.getSource()).removeFocusListener(this);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.disposeDialog();
    }

    @Override
    public void windowClosed(WindowEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (GotoLineOrBookmarkPanel.this.blocker != null) {
                    GotoLineOrBookmarkPanel.this.blocker.stopBlocking(false);
                }
            }
        });
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    static {
        bundle = NbBundle.getBundle(GotoLineOrBookmarkPanel.class);
    }

    public static final class BookmarksGotoAction
    extends ExtKit.GotoAction {
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                new GotoLineOrBookmarkPanel().showDialog(target, new KeyEventBlocker(target, false));
            }
        }
    }
}

