/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.EventListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkManager;
import org.netbeans.modules.editor.bookmarks.BookmarkManagerEvent;
import org.netbeans.modules.editor.bookmarks.BookmarkManagerListener;
import org.netbeans.modules.editor.bookmarks.BookmarkUtils;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarks;
import org.netbeans.modules.editor.bookmarks.ui.BookmarkNode;
import org.netbeans.modules.editor.bookmarks.ui.BookmarksNodeTree;
import org.netbeans.modules.editor.bookmarks.ui.BookmarksTable;
import org.netbeans.modules.editor.bookmarks.ui.BookmarksTableModel;
import org.openide.cookies.EditorCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class BookmarksView
extends TopComponent
implements BookmarkManagerListener,
PropertyChangeListener,
ExplorerManager.Provider {
    private static final String HELP_ID = "bookmarks_window_csh";
    private static final int PREVIEW_PANE_REFRESH_DELAY = 300;
    private final transient BookmarksNodeTree nodeTree = new BookmarksNodeTree();
    private final transient ExplorerManager explorerManager = new ExplorerManager();
    private transient boolean treeViewShowing;
    private transient JSplitPane splitPane;
    private transient BookmarksTableView tableView;
    private transient BeanTreeView treeView;
    private transient JPanel previewPanel;
    private transient boolean dividerLocationSet;
    private transient JToggleButton bookmarksTreeButton;
    private transient JToggleButton bookmarksTableButton;
    private transient Timer previewRefreshTimer;
    private transient BookmarkInfo displayedBookmarkInfo;
    private transient boolean initialSelectionDone;
    private static final String PREFS_NODE = "BookmarksProperties";
    private static final Preferences prefs = NbPreferences.forModule(BookmarksView.class).node("BookmarksProperties");
    private static final String TREE_VIEW_VISIBLE_PREF = "treeViewVisible";
    private static final String TREE_VIEW_VISIBLE_PREF_TRUE = "true";
    private static final String TREE_VIEW_VISIBLE_PREF_FALSE = "false";

    public static TopComponent create() {
        return new BookmarksView();
    }

    public static BookmarksView openView() {
        BookmarksView bookmarksView = (BookmarksView)WindowManager.getDefault().findTopComponent("bookmarks");
        if (bookmarksView == null) {
            bookmarksView = (BookmarksView)BookmarksView.create();
        }
        bookmarksView.open();
        bookmarksView.requestActive();
        return bookmarksView;
    }

    public static ActionListener openAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarksView.openView();
            }
        };
    }

    BookmarksView() {
        this.explorerManager.setRootContext(this.nodeTree.rootNode());
        ActionMap actionMap = this.getActionMap();
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.explorerManager, (boolean)false));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)actionMap));
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(84, 128), "toggle-view");
        actionMap.put("toggle-view", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarksView.this.setTreeViewVisible(!BookmarksView.this.treeViewShowing);
            }
        });
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/editor/bookmarks/resources/bookmark_16.png"));
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public String getName() {
        return NbBundle.getMessage(BookmarksView.class, (String)"LBL_BookmarksView");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    protected String preferredID() {
        return "bookmarks";
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getToolTipText() {
        return NbBundle.getMessage(BookmarksView.class, (String)"LBL_BookmarksViewToolTip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLayoutAndComponents() {
        if (this.previewPanel == null) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.add(this.createLeftToolBar(), gridBagConstraints);
            this.splitPane = new JSplitPane(1);
            this.splitPane.setContinuousLayout(true);
            this.previewPanel = new JPanel();
            this.previewPanel.setLayout(new GridLayout(1, 1));
            BookmarksView.fixScrollPaneinSplitPaneJDKIssue(this.previewPanel);
            this.splitPane.setRightComponent(this.previewPanel);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add(this.splitPane, gridBagConstraints);
            if (TREE_VIEW_VISIBLE_PREF_FALSE.equals(prefs.get(TREE_VIEW_VISIBLE_PREF, TREE_VIEW_VISIBLE_PREF_TRUE))) {
                this.treeViewShowing = true;
                this.setTreeViewVisible(false);
            } else {
                this.setTreeViewVisible(true);
            }
            BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
            try {
                lockedBookmarkManager.addBookmarkManagerListener((BookmarkManagerListener)WeakListeners.create(BookmarkManagerListener.class, (EventListener)this, (Object)lockedBookmarkManager));
            }
            finally {
                lockedBookmarkManager.unlock();
            }
        }
    }

    @Override
    public void bookmarksChanged(BookmarkManagerEvent evt) {
        this.updateTreeRootContext(evt);
    }

    private void setTreeViewVisible(boolean treeViewVisible) {
        if (treeViewVisible != this.treeViewShowing) {
            TreeOrTableContainer container;
            boolean create;
            this.treeViewShowing = treeViewVisible;
            prefs.put(TREE_VIEW_VISIBLE_PREF, treeViewVisible ? TREE_VIEW_VISIBLE_PREF_TRUE : TREE_VIEW_VISIBLE_PREF_FALSE);
            if (treeViewVisible) {
                boolean bl = create = this.treeView == null;
                if (create) {
                    container = new TreeOrTableContainer();
                    this.updateTreeRootContext(null);
                    this.treeView = new BeanTreeView();
                    container.add((Component)this.treeView);
                    BookmarksView.fixScrollPaneinSplitPaneJDKIssue((Component)this.treeView);
                    this.treeView.setRootVisible(false);
                    this.treeView.setDragSource(false);
                    this.treeView.setDropTarget(false);
                } else {
                    container = (TreeOrTableContainer)this.treeView.getParent();
                }
            } else {
                boolean bl = create = this.tableView == null;
                if (create) {
                    this.tableView = new BookmarksTableView();
                    container = new TreeOrTableContainer();
                    container.add(this.tableView);
                    this.rebuildTableEntries();
                    this.initTableView();
                } else {
                    container = (TreeOrTableContainer)this.tableView.getParent();
                }
            }
            int dividerLocation = this.splitPane.getDividerLocation();
            this.splitPane.setLeftComponent(container);
            this.splitPane.setDividerLocation(dividerLocation);
            if (!treeViewVisible && create) {
                this.splitPane.validate();
                this.updateTableColumnSizes();
            }
            this.bookmarksTreeButton.setSelected(treeViewVisible);
            this.bookmarksTableButton.setSelected(!treeViewVisible);
            this.requestFocusTreeOrTable();
        }
    }

    private void updateTreeRootContext(BookmarkManagerEvent evt) {
        boolean structureChange;
        boolean bl = structureChange = evt == null || evt.isStructureChange();
        if (structureChange) {
            this.updateNodeTree();
        } else {
            this.nodeTree.updateBookmarkNodes(evt);
            this.notifyTableEntriesChanged(evt);
        }
    }

    private void updateNodeTree() {
        this.nodeTree.updateNodeTree();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BookmarksView.this.rebuildTableEntries();
            }
        });
    }

    private void rebuildTableEntries() {
        if (this.tableView != null) {
            BookmarksTable table = this.tableView.getTable();
            int selectedIndex = Math.max(table.getSelectedRow(), 0);
            ((BookmarksTableModel)table.getModel()).setEntries(this.nodeTree.bookmarkNodes(false));
            selectedIndex = Math.min(selectedIndex, table.getRowCount() - 1);
            if (selectedIndex >= 0) {
                table.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
            }
        }
    }

    private void notifyTableEntriesChanged(BookmarkManagerEvent evt) {
        if (this.tableView != null) {
            BookmarksTable table = this.tableView.getTable();
            BookmarksTableModel model = (BookmarksTableModel)table.getModel();
            for (int i = model.getEntryCount() - 1; i >= 0; --i) {
                if (evt.getChange(model.getEntry(i).getBookmarkInfo()) == null) continue;
                model.fireTableRowsUpdated(i, i);
            }
        }
    }

    private void initTableView() {
        BookmarksView.fixScrollPaneinSplitPaneJDKIssue(this.tableView);
        this.tableView.getTable().getActionMap().put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkInfo selectedBookmark = BookmarksView.this.getTableSelectedBookmark();
                if (selectedBookmark != null) {
                    BookmarkUtils.postOpenEditor(selectedBookmark);
                }
            }
        });
        this.tableView.getTable().getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarkInfo selectedBookmark = BookmarksView.this.getTableSelectedBookmark();
                if (selectedBookmark != null) {
                    BookmarkUtils.removeBookmarkUnderLock(selectedBookmark);
                }
            }
        });
        this.tableView.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BookmarksView.this.schedulePaneRefresh();
            }
        });
    }

    private void updateTableColumnSizes() {
        BookmarksTable table = this.tableView.getTable();
        Font font = this.tableView.getFont();
        FontMetrics fm = this.tableView.getFontMetrics(font);
        int maxCharWidth = fm.charWidth('A');
        int editingBorder = 4;
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn nameColumn = columnModel.getColumn(0);
        nameColumn.setPreferredWidth(8 * maxCharWidth + editingBorder);
        TableColumn keyColumn = columnModel.getColumn(1);
        keyColumn.setPreferredWidth(3 * maxCharWidth + editingBorder);
        keyColumn.setMinWidth(keyColumn.getPreferredWidth());
        TableColumn locationColumn = columnModel.getColumn(2);
        Insets insets = this.tableView.getBorder().getBorderInsets(this.tableView);
        int remainingWidth = this.tableView.getParent().getWidth() - insets.left - insets.right;
        remainingWidth -= 2 * columnModel.getColumnMargin();
        remainingWidth -= nameColumn.getPreferredWidth();
        locationColumn.setPreferredWidth(remainingWidth -= keyColumn.getPreferredWidth());
    }

    void requestFocusTreeOrTable() {
        Children rootChildren;
        if (this.treeViewShowing) {
            this.treeView.requestFocusInWindow();
        } else {
            this.tableView.getTable().requestFocusInWindow();
        }
        Node selectedNode = this.getTreeSelectedNode();
        if (selectedNode == null && (rootChildren = this.explorerManager.getRootContext().getChildren()).getNodesCount() > 0) {
            try {
                this.explorerManager.setSelectedNodes(new Node[]{rootChildren.getNodeAt(0)});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        this.requestFocusTreeOrTable();
        return this.isFocusable();
    }

    void refreshView() {
        this.updateTreeRootContext(null);
        this.requestFocusTreeOrTable();
    }

    protected void componentActivated() {
        super.componentActivated();
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)true);
        this.requestFocusTreeOrTable();
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)false);
        super.componentDeactivated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void componentShowing() {
        BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
        try {
            lockedBookmarkManager.keepOpenProjectsBookmarksLoaded();
        }
        finally {
            lockedBookmarkManager.unlock();
        }
        this.initLayoutAndComponents();
        this.doInitialSelection();
        super.componentShowing();
    }

    protected void componentHidden() {
        super.componentHidden();
    }

    private void schedulePaneRefresh() {
        if (this.previewRefreshTimer == null) {
            this.previewRefreshTimer = new Timer(300, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BookmarksView.this.checkShowPreview();
                }
            });
            this.previewRefreshTimer.setRepeats(false);
        }
        this.previewRefreshTimer.restart();
    }

    void checkShowPreview() {
        FileObject fo;
        BookmarkInfo bookmark;
        BookmarkInfo selectedBookmark = null;
        if (this.treeViewShowing) {
            Node selectedNode = this.getTreeSelectedNode();
            if (selectedNode instanceof BookmarkNode) {
                BookmarkNode bmNode = (BookmarkNode)selectedNode;
                selectedBookmark = bmNode.getBookmarkInfo();
            }
        } else {
            selectedBookmark = this.getTableSelectedBookmark();
        }
        if (selectedBookmark != null && (bookmark = selectedBookmark) != this.displayedBookmarkInfo && (fo = bookmark.getFileBookmarks().getFileObject()) != null) {
            try {
                DataObject dob = DataObject.find((FileObject)fo);
                final EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
                if (ec != null) {
                    StyledDocument doc = ec.getDocument();
                    if (doc == null) {
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    final StyledDocument d = ec.openDocument();
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            BookmarksView.this.showPreview(fo, d, bookmark);
                                        }
                                    });
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                        });
                    } else {
                        this.showPreview(fo, doc, bookmark);
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
        }
    }

    void showPreview(FileObject fo, Document doc, BookmarkInfo bookmarkInfo) {
        if (bookmarkInfo != this.displayedBookmarkInfo) {
            int lineIndex = bookmarkInfo.getCurrentLineIndex();
            String mimeType = (String)doc.getProperty("mimeType");
            if (mimeType != null) {
                JEditorPane pane = new JEditorPane();
                EditorKit editorKit = (EditorKit)MimeLookup.getLookup((String)mimeType).lookup(EditorKit.class);
                pane.setEditorKit(editorKit);
                pane.setDocument(doc);
                pane.setEditable(false);
                EditorUI editorUI = Utilities.getEditorUI((JTextComponent)pane);
                JComponent editorComponent = editorUI != null ? editorUI.getExtComponent() : new JScrollPane(pane);
                this.previewPanel.removeAll();
                this.previewPanel.add(editorComponent);
                int offset = BookmarkUtils.lineIndex2Offset(doc, lineIndex);
                pane.setCaretPosition(offset);
                this.displayedBookmarkInfo = bookmarkInfo;
                this.previewPanel.revalidate();
            }
        }
    }

    Node getTreeSelectedNode() {
        Node[] selectedNodes;
        Node selectedNode = null;
        if (this.treeViewShowing && (selectedNodes = this.explorerManager.getSelectedNodes()).length > 0) {
            selectedNode = selectedNodes[0];
        }
        return selectedNode;
    }

    BookmarkInfo getTableSelectedBookmark() {
        BookmarksTable table = this.tableView.getTable();
        int selectedRowIndex = table.getSelectedRow();
        if (selectedRowIndex != -1 && selectedRowIndex < table.getRowCount()) {
            return ((BookmarksTableModel)table.getModel()).getEntry(selectedRowIndex).getBookmarkInfo();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitialSelection() {
        if (!this.initialSelectionDone && this.treeViewShowing) {
            Node selectedNode = this.getTreeSelectedNode();
            if (selectedNode instanceof BookmarkNode) {
                this.initialSelectionDone = true;
            } else {
                FileObject selectedFileObject = (FileObject)org.openide.util.Utilities.actionsGlobalContext().lookup(FileObject.class);
                if (selectedFileObject != null) {
                    BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
                    try {
                        ProjectBookmarks projectBookmarks = lockedBookmarkManager.getProjectBookmarks(selectedFileObject);
                        Node bNode = this.nodeTree.findFirstBookmarkNode(projectBookmarks, selectedFileObject);
                        if (bNode != null) {
                            this.initialSelectionDone = true;
                            selectedFileObject = null;
                            try {
                                this.explorerManager.setSelectedNodes(new Node[]{bNode});
                            }
                            catch (PropertyVetoException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                    finally {
                        lockedBookmarkManager.unlock();
                    }
                }
            }
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (!this.dividerLocationSet && this.splitPane != null && this.treeView != null) {
            this.dividerLocationSet = true;
            this.splitPane.setDividerLocation(0.5);
            this.splitPane.setResizeWeight(0.5);
        }
    }

    private JToolBar createLeftToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setOrientation(1);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorderPainted(true);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            toolBar.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        JButton refreshButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/bookmarks/resources/refresh.png", (boolean)false));
        refreshButton.setToolTipText(NbBundle.getMessage(BookmarksView.class, (String)"LBL_toolBarRefreshButtonToolTip"));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarksView.this.refreshView();
            }
        });
        toolBar.add(refreshButton);
        toolBar.addSeparator();
        this.bookmarksTreeButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/bookmarks/resources/bookmarksTree.png", (boolean)false));
        this.bookmarksTreeButton.setToolTipText(NbBundle.getMessage(BookmarksView.class, (String)"LBL_toolBarTreeViewButtonToolTip"));
        this.bookmarksTreeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BookmarksView.this.treeViewShowing) {
                    BookmarksView.this.setTreeViewVisible(true);
                } else {
                    BookmarksView.this.bookmarksTableButton.doClick();
                }
            }
        });
        toolBar.add(this.bookmarksTreeButton);
        this.bookmarksTableButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/bookmarks/resources/bookmarksTable.png", (boolean)false));
        this.bookmarksTableButton.setToolTipText(NbBundle.getMessage(BookmarksView.class, (String)"LBL_toolBarTableViewButtonToolTip"));
        this.bookmarksTableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BookmarksView.this.treeViewShowing) {
                    BookmarksView.this.setTreeViewVisible(false);
                } else {
                    BookmarksView.this.bookmarksTreeButton.doClick();
                }
            }
        });
        toolBar.add(this.bookmarksTableButton);
        toolBar.addSeparator();
        return toolBar;
    }

    private static void fixScrollPaneinSplitPaneJDKIssue(Component c) {
        c.setMinimumSize(new Dimension(10, 10));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            this.schedulePaneRefresh();
        }
    }

    private static final class BookmarksTableView
    extends JScrollPane {
        BookmarksTableView() {
            this.setViewportView((Component)((Object)new BookmarksTable()));
        }

        BookmarksTable getTable() {
            return (BookmarksTable)((Object)this.getViewport().getView());
        }
    }

    private final class TreeOrTableContainer
    extends JPanel {
        TreeOrTableContainer() {
            this.setLayout(new GridLayout(1, 1));
            BookmarksView.fixScrollPaneinSplitPaneJDKIssue(this);
        }
    }
}

