/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.tasklist;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.Utilities;
import org.netbeans.modules.hudson.tasklist.JobScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AnalysisPluginImpl
implements JobScanner {
    private static final Logger LOG = Logger.getLogger(AnalysisPluginImpl.class.getName());
    private static final String[] PLUGINS = new String[]{"findbugs", "checkstyle", "pmd", "warnings", "dry"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findTasks(Project p, HudsonJob job, int buildNumber, JobScanner.TaskAdder callback) throws IOException {
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        roots.add(p.getProjectDirectory());
        for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)p).getSourceGroups("java")) {
            roots.add(sourceGroup.getRootFolder());
        }
        for (String string : PLUGINS) {
            Document doc;
            if (Thread.interrupted()) {
                return;
            }
            String url = job.getUrl() + buildNumber + "/" + string + "Result/api/xml?tree=warnings[fileName,primaryLineNumber,priority,message]";
            try {
                HttpURLConnection conn = new ConnectionBuilder().job(job).url(url).httpConnection();
                try {
                    InputSource input = new InputSource(conn.getInputStream());
                    input.setSystemId(url);
                    doc = XMLUtil.parse((InputSource)input, (boolean)false, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
                }
                catch (SAXException x) {
                    LOG.log(Level.FINE, "parse error for " + url, x);
                    continue;
                }
                finally {
                    conn.disconnect();
                }
            }
            catch (FileNotFoundException x) {
                LOG.log(Level.FINE, "no {0} for {1}", new Object[]{string, job});
                continue;
            }
            LOG.log(Level.FINE, "found {0} for {1}", new Object[]{string, job});
            for (Element warning : XMLUtil.findSubElements((Element)doc.getDocumentElement())) {
                if (Thread.interrupted()) {
                    return;
                }
                Element warningEl = XMLUtil.findElement((Element)warning, (String)"message", null);
                if (warningEl == null) {
                    LOG.log(Level.FINE, "skipping {0} since it may be pre-1.367", job.getInstance());
                    return;
                }
                String message = XMLUtil.findText((Node)warningEl);
                if (message == null) {
                    LOG.log(Level.WARNING, "no message in <warning> from {0}", url);
                    continue;
                }
                String group = "HIGH".equals(XMLUtil.findText((Node)XMLUtil.findElement((Element)warning, (String)"priority", null))) ? "nb-tasklist-error" : "nb-tasklist-warning";
                String fileName = XMLUtil.findText((Node)XMLUtil.findElement((Element)warning, (String)"fileName", null));
                FileObject f = AnalysisPluginImpl.locate(fileName, roots);
                if (f != null) {
                    LOG.log(Level.FINER, "successfully located {0}", f);
                    int primaryLineNumber = Integer.parseInt(XMLUtil.findText((Node)XMLUtil.findElement((Element)warning, (String)"primaryLineNumber", null)));
                    callback.add(Task.create((FileObject)f, (String)group, (String)message, (int)primaryLineNumber));
                    continue;
                }
                String workspacePath = AnalysisPluginImpl.workspacePath(fileName, job.getName());
                if (workspacePath == null) {
                    LOG.log(Level.WARNING, "{0} does not look to be inside {1}", new Object[]{fileName, job});
                    continue;
                }
                LOG.log(Level.FINE, "did not find any local file for {0}", fileName);
                callback.add(Task.create((URL)new URL(job.getUrl() + "workspace/" + Utilities.uriEncode((String)workspacePath)), (String)group, (String)message));
            }
        }
    }

    @CheckForNull
    static FileObject locate(String fileName, Collection<FileObject> roots) {
        FileObject f;
        String fileNameSlashes = fileName.replace('\\', '/');
        int pos = 0;
        block0: while (true) {
            FileObject root;
            int i;
            if ((i = fileNameSlashes.indexOf(47, pos)) == -1) {
                return null;
            }
            pos = i + 1;
            String path = fileNameSlashes.substring(pos);
            Iterator<FileObject> i$ = roots.iterator();
            do {
                if (!i$.hasNext()) continue block0;
            } while ((f = (root = i$.next()).getFileObject(path)) == null);
            break;
        }
        return f;
    }

    @CheckForNull
    static String workspacePath(String fileName, String jobName) {
        String infix;
        String fileNameSlashes = fileName.replace('\\', '/');
        int i = fileNameSlashes.indexOf(infix = "/workspace/" + jobName + "/");
        if (i == -1) {
            infix = "/" + jobName + "/workspace/";
            i = fileNameSlashes.indexOf(infix);
        }
        if (i == -1) {
            return null;
        }
        return fileNameSlashes.substring(i + infix.length());
    }
}

