/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.ssh.service.util;

public class ParseUtil {
    private String user;
    private String password;
    private String host;
    private int port;

    public void parseURLElements(String url) throws IllegalArgumentException {
        if (!url.isEmpty() && url.contains("@")) {
            String[] tokens = url.split("@");
            String[] userPart = tokens[0].split(":");
            String[] hostPart = tokens[1].split(":");
            this.user = userPart[0];
            this.password = userPart.length == 2 ? userPart[1] : null;
            this.host = hostPart[0];
            this.port = hostPart.length == 2 ? Integer.parseInt(hostPart[1]) : 22;
        } else if (ParseUtil.isProtocolURL(url)) {
            String[] tokens = url.split("//");
            String[] connectionParts = tokens[1].split(":");
            this.host = connectionParts[0];
            if (connectionParts.length > 1) {
                this.port = Integer.parseInt(connectionParts[1]);
            }
        } else {
            throw new IllegalArgumentException("Neither a SSH-Connection- or HTTP(S)-URL: " + url);
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return null;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getAsURL() {
        StringBuilder builder = new StringBuilder();
        if (!ParseUtil.isValidURLPart(this.host)) {
            return null;
        }
        if (ParseUtil.isValidURLPart(this.user)) {
            builder.append(this.user);
        }
        if (builder.length() > 0 && ParseUtil.isValidURLPart(this.password)) {
            builder.append(":");
            builder.append(this.password);
        }
        if (builder.length() > 0) {
            builder.append("@");
        }
        builder.append(this.host);
        builder.append(":");
        builder.append(this.port);
        return builder.toString();
    }

    private static boolean isValidURLPart(String part) {
        return part != null && !part.isEmpty();
    }

    private static boolean isProtocolURL(String url) {
        return url != null && (url.contains("http://") || url.contains("https://"));
    }
}

