/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.ssh.service.manager;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import de.proveo.idm.ssh.service.TunnelSegment;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TunnelManager {
    private static final Logger log = Logger.getLogger(TunnelManager.class.getName());
    private HashMap<TunnelSegment, Session> tunnels = new HashMap();
    private static TunnelManager instance;
    private static int assignedPort;

    private TunnelManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TunnelManager getInstance() {
        if (instance != null) return instance;
        Class<TunnelManager> clazz = TunnelManager.class;
        synchronized (TunnelManager.class) {
            instance = new TunnelManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public TunnelSegment findTunnelSegment(String user, String host, int port) {
        for (TunnelSegment s : this.tunnels.keySet()) {
            if (!s.getUser().equals(user) || !s.getHost().equals(host) || s.getPort() != port) continue;
            return s;
        }
        return null;
    }

    public Session getSession(TunnelSegment sgm) {
        return this.tunnels.get(sgm);
    }

    public void addTunnelSegment(TunnelSegment sgm, Session session) {
        this.tunnels.put(sgm, session);
    }

    public void removeTunnelSegment(TunnelSegment sgm) {
        this.tunnels.remove(sgm);
    }

    public void disconnect(TunnelSegment segment) {
        if (this.tunnels.containsKey(segment)) {
            try {
                TunnelSegment parent;
                do {
                    parent = segment.getParent();
                    segment.decreaseUserCount();
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "Decreased user count for segment {0}", segment);
                    }
                    if (segment.getUserCount() > 0) continue;
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "User count for segment reached 0 and will be disconnected, segment: {0}", segment);
                    }
                    Session currentSession = this.tunnels.get(segment);
                    currentSession.disconnect();
                    this.tunnels.remove(segment);
                    if (parent == null) continue;
                    log.info("Segment had parent. Forwarding to disconnected segment will be removed");
                    Session session = this.tunnels.get(parent);
                    session.delPortForwardingL(segment.getLocalPort());
                    parent.decreaseUserCount();
                } while ((segment = parent) != null);
                if (this.tunnels.isEmpty()) {
                    assignedPort = 2000;
                }
            }
            catch (JSchException ex) {
                log.log(Level.SEVERE, "runs into", ex);
            }
        } else if (log.isLoggable(Level.WARNING)) {
            log.log(Level.WARNING, "Requested disconnect for tunnel segment, but segment was not found in {0}", this.getClass().getName());
            log.log(Level.WARNING, "User {0}", segment.getUser());
            log.log(Level.WARNING, "Host {0}", segment.getHost());
            log.log(Level.WARNING, "Port {0}", segment.getPort());
            log.log(Level.WARNING, "Assigned local port {0}", segment.getLocalPort());
        }
    }

    public int getNextPort() {
        return assignedPort;
    }

    public void setNextPort(int i) {
        assignedPort = i;
    }

    public boolean isTunnelSession(Session session) {
        for (Session tunnelSession : this.tunnels.values()) {
            if (session != tunnelSession) continue;
            return true;
        }
        return false;
    }

    static {
        assignedPort = 2000;
    }
}

