/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.ssh.service.gui.impl;

import de.proveo.idm.ssh.service.gui.impl.ManageableTableModel;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class SSHPortForwardingTableModel
extends AbstractTableModel
implements ManageableTableModel {
    private final String[] columnNames = new String[]{NbBundle.getMessage(SSHPortForwardingTableModel.class, (String)"table.header.host"), NbBundle.getMessage(SSHPortForwardingTableModel.class, (String)"table.header.port")};
    private ArrayList<String> remoteHost = new ArrayList();
    private ArrayList<Integer> remotePort = new ArrayList();

    public void addDefaultElement(String remoteHost, int remotePort) {
        this.remoteHost.add(remoteHost);
        this.remotePort.add(remotePort);
    }

    public void addElement(String remoteHost, int remotePort) {
        this.remoteHost.add(remoteHost);
        this.remotePort.add(remotePort);
    }

    @Override
    public void addNewElement() {
        this.remoteHost.add("");
        this.remotePort.add(22);
        this.fireTableDataChanged();
    }

    @Override
    public void addNewElementAt(int row) {
        this.remoteHost.add(row, "");
        this.remotePort.add(row, 22);
        this.fireTableDataChanged();
    }

    @Override
    public void clear() {
        this.remoteHost.clear();
        this.remotePort.clear();
    }

    @Override
    public void clearDefaults() {
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getDefaultValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.remoteHost.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount() || rowIndex < 0) {
            return "";
        }
        Object result = "";
        switch (columnIndex) {
            case 0: {
                result = this.remoteHost.get(rowIndex);
                break;
            }
            case 1: {
                result = this.remotePort.get(rowIndex);
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void moveTo(int from, int to) {
        String remoteHostTmp = this.remoteHost.get(from);
        Integer remotePortTmp = this.remotePort.get(from);
        this.remoteHost.set(from, this.remoteHost.get(to));
        this.remotePort.set(from, this.remotePort.get(to));
        this.remoteHost.set(to, remoteHostTmp);
        this.remotePort.set(to, remotePortTmp);
        this.fireTableDataChanged();
    }

    public void removeElement(String remoteHost, int remotePort) {
        this.remoteHost.remove(remoteHost);
        this.remotePort.remove(remotePort);
    }

    @Override
    public void removeElementAt(int rowIndex) {
        this.remoteHost.remove(rowIndex);
        this.remotePort.remove(rowIndex);
        this.fireTableDataChanged();
    }

    @Override
    public void removeLast() {
        this.remoteHost.remove(this.remoteHost.size() - 1);
        this.remotePort.remove(this.remotePort.size() - 1);
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount()) {
            return;
        }
        if (aValue == null) {
            aValue = "";
        }
        switch (columnIndex) {
            case 0: {
                if (this.remoteHost.size() == rowIndex) {
                    this.remoteHost.add(aValue.toString());
                    break;
                }
                this.remoteHost.set(rowIndex, aValue.toString());
                break;
            }
            case 1: {
                if (this.remotePort.size() == rowIndex) {
                    this.remotePort.add(Integer.parseInt(aValue.toString()));
                    break;
                }
                this.remotePort.set(rowIndex, Integer.parseInt(aValue.toString()));
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public boolean validate(int row, int column) {
        return true;
    }

    @Override
    public boolean validateAll() {
        return true;
    }
}

