/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.ssh.service.gui.impl;

import de.proveo.idm.ssh.service.gui.impl.ManageableTableModel;
import de.proveo.idm.ssh.service.gui.impl.TableSorter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JTable;

public class DropTableListener
implements DropTargetListener {
    private static final Logger log = Logger.getLogger(DropTableListener.class.getName());
    private JTable table;
    private ManageableTableModel tableModel;
    private int[] last = new int[]{-1};
    private boolean dragging;

    public DropTableListener(JTable inputTable) {
        this.table = inputTable;
        try {
            this.tableModel = (ManageableTableModel)((Object)inputTable.getModel());
        }
        catch (ClassCastException ex) {
            this.tableModel = (ManageableTableModel)((Object)((TableSorter)inputTable.getModel()).getTableModel());
        }
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    try {
                        DropTableListener.this.tableModel = (ManageableTableModel)((Object)DropTableListener.this.table.getModel());
                    }
                    catch (ClassCastException ex) {
                        DropTableListener.this.tableModel = (ManageableTableModel)((Object)((TableSorter)DropTableListener.this.table.getModel()).getTableModel());
                    }
                    log.fine("TableModel changed");
                }
            }
        });
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.dragging = true;
        if (this.table.getSelectedRow() != -1) {
            this.last = new int[]{-1};
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.dragging = false;
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        int[] from = this.table.getSelectedRows();
        int to = this.table.rowAtPoint(dtde.getLocation());
        int rowCount = this.table.getRowCount();
        if (this.dragging) {
            if (this.last[0] == -1 && rowCount >= to + from.length && from[0] != to) {
                this.last = new int[from.length];
                if (from[0] > to) {
                    for (int i = 0; i < from.length; ++i) {
                        this.tableModel.moveTo(from[i], to + i);
                        this.last[i] = to + i;
                    }
                } else {
                    for (int i = from.length - 1; i >= 0; --i) {
                        this.tableModel.moveTo(from[i], to + i);
                        this.last[i] = to + i;
                    }
                }
                this.table.setRowSelectionInterval(to, to + from.length - 1);
            } else if (this.last[0] != -1 && rowCount >= to + this.last.length && this.last[0] != to) {
                int[] newLast = new int[this.last.length];
                if (this.last[0] > to) {
                    for (int i = 0; i < this.last.length; ++i) {
                        this.tableModel.moveTo(this.last[i], to + i);
                        newLast[i] = to + i;
                    }
                } else {
                    for (int i = this.last.length - 1; i >= 0; --i) {
                        this.tableModel.moveTo(this.last[i], to + i);
                        newLast[i] = to + i;
                    }
                }
                this.table.setRowSelectionInterval(to, to + this.last.length - 1);
                this.last = newLast;
            }
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.dragging = false;
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

