/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.ssh.service;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import de.proveo.idm.ssh.service.MySSHUserInfo;
import de.proveo.idm.ssh.service.TunnelSegment;
import de.proveo.idm.ssh.service.manager.TunnelManager;
import de.proveo.idm.ssh.service.util.ParseUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class SSHConnection {
    public static final String PROP_CONNECTED = "ssh_connected";
    public static final String LOCALHOST = "localhost";
    public static final File DEFAULT_KNOWN_HOSTS_FILE = new File(System.getProperty("user.home") + File.separatorChar + ".ssh" + File.separatorChar + "known_hosts");
    public static final Icon INFOMAN_LOGIN_IMAGE = new ImageIcon(SSHConnection.class.getResource("/de/proveo/idm/ssh/service/resources/login_infoman_left.png"));
    public static final Icon SERVER_LOGIN_IMAGE = new ImageIcon(SSHConnection.class.getResource("/de/proveo/idm/ssh/service/resources/login_server_left.png"));
    private static final Logger log = Logger.getLogger(SSHConnection.class.getName());
    private static final String JSCH_PORT_IN_USE_MSG_1 = "PortForwardingL: local port .* is already registered.";
    private static final String JSCH_PORT_IN_USE_MSG_2 = "PortForwardingL: local port .* cannot be bound.";
    private static final Object tunnelLock = new Object();
    private static final int MAX_PORT_RANGE = 65535;
    private final MySSHUserInfo userInfo = new MySSHUserInfo();
    private final JSch jsch = new JSch();
    private int connectionPort = -1;
    private int connectingTimeout = 60000;
    private String url;
    private ArrayList<TunnelSegment> tunnelSegments = new ArrayList();
    private PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private Session session;
    private TunnelSegment lastSegment;

    public SSHConnection() throws IOException {
        this.setKnownHosts(DEFAULT_KNOWN_HOSTS_FILE.getAbsolutePath());
        List<InputStream> privKeys = SSHConnection.getDefaultPrivateKeys();
        for (InputStream privKey : privKeys) {
            this.addPrivateKey(privKey);
        }
    }

    private void addPrivateKey(InputStream privateKey) throws IOException {
        this.addPrivateKey(new InputStreamReader(privateKey));
    }

    private void addPrivateKey(Reader reader) throws IOException {
        BufferedReader br = null;
        String privateKey = "";
        try {
            br = new BufferedReader(reader);
            while (br.ready()) {
                privateKey = privateKey + br.readLine() + "\n";
            }
        }
        catch (IOException ex) {
            privateKey = null;
            throw new IOException(ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignore) {}
            }
        }
        if (privateKey.trim().length() != 0) {
            try {
                this.jsch.addIdentity(reader + "", privateKey.getBytes(), null, "".getBytes());
            }
            catch (JSchException ex) {
                throw new IOException(ex);
            }
        }
    }

    private void setKnownHosts(String filename) throws IOException {
        try {
            this.jsch.setKnownHosts(filename);
        }
        catch (JSchException ex) {
            throw new IOException(ex);
        }
    }

    public void addTunnel(String tunnel) {
        TunnelSegment segment = new TunnelSegment(tunnel);
        this.tunnelSegments.add(segment);
    }

    public void addTunnel(Collection<String> tunnel) {
        for (String part : tunnel) {
            TunnelSegment segment = new TunnelSegment(part);
            this.tunnelSegments.add(segment);
        }
    }

    public void setConnectionURL(String url) {
        this.url = url;
    }

    public void addTunnelSegment(TunnelSegment sgm) {
        this.tunnelSegments.add(sgm);
    }

    public void removeTunnelSegment(TunnelSegment sgm) {
        this.tunnelSegments.remove(sgm);
    }

    public void connectToURL() throws IllegalArgumentException, JSchException {
        ParseUtil util = new ParseUtil();
        util.parseURLElements(this.url);
        String user = util.getUser();
        String host = util.getHost();
        int port = util.getPort();
        if (this.tunnelSegments.size() > 0) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "{0} tunnel segments available. Establishing tunnel", this.tunnelSegments.size());
            }
            this.establishTunnel(host, port);
            host = LOCALHOST;
            port = this.connectionPort;
        } else {
            this.connectionPort = port;
        }
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "Connecting to {0}@{1}:{2}", new Object[]{user, host, port});
        }
        this.session = this.jsch.getSession(user, host, this.connectionPort);
        this.userInfo.reInit();
        this.userInfo.setConnetingToUrl(this.url);
        this.userInfo.setType(0);
        this.session.setConfig("StrictHostKeyChecking", "no");
        this.session.setUserInfo((UserInfo)this.userInfo);
        this.session.setPassword(this.userInfo.getPassword());
        this.session.connect(this.connectingTimeout);
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "{0}@{1}:{2} connected", new Object[]{user, host, port});
        }
        this.propChangeSupport.firePropertyChange(PROP_CONNECTED, null, (Object)this.session.isConnected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establishTunnel(String url) throws JSchException {
        Object object = tunnelLock;
        synchronized (object) {
            this.url = url;
            ParseUtil util = new ParseUtil();
            util.parseURLElements(url);
            this.establishTunnel(util.getHost(), util.getPort());
        }
    }

    protected void establishTunnel(String remoteHost, int remotePort) throws JSchException {
        TunnelManager mgr = TunnelManager.getInstance();
        Iterator<TunnelSegment> segments = this.tunnelSegments.iterator();
        TunnelSegment sgm = segments.next();
        int assignedPort = -1;
        TunnelSegment foundSgm = mgr.findTunnelSegment(sgm.getUser(), sgm.getHost(), sgm.getPort());
        if (foundSgm == null) {
            if (log.isLoggable(Level.INFO)) {
                log.info("Current tunnel segment does not exist, creating it");
                log.info("Tunnel segment info:");
                log.log(Level.INFO, "User {0} Host {1} Port {2}", new Object[]{sgm.getUser(), sgm.getHost(), sgm.getPort()});
            }
            this.createInitialTunnelSegment(mgr, sgm, remoteHost, remotePort);
        } else {
            this.session = mgr.getSession(foundSgm);
            if (!this.session.isConnected()) {
                try {
                    this.session.connect();
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Current tunnel segment exists. Segment info:");
                        log.log(Level.INFO, "User {0} Host {1} Port {2}", new Object[]{foundSgm.getUser(), foundSgm.getHost(), foundSgm.getPort()});
                    }
                }
                catch (Exception ex) {
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Current tunnel segment exists, but is corrupt. Segment info:");
                        log.log(Level.INFO, "User {0} Host {1} Port {2}", new Object[]{foundSgm.getUser(), foundSgm.getHost(), foundSgm.getPort()});
                        log.info("Recreate tunnel segment ...");
                    }
                    TunnelManager.getInstance().removeTunnelSegment(foundSgm);
                    this.createInitialTunnelSegment(mgr, sgm, remoteHost, remotePort);
                }
            } else {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Current tunnel segment exists. Segment info:");
                    log.log(Level.INFO, "User {0} Host {1} Port {2}", new Object[]{foundSgm.getUser(), foundSgm.getHost(), foundSgm.getPort()});
                }
                this.lastSegment = foundSgm;
                foundSgm.increaseUserCount();
            }
            if (!segments.hasNext()) {
                this.connectionPort = this.createForwarding(remoteHost, remotePort);
            }
        }
        if (segments.hasNext()) {
            while (segments.hasNext()) {
                sgm = segments.next();
                foundSgm = mgr.findTunnelSegment(sgm.getUser(), sgm.getHost(), sgm.getPort());
                if (foundSgm == null) {
                    this.createTunnelSegment(mgr, sgm, assignedPort);
                    continue;
                }
                this.session = TunnelManager.getInstance().getSession(foundSgm);
                if (!this.session.isConnected()) {
                    try {
                        this.session.connect();
                    }
                    catch (Exception ex) {
                        if (log.isLoggable(Level.INFO)) {
                            log.info("Current tunnel segment exists, but is corrupt. Segment info:");
                            log.log(Level.INFO, "User {0} Host {1} Port {2}", new Object[]{foundSgm.getUser(), foundSgm.getHost(), foundSgm.getPort()});
                            log.info("Recreate tunnel segment ...");
                        }
                        TunnelManager.getInstance().removeTunnelSegment(foundSgm);
                        this.createTunnelSegment(mgr, sgm, assignedPort);
                    }
                    continue;
                }
                foundSgm.increaseUserCount();
                this.lastSegment = foundSgm;
            }
            this.connectionPort = this.createForwarding(remoteHost, remotePort);
        }
    }

    private void createInitialTunnelSegment(TunnelManager mgr, TunnelSegment sgm, String remoteHost, int remotePort) throws JSchException {
        this.session = this.jsch.getSession(sgm.getUser(), sgm.getHost(), sgm.getPort());
        this.session.setConfig("StrictHostKeyChecking", "no");
        this.userInfo.reInit();
        this.userInfo.setConnetingToUrl(String.format("%s@%s:%s", sgm.getUser(), sgm.getHost(), sgm.getPort()));
        this.userInfo.setType(2);
        this.session.setUserInfo((UserInfo)this.userInfo);
        this.session.setPassword(this.userInfo.getPassword());
        this.session.connect(this.connectingTimeout);
        this.lastSegment = sgm;
        sgm.increaseUserCount();
        sgm.setConnected(true);
        this.connectionPort = this.createForwarding(remoteHost, remotePort);
        sgm.setLocalPort(this.connectionPort);
        mgr.addTunnelSegment(sgm, this.session);
    }

    private void createTunnelSegment(TunnelManager mgr, TunnelSegment sgm, int assignedPort) throws JSchException {
        if (this.lastSegment != null) {
            this.session = mgr.getSession(this.lastSegment);
            if (log.isLoggable(Level.INFO)) {
                log.info("Connecting current tunnel segment to previous tunnel segment");
            }
        }
        assignedPort = this.createForwarding(sgm.getHost(), sgm.getPort());
        sgm.setLocalPort(assignedPort);
        this.session = this.jsch.getSession(sgm.getUser(), LOCALHOST, assignedPort);
        this.userInfo.reInit();
        this.userInfo.setConnetingToUrl(String.format("%s@%s:%s", sgm.getUser(), sgm.getHost(), sgm.getPort()));
        this.userInfo.setType(2);
        this.session.setUserInfo((UserInfo)this.userInfo);
        this.session.setPassword(this.userInfo.getPassword());
        this.session.setConfig("StrictHostKeyChecking", "no");
        if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "Connecting to {0}@localhost:{1}", new Object[]{sgm.getUser(), assignedPort});
        }
        this.session.connect(this.connectingTimeout);
        sgm.setParent(this.lastSegment);
        this.lastSegment.increaseUserCount();
        this.lastSegment = sgm;
        sgm.increaseUserCount();
        sgm.setConnected(true);
        mgr.addTunnelSegment(sgm, this.session);
    }

    private int createForwarding(String host, int port) throws JSchException {
        TunnelManager tMgr = TunnelManager.getInstance();
        int assignedPort = tMgr.getNextPort();
        while (true) {
            try {
                assignedPort = this.session.setPortForwardingL(assignedPort, host, port);
                tMgr.setNextPort(assignedPort + 1);
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "Forwarded host {0}:{1} through local port {2}", new Object[]{host, port, assignedPort});
                }
                return assignedPort;
            }
            catch (JSchException ex) {
                String errorMessage = ex.getMessage();
                if (errorMessage.matches(JSCH_PORT_IN_USE_MSG_1) || errorMessage.matches(JSCH_PORT_IN_USE_MSG_2)) {
                    tMgr.setNextPort(++assignedPort);
                    if (!log.isLoggable(Level.INFO)) continue;
                    log.log(Level.INFO, "Local port {0} is already in use, try next port {1}", new Object[]{assignedPort - 1, assignedPort});
                    continue;
                }
                throw ex;
                if (assignedPort < 65535) continue;
                return -1;
            }
            break;
        }
    }

    public synchronized void disconnect() {
        if (this.session != null && this.session.isConnected()) {
            try {
                TunnelManager manager = TunnelManager.getInstance();
                Session parentSession = manager.getSession(this.lastSegment);
                if (parentSession != null) {
                    manager.disconnect(this.lastSegment);
                }
                if (!manager.isTunnelSession(this.session)) {
                    this.session.disconnect();
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "Disconnected from {0}", String.format("%s@%s", this.session.getUserName(), this.session.getHost()));
                    }
                }
                this.propChangeSupport.firePropertyChange(PROP_CONNECTED, null, (Object)this.session.isConnected());
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Runs into", ex);
            }
        } else if (log.isLoggable(Level.INFO)) {
            log.info("Cannot disconnect, because session is not connected or null!");
        }
    }

    public Session getSession() {
        return this.session;
    }

    public int getConnectionPort() {
        return this.connectionPort;
    }

    public boolean isConnected() {
        return this.session != null ? this.session.isConnected() : false;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propChangeSupport.removePropertyChangeListener(l);
    }

    public static List<InputStream> getDefaultPrivateKeys() {
        ArrayList<InputStream> ret = new ArrayList<InputStream>();
        ret.add(SSHConnection.class.getResourceAsStream("/de/proveo/idm/ssh/service/resources/ssh/id_rsa"));
        ret.add(SSHConnection.class.getResourceAsStream("/de/proveo/idm/ssh/service/resources/ssh/infomanAdmin_rsa"));
        return ret;
    }
}

