/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.ssh.service;

import com.jcraft.jsch.UIKeyboardInteractive;
import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.ssh.service.SSHConnection;
import de.proveo.infoman.remote.SSHUserInfo;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;
import org.netbeans.api.keyring.Keyring;

public class MySSHUserInfo
extends SSHUserInfo
implements UIKeyboardInteractive {
    private static final String PASSWORD_KEY_PREFIX = "ssh.passwd.";
    private static final String PASSPHRASE_KEY_PREFIX = "ssh.passphrase.";
    private String user = null;

    public String getPassphrase() {
        return this.passphrase;
    }

    public String getPassword() {
        return this.passwd;
    }

    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        String[] response = new String[prompt.length];
        for (int i = 0; i < prompt.length; ++i) {
            Icon leftIcon;
            String passKey = PASSWORD_KEY_PREFIX + this.host;
            if (this.user != null) {
                passKey = PASSWORD_KEY_PREFIX + this.host + ".%s";
            }
            Icon rightIcon = DialogUtil.DEFAULT_LOGIN_IMAGE_RIGHT;
            switch (this.deviceType) {
                case 0: {
                    leftIcon = SSHConnection.INFOMAN_LOGIN_IMAGE;
                    break;
                }
                case 2: {
                    leftIcon = SSHConnection.SERVER_LOGIN_IMAGE;
                    break;
                }
                default: {
                    leftIcon = DialogUtil.DEFAULT_LOGIN_IMAGE_LEFT;
                }
            }
            Credentials cred = DialogUtil.showLoginDialog((String)("Password for " + this.host), (String)"Enter Password", (String)passKey, (String)this.user, (boolean)false, (Icon)leftIcon, (Icon)rightIcon);
            if (cred == null) {
                return null;
            }
            response[i] = new String(cred.getPassword());
        }
        return response;
    }

    public boolean promptPassphrase(String message) {
        Icon leftIcon;
        if (this.host != null) {
            message = "Passphrase for " + this.host + ":";
        }
        String passKey = PASSPHRASE_KEY_PREFIX + this.host;
        if (this.user != null) {
            passKey = PASSPHRASE_KEY_PREFIX + this.host + ".%s";
        }
        Icon rightIcon = DialogUtil.DEFAULT_LOGIN_IMAGE_RIGHT;
        switch (this.deviceType) {
            case 0: {
                leftIcon = SSHConnection.INFOMAN_LOGIN_IMAGE;
                break;
            }
            case 2: {
                leftIcon = SSHConnection.SERVER_LOGIN_IMAGE;
                break;
            }
            default: {
                leftIcon = DialogUtil.DEFAULT_LOGIN_IMAGE_LEFT;
            }
        }
        Credentials cred = DialogUtil.showLoginDialog((String)message, (String)"Enter Passphrase", (String)passKey, (String)this.user, (boolean)false, (Icon)leftIcon, (Icon)rightIcon);
        if (cred != null) {
            this.passphrase = new String(cred.getPassword());
            return true;
        }
        return false;
    }

    public boolean promptPassword(String message) {
        Icon leftIcon;
        if (this.host != null) {
            message = "Password for " + this.host + ":";
        }
        String passKey = PASSWORD_KEY_PREFIX + this.host;
        if (this.user != null) {
            passKey = PASSWORD_KEY_PREFIX + this.host + ".%s";
        }
        Icon rightIcon = DialogUtil.DEFAULT_LOGIN_IMAGE_RIGHT;
        switch (this.deviceType) {
            case 0: {
                leftIcon = SSHConnection.INFOMAN_LOGIN_IMAGE;
                break;
            }
            case 2: {
                leftIcon = SSHConnection.SERVER_LOGIN_IMAGE;
                break;
            }
            default: {
                leftIcon = DialogUtil.DEFAULT_LOGIN_IMAGE_LEFT;
            }
        }
        Credentials cred = DialogUtil.showLoginDialog((String)message, (String)"Enter Password", (String)passKey, (String)this.user, (boolean)false, (Icon)leftIcon, (Icon)rightIcon);
        if (cred != null) {
            this.passwd = new String(cred.getPassword());
            return true;
        }
        return false;
    }

    public boolean promptYesNo(String str) {
        Object result = DialogUtil.showMessageDialog((Object)str, (String)"Warning", (boolean)true, (int)2, (int)0);
        return DialogUtil.YES_OPTION.equals(result);
    }

    public void reInit() {
        this.host = null;
        this.passphrase = null;
        this.passwd = null;
    }

    public void setConnetingToUrl(String url) {
        this.host = url;
        this.user = null;
        this.passwd = null;
        this.passphrase = null;
        if (this.host != null) {
            char[] passph;
            char[] password;
            if (this.host.contains("@")) {
                String[] split = StringUtils.split((String)this.host, (String)"@");
                this.user = split[0];
                if (this.user.contains(":")) {
                    split = StringUtils.split((String)this.user, (String)":");
                    this.user = split[0];
                }
            }
            String passwdKey = PASSWORD_KEY_PREFIX + this.host;
            String passphraseKey = PASSPHRASE_KEY_PREFIX + this.host;
            if (this.user != null) {
                passwdKey = PASSWORD_KEY_PREFIX + this.host + "." + this.user;
                passphraseKey = PASSPHRASE_KEY_PREFIX + this.host + "." + this.user;
            }
            if ((password = Keyring.read((String)passwdKey)) != null) {
                this.passwd = new String(password);
            }
            if ((passph = Keyring.read((String)passphraseKey)) != null) {
                this.passphrase = new String(passph);
            }
        }
    }

    public void setPasswd(String password) {
        this.passwd = password;
    }

    public void showMessage(String message) {
        DialogUtil.showMessageDialog((Object)message, null, (boolean)true, (int)-1, (int)-1);
    }
}

