/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.issuetable;

import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;
import org.openide.util.NbBundle;

public abstract class Filter {
    private static AllFilter allFilter;
    private static NotSeenFilter notSeenFilter;
    private static NewFilter newFilter;

    public abstract String getDisplayName();

    public abstract boolean accept(IssueNode var1);

    static synchronized Filter getAllFilter() {
        if (allFilter == null) {
            allFilter = new AllFilter();
        }
        return allFilter;
    }

    static Filter getNotSeenFilter() {
        if (notSeenFilter == null) {
            notSeenFilter = new NotSeenFilter();
        }
        return notSeenFilter;
    }

    static Filter getNewFilter() {
        if (newFilter == null) {
            newFilter = new NewFilter();
        }
        return newFilter;
    }

    private static class AllFilter
    extends Filter {
        AllFilter() {
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(Filter.class, (String)"LBL_AllIssuesFilter");
        }

        @Override
        public boolean accept(IssueNode node) {
            return true;
        }
    }

    private static class NewFilter
    extends Filter {
        NewFilter() {
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(Filter.class, (String)"LBL_NewIssuesFilter");
        }

        @Override
        public boolean accept(IssueNode node) {
            return node.getStatus() == IssueStatusProvider.Status.INCOMING_NEW;
        }
    }

    private static class NotSeenFilter
    extends Filter {
        NotSeenFilter() {
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(Filter.class, (String)"LBL_UnseenIssuesFilter");
        }

        @Override
        public boolean accept(IssueNode node) {
            return node.getStatus() != IssueStatusProvider.Status.SEEN;
        }
    }
}

