/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.Body;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.Element;
import org.netbeans.modules.css.model.api.ElementFactory;
import org.netbeans.modules.css.model.api.Media;
import org.netbeans.modules.css.model.api.MediaBody;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.ModelUtils;
import org.netbeans.modules.css.model.api.ModelVisitor;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.Selector;
import org.netbeans.modules.css.model.api.SelectorsGroup;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.visual.Bundle;
import org.netbeans.modules.css.visual.ComboBoxAutoCompleteSupport;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelFactory;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class EditRulesPanel
extends JPanel {
    private String selectorText;
    private DefaultComboBoxModel STYLESHEETS_MODEL;
    private DefaultComboBoxModel AT_RULES_MODEL;
    private DefaultComboBoxModel SELECTORS_MODEL = new DefaultComboBoxModel();
    private FileObject context;
    private Model selectedStyleSheetModel;
    private Collection<String> TAG_NAMES;
    private Map<FileObject, Collection<String>> findAllClassDeclarations;
    private Map<FileObject, Collection<String>> findAllIdDeclarations;
    private SelectorItemRenderer SELECTOR_MODEL_ITEM_RENDERER;
    private JButton addStylesheetButton;
    private JComboBox atRuleCB;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JTextField jTextField1;
    private JComboBox selectorCB;
    private JComboBox styleSheetCB;

    public EditRulesPanel() {
        this.STYLESHEETS_MODEL = new DefaultComboBoxModel();
        this.AT_RULES_MODEL = new DefaultComboBoxModel();
        this.initComponents();
        ComboBoxAutoCompleteSupport.install(this.selectorCB);
        this.selectorCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (item instanceof String) {
                    EditRulesPanel.this.setSelector((String)item);
                } else {
                    EditRulesPanel.this.setSelector((SelectorItem)e.getItem());
                }
            }
        });
        final ComboBoxEditor editor = this.selectorCB.getEditor();
        if (editor.getEditorComponent() instanceof JTextComponent) {
            JTextComponent textEditor = (JTextComponent)editor.getEditorComponent();
            Document doc = textEditor.getDocument();
            doc.addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent de) {
                    this.change();
                }

                @Override
                public void removeUpdate(DocumentEvent de) {
                    this.change();
                }

                @Override
                public void changedUpdate(DocumentEvent de) {
                    this.change();
                }

                private void change() {
                    EditRulesPanel.this.setSelector(editor.getItem().toString());
                }
            });
        }
    }

    private void setSelector(String text) {
        this.selectorText = text;
        this.styleSheetCB.setEnabled(true);
        this.atRuleCB.setEnabled(true);
    }

    private void setSelector(SelectorItem selector) {
        boolean exists;
        this.selectorText = selector.getItemName();
        FileObject existsIn = selector.getFile();
        boolean bl = exists = existsIn != null;
        if (exists) {
            this.STYLESHEETS_MODEL.setSelectedItem(existsIn);
        }
        this.styleSheetCB.setEnabled(!exists);
        this.atRuleCB.setEnabled(!exists);
    }

    public void setContext(FileObject context) {
        this.context = context;
        this.updateModels();
    }

    private void updateModels() {
        this.updateSelectorsModel();
        this.updateStyleSheetsModel();
        this.updateCssModel(this.context);
        if (this.selectedStyleSheetModel == null) {
            return;
        }
        this.updateAtRulesModel();
    }

    private void updateStyleSheetsModel() {
        try {
            this.STYLESHEETS_MODEL.removeAllElements();
            Project project = FileOwnerQuery.getOwner((FileObject)this.context);
            if (project == null) {
                return;
            }
            CssIndex index = CssIndex.create((Project)project);
            for (FileObject file : index.getAllIndexedFiles()) {
                if (!"text/css".equals(file.getMIMEType())) continue;
                this.STYLESHEETS_MODEL.addElement(file);
            }
            if (this.STYLESHEETS_MODEL.getIndexOf(this.context) >= 0) {
                this.STYLESHEETS_MODEL.setSelectedItem(this.context);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateCssModel(FileObject file) {
        try {
            Source source = Source.create((FileObject)file);
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    if ((resultIterator = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css")) != null) {
                        CssParserResult result = (CssParserResult)resultIterator.getParserResult();
                        EditRulesPanel.this.selectedStyleSheetModel = Model.getModel((CssParserResult)result);
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateAtRulesModel() {
        this.AT_RULES_MODEL.removeAllElements();
        this.AT_RULES_MODEL.addElement(null);
        this.selectedStyleSheetModel.runReadTask(new Model.ModelTask(){

            public void run(StyleSheet styleSheet) {
                ModelVisitor.Adapter visitor = new ModelVisitor.Adapter(){

                    public void visitMedia(Media media) {
                        String displayName = EditRulesPanel.this.selectedStyleSheetModel.getElementSource((Element)media.getMediaQueryList()).toString();
                        EditRulesPanel.this.AT_RULES_MODEL.addElement(new MediaItem(displayName, media));
                    }
                };
                styleSheet.accept((ModelVisitor)visitor);
            }
        });
        this.atRuleCB.setEnabled(this.AT_RULES_MODEL.getSize() > 1);
    }

    public void applyChanges() {
        if (this.selectorText == null) {
            return;
        }
        this.selectedStyleSheetModel.runWriteTask(new Model.ModelTask(){

            public void run(StyleSheet styleSheet) {
                ElementFactory factory = EditRulesPanel.this.selectedStyleSheetModel.getElementFactory();
                Selector s = factory.createSelector((CharSequence)EditRulesPanel.this.selectorText);
                SelectorsGroup sg = factory.createSelectorsGroup(new Selector[]{s});
                Declarations ds = factory.createDeclarations();
                Rule rule = factory.createRule(sg, ds);
                Media media = EditRulesPanel.this.getSelectedMedia();
                if (media == null) {
                    Body body = styleSheet.getBody();
                    if (body == null) {
                        body = factory.createBody();
                        styleSheet.setBody(body);
                    }
                    styleSheet.getBody().addRule(rule);
                } else {
                    MediaBody mediaBody = media.getMediaBody();
                    if (mediaBody == null) {
                        mediaBody = factory.createMediaBody();
                    }
                    mediaBody.addRule(rule);
                }
                try {
                    EditRulesPanel.this.selectedStyleSheetModel.applyChanges();
                    EditRulesPanel.this.selectTheRuleInEditorIfOpened(EditRulesPanel.this.selectedStyleSheetModel, rule);
                }
                catch (IOException | BadLocationException | ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private void selectTheRuleInEditorIfOpened(final Model omodel, final Rule orule) throws DataObjectNotFoundException, ParseException {
        FileObject file = (FileObject)omodel.getLookup().lookup(FileObject.class);
        DataObject dobj = DataObject.find((FileObject)file);
        final EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
        final AtomicInteger ruleOffset = new AtomicInteger(-1);
        Source source = Source.create((FileObject)file);
        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                if ((resultIterator = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css")) != null) {
                    CssParserResult result = (CssParserResult)resultIterator.getParserResult();
                    final Model model = Model.getModel((CssParserResult)result);
                    model.runReadTask(new Model.ModelTask(){

                        public void run(StyleSheet styleSheet) {
                            ModelUtils utils = new ModelUtils(model);
                            Rule match = utils.findMatchingRule(omodel, orule);
                            if (match != null) {
                                ruleOffset.set(match.getStartOffset());
                            }
                        }
                    });
                }
            }
        });
        if (ruleOffset.get() == -1) {
            return;
        }
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                JEditorPane[] openedPanes = ec.getOpenedPanes();
                if (openedPanes != null && openedPanes.length > 0) {
                    JEditorPane pane = openedPanes[0];
                    pane.setCaretPosition(ruleOffset.get());
                }
            }
        });
    }

    private Media getSelectedMedia() {
        Object selected = this.atRuleCB.getSelectedItem();
        if (selected == null) {
            return null;
        }
        return ((MediaItem)selected).getMedia();
    }

    private void updateSelectorsModel() {
        try {
            this.SELECTORS_MODEL.removeAllElements();
            Project project = FileOwnerQuery.getOwner((FileObject)this.context);
            if (project == null) {
                return;
            }
            CssIndex index = CssIndex.create((Project)project);
            this.findAllClassDeclarations = index.findAllClassDeclarations();
            for (FileObject file : this.findAllClassDeclarations.keySet()) {
                Collection<String> classes = this.findAllClassDeclarations.get(file);
                for (String clz : classes) {
                    this.SELECTORS_MODEL.addElement(SelectorItem.createClass(clz, file));
                }
            }
            this.findAllIdDeclarations = index.findAllIdDeclarations();
            for (FileObject file : this.findAllIdDeclarations.keySet()) {
                Collection<String> ids = this.findAllIdDeclarations.get(file);
                for (String id : ids) {
                    this.SELECTORS_MODEL.addElement(SelectorItem.createId(id, file));
                }
            }
            for (String tag : this.getTagNames()) {
                this.SELECTORS_MODEL.addElement(SelectorItem.createElement(tag));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Collection<String> getTagNames() {
        if (this.TAG_NAMES == null) {
            this.TAG_NAMES = new TreeSet<String>();
            HtmlModel model = HtmlModelFactory.getModel((HtmlVersion)HtmlVersion.HTML5);
            for (HtmlTag tag : model.getAllTags()) {
                this.TAG_NAMES.add(tag.getName());
            }
        }
        return this.TAG_NAMES;
    }

    private SelectorItemRenderer getSelectorModelItemRenderer() {
        if (this.SELECTOR_MODEL_ITEM_RENDERER == null) {
            this.SELECTOR_MODEL_ITEM_RENDERER = new SelectorItemRenderer();
        }
        return this.SELECTOR_MODEL_ITEM_RENDERER;
    }

    private ListCellRenderer createSelectorsRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    SelectorItemRenderer selectorModelItemRenderer = EditRulesPanel.this.getSelectorModelItemRenderer();
                    selectorModelItemRenderer.setItem((SelectorItem)value, isSelected);
                    return selectorModelItemRenderer;
                }
                return c;
            }
        };
    }

    private ListCellRenderer createAtRulesRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    this.setText(Bundle.EditRulesPanel_none_item());
                } else {
                    this.setText(((MediaItem)value).getDisplayName());
                }
                return c;
            }
        };
    }

    private ListCellRenderer createStylesheetsRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    return c;
                }
                FileObject file = (FileObject)value;
                String fileNameExt = file.getNameExt();
                this.setText(fileNameExt);
                return c;
            }
        };
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.styleSheetCB = new JComboBox();
        this.atRuleCB = new JComboBox();
        this.jLabel4 = new JLabel();
        this.selectorCB = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.addStylesheetButton = new JButton();
        this.jTextField1 = new JTextField();
        this.jLabel1 = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(EditRulesPanel.class, (String)"EditRulesPanel.jButton1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(EditRulesPanel.class, (String)"EditRulesPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(EditRulesPanel.class, (String)"EditRulesPanel.jLabel3.text"));
        this.styleSheetCB.setModel(this.STYLESHEETS_MODEL);
        this.styleSheetCB.setRenderer(this.createStylesheetsRenderer());
        this.styleSheetCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EditRulesPanel.this.styleSheetCBItemStateChanged(evt);
            }
        });
        this.atRuleCB.setModel(this.AT_RULES_MODEL);
        this.atRuleCB.setRenderer(this.createAtRulesRenderer());
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(EditRulesPanel.class, (String)"EditRulesPanel.jLabel4.text"));
        this.selectorCB.setEditable(true);
        this.selectorCB.setModel(this.SELECTORS_MODEL);
        this.selectorCB.setRenderer(this.createSelectorsRenderer());
        this.addStylesheetButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/css/visual/resources/plus.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.addStylesheetButton, (String)NbBundle.getMessage(EditRulesPanel.class, (String)"EditRulesPanel.addStylesheetButton.text"));
        this.addStylesheetButton.setEnabled(false);
        this.jTextField1.setText(NbBundle.getMessage(EditRulesPanel.class, (String)"EditRulesPanel.jTextField1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(EditRulesPanel.class, (String)"EditRulesPanel.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator1).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.styleSheetCB, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addStylesheetButton).addContainerGap()).addComponent(this.jTextField1).addComponent(this.atRuleCB, 0, -1, Short.MAX_VALUE).addComponent(this.selectorCB, 0, 316, Short.MAX_VALUE))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel4).addComponent(this.selectorCB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.styleSheetCB, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jLabel2)).addComponent(this.addStylesheetButton)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.atRuleCB, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap(40, Short.MAX_VALUE)));
    }

    private void styleSheetCBItemStateChanged(ItemEvent evt) {
        FileObject file = (FileObject)this.STYLESHEETS_MODEL.getSelectedItem();
        if (file != null) {
            this.updateCssModel(file);
            this.updateAtRulesModel();
        }
    }

    private static class MediaItem {
        private Media media;
        private String displayName;

        public MediaItem(String displayName, Media media) {
            this.displayName = displayName;
            this.media = media;
        }

        public Media getMedia() {
            return this.media;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    private static class SelectorItem {
        private String clz;
        private String id;
        private String element;
        private FileObject existsIn;

        private static SelectorItem createClass(String name, FileObject existsIn) {
            return new SelectorItem(name, null, null, existsIn);
        }

        private static SelectorItem createId(String name, FileObject existsIn) {
            return new SelectorItem(null, name, null, existsIn);
        }

        private static SelectorItem createElement(String name) {
            return new SelectorItem(null, null, name, null);
        }

        public SelectorItem(String clz, String id, String element, FileObject existsIn) {
            this.clz = clz;
            this.id = id;
            this.element = element;
            this.existsIn = existsIn;
        }

        public FileObject getFile() {
            return this.existsIn;
        }

        public String getFileDisplayName() {
            return this.existsIn != null ? this.existsIn.getNameExt() : null;
        }

        public String getItemName() {
            StringBuilder sb = new StringBuilder();
            if (this.clz != null) {
                sb.append('.');
                sb.append(this.clz);
            } else if (this.id != null) {
                sb.append('#');
                sb.append(this.id);
            } else if (this.element != null) {
                sb.append(this.element);
            }
            return sb.toString();
        }

        public String toString() {
            return this.getItemName().toString();
        }
    }

    private static class SelectorItemRenderer
    extends JPanel {
        private JLabel west = new JLabel();
        private JLabel east = new JLabel();
        private Color bg;
        private Color bgSelected;
        private Color fg;
        private Color fgSelected;
        private Color inFile;

        public SelectorItemRenderer() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.west, "West");
            this.add((Component)this.east, "East");
            this.fg = UIManager.getDefaults().getColor("ComboBox.foreground");
            this.bg = UIManager.getDefaults().getColor("ComboBox.background");
            this.fgSelected = UIManager.getDefaults().getColor("ComboBox.selectionForeground");
            this.bgSelected = UIManager.getDefaults().getColor("ComboBox.selectionBackground");
            this.inFile = Color.gray;
        }

        public void setItem(SelectorItem item, boolean isSelected) {
            this.west.setText(item.getItemName());
            this.east.setText(item.getFileDisplayName());
            if (isSelected) {
                this.west.setForeground(this.fgSelected);
                this.east.setForeground(this.fgSelected);
                this.setBackground(this.bgSelected);
            } else {
                this.west.setForeground(this.fg);
                this.east.setForeground(this.inFile);
                this.setBackground(this.bg);
            }
        }
    }
}

