/*
 * Decompiled with CFR 0.152.
 */
package org.mycompany.installer.utils.applications;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.system.WindowsNativeUtils;
import org.netbeans.installer.utils.system.windows.WindowsRegistry;

public class NetBeansRCPUtils {
    public static final String NEW_LINE_PATTERN = "[\r\n|\n|\r]";
    public static final String SPACES_PATTERN = "\\ *";
    public static final String DEFAULT_USERDIR = "default_userdir=";
    public static final String DEFAULT_USERDIR_MAC = "default_mac_userdir=";
    public static final String USER_HOME_TOKEN = "${HOME}";
    public static final String APPNAME_TOKEN = "${APPNAME}";
    public static final String ERROR_CANNOT_GET_USERDIR_STRING = ResourceUtils.getString(NetBeansRCPUtils.class, "NU.error.cannot.get.userdir");

    public static File getApplicationUserDirFile(File appLocation) throws IOException {
        String dir = NetBeansRCPUtils.getApplicationUserDir(appLocation);
        String userHome = System.getProperty("user.home");
        if (SystemUtils.isWindows()) {
            WindowsNativeUtils wnu = (WindowsNativeUtils)SystemUtils.getNativeUtils();
            WindowsRegistry reg = wnu.getWindowsRegistry();
            String key = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
            try {
                if (reg.keyExists(1, key)) {
                    if (reg.valueExists(1, key, "AppData")) {
                        userHome = reg.getStringValue(1, key, "AppData", false);
                    }
                }
            }
            catch (NativeException e) {
                LogManager.log(e);
            }
        }
        dir = dir.replace(USER_HOME_TOKEN, userHome);
        dir = dir.replace(APPNAME_TOKEN, NetBeansRCPUtils.getApplicationName(appLocation));
        return new File(dir);
    }

    public static String getApplicationUserDir(File appLocation) throws IOException {
        File[] confFiles = new File(appLocation, "etc").listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".conf");
            }
        });
        File conf = null;
        if (confFiles.length == 1) {
            conf = confFiles[0];
        } else {
            for (File f : confFiles) {
                String prefix = f.getName().substring(0, f.getName().indexOf(".conf"));
                if ((!SystemUtils.isUnix() || !new File(appLocation, "bin/" + prefix).exists()) && (!SystemUtils.isWindows() || !new File(appLocation, "bin/" + prefix + ".exe").exists())) continue;
                conf = f;
                break;
            }
        }
        if (conf == null) {
            return null;
        }
        String contents = FileUtils.readFile(conf);
        Matcher matcher = Pattern.compile("[\r\n|\n|\r]\\ *" + (SystemUtils.isMacOS() ? DEFAULT_USERDIR_MAC : DEFAULT_USERDIR) + "\"(.*?)\"").matcher(contents);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        throw new IOException(StringUtils.format(ERROR_CANNOT_GET_USERDIR_STRING, conf));
    }

    public static String getApplicationName(File appLocation) {
        File[] confFiles = new File(appLocation, "etc").listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".conf");
            }
        });
        if (confFiles.length == 1) {
            String name = confFiles[0].getName();
            return name.substring(0, name.indexOf(".conf"));
        }
        for (File f : confFiles) {
            String name = f.getName();
            String prefix = name.substring(0, name.indexOf(".conf"));
            if ((!SystemUtils.isUnix() || !new File(appLocation, "bin/" + prefix).exists()) && (!SystemUtils.isWindows() || !new File(appLocation, "bin/" + prefix + ".exe").exists())) continue;
            return prefix;
        }
        return null;
    }

    private NetBeansRCPUtils() {
    }
}

