#!/bin/sh
cd /home/infoman
export PATH
CLASSPATH=.:infoman-main-1.12.1.jar:commons-codec-1.3.jar:commons-collections-3.2.jar:commons-httpclient-3.1.jar:commons-io-1.4.jar:commons-lang-2.4.jar:commons-logging-1.1.1.jar:commons-net-1.4.1.jar:infoman-api-1.12.1.jar:infoman-can-1.12.1.jar:infoman-controlSocket-1.12.1.jar:infoman-datasync-1.12.1.jar:infoman-event-1.12.1.jar:infoman-gps-1.12.1.jar:infoman-impactSensor-1.12.1.jar:infoman-impl-util-1.12.1.jar:infoman-io-1.12.1.jar:infoman-lcd-1.12.1.jar:infoman-linux-io-1.12.1.jar:infoman-mifare-1.12.1.jar:infoman-phytec-io-1.12.1.jar:infoman-plugin-1.12.1.jar:infoman-scl-1.12.1.jar:infoman-util-1.12.1.jar:onewireapi-1.0.jar:log4j-1.2.16.jar:oro-2.0.8.jar:proveo-wwt-eventBase-4.6.12-dev.jar:puretls-0.9b5.jar

PLUGIN_DIRECTORY=plugins
PLUGIN_FILES=*.jar

LIBRARY_PATH=.:/lib:$PLUGIN_DIRECTORY

for file in $PLUGIN_DIRECTORY/*
do
        if [ -d $file ];then
                for file2 in $file/$PLUGIN_FILES
                        do
                                CLASSPATH=$CLASSPATH:$file2
                        done

		LIBRARY_PATH=$LIBRARY_PATH:$file
        fi
done
for file in $PLUGIN_DIRECTORY/$PLUGIN_FILES
do
        CLASSPATH=$CLASSPATH:$file
done

# search java vm
if [ -f /bin/mika ]; then
  JAVA_VM=mika
else
  if [ -f /bin/mika.old ]; then
    mv /bin/mika.old /bin/mika
    touch /var/log/infoman.bin.mika.restored
    JAVA_VM=mika
  else
    JAVA_VM=wonka
  fi
fi

if [ -f /bin/mika.old ]; then
    rm -f /bin/mika.old
fi

# remove old wpa_supplicant
if [ -f /sbin/wpa_supplicant ]; then
    rm -rf /sbin/wpa_supplicant.old
else
    if [ -f /sbin/wpa_supplicant.old ]; then
        mv /sbin/wpa_supplicant.old /sbin/wpa_supplicant
    fi
fi

# remove old wpa_cli
if [ -f /sbin/wpa_cli ]; then
    rm -rf /sbin/wpa_cli.old
else
    if [ -f /sbin/wpa_cli.old ]; then
        mv /sbin/wpa_cli.old /sbin/wpa_cli
    fi
fi

# remove old wpa_passphrase
if [ -f /sbin/wpa_passphrase ]; then
    rm -rf /sbin/wpa_passphrase.old
else
    if [ -f /sbin/wpa_passphrase.old ]; then
        mv /sbin/wpa_passphrase.old /sbin/wpa_passphrase
    fi
fi

# If the service iomultiplexd is running the service is stoped.
msvc -d services/iomultiplexd

DATE_TIME=`date +%m.%d.%y_%H-%M-%S`
PROCESS_LOG=$JAVA_VM"_"$DATE_TIME".log"
OLD_PROCESS_LOG=$JAVA_VM.log

if [ -e $OLD_PROCESS_LOG ]; then
	rm -rf $OLD_PROCESS_LOG&
fi

INDEX=1
MAX=10
for LINE in `ls -lt $JAVA_VM*.log | awk '{ print $9 }'`;do
	if [ $INDEX -gt $MAX ];then
		rm -f $LINE&
	fi

	let INDEX=$INDEX+1
done

echo `date` `uptime` >> $PROCESS_LOG
echo `date` $JAVA_VM start >> $PROCESS_LOG
$JAVA_VM -Xmx=32M -Djava.library.path=$LIBRARY_PATH -cp $CLASSPATH de.proveo.infoman.InfomanMain 2>> $PROCESS_LOG
EXIT_CODE=$?
echo `date` "exit code: "$EXIT_CODE >> $PROCESS_LOG
echo `date` `uptime` >> $PROCESS_LOG
echo --------------------------  >> $PROCESS_LOG
