#!/bin/sh
#
# Infoman Diagnostic Script
#
# /sbin/infomanDiagnostic.sh
#
# The output is written to /tmp/diagnostic.tar.gz
#

rm -rf /tmp/diag/ /tmp/diagnostic.tar.gz
mkdir -p /tmp/diag

# infoman.log
cat /home/infoman/infoman.log.2 /home/infoman/infoman.log.1 /home/infoman/infoman.log | gzip > /tmp/diag/infoman.log.gz

# infoman-debug.log
cat /var/log/infoman-debug.log.6 /var/log/infoman-debug.log.5 /var/log/infoman-debug.log.4 /var/log/infoman-debug.log.3 /var/log/infoman-debug.log.2 /var/log/infoman-debug.log.1 /var/log/infoman-debug.log | gzip > /tmp/diag/infoman-debug.log.gz

# environment
df > /tmp/diag/df.log
echo q > stopCmd
top < stopCmd  > /tmp/diag/top.log
free > /tmp/diag/free.log
ps > /tmp/diag/ps.log
dmesg > /tmp/diag/dmesg.log
ls -al /proc/$(pidof mika)/fd > /tmp/diag/mika-pid-fd.log

mkdir -p /tmp/diag/home/infoman
cp /home/infoman/infomanACL /tmp/diag/home/infoman
cp /home/infoman/persistentBlackboard /tmp/diag/home/infoman
cp /home/infoman/*.properties /tmp/diag/home/infoman

mkdir -p /tmp/diag/etc
cp /etc/resolv.conf /tmp/diag/etc

ls / -lR | gzip > /tmp/diag/filesystem.gz

tar -czvf /tmp/diagnostic.tar.gz /tmp/diag /home/infoman/mika* /etc/minit /etc/ppp

rm -rf /tmp/diag/
exit
