import de.proveo.idm.infoman.archive.api.InfomanEFMFileRead;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/**
 * @author funfried
 */
public class FileRead extends InfomanEFMFileRead
{
	private static final Logger log = Logger.getLogger(FileRead.class.getName());

	/**
	 * @todo optimize: a bit inefficient, why not building a mapt with the command name?
	 * (everthing which is before "=" is the key)
	 */
	@Override
	public Properties parseFile(File file) throws Exception
	{
		Properties props = new Properties();

		FileInputStream fis = null;
		InputStreamReader isr = null;
		BufferedReader br = null;

		try
		{
			fis = new FileInputStream(file);
			isr = new InputStreamReader(fis);
			br = new BufferedReader(isr);

			while(br.ready())
			{
				String line = br.readLine();
				if(line == null)
				{
					continue;
				}

				line = line.trim();
				if(line.startsWith("//"))
				{ // comment
					continue;
				}
				else if(line.contains("//"))
				{ // contains comment
					line = StringUtils.substringBefore(line, "//").trim();
				}

				if(line.length() == 0)
				{
					continue;
				}

				if(line.toUpperCase().startsWith("AT+LOCASV"))
				{
					props.putAll(this.parseAT_LOCASV(line));
				}
				else if(line.toUpperCase().startsWith("AT+LOCTSV"))
				{
					props.putAll(this.parseAT_LOCTSV(line));
				}
				else if(line.toUpperCase().startsWith("AT+LOCTAK"))
				{
					props.putAll(this.parseAT_LOCTAK(line));
				}
				else if(line.toUpperCase().startsWith("AT#TCPSERV"))
				{
					props.putAll(this.parseAT_TCPSERV(line));
				}
				else if(line.toUpperCase().startsWith("AT#TCPPORT"))
				{
					props.putAll(this.parseAT_TCPPORT(line));
				}
				else if(line.toUpperCase().startsWith("AT#DLEMODE"))
				{
					props.putAll(this.parseAT_DLEMODE(line));
				}
				else if(line.toUpperCase().startsWith("AT+LOCSTK"))
				{
					props.putAll(this.parseAT_LOCSTK(line));
				}
				else if(line.toUpperCase().startsWith("AT+LOCSND"))
				{
					props.putAll(this.parseAT_LOCSND(line));
				}
				else if(line.toUpperCase().startsWith("AT+LOCGAP"))
				{
					props.putAll(this.parseAT_LOCGAP(line));
				}
				else if(line.toUpperCase().startsWith("AT+LOCCRS"))
				{
					props.putAll(this.parseAT_LOCCRS(line));
				}
				else if(line.toUpperCase().startsWith("AT+PRVCFG"))
				{
					props.putAll(parseAT_PRVCFG(line));
				}
				else if(line.toUpperCase().startsWith("AT+EGMOVE"))
				{
					props.putAll(this.parseAT_EGMOVE(line));
				}
				else if(line.toUpperCase().startsWith("AT+EGSHOCK"))
				{
					props.putAll(this.parseAT_EGSHOCK(line));
				}
				else if(line.toUpperCase().startsWith("AT+PRVPWR"))
				{
					props.putAll(this.parseAT_PRVPWR(line));
				}				
				else
				{
					log.log(Level.WARNING, "Found unknown AT command: {0}", line);

					props.putAll(this.parseUnknownATCommand(line));
				}
			}
		}
		finally
		{
			IOUtils.closeQuietly(br);
			IOUtils.closeQuietly(isr);
			IOUtils.closeQuietly(fis);
		}

		return props;
	}

	protected Properties parseAT_TCPSERV(String command)
	{
		Properties props = new Properties();

		if(!command.toUpperCase().startsWith("AT#TCPSERV"))
		{
			log.log(Level.WARNING, "Could not parse AT#TCPSERV, command was: {0}", command);

			return props;
		}

		String line = StringUtils.substringAfter(command, "=");
		String[] values = StringUtils.split(line, ",");
		if(values.length == 2)
		{
			if("1".equals(this.parseNumber(values[0])))
			{
				props.setProperty("server.address", this.parseString(values[1]));
			}
			else
			{
				log.log(Level.WARNING, "Unexpected values in AT#TCPSERV, command was: {0}", command);
			}
		}
		else
		{
			log.log(Level.WARNING, "Unexpected values in AT#TCPSERV, command was: {0}", command);
		}

		return props;
	}

	protected Properties parseAT_TCPPORT(String command)
	{
		Properties props = new Properties();

		if(!command.toUpperCase().startsWith("AT#TCPPORT"))
		{
			log.log(Level.WARNING, "Could not parse AT#TCPPORT, command was: {0}", command);

			return props;
		}

		String line = StringUtils.substringAfter(command, "=");
		String[] values = StringUtils.split(line, ",");
		if(values.length == 2)
		{
			if("1".equals(this.parseNumber(values[0])))
			{
				props.setProperty("server.port", this.parseString(values[1]));
			}
			else
			{
				log.log(Level.WARNING, "Unexpected values in AT#TCPPORT, command was: {0}", command);
			}
		}
		else
		{
			log.log(Level.WARNING, "Unexpected values in AT#TCPPORT, command was: {0}", command);
		}

		return props;
	}

	protected Properties parseAT_DLEMODE(String command)
	{
		Properties props = new Properties();

		if(!command.toUpperCase().startsWith("AT#DLEMODE"))
		{
			log.log(Level.WARNING, "Could not parse AT#DLEMODE, command was: {0}", command);

			return props;
		}

		String line = StringUtils.substringAfter(command, "=");
		String[] values = StringUtils.split(line, ",");
		if(values.length == 2)
		{
			if("1".equals(this.parseNumber(values[0])))
			{
				props.setProperty("server.dleMode", this.parseBoolean(values[1]));
			}
			else
			{
				log.log(Level.WARNING, "Unexpected values in AT#DLEMODE, command was: {0}", command);
			}
		}
		else
		{
			log.log(Level.WARNING, "Unexpected values in AT#DLEMODE, command was: {0}", command);
		}

		return props;
	}
}
