<%
/**
 * Copyright (c) 2000-2007 Liferay, Inc. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
%>

<script type="text/javascript">
	function <portlet:namespace />updateCalendar(month, day, year) {
		self.location = '<portlet:renderURL windowState="<%= WindowState.MAXIMIZED.toString() %>"><portlet:param name="tabs1" value="day" /><portlet:param name="eventType" value="<%= eventType %>" /></portlet:renderURL>&<portlet:namespace />month=' + month + '&<portlet:namespace />day=' + day + '&<portlet:namespace />year=' + year;
	}
</script>

<table border="0" cellpadding="0" cellspacing="0">
<tr>
	<td>
		<table border="0" cellpadding="0" cellspacing="0">
		<tr>
			<td>
				<a href="<%= portletURL.toString() %>&<portlet:namespace />month=<%= selMonth %>&<portlet:namespace />day=<%= selDay %>&<portlet:namespace />year=<%= selYear - 1 %>&<portlet:namespace />eventType=<%= eventType %>">
				<img border="0" src="<%= themeDisplay.getPathThemeImage() %>/arrows/01_left.gif">
				</a>
			</td>
			<td style="padding-left: 10px;"></td>
			<td>
				<select onChange="self.location = '<%= portletURL.toString() %>&<portlet:namespace />year=' + this.value;">

					<%
					for (int i = -10; i <= 10; i++) {
					%>

						<option <%= ((curYear - selYear + i) == 0) ? "selected" : "" %> value="<%= Integer.toString(curYear + i) %>"><%= curYear + i %></option>

					<%
					}
					%>

				</select>
			</td>
			<td style="padding-left: 10px;"></td>
			<td>
				<a href="<%= portletURL.toString() %>&<portlet:namespace />month=<%= selMonth %>&<portlet:namespace />day=<%= selDay %>&<portlet:namespace />year=<%= selYear + 1 %>&<portlet:namespace />eventType=<%= eventType %>">
				<img border="0" src="<%= themeDisplay.getPathThemeImage() %>/arrows/01_right.gif">
				</a>
			</td>
		</tr>
		</table>
	</td>
	<td align="right">
		<select onChange="self.location = '<%= portletURL.toString() %>&<portlet:namespace />month=<%= selMonth %>&<portlet:namespace />day=<%= selDay %>&<portlet:namespace />year=<%= selYear %>&<portlet:namespace />eventType=' + this.value;">
			<option value=""><%= LanguageUtil.get(pageContext, "all-events") %></option>

			<%
			for (int i = 0; i < CalEventImpl.TYPES.length; i++) {
			%>

				<option <%= eventType.equals(CalEventImpl.TYPES[i]) ? "selected" : "" %> value="<%= CalEventImpl.TYPES[i] %>"><%= LanguageUtil.get(pageContext, CalEventImpl.TYPES[i]) %></option>

			<%
			}
			%>

		</select>
	</td>
</tr>
<tr>
	<td colspan="2">
		<br>

		<%
		List calendars = new ArrayList(12);

		for (int j = 0; j < 12; j++) {
			Calendar cal = (Calendar)selCal.clone();

			cal.set(Calendar.MONTH, j);
			cal.set(Calendar.DATE, 1);

			calendars.add(cal);
		}
		%>

		<liferay-ui:table-iterator
			list="<%= calendars %>"
			listType="java.util.Calendar"
			rowLength="3"
			rowPadding="30"
			rowValign="top">

			<%
			int month = tableIteratorObj.get(Calendar.MONTH);
			int year = tableIteratorObj.get(Calendar.YEAR);

			int maxDayOfMonth = tableIteratorObj.getActualMaximum(Calendar.DATE);

			Set data = new HashSet();

			for (int i = 1; i <= maxDayOfMonth; i++) {
				Calendar tempCal = (Calendar)selCal.clone();

				tempCal.set(Calendar.MONTH, month);
				tempCal.set(Calendar.DATE, i);
				tempCal.set(Calendar.YEAR, year);

				boolean hasEvents = CalEventLocalServiceUtil.hasEvents(portletGroupId, tempCal, eventType);

				if (hasEvents) {
					data.add(new Integer(i));
				}
			}
			%>

			<liferay-ui:calendar
				month="<%= month %>"
				day="<%= 1 %>"
				year="<%= year %>"
				headerPattern="MMMM"
				data="<%= data %>"
			/>
		</liferay-ui:table-iterator>
	</td>
</tr>
</table>