<%
/**
 * Copyright (c) 2000-2007 Liferay, Inc. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
%>

<%@ include file="/html/common/init.jsp" %>

<%@ page import="com.liferay.portal.language.LanguageUtil" %>

<%
String jSecurityCheck = "j_security_check";


jSecurityCheck = "c/portal/" + jSecurityCheck;
String jUserName = (String)session.getAttribute("j_username");
String jPassword = (String)session.getAttribute("j_password");
%>

<c:choose>
	<c:when test="<%= Validator.isNotNull(jUserName) && Validator.isNotNull(jPassword) %>">
		<html dir="<bean:message key="lang.dir" />">

		<head>
			<meta content="<%= Constants.TEXT_HTML %>; charset=<%= LanguageUtil.getCharset(locale) %>" http-equiv="content-type">
			<meta content="no-cache" http-equiv="Cache-Control">
			<meta content="no-cache" http-equiv="Pragma">
			<meta content="0" http-equiv="Expires">
			<script src="/html/js/xp_progress.js" type="text/javascript"></script>
<style type="text/css">
<!--
/* html {
	background: #fff url(/html/themes/proveo/images/base_layout/footer_bg.jpg) left bottom repeat-x;
	min-height: 100%;
}*/
body {
	margin: 0px;
	padding: 0px;
	font-family: Arial, Helvetica, sans-serif;
	font-size: small;
}
#proveo-layout-box {
	padding: 0px;
	margin: 0 auto 0 auto;
	text-align: left;
	background-image: url(/html/themes/proveo/images/base_layout/header_bg.jpg);
	width: 100%;
	height: 139px;
	border-bottom:1px solid #ccc;
}
#proveo_layout-top-banner {
	height: 110px;
	position: relative;
	text-align: left;
	z-index: 3;
}
#proveo_layout-top-banner img {
	margin-left: 42px;
	margin-top: 12px;
}
h1 {
	font-size: 80%;
	color: #000;
	margin-top: 50px;
}
#proveo_layout-outer-side-decoration {
	height: 100%;
}
#proveo_layout-inner-side-decoration {
	height: 100%;
	margin: 0 auto 0 auto;
}
-->
</style>

		</head>

		<body onLoad="setTimeout('document.fm.submit()', 100);">
		<div id="proveo-layout-box">
			<div id="proveo_layout-top-banner">
				<img src="/html/themes/proveo/images/base_layout/proveo_logo.gif" alt="" title="" />
			</div>
		</div>
	<center>
		<!-- <table border="0" cellpadding="0" cellspacing="0" height="100%" width="600"> -->
		<table border="0" cellpadding="0" cellspacing="0" width="600">
		<tr>
			<td align="center" valign="middle">
				<form action="<%= jSecurityCheck %>" method="post" name="fm">
				<input name="j_username" type="hidden" value="<%= jUserName %>">
				<input name="j_password" type="hidden" value="<%= jPassword %>">
				</form>

					<h1><%= LanguageUtil.get(pageContext, "processing-login") %></h1>

				<script type="text/javascript">
				var progressBar = createBar(300, 15, "#ffffff", 1, "#cccccc", "#ff9900", 85, 7, 3, "");
				</script>
			</td>
		</tr>
		</table>

		</center>

		</body>

		</html>

		<%
		
		SessionMessages.clear(request);
		SessionErrors.clear(request);
		
		%>

	</c:when>
	<c:otherwise>
		
		
		<!--
		This only happens if you're logged in and the server is rebooted and
		the user's old session is not recovered. Forward the user to the default
		page instead of posting to the protected page with invalid credentials.
		-->

		<%
		try {
			session.invalidate();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		%>

		<html dir="<bean:message key="lang.dir" />">

		<head>
			<title></title>
			<meta content="no-cache" http-equiv="Cache-Control">
			<meta content="no-cache" http-equiv="Pragma">
			<meta content="0" http-equiv="Expires">
			<script type="text/javascript" src="/resources/js/rts.js"></script>
		</head>
		
		<script type="text/javascript">
			if(isMobileDevice())
				self.location = self.location = '../../login/mobileLogin.jsp';
		</script>
		
		<body>
			<span class="proveo_portlet-msg-error"><%= LanguageUtil.get(pageContext, "session-timeout") %>
			<br>
			<a href="#" onclick="top.location='/c/portal/';">Login</a>
		</body>

		</html>
	</c:otherwise>
</c:choose>