// Session tab state support (rich:tabPanel)
//
// Panels and tabs are identified by id!
//
// needs cookies javasript functions

// When this object is defined, RichFaces.switchTab() calls
// saveTabState() to save active tab states
var saveTabStateCookies = new Object();
// When this parameter is true, only states from tabs are
// saved with id beginning with idPrefix (see below)
var useIdPrefix = false;
// Prefix to use with partial state saving
var idPrefix = "tabPanelState";
// Do not store tab state when panel id contains...
var idNoStore = "nostore";
// Cookie value separator
var separator = ",";
// CSS class used to identify rich:tabPanels
var panelClassName = "rich-tabpanel";
// Cookie name prefix for tab states. Necessary for deleting
// tab states with deleteTabStates()
var tabStateCookiePrefix = "riTaSt_";

function getElementsByClassName(strClass, strTag, objContElm)
{
  strTag = strTag || "*";
  objContElm = objContElm || document;    
  var objColl = objContElm.getElementsByTagName(strTag);
  if (!objColl.length &&  strTag == "*" &&  objContElm.all) objColl = objContElm.all;
  var arr = new Array();                              
  var delim = strClass.indexOf('|') != -1  ? '|' : ' ';   
  var arrClass = strClass.split(delim);    
  for (var i = 0, j = objColl.length; i < j; i++)
  {                         
    var arrObjClass = objColl[i].className.split(' ');   
    if (delim == ' ' && arrClass.length > arrObjClass.length) continue;
    var c = 0;
    comparisonLoop:
    for (var k = 0, l = arrObjClass.length; k < l; k++)
	{
      for (var m = 0, n = arrClass.length; m < n; m++)
      {
        if (arrClass[m] == arrObjClass[k]) c++;
        if ((delim == '|' && c == 1) || (delim == ' ' && c == arrClass.length))
        {
          arr.push(objColl[i]); 
          break comparisonLoop;
        }
      }
    }
  }
  return arr; 
}

// Find all rich:tabPanels with matching cookie prefix and id
// prefix (if activated)
//
// returns String array of matching element ids
function findTabPanels()
{
//	var d = Element.extend(document);
	var tables = getElementsByClassName(panelClassName);
	if (!tables || tables.length == 0)
		return null;
		
	var tabPanels = new Array(); 
    for (var i = 0; i < tables.length; i++)
    {
   		if (useIdPrefix)
   		{
			if (tables[i].id.indexOf(idPrefix) != -1)
        		tabPanels.push(tables[i].id);
        }
        else
	       	tabPanels.push(tables[i].id);
	}
        	
    if (tabPanels.length == 0)
    	return null;
    else
    	return tabPanels;
};

// Generate tab string for cookie
//
// returns cookie state string
function generateTabStateString(tab, value)
{
	var tabStateString = tab + separator + value;
	return tabStateString;
}

// Parse values from cookie and restore tab state
function parseTabStateStringAndRestore(panel, tabStateString)
{
	var values = tabStateString.split(separator);
	if (values.length != 2)
		return;
		
	var e = document.getElementById(values[0]);
	if (e)
    {
		RichFaces.switchTab(panel, values[0], values[1]);
        RichFaces.onTabChange(panel, values[0]);
    }
};

// Save tab state, called from RichFaches.switchTab()
// Do only call manually if you know what you are doing!
function saveTabState(pane, tab, value)
{
	if (pane.indexOf(idNoStore, 0) == -1)
		setCookie(tabStateCookiePrefix + pane, generateTabStateString(tab, value));
};

// Restore tab states
// If there are no states to restore, nothing happens.
function restoreTabState()
{
	var panels = findTabPanels();
	if (!panels)
		return;
	
	for (var i = 0; i < panels.length; i++)
	{
		var cookie = getCookie(tabStateCookiePrefix + panels[i]);
		if (!cookie)
			continue;
		parseTabStateStringAndRestore(panels[i], cookie);
	}
};

// Delete saved tab states
function deleteTabStates()
{
	var cookies = document.cookie.split('; ');
	for (var i = 0; i < cookies.length; i++)
	{
		if (cookies[i].indexOf(tabStateCookiePrefix) == 0)
		{
			var cookieName = cookies[i].substring(0, cookies[i].indexOf("="));
			deleteCookie(cookieName);
		}
	}
}

restoreTabState();
		