package de.proveo.rts.web.portlet.managedBeans.operation;

import javax.faces.model.ListDataModel;

import de.proveo.rts.web.logicAccess.payloadData.CurrentDataAccess;
import de.proveo.rts.web.managedBeans.common.dataSelection.ReportSelectionDTOFactory;
import de.proveo.rts.web.portlet.managedBeans.base.ProveoPortletBase;
import de.proveo.rts.web.portlet.util.RtsPortletUtil;

public class OperationUseBean extends ProveoPortletBase {

	private ListDataModel dataModel;
	
	private boolean showUnitKind;

	private boolean showUnitIcon;
	
	public OperationUseBean()
	{
		if (isInitialized())
		{
			showUnitKind = 
				Boolean.parseBoolean(RtsPortletUtil.getPreference("showUnitKind", "false"));
			showUnitIcon = 
				Boolean.parseBoolean(RtsPortletUtil.getPreference("showUnitIcon", "false"));

			if(!RtsPortletUtil.isEditMode())
			{
				update();
			}
		}
	}
	
	public void update() {
		 list = CurrentDataAccess.getCurrentUse(
				 ReportSelectionDTOFactory.buildUnitReportSelectionDTO(selectedUnitId, null, null, false));
		 if (isDataAvailable())
		 {
			 dataModel = new ListDataModel(list);
			 unitSelectionString = list.getName();
		 }
	}
	
	public void save()
	{
		super.save();

		RtsPortletUtil.setPreference("showUnitIcon", String.valueOf(showUnitIcon));
		RtsPortletUtil.setPreference("showUnitKind", String.valueOf(showUnitKind));
	}
	
	public boolean isShowUnitIcon()
	{
		return showUnitIcon;
	}

	public void setShowUnitIcon(boolean showUnitIcon)
	{
		this.showUnitIcon = showUnitIcon;
	}

	public boolean isShowUnitKind()
	{
		return showUnitKind;
	}

	public void setShowUnitKind(boolean showUnitKind)
	{
		this.showUnitKind = showUnitKind;
	}

	public ListDataModel getDataModel() {
		return dataModel;
	}

	public void setDataModel(ListDataModel dataModel) {
		this.dataModel = dataModel;
	}


}
