package de.proveo.rts.web.portlet.managedBeans.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.Map.Entry;

import javax.faces.event.ValueChangeEvent;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;

import de.proveo.rts.web.components.picklist.PicklistItem;
import de.proveo.rts.web.logicAccess.payloadData.CurrentDataAccess;
import de.proveo.rts.web.managedBeans.common.dataSelection.ReportSelectionDTOFactory;
import de.proveo.rts.web.portlet.managedBeans.base.ProveoPortletBase;
import de.proveo.rts.web.portlet.util.RtsPortletUtil;
import de.proveo.rts.web.util.RtsUtil;

public class GroupOperationBean extends ProveoPortletBase
{
	private ArrayList<Integer> statusModelList = new ArrayList<Integer>();

	private ListDataModel dataModel;

	private ArrayList<PicklistItem> availableStatusModelIds = new ArrayList<PicklistItem>();

	private ArrayList<PicklistItem> assignedStatusModelIds = new ArrayList<PicklistItem>();
	
	private HashMap<Integer, String> allStatusModelIds = new HashMap<Integer, String>(); 

	private boolean viewPosition;

	private boolean viewKeepAlive;

	private boolean showUnitKind;

	private boolean showUnitIcon;

	boolean selectedStateModelsChanged;

	public GroupOperationBean()
	{
		super();

		// Retrieve all status model ids
		SelectItem[] models = RtsPortletUtil.getSessionDataBean().getStatusModels();
		allStatusModelIds = new HashMap<Integer, String>(models.length);
		for (SelectItem si : models)
			allStatusModelIds.put((Integer)si.getValue(), si.getLabel());

		assignedStatusModelIds.clear();
		if (isInitialized())
		{
			// Retrieve assigned status model ids
			String[] ids = RtsPortletUtil.getPreferences("statusModelIds");
			if (ids != null)
				for (String id : ids)
					assignedStatusModelIds.add(new PicklistItem(id, allStatusModelIds.get(Integer.parseInt(id))));

			viewPosition = 
				Boolean.parseBoolean(RtsPortletUtil.getPreference("viewPosition", "false"));
			viewKeepAlive = 
				Boolean.parseBoolean(RtsPortletUtil.getPreference("viewKeepAlive", "false"));
			showUnitKind = 
				Boolean.parseBoolean(RtsPortletUtil.getPreference("showUnitKind", "false"));
			showUnitIcon = 
				Boolean.parseBoolean(RtsPortletUtil.getPreference("showUnitIcon", "false"));

			if(!RtsPortletUtil.isEditMode())
			{
				update();
			}
		}

		// Generate list with available status model ids
		availableStatusModelIds.clear();
		Set<Entry<Integer, String>> keySet = allStatusModelIds.entrySet();
		for (Entry<Integer, String> entry : keySet)
		{
			boolean found = false;
			String key = String.valueOf(entry.getKey());
			for (PicklistItem pi : assignedStatusModelIds)
				if (pi.getValue().equals(key))
				{
					found = true;
					break;
				}
			if (!found)
				availableStatusModelIds.add(new PicklistItem(String.valueOf(entry.getKey()), entry.getValue()));
		}
		Collections.sort(availableStatusModelIds);
	}

	public void update()
	{
		list = CurrentDataAccess.getCurrentAllData(
				ReportSelectionDTOFactory.buildUnitReportSelectionDTO(selectedUnitId, null, null, false));
		if (isDataAvailable())
		{
			// if (dto != null && statusModelIds != null) {

			unitSelectionString = list.getName();

			// Create ListDataModel for Columns
			statusModelList = new ArrayList<Integer>(assignedStatusModelIds.size());
			for (int i = 0; i < assignedStatusModelIds.size(); i++)
				statusModelList.add(Integer.parseInt(assignedStatusModelIds.get(i).getValue()));

			

			dataModel = new ListDataModel(list);
		}
	}

	public void selectionChanged(ValueChangeEvent event)
	{
		selectedStateModelsChanged = true;
	}

	public void save()
	{
		super.save();
		//if (selectedStateModelsChanged)	Not supported at this time
		{
			String[] assignedIds = new String[assignedStatusModelIds.size()];
			for (int i = 0; i < assignedStatusModelIds.size(); i++)
				assignedIds[i] = assignedStatusModelIds.get(i).getValue();
			RtsPortletUtil.setPreferences("statusModelIds", assignedIds);
		}

		RtsPortletUtil.setPreference("viewKeepAlive", String.valueOf(viewKeepAlive));
		RtsPortletUtil.setPreference("viewPosition", String.valueOf(viewPosition));
		RtsPortletUtil.setPreference("showUnitIcon", String.valueOf(showUnitIcon));
		RtsPortletUtil.setPreference("showUnitKind", String.valueOf(showUnitKind));
	}

	public ArrayList<PicklistItem> getAvailableStatusModelIds()
	{
		return availableStatusModelIds;
	}

	public void setAvailableStatusModelIds(ArrayList<PicklistItem> availableStatusModelIds)
	{
		this.availableStatusModelIds = availableStatusModelIds;
	}

	public ArrayList<PicklistItem> getAssignedStatusModelIds()
	{
		return assignedStatusModelIds;
	}

	public void setAssignedStatusModelIds(ArrayList<PicklistItem> assignedStatusModelIds)
	{
		this.assignedStatusModelIds = assignedStatusModelIds;
	}

	public boolean isViewKeepAlive()
	{
		return viewKeepAlive;
	}

	public void setViewKeepAlive(boolean viewKeepAlive)
	{
		this.viewKeepAlive = viewKeepAlive;
	}

	public boolean isViewPosition()
	{
		return viewPosition;
	}

	public void setViewPosition(boolean viewPosition)
	{
		this.viewPosition = viewPosition;
	}

	public void setDataModel(ListDataModel dataModel)
	{
		this.dataModel = dataModel;
	}

	public ListDataModel getDataModel()
	{
		return dataModel;
	}

	public boolean isShowUnitIcon()
	{
		return showUnitIcon;
	}

	public void setShowUnitIcon(boolean showUnitIcon)
	{
		this.showUnitIcon = showUnitIcon;
	}

	public boolean isShowUnitKind()
	{
		return showUnitKind;
	}

	public void setShowUnitKind(boolean showUnitKind)
	{
		this.showUnitKind = showUnitKind;
	}

	public ArrayList<Integer> getStatusModelList()
	{
		return statusModelList;
	}

	public void setStatusModelList(ArrayList<Integer> statusModelList)
	{
		this.statusModelList = statusModelList;
	}
}
