package de.proveo.rts.web.portlet.managedBeans.notification;

import javax.faces.model.ListDataModel;

import org.joda.time.Interval;

import de.proveo.rts.web.logicAccess.payloadData.HistoryDataAccess;
import de.proveo.rts.web.managedBeans.common.dataSelection.ReportSelectionDTOFactory;
import de.proveo.rts.web.portlet.managedBeans.base.ProveoPortletBase;
import de.proveo.rts.web.portlet.util.RtsPortletUtil;

public class UnitNotificationBean extends ProveoPortletBase
{
	Long messageId;
	ListDataModel dataModel;

	public ListDataModel getDataModel()
	{
		return dataModel;
	}

	public void setDataModel(ListDataModel dataModel)
	{
		this.dataModel = dataModel;
	}

	public UnitNotificationBean()
	{
		super();

		if (isInitialized())
		{
			messageId = Long.valueOf(RtsPortletUtil.getPreference("notificationId", "0"));
			if (messageId == 0)
				messageId = null;

			if(!RtsPortletUtil.isEditMode())
			{
				update();
			}
		}
	}

	public void update()
	{
		try
		{
			Interval interval = getSelectedInterval();

			list = HistoryDataAccess.getNotificationData(
					ReportSelectionDTOFactory.buildUnitReportSelectionDTO(selectedUnitId, interval.getStartMillis(), interval.getEndMillis(), false),
					messageId);

			if (isDataAvailable())
			{
				unitSelectionString = list.getName();
				dataModel = new ListDataModel(list);
			}

		}
		catch (Exception e)
		{
			errorOccured(e);
		}
	}

	public void save()
	{
		super.save();
		RtsPortletUtil.setPreference("messageId", String.valueOf(messageId));
	}

	public Long getMessageId()
	{
		return messageId;
	}

	public void setMessageId(Long messageId)
	{
		this.messageId = messageId;
	}
}
