package de.proveo.rts.web.portlet.managedBeans.common.dataTable.myfaces;

import javax.el.ValueExpression;
import javax.faces.component.UIComponent;


import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;

import de.proveo.rts.web.portlet.util.RtsPortletUtil;
import de.proveo.rts.web.util.RtsUtil;

public class SetMyFacesSortingHandler extends TagHandler
{
	private final TagAttribute tableId;
	private final TagAttribute columnName;
	private final TagAttribute sortAscending;

	public SetMyFacesSortingHandler(final TagConfig config)
	{
		super(config);
		/* Define var and valueBinding attributes. */
		this.tableId = this.getRequiredAttribute("tableId");
		this.sortAscending = this.getRequiredAttribute("sortAscending");
		this.columnName = this.getRequiredAttribute("columnName");
	}

	public void apply(final FaceletContext faceletsContext, final UIComponent parent)
	{
		Object value = columnName.getValueExpression(faceletsContext, Object.class).getValue(faceletsContext);
			
		if (value != null)
		{
			String tableId = this.tableId.getValue(faceletsContext);
			String columnName = this.columnName.getValue(faceletsContext);
			Boolean sortAscending = Boolean.parseBoolean(this.sortAscending.getValue(faceletsContext));
			
			((MyFacesSessionDataBean) RtsPortletUtil.getManagedBean("myFacesSessionData")).setSortColumn(tableId, columnName, sortAscending);
		}
	}	
}