package de.proveo.rts.web.portlet.managedBeans.base;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.Interval;

import de.proveo.rts.web.controller.SessionController.TimeSelectionMode;
import de.proveo.rts.web.i18n.LanguageUtil;
import de.proveo.rts.web.portlet.util.RtsPortletUtil;
import de.proveo.rts.web.util.RtsUtil;
import de.proveo.rts.web.util.time.TimeIntervalFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;

public abstract class ProveoPortletBase
{
	private static final Log log = LogFactory.getLog(ProveoPortletBase.class);
	
	protected Long selectedUnitId;

	protected DTOListBase<?> list;

	protected TimeSelectionMode mode;

	protected int offset;

	protected String unitSelectionString;
	
	protected boolean showPreview;

	public String getUnitSelectionString()
	{
		return RtsUtil.convertUnitString(unitSelectionString);
	}

	public ProveoPortletBase()
	{
		String unitId = RtsPortletUtil.getPreference("unitId", null);
		selectedUnitId = (unitId == null) ? null : Long.valueOf(unitId);
		
		if (isInitialized())
		{
			String modeStr = RtsPortletUtil.getPreference("mode", "");
			if (!modeStr.equals(""))
			{
				mode = TimeSelectionMode.valueOf(RtsPortletUtil.getPreference("mode", "").toUpperCase());
				offset = Integer.valueOf(RtsPortletUtil.getPreference("offset"));
			}
		}
		
		if (mode == null)
			mode = TimeSelectionMode.DAY;
	}

	public Interval getSelectedInterval()
	{
		return TimeIntervalFactory.getIntervalWithOffset(mode, offset);
	}

	public boolean isDataAvailable()
	{
		return !RtsUtil.isListEmpty(list);
	}

	public boolean isInitialized()
	{
		return selectedUnitId != null;
	}

	public abstract void update();

	public void save()
	{
		RtsPortletUtil.setPreference("unitId", String.valueOf(selectedUnitId));
		if (mode != null)
		{
			RtsPortletUtil.setPreference("mode", String.valueOf(mode));
			RtsPortletUtil.setPreference("offset", String.valueOf(offset));
		}
	}

	public String saveAction()
	{
		save();
		update();
		RtsPortletUtil.toViewMode();
		return RtsUtil.getNavigationOutcomeForManagedBean(this).concat("_view");
	}

	//not used at the moment
	public String backAction()
	{
		// update() causes conflicts when portlet is not configured
		// update();
		RtsPortletUtil.toViewMode();
		return RtsUtil.getNavigationOutcomeForManagedBean(this).concat("_view");
	}

	public String editAction()
	{
		RtsPortletUtil.toEditMode();
		return RtsUtil.getNavigationOutcomeForManagedBean(this).concat("_edit");
	}
	
	public String showPreviewAction()
	{
		showPreview = true;
		update();
		return RtsUtil.getNavigationOutcomeForManagedBean(this).concat("_edit");
	}

	public Long getSelectedUnitId()
	{
		return selectedUnitId;
	}

	public void setSelectedUnitId(Long selectedUnitId)
	{
		this.selectedUnitId = selectedUnitId;
	}

	public String getTimeSelection()
	{

		if (mode != null)
			return mode.name().concat("_").concat(String.valueOf(offset));
		else
			return null;
	}

	public void setTimeSelection(String timeSelection)
	{
		String[] selections = timeSelection.split("_");
		mode = TimeSelectionMode.valueOf(selections[0]);
		offset = Integer.parseInt(selections[1]);
	}

	public String getTimeSelectionString()
	{
		return LanguageUtil.getTimeSelectionName(mode, offset);
	}
	
	public void errorOccured(Exception e)
	{
		log.error("runs into", e);
	}

	public boolean isShowPreview()
	{
		return showPreview;
	}

	public void setShowPreview(boolean showPreview)
	{
		this.showPreview = showPreview;
	}
	
	public String getPortletName()
	{
		return RtsPortletUtil.getPortletName();
	}
}
