package de.proveo.rts.web.portlet.data;

import java.util.ArrayList;
import java.util.List;

import javax.faces.model.SelectItem;

import de.proveo.rts.web.config.RtsConfig;
import de.proveo.rts.web.controller.SessionController.TimeSelectionMode;
import de.proveo.rts.web.i18n.LanguageUtil;


public class PortletDataBean {

	List<SelectItem> timeSelections;

	List<SelectItem> chartWidths;

	List<SelectItem> chartEntryHeights;
	
	List<SelectItem> pieChartHeights;
	
	public List<SelectItem> getChartEntryHeights() {
		if (chartEntryHeights != null)
			return chartEntryHeights;

		String pixel = "pixel";

		chartEntryHeights = new ArrayList<SelectItem>();

		chartEntryHeights.add(new SelectItem(12, "12".concat(" ").concat(pixel)));

		chartEntryHeights.add(new SelectItem(15, "15".concat(" ").concat(pixel)));

		chartEntryHeights.add(new SelectItem(20, "20".concat(" ").concat(pixel)));

		chartEntryHeights.add(new SelectItem(25, "25".concat(" ").concat(pixel)));
		
		chartEntryHeights.add(new SelectItem(30, "30".concat(" ").concat(pixel)));
		
		chartEntryHeights.add(new SelectItem(35, "35".concat(" ").concat(pixel)));

		return chartEntryHeights;
	}

	public List<SelectItem> getTimeSelections() {

		if (timeSelections != null)
			return timeSelections;

		timeSelections = new ArrayList<SelectItem>();
		
		if(RtsConfig.configuration.application.debugMode)
			timeSelections.add(new SelectItem(TimeSelectionMode.MONTH.name()
				.concat("_").concat("-5"), "Testdaten (vor 5 Monaten) "));
		
		
		timeSelections.add(new SelectItem(TimeSelectionMode.DAY.name().concat(
				"_").concat("0"), LanguageUtil.getTimeSelectionName(
				TimeSelectionMode.DAY, 0)));

		timeSelections.add(new SelectItem(TimeSelectionMode.DAY.name().concat(
				"_").concat("-1"), LanguageUtil.getTimeSelectionName(
				TimeSelectionMode.DAY, -1)));

		timeSelections.add(new SelectItem(TimeSelectionMode.WEEK.name().concat(
				"_").concat("0"), LanguageUtil.getTimeSelectionName(
				TimeSelectionMode.WEEK, 0)));

		timeSelections.add(new SelectItem(TimeSelectionMode.WEEK.name().concat(
				"_").concat("-1"), LanguageUtil.getTimeSelectionName(
				TimeSelectionMode.WEEK, -1)));

		timeSelections.add(new SelectItem(TimeSelectionMode.MONTH.name()
				.concat("_").concat("0"), LanguageUtil.getTimeSelectionName(
				TimeSelectionMode.MONTH, 0)));

		timeSelections.add(new SelectItem(TimeSelectionMode.MONTH.name()
				.concat("_").concat("-1"), LanguageUtil.getTimeSelectionName(
				TimeSelectionMode.MONTH, -1)));

		
		return timeSelections;
	}

	public List<SelectItem> getChartWidths() {
		if (chartWidths != null)
			return chartWidths;

		String pixel = "pixel";

		chartWidths = new ArrayList<SelectItem>();

		chartWidths.add(new SelectItem(350, "350 " + pixel));
		
		chartWidths.add(new SelectItem(400, "400 " + pixel));

		chartWidths.add(new SelectItem(450, "450 " + pixel));
		
		chartWidths.add(new SelectItem(500, "500 " + pixel));

		chartWidths.add(new SelectItem(550, "550 " + pixel));

		chartWidths.add(new SelectItem(750, "750 " + pixel));

		return chartWidths;
	}
	
	public List<SelectItem> getPieChartHeights() {
		if (pieChartHeights != null)
			return pieChartHeights;

		String pixel = "pixel";

		pieChartHeights = new ArrayList<SelectItem>();

		pieChartHeights.add(new SelectItem(200, "200".concat(" ").concat(pixel)));
		
		pieChartHeights.add(new SelectItem(300, "300".concat(" ").concat(pixel)));
		
		pieChartHeights.add(new SelectItem(350, "350".concat(" ").concat(pixel)));

		pieChartHeights.add(new SelectItem(400, "400".concat(" ").concat(pixel)));
		
		pieChartHeights.add(new SelectItem(450, "450".concat(" ").concat(pixel)));

		pieChartHeights.add(new SelectItem(500, "500".concat(" ").concat(pixel)));
		
		pieChartHeights.add(new SelectItem(550, "550".concat(" ").concat(pixel)));

		return pieChartHeights;
	}

}
