/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import javax.jcr.RepositoryException;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.version.VersionManagerImpl;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.core.virtual.VirtualNodeState;
import org.apache.jackrabbit.core.virtual.VirtualPropertyState;
import org.apache.jackrabbit.name.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VersionItemStateProvider
implements VirtualItemStateProvider,
ItemStateListener {
    private static Logger log = LoggerFactory.getLogger((Class)VersionItemStateProvider.class);
    private final VersionManagerImpl vMgr;
    private final NodeId historyRootId;
    private final SharedItemStateManager stateMgr;
    private ReferenceMap items = new ReferenceMap(0, 2);

    public VersionItemStateProvider(VersionManagerImpl vMgr, SharedItemStateManager stateMgr) {
        this.vMgr = vMgr;
        this.stateMgr = stateMgr;
        this.historyRootId = vMgr.getHistoryRootId();
        stateMgr.addListener(this);
    }

    public boolean isVirtualRoot(ItemId id) {
        return id.equals(this.historyRootId);
    }

    public NodeId getVirtualRootId() {
        return this.historyRootId;
    }

    public VirtualPropertyState createPropertyState(VirtualNodeState parent, QName name, int type, boolean multiValued) throws RepositoryException {
        throw new IllegalStateException("VersionManager should never create a VirtualPropertyState");
    }

    public VirtualNodeState createNodeState(VirtualNodeState parent, QName name, NodeId id, QName nodeTypeName) throws RepositoryException {
        throw new IllegalStateException("VersionManager should never create a VirtualNodeState");
    }

    public synchronized ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemState item = (ItemState)this.items.get((Object)id);
        if (item == null) {
            item = this.stateMgr.getItemState(id);
            this.items.put((Object)id, (Object)item);
        }
        return item;
    }

    public boolean setNodeReferences(NodeReferences refs) {
        return this.vMgr.setNodeReferences(refs);
    }

    public boolean hasItemState(ItemId id) {
        return this.items.get((Object)id) != null || this.stateMgr.hasItemState(id);
    }

    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        return this.stateMgr.getNodeReferences(id);
    }

    public boolean hasNodeReferences(NodeReferencesId id) {
        return this.stateMgr.hasNodeReferences(id);
    }

    public void addListener(ItemStateListener listener) {
        this.stateMgr.addListener(listener);
    }

    public void removeListener(ItemStateListener listener) {
        this.stateMgr.removeListener(listener);
    }

    public void stateCreated(ItemState created) {
    }

    public void stateModified(ItemState modified) {
    }

    public void stateDestroyed(ItemState destroyed) {
        this.items.remove((Object)destroyed.getId());
    }

    public void stateDiscarded(ItemState discarded) {
        this.items.remove((Object)discarded.getId());
    }
}

