/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.jackrabbit.core.security.AnonymousPrincipal;
import org.apache.jackrabbit.core.security.CredentialsCallback;
import org.apache.jackrabbit.core.security.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLoginModule
implements LoginModule {
    private static Logger log = LoggerFactory.getLogger((Class)SimpleLoginModule.class);
    private static final String OPT_ANONYMOUS = "anonymousId";
    private static final String OPT_DEFAULT = "defaultUserId";
    private static final String DEFAULT_ANONYMOUS_ID = "anonymous";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private final Set principals = new HashSet();
    private String anonymousUserId = "anonymous";
    private String defaultUserId = null;

    public String getAnonymousId() {
        return this.anonymousUserId;
    }

    public void setAnonymousId(String anonymousId) {
        this.anonymousUserId = anonymousId;
    }

    public String getDefaultUserId() {
        return this.defaultUserId;
    }

    public void setDefaultUserId(String defaultUserId) {
        this.defaultUserId = defaultUserId;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        String userId = (String)options.get(OPT_ANONYMOUS);
        if (userId != null) {
            this.anonymousUserId = userId;
        }
        if (options.containsKey(OPT_DEFAULT)) {
            this.defaultUserId = (String)options.get(OPT_DEFAULT);
        }
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("no CallbackHandler available");
        }
        boolean authenticated = false;
        this.principals.clear();
        try {
            CredentialsCallback ccb = new CredentialsCallback();
            this.callbackHandler.handle(new Callback[]{ccb});
            Credentials creds = ccb.getCredentials();
            if (creds != null) {
                if (creds instanceof SimpleCredentials) {
                    SimpleCredentials sc = (SimpleCredentials)creds;
                    Object attr = sc.getAttribute("org.apache.jackrabbit.core.security.impersonator");
                    if (attr == null || attr instanceof Subject) {
                        // empty if block
                    }
                    if (this.anonymousUserId.equals(sc.getUserID())) {
                        this.principals.add(new AnonymousPrincipal());
                    } else {
                        this.principals.add(new UserPrincipal(sc.getUserID()));
                    }
                    authenticated = true;
                }
            } else if (this.defaultUserId != null) {
                this.principals.add(new UserPrincipal(this.defaultUserId));
                authenticated = true;
            } else {
                this.principals.add(new AnonymousPrincipal());
                authenticated = true;
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getCallback().toString() + " not available");
        }
        if (authenticated) {
            return !this.principals.isEmpty();
        }
        this.principals.clear();
        throw new FailedLoginException();
    }

    public boolean commit() throws LoginException {
        if (this.principals.isEmpty()) {
            return false;
        }
        this.subject.getPrincipals().addAll(this.principals);
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.principals.isEmpty()) {
            return false;
        }
        this.logout();
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        return true;
    }
}

