/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;

class WildcardTermEnum
extends FilteredTermEnum {
    private final Matcher pattern;
    private final String field;
    private final String prefix;
    private boolean endEnum = false;
    private final OffsetCharSequence input;

    public WildcardTermEnum(IndexReader reader, String field, String propName, String pattern) throws IOException {
        int idx;
        this.field = field;
        for (idx = 0; idx < pattern.length() && Character.isLetterOrDigit(pattern.charAt(idx)); ++idx) {
        }
        this.prefix = propName == null ? pattern.substring(0, idx) : FieldNames.createNamedValue(propName, pattern.substring(0, idx));
        this.input = new OffsetCharSequence(this.prefix.length(), this.prefix);
        this.pattern = this.createRegexp(pattern.substring(idx)).matcher(this.input);
        this.setEnum(reader.terms(new Term(field, this.prefix)));
    }

    protected boolean termCompare(Term term) {
        if (term.field() == this.field && term.text().startsWith(this.prefix)) {
            this.input.setBase(term.text());
            return this.pattern.reset().matches();
        }
        this.endEnum = true;
        return false;
    }

    protected float difference() {
        return 1.0f;
    }

    protected boolean endEnum() {
        return this.endEnum;
    }

    private Pattern createRegexp(String likePattern) {
        StringBuffer regexp = new StringBuffer();
        boolean escaped = false;
        block4: for (int i = 0; i < likePattern.length(); ++i) {
            if (likePattern.charAt(i) == '\\') {
                if (escaped) {
                    regexp.append("\\\\");
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (Character.isLetterOrDigit(likePattern.charAt(i))) {
                if (escaped) {
                    regexp.append("\\\\").append(likePattern.charAt(i));
                    escaped = false;
                    continue;
                }
                regexp.append(likePattern.charAt(i));
                continue;
            }
            if (escaped) {
                regexp.append('\\').append(likePattern.charAt(i));
                escaped = false;
                continue;
            }
            switch (likePattern.charAt(i)) {
                case '_': {
                    regexp.append('.');
                    continue block4;
                }
                case '%': {
                    regexp.append(".*");
                    continue block4;
                }
                default: {
                    regexp.append('\\').append(likePattern.charAt(i));
                }
            }
        }
        return Pattern.compile(regexp.toString(), 32);
    }

    private static final class OffsetCharSequence
    implements CharSequence {
        private final int offset;
        private CharSequence base;

        OffsetCharSequence(int offset, CharSequence base) {
            this.offset = offset;
            this.base = base;
        }

        public void setBase(CharSequence base) {
            this.base = base;
        }

        public int length() {
            return this.base.length() - this.offset;
        }

        public char charAt(int index) {
            return this.base.charAt(index + this.offset);
        }

        public CharSequence subSequence(int start, int end) {
            return this.base.subSequence(start + this.offset, end + this.offset);
        }

        public String toString() {
            return ((Object)this.base.subSequence(this.offset, this.base.length())).toString();
        }
    }
}

