/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.AbstractIndex;
import org.apache.jackrabbit.core.query.lucene.DocNumberCache;
import org.apache.jackrabbit.core.query.lucene.FSDirectory;
import org.apache.jackrabbit.core.query.lucene.IndexListener;
import org.apache.jackrabbit.core.query.lucene.ReadOnlyIndexReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PersistentIndex
extends AbstractIndex {
    private static final Logger log = LoggerFactory.getLogger((Class)PersistentIndex.class);
    private static final String WRITE_LOCK = "write.lock";
    private static final String COMMIT_LOCK = "commit.lock";
    private final String name;
    private boolean lockEncountered = false;
    private IndexListener listener;

    PersistentIndex(String name, File indexDir, boolean create, Analyzer analyzer, DocNumberCache cache) throws IOException {
        super(analyzer, FSDirectory.getDirectory(indexDir, create), cache);
        File commitLock;
        this.name = name;
        File writeLock = new File(indexDir, WRITE_LOCK);
        if (writeLock.exists()) {
            this.lockEncountered = true;
            log.warn("Removing write lock on search index.");
            if (!writeLock.delete()) {
                log.error("Unable to remove write lock on search index.");
            }
        }
        if ((commitLock = new File(indexDir, COMMIT_LOCK)).exists()) {
            this.lockEncountered = true;
            log.warn("Removing commit lock on search index.");
            if (!commitLock.delete()) {
                log.error("Unable to remove write lock on search index.");
            }
        }
    }

    int removeDocument(Term idTerm) throws IOException {
        int num = super.removeDocument(idTerm);
        if (num > 0 && this.listener != null) {
            this.listener.documentDeleted(idTerm);
        }
        return num;
    }

    boolean getLockEncountered() {
        return this.lockEncountered;
    }

    void mergeIndex(AbstractIndex index) throws IOException {
        index.commit();
        this.getIndexWriter().addIndexes(new Directory[]{index.getDirectory()});
        this.invalidateSharedReader();
    }

    void addIndexes(IndexReader[] readers) throws IOException {
        this.getIndexWriter().addIndexes(readers);
        this.getIndexWriter().optimize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyIndex(AbstractIndex index) throws IOException {
        index.commit(true);
        byte[] buffer = new byte[1024];
        Directory dir = index.getDirectory();
        Directory dest = this.getDirectory();
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            InputStream in = dir.openFile(files[i]);
            try {
                OutputStream out = dest.createFile(files[i]);
                try {
                    int num;
                    for (long remaining = in.length(); remaining > 0L; remaining -= (long)num) {
                        num = (int)Math.min(remaining, (long)buffer.length);
                        in.readBytes(buffer, 0, num);
                        out.writeBytes(buffer, num);
                    }
                    continue;
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
    }

    synchronized ReadOnlyIndexReader getReadOnlyIndexReader(IndexListener listener) throws IOException {
        ReadOnlyIndexReader reader = this.getReadOnlyIndexReader();
        this.listener = listener;
        return reader;
    }

    synchronized void resetListener() {
        this.listener = null;
    }

    int getNumDocuments() throws IOException {
        return this.getIndexReader().numDocs();
    }

    String getName() {
        return this.name;
    }
}

