/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.MatchAllScorer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

class MatchAllWeight
implements Weight {
    private final Query query;
    private final String field;
    private final Searcher searcher;
    private float value;
    private float idf;
    private float queryWeight;

    MatchAllWeight(Query query, Searcher searcher, String field) {
        this.query = query;
        this.searcher = searcher;
        this.field = field;
    }

    public Query getQuery() {
        return this.query;
    }

    public float getValue() {
        return this.value;
    }

    public float sumOfSquaredWeights() throws IOException {
        this.idf = this.searcher.getSimilarity().idf(this.searcher.maxDoc(), this.searcher.maxDoc());
        this.queryWeight = this.idf * 1.0f;
        return this.queryWeight * this.queryWeight;
    }

    public void normalize(float queryNorm) {
        this.queryWeight *= queryNorm;
        this.value = this.queryWeight * this.idf;
    }

    public Scorer scorer(IndexReader reader) throws IOException {
        return new MatchAllScorer(reader, this, this.field);
    }

    public Explanation explain(IndexReader reader, int doc) throws IOException {
        return new Explanation(Similarity.getDefault().idf(reader.maxDoc(), reader.maxDoc()), "matchAll");
    }
}

