/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype.compact;

import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.core.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.core.nodetype.ItemDef;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropDefImpl;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.nodetype.compact.Lexer;
import org.apache.jackrabbit.core.nodetype.compact.ParseException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;
import org.apache.jackrabbit.util.name.NamespaceMapping;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.apache.jackrabbit.value.ValueHelper;

public class CompactNodeTypeDefReader {
    private List nodeTypeDefs = new LinkedList();
    private NamespaceMapping nsMapping;
    private Lexer lexer;
    private String currentToken;

    public CompactNodeTypeDefReader(Reader r, String systemId) throws ParseException {
        this(r, systemId, new NamespaceMapping());
    }

    public CompactNodeTypeDefReader(Reader r, String systemId, NamespaceMapping mapping) throws ParseException {
        this.lexer = new Lexer(r, systemId);
        this.nsMapping = mapping;
        this.nextToken();
        this.parse();
    }

    public List getNodeTypeDefs() {
        return this.nodeTypeDefs;
    }

    public NamespaceMapping getNamespaceMapping() {
        return this.nsMapping;
    }

    private void parse() throws ParseException {
        while (!this.currentTokenEquals("eof") && this.doNameSpace()) {
        }
        while (!this.currentTokenEquals("eof")) {
            NodeTypeDef ntd = new NodeTypeDef();
            ntd.setOrderableChildNodes(false);
            ntd.setMixin(false);
            ntd.setPrimaryItemName(null);
            this.doNodeTypeName(ntd);
            this.doSuperTypes(ntd);
            this.doOptions(ntd);
            this.doItemDefs(ntd);
            this.nodeTypeDefs.add(ntd);
        }
    }

    private boolean doNameSpace() throws ParseException {
        if (!this.currentTokenEquals('<')) {
            return false;
        }
        this.nextToken();
        String prefix = this.currentToken;
        this.nextToken();
        if (!this.currentTokenEquals('=')) {
            this.lexer.fail("Missing = in namespace decl.");
        }
        this.nextToken();
        String uri = this.currentToken;
        this.nextToken();
        if (!this.currentTokenEquals('>')) {
            this.lexer.fail("Missing > in namespace decl.");
        }
        try {
            this.nsMapping.setMapping(prefix, uri);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        this.nextToken();
        return true;
    }

    private void doNodeTypeName(NodeTypeDef ntd) throws ParseException {
        if (!this.currentTokenEquals('[')) {
            this.lexer.fail("Missing '[' delimiter for beginning of node type name");
        }
        this.nextToken();
        ntd.setName(this.toQName(this.currentToken));
        this.nextToken();
        if (!this.currentTokenEquals(']')) {
            this.lexer.fail("Missing ']' delimiter for end of node type name, found " + this.currentToken);
        }
        this.nextToken();
    }

    private void doSuperTypes(NodeTypeDef ntd) throws ParseException {
        ArrayList<QName> supertypes = new ArrayList<QName>();
        if (!this.currentTokenEquals('>')) {
            return;
        }
        do {
            this.nextToken();
            supertypes.add(this.toQName(this.currentToken));
            this.nextToken();
        } while (this.currentTokenEquals(','));
        ntd.setSupertypes(supertypes.toArray(new QName[0]));
    }

    private void doOptions(NodeTypeDef ntd) throws ParseException {
        if (this.currentTokenEquals(Lexer.ORDERABLE)) {
            ntd.setOrderableChildNodes(true);
            this.nextToken();
            if (this.currentTokenEquals(Lexer.MIXIN)) {
                ntd.setMixin(true);
                this.nextToken();
            }
        } else if (this.currentTokenEquals(Lexer.MIXIN)) {
            ntd.setMixin(true);
            this.nextToken();
            if (this.currentTokenEquals(Lexer.ORDERABLE)) {
                ntd.setMixin(true);
                this.nextToken();
            }
        }
    }

    private void doItemDefs(NodeTypeDef ntd) throws ParseException {
        ArrayList<PropDefImpl> propertyDefinitions = new ArrayList<PropDefImpl>();
        ArrayList<NodeDefImpl> nodeDefinitions = new ArrayList<NodeDefImpl>();
        while (this.currentTokenEquals('-') || this.currentTokenEquals('+')) {
            if (this.currentTokenEquals('-')) {
                PropDefImpl pdi = new PropDefImpl();
                pdi.setAutoCreated(false);
                pdi.setDeclaringNodeType(ntd.getName());
                pdi.setDefaultValues(null);
                pdi.setMandatory(false);
                pdi.setMultiple(false);
                pdi.setOnParentVersion(1);
                pdi.setProtected(false);
                pdi.setRequiredType(1);
                pdi.setValueConstraints(null);
                this.nextToken();
                this.doPropertyDefinition(pdi, ntd);
                propertyDefinitions.add(pdi);
                continue;
            }
            if (!this.currentTokenEquals('+')) continue;
            NodeDefImpl ndi = new NodeDefImpl();
            ndi.setAllowsSameNameSiblings(false);
            ndi.setAutoCreated(false);
            ndi.setDeclaringNodeType(ntd.getName());
            ndi.setMandatory(false);
            ndi.setOnParentVersion(1);
            ndi.setProtected(false);
            ndi.setDefaultPrimaryType(null);
            ndi.setRequiredPrimaryTypes(new QName[]{QName.NT_BASE});
            this.nextToken();
            this.doChildNodeDefinition(ndi, ntd);
            nodeDefinitions.add(ndi);
        }
        if (propertyDefinitions.size() > 0) {
            ntd.setPropertyDefs(propertyDefinitions.toArray(new PropDef[0]));
        }
        if (nodeDefinitions.size() > 0) {
            ntd.setChildNodeDefs(nodeDefinitions.toArray(new NodeDef[0]));
        }
    }

    private void doPropertyDefinition(PropDefImpl pdi, NodeTypeDef ntd) throws ParseException {
        if (this.currentToken.equals("*")) {
            pdi.setName(ItemDef.ANY_NAME);
        } else {
            pdi.setName(this.toQName(this.currentToken));
        }
        this.nextToken();
        this.doPropertyType(pdi);
        this.doPropertyDefaultValue(pdi);
        this.doPropertyAttributes(pdi, ntd);
        this.doPropertyValueConstraints(pdi);
    }

    private void doPropertyType(PropDefImpl pdi) throws ParseException {
        if (!this.currentTokenEquals('(')) {
            return;
        }
        this.nextToken();
        if (this.currentTokenEquals(Lexer.STRING)) {
            pdi.setRequiredType(1);
        } else if (this.currentTokenEquals(Lexer.BINARY)) {
            pdi.setRequiredType(2);
        } else if (this.currentTokenEquals(Lexer.LONG)) {
            pdi.setRequiredType(3);
        } else if (this.currentTokenEquals(Lexer.DOUBLE)) {
            pdi.setRequiredType(4);
        } else if (this.currentTokenEquals(Lexer.BOOLEAN)) {
            pdi.setRequiredType(6);
        } else if (this.currentTokenEquals(Lexer.DATE)) {
            pdi.setRequiredType(5);
        } else if (this.currentTokenEquals(Lexer.NAME)) {
            pdi.setRequiredType(7);
        } else if (this.currentTokenEquals(Lexer.PATH)) {
            pdi.setRequiredType(8);
        } else if (this.currentTokenEquals(Lexer.REFERENCE)) {
            pdi.setRequiredType(9);
        } else if (this.currentTokenEquals(Lexer.UNDEFINED)) {
            pdi.setRequiredType(0);
        } else {
            this.lexer.fail("Unkown property type '" + this.currentToken + "' specified");
        }
        this.nextToken();
        if (!this.currentTokenEquals(')')) {
            this.lexer.fail("Missing ')' delimiter for end of property type");
        }
        this.nextToken();
    }

    private void doPropertyAttributes(PropDefImpl pdi, NodeTypeDef ntd) throws ParseException {
        while (this.currentTokenEquals(Lexer.ATTRIBUTE)) {
            if (this.currentTokenEquals(Lexer.PRIMARY)) {
                if (ntd.getPrimaryItemName() != null) {
                    String name = null;
                    try {
                        name = NameFormat.format(ntd.getName(), (NamespaceResolver)this.nsMapping);
                    }
                    catch (NoPrefixDeclaredException e) {
                        // empty catch block
                    }
                    this.lexer.fail("More than one primary item specified in node type '" + name + "'");
                }
                ntd.setPrimaryItemName(pdi.getName());
            } else if (this.currentTokenEquals(Lexer.AUTOCREATED)) {
                pdi.setAutoCreated(true);
            } else if (this.currentTokenEquals(Lexer.MANDATORY)) {
                pdi.setMandatory(true);
            } else if (this.currentTokenEquals(Lexer.PROTECTED)) {
                pdi.setProtected(true);
            } else if (this.currentTokenEquals(Lexer.MULTIPLE)) {
                pdi.setMultiple(true);
            } else if (this.currentTokenEquals(Lexer.COPY)) {
                pdi.setOnParentVersion(1);
            } else if (this.currentTokenEquals(Lexer.VERSION)) {
                pdi.setOnParentVersion(2);
            } else if (this.currentTokenEquals(Lexer.INITIALIZE)) {
                pdi.setOnParentVersion(3);
            } else if (this.currentTokenEquals(Lexer.COMPUTE)) {
                pdi.setOnParentVersion(4);
            } else if (this.currentTokenEquals(Lexer.IGNORE)) {
                pdi.setOnParentVersion(5);
            } else if (this.currentTokenEquals(Lexer.ABORT)) {
                pdi.setOnParentVersion(6);
            }
            this.nextToken();
        }
    }

    private void doPropertyDefaultValue(PropDefImpl pdi) throws ParseException {
        if (!this.currentTokenEquals('=')) {
            return;
        }
        ArrayList<InternalValue> defaultValues = new ArrayList<InternalValue>();
        do {
            this.nextToken();
            InternalValue value = null;
            try {
                value = InternalValue.create(ValueHelper.convert(this.currentToken, pdi.getRequiredType(), ValueFactoryImpl.getInstance()), this.nsMapping);
            }
            catch (ValueFormatException e) {
                this.lexer.fail("'" + this.currentToken + "' is not a valid string representation of a value of type " + pdi.getRequiredType());
            }
            catch (RepositoryException e) {
                this.lexer.fail("An error occured during value conversion of '" + this.currentToken + "'");
            }
            defaultValues.add(value);
            this.nextToken();
        } while (this.currentTokenEquals(','));
        pdi.setDefaultValues(defaultValues.toArray(new InternalValue[0]));
    }

    private void doPropertyValueConstraints(PropDefImpl pdi) throws ParseException {
        if (!this.currentTokenEquals('<')) {
            return;
        }
        ArrayList<ValueConstraint> constraints = new ArrayList<ValueConstraint>();
        do {
            this.nextToken();
            ValueConstraint constraint = null;
            try {
                constraint = ValueConstraint.create(pdi.getRequiredType(), this.currentToken, this.nsMapping);
            }
            catch (InvalidConstraintException e) {
                this.lexer.fail("'" + this.currentToken + "' is not a valid constraint expression for a value of type " + pdi.getRequiredType());
            }
            constraints.add(constraint);
            this.nextToken();
        } while (this.currentTokenEquals(','));
        pdi.setValueConstraints(constraints.toArray(new ValueConstraint[0]));
    }

    private void doChildNodeDefinition(NodeDefImpl ndi, NodeTypeDef ntd) throws ParseException {
        if (this.currentTokenEquals('*')) {
            ndi.setName(ItemDef.ANY_NAME);
        } else {
            ndi.setName(this.toQName(this.currentToken));
        }
        this.nextToken();
        this.doChildNodeRequiredTypes(ndi);
        this.doChildNodeDefaultType(ndi);
        this.doChildNodeAttributes(ndi, ntd);
    }

    private void doChildNodeRequiredTypes(NodeDefImpl ndi) throws ParseException {
        if (!this.currentTokenEquals('(')) {
            return;
        }
        ArrayList<QName> types = new ArrayList<QName>();
        do {
            this.nextToken();
            types.add(this.toQName(this.currentToken));
            this.nextToken();
        } while (this.currentTokenEquals(','));
        ndi.setRequiredPrimaryTypes(types.toArray(new QName[0]));
        this.nextToken();
    }

    private void doChildNodeDefaultType(NodeDefImpl ndi) throws ParseException {
        if (!this.currentTokenEquals('=')) {
            return;
        }
        this.nextToken();
        ndi.setDefaultPrimaryType(this.toQName(this.currentToken));
        this.nextToken();
    }

    private void doChildNodeAttributes(NodeDefImpl ndi, NodeTypeDef ntd) throws ParseException {
        while (this.currentTokenEquals(Lexer.ATTRIBUTE)) {
            if (this.currentTokenEquals(Lexer.PRIMARY)) {
                if (ntd.getPrimaryItemName() != null) {
                    String name = null;
                    try {
                        name = NameFormat.format(ntd.getName(), (NamespaceResolver)this.nsMapping);
                    }
                    catch (NoPrefixDeclaredException e) {
                        // empty catch block
                    }
                    this.lexer.fail("More than one primary item specified in node type '" + name + "'");
                }
                ntd.setPrimaryItemName(ndi.getName());
            } else if (this.currentTokenEquals(Lexer.AUTOCREATED)) {
                ndi.setAutoCreated(true);
            } else if (this.currentTokenEquals(Lexer.MANDATORY)) {
                ndi.setMandatory(true);
            } else if (this.currentTokenEquals(Lexer.PROTECTED)) {
                ndi.setProtected(true);
            } else if (this.currentTokenEquals(Lexer.MULTIPLE)) {
                ndi.setAllowsSameNameSiblings(true);
            } else if (this.currentTokenEquals(Lexer.COPY)) {
                ndi.setOnParentVersion(1);
            } else if (this.currentTokenEquals(Lexer.VERSION)) {
                ndi.setOnParentVersion(2);
            } else if (this.currentTokenEquals(Lexer.INITIALIZE)) {
                ndi.setOnParentVersion(3);
            } else if (this.currentTokenEquals(Lexer.COMPUTE)) {
                ndi.setOnParentVersion(4);
            } else if (this.currentTokenEquals(Lexer.IGNORE)) {
                ndi.setOnParentVersion(5);
            } else if (this.currentTokenEquals(Lexer.ABORT)) {
                ndi.setOnParentVersion(6);
            }
            this.nextToken();
        }
    }

    private QName toQName(String stringName) throws ParseException {
        try {
            return NameFormat.parse(stringName, (NamespaceResolver)this.nsMapping);
        }
        catch (IllegalNameException e) {
            this.lexer.fail("Error while parsing '" + stringName + "'", e);
            return null;
        }
        catch (UnknownPrefixException e) {
            this.lexer.fail("Error while parsing '" + stringName + "'", e);
            return null;
        }
    }

    private void nextToken() throws ParseException {
        this.currentToken = this.lexer.getNextToken();
    }

    private boolean currentTokenEquals(String[] s) {
        for (int i = 0; i < s.length; ++i) {
            if (!this.currentToken.equals(s[i])) continue;
            return true;
        }
        return false;
    }

    private boolean currentTokenEquals(char c) {
        return this.currentToken.length() == 1 && this.currentToken.charAt(0) == c;
    }

    private boolean currentTokenEquals(String s) {
        return this.currentToken.equals(s);
    }
}

