/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemPathUtil;
import org.apache.jackrabbit.core.fs.RandomAccessOutputStream;
import org.apache.jackrabbit.core.fs.db.DbFileSystem;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleFileSystem
extends DbFileSystem {
    private static Logger log = LoggerFactory.getLogger((Class)OracleFileSystem.class);
    private Class blobClass;
    private Integer DURATION_SESSION_CONSTANT;
    private Integer MODE_READWRITE_CONSTANT;

    public OracleFileSystem() {
        this.schema = "oracle";
        this.driver = "oracle.jdbc.OracleDriver";
        this.schemaObjectPrefix = "";
        this.user = "";
        this.password = "";
        this.initialized = false;
    }

    public void init() throws FileSystemException {
        super.init();
        try {
            this.blobClass = this.con.getClass().getClassLoader().loadClass("oracle.sql.BLOB");
            this.DURATION_SESSION_CONSTANT = new Integer(this.blobClass.getField("DURATION_SESSION").getInt(null));
            this.MODE_READWRITE_CONSTANT = new Integer(this.blobClass.getField("MODE_READWRITE").getInt(null));
        }
        catch (Exception e) {
            String msg = "failed to load/introspect oracle.sql.BLOB";
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
    }

    protected List initPreparedStatements() throws SQLException {
        LinkedList<PreparedStatement> stmts = new LinkedList<PreparedStatement>();
        this.insertFileStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "values (?, ?, ?, ?, ?)");
        stmts.add(this.insertFileStmt);
        this.insertFolderStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "values (?, nvl(?, ' '), ?, null)");
        stmts.add(this.insertFolderStmt);
        this.updateDataStmt = this.con.prepareStatement("update " + this.schemaObjectPrefix + "FSENTRY " + "set FSENTRY_DATA = ?, FSENTRY_LASTMOD = ?, FSENTRY_LENGTH = ? " + "where FSENTRY_PATH = ? and FSENTRY_NAME = ? " + "and FSENTRY_LENGTH is not null");
        stmts.add(this.updateDataStmt);
        this.updateLastModifiedStmt = this.con.prepareStatement("update " + this.schemaObjectPrefix + "FSENTRY set FSENTRY_LASTMOD = ? " + "where FSENTRY_PATH = ? and FSENTRY_NAME = ? " + "and FSENTRY_LENGTH is not null");
        stmts.add(this.updateLastModifiedStmt);
        this.selectExistStmt = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = nvl(?, ' ')");
        stmts.add(this.selectExistStmt);
        this.selectFileExistStmt = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_LENGTH is not null");
        stmts.add(this.selectFileExistStmt);
        this.selectFolderExistStmt = this.con.prepareStatement("select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = nvl(?, ' ') and FSENTRY_LENGTH is null");
        stmts.add(this.selectFolderExistStmt);
        this.selectFileNamesStmt = this.con.prepareStatement("select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_LENGTH is not null");
        stmts.add(this.selectFileNamesStmt);
        this.selectFolderNamesStmt = this.con.prepareStatement("select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME != ' ' " + "and FSENTRY_LENGTH is null");
        stmts.add(this.selectFolderNamesStmt);
        this.selectFileAndFolderNamesStmt = this.con.prepareStatement("select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME != ' '");
        stmts.add(this.selectFileAndFolderNamesStmt);
        this.selectChildCountStmt = this.con.prepareStatement("select count(FSENTRY_NAME) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ?  " + "and FSENTRY_NAME != ' '");
        stmts.add(this.selectChildCountStmt);
        this.selectDataStmt = this.con.prepareStatement("select nvl(FSENTRY_DATA, empty_blob()) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_LENGTH is not null");
        stmts.add(this.selectDataStmt);
        this.selectLastModifiedStmt = this.con.prepareStatement("select FSENTRY_LASTMOD from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = nvl(?, ' ')");
        stmts.add(this.selectLastModifiedStmt);
        this.selectLengthStmt = this.con.prepareStatement("select nvl(FSENTRY_LENGTH, 0) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_LENGTH is not null");
        stmts.add(this.selectLengthStmt);
        this.deleteFileStmt = this.con.prepareStatement("delete from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_LENGTH is not null");
        stmts.add(this.deleteFileStmt);
        this.deleteFolderStmt = this.con.prepareStatement("delete from " + this.schemaObjectPrefix + "FSENTRY where " + "(FSENTRY_PATH = ? and FSENTRY_NAME = nvl(?, ' ') and FSENTRY_LENGTH is null) " + "or (FSENTRY_PATH = ?) " + "or (FSENTRY_PATH like ?) ");
        stmts.add(this.deleteFolderStmt);
        this.copyFileStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "select ?, ?, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_LENGTH is not null");
        stmts.add(this.copyFileStmt);
        this.copyFilesStmt = this.con.prepareStatement("insert into " + this.schemaObjectPrefix + "FSENTRY " + "(FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "select ?, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? " + "and FSENTRY_LENGTH is not null");
        stmts.add(this.copyFilesStmt);
        return stmts;
    }

    public OutputStream getOutputStream(final String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        final String parentDir = FileSystemPathUtil.getParentDir(filePath);
        final String name = FileSystemPathUtil.getName(filePath);
        if (!this.isFolder(parentDir)) {
            throw new FileSystemException("path not found: " + parentDir);
        }
        if (this.isFolder(filePath)) {
            throw new FileSystemException("path denotes folder: " + filePath);
        }
        try {
            TransientFileFactory fileFactory = TransientFileFactory.getInstance();
            final File tmpFile = fileFactory.createTransientFile("bin", null, null);
            return new FilterOutputStream(new FileOutputStream(tmpFile)){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    Blob blob;
                    InputStream in;
                    block22: {
                        super.close();
                        PreparedStatement stmt = null;
                        in = null;
                        blob = null;
                        try {
                            if (OracleFileSystem.this.isFile(filePath)) {
                                PreparedStatement preparedStatement = stmt = OracleFileSystem.this.updateDataStmt;
                                synchronized (preparedStatement) {
                                    long length = tmpFile.length();
                                    in = new FileInputStream(tmpFile);
                                    blob = OracleFileSystem.this.createTemporaryBlob(in);
                                    stmt.setBlob(1, blob);
                                    stmt.setLong(2, System.currentTimeMillis());
                                    stmt.setLong(3, length);
                                    stmt.setString(4, parentDir);
                                    stmt.setString(5, name);
                                    stmt.executeUpdate();
                                }
                            } else {
                                stmt = OracleFileSystem.this.insertFileStmt;
                                stmt.setString(1, parentDir);
                                stmt.setString(2, name);
                                long length = tmpFile.length();
                                in = new FileInputStream(tmpFile);
                                blob = OracleFileSystem.this.createTemporaryBlob(in);
                                stmt.setBlob(3, blob);
                                stmt.setLong(4, System.currentTimeMillis());
                                stmt.setLong(5, length);
                                stmt.executeUpdate();
                            }
                            if (stmt == null) break block22;
                        }
                        catch (Exception e) {
                            try {
                                throw new IOException(e.getMessage());
                            }
                            catch (Throwable throwable) {
                                if (stmt != null) {
                                    OracleFileSystem.this.resetStatement(stmt);
                                }
                                if (blob != null) {
                                    try {
                                        OracleFileSystem.this.freeTemporaryBlob(blob);
                                    }
                                    catch (Exception e1) {
                                        // empty catch block
                                    }
                                }
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Exception e1) {
                                        // empty catch block
                                    }
                                }
                                tmpFile.delete();
                                throw throwable;
                            }
                        }
                        OracleFileSystem.this.resetStatement(stmt);
                    }
                    if (blob != null) {
                        try {
                            OracleFileSystem.this.freeTemporaryBlob(blob);
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    tmpFile.delete();
                }
            };
        }
        catch (Exception e) {
            String msg = "failed to open output stream to file: " + filePath;
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessOutputStream getRandomAccessOutputStream(final String filePath) throws FileSystemException, UnsupportedOperationException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        final String parentDir = FileSystemPathUtil.getParentDir(filePath);
        final String name = FileSystemPathUtil.getName(filePath);
        if (!this.isFolder(parentDir)) {
            throw new FileSystemException("path not found: " + parentDir);
        }
        if (this.isFolder(filePath)) {
            throw new FileSystemException("path denotes folder: " + filePath);
        }
        try {
            TransientFileFactory fileFactory = TransientFileFactory.getInstance();
            final File tmpFile = fileFactory.createTransientFile("bin", null, null);
            if (this.isFile(filePath)) {
                InputStream in = this.getInputStream(filePath);
                FileOutputStream out = new FileOutputStream(tmpFile);
                try {
                    int read;
                    byte[] ba = new byte[8192];
                    while ((read = in.read(ba, 0, ba.length)) != -1) {
                        ((OutputStream)out).write(ba, 0, read);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                    in.close();
                }
            }
            return new RandomAccessOutputStream(){
                private final RandomAccessFile raf;
                {
                    this.raf = new RandomAccessFile(tmpFile, "rw");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    Blob blob;
                    InputStream in;
                    block22: {
                        this.raf.close();
                        PreparedStatement stmt = null;
                        in = null;
                        blob = null;
                        try {
                            if (OracleFileSystem.this.isFile(filePath)) {
                                PreparedStatement preparedStatement = stmt = OracleFileSystem.this.updateDataStmt;
                                synchronized (preparedStatement) {
                                    long length = tmpFile.length();
                                    in = new FileInputStream(tmpFile);
                                    blob = OracleFileSystem.this.createTemporaryBlob(in);
                                    stmt.setBlob(1, blob);
                                    stmt.setLong(2, System.currentTimeMillis());
                                    stmt.setLong(3, length);
                                    stmt.setString(4, parentDir);
                                    stmt.setString(5, name);
                                    stmt.executeUpdate();
                                }
                            } else {
                                stmt = OracleFileSystem.this.insertFileStmt;
                                stmt.setString(1, parentDir);
                                stmt.setString(2, name);
                                long length = tmpFile.length();
                                in = new FileInputStream(tmpFile);
                                blob = OracleFileSystem.this.createTemporaryBlob(in);
                                stmt.setBlob(3, blob);
                                stmt.setLong(4, System.currentTimeMillis());
                                stmt.setLong(5, length);
                                stmt.executeUpdate();
                            }
                            if (stmt == null) break block22;
                        }
                        catch (Exception e) {
                            try {
                                throw new IOException(e.getMessage());
                            }
                            catch (Throwable throwable) {
                                if (stmt != null) {
                                    OracleFileSystem.this.resetStatement(stmt);
                                }
                                if (blob != null) {
                                    try {
                                        OracleFileSystem.this.freeTemporaryBlob(blob);
                                    }
                                    catch (Exception e1) {
                                        // empty catch block
                                    }
                                }
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Exception e1) {
                                        // empty catch block
                                    }
                                }
                                tmpFile.delete();
                                throw throwable;
                            }
                        }
                        OracleFileSystem.this.resetStatement(stmt);
                    }
                    if (blob != null) {
                        try {
                            OracleFileSystem.this.freeTemporaryBlob(blob);
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    tmpFile.delete();
                }

                public void seek(long position) throws IOException {
                    this.raf.seek(position);
                }

                public void write(int b) throws IOException {
                    this.raf.write(b);
                }

                public void flush() {
                }

                public void write(byte[] b) throws IOException {
                    this.raf.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    this.raf.write(b, off, len);
                }
            };
        }
        catch (Exception e) {
            String msg = "failed to open output stream to file: " + filePath;
            log.error(msg, (Throwable)e);
            throw new FileSystemException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Blob createTemporaryBlob(InputStream in) throws Exception {
        Method createTemporary = this.blobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
        Object blob = createTemporary.invoke(null, this.con, Boolean.FALSE, this.DURATION_SESSION_CONSTANT);
        Method open = this.blobClass.getMethod("open", Integer.TYPE);
        open.invoke(blob, this.MODE_READWRITE_CONSTANT);
        Method getBinaryOutputStream = this.blobClass.getMethod("getBinaryOutputStream", new Class[0]);
        OutputStream out = (OutputStream)getBinaryOutputStream.invoke(blob, null);
        try {
            int read;
            byte[] buf = new byte[8192];
            while ((read = in.read(buf, 0, buf.length)) > -1) {
                out.write(buf, 0, read);
            }
        }
        finally {
            try {
                out.flush();
            }
            catch (IOException ioe) {}
            out.close();
        }
        Method close = this.blobClass.getMethod("close", new Class[0]);
        close.invoke(blob, null);
        return (Blob)blob;
    }

    protected void freeTemporaryBlob(Object blob) throws Exception {
        Method freeTemporary = this.blobClass.getMethod("freeTemporary", new Class[0]);
        freeTemporary.invoke(blob, null);
    }
}

