/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import javax.security.auth.Subject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.LocalNamespaceMappings;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.config.AccessManagerConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.AuthContext;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.core.version.VersionManager;
import org.apache.jackrabbit.core.xml.DocViewSAXEventGenerator;
import org.apache.jackrabbit.core.xml.ImportHandler;
import org.apache.jackrabbit.core.xml.SessionImporter;
import org.apache.jackrabbit.core.xml.SysViewSAXEventGenerator;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.PathFormat;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SessionImpl
implements Session,
Dumpable {
    private static Logger log = LoggerFactory.getLogger((Class)SessionImpl.class);
    public static final String READ_ACTION = "read";
    public static final String REMOVE_ACTION = "remove";
    public static final String ADD_NODE_ACTION = "add_node";
    public static final String SET_PROPERTY_ACTION = "set_property";
    protected boolean alive = true;
    protected final RepositoryImpl rep;
    protected AuthContext loginContext;
    protected final Subject subject;
    protected final String userId;
    protected final HashMap attributes = new HashMap();
    protected final NodeTypeManagerImpl ntMgr;
    protected AccessManager accessMgr;
    protected final SessionItemStateManager itemStateMgr;
    protected final HierarchyManager hierMgr;
    protected final ItemManager itemMgr;
    protected final WorkspaceImpl wsp;
    protected final LocalNamespaceMappings nsMappings;
    protected final VersionManager versionMgr;
    protected final Map listeners = new ReferenceMap(2, 2);
    protected final Set lockTokens = new HashSet();
    protected ValueFactory valueFactory;

    protected SessionImpl(RepositoryImpl rep, AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        this(rep, loginContext.getSubject(), wspConfig);
        this.loginContext = loginContext;
    }

    protected SessionImpl(RepositoryImpl rep, Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        this.rep = rep;
        Set<Principal> principals = subject.getPrincipals();
        if (principals.isEmpty()) {
            String msg = "unable to instantiate Session: no principals found";
            log.error(msg);
            throw new RepositoryException(msg);
        }
        Principal principal = principals.iterator().next();
        this.userId = principal.getName();
        this.subject = subject;
        this.nsMappings = new LocalNamespaceMappings(rep.getNamespaceRegistry());
        this.ntMgr = new NodeTypeManagerImpl(rep.getNodeTypeRegistry(), rep.getNamespaceRegistry(), this.getNamespaceResolver());
        String wspName = wspConfig.getName();
        this.wsp = this.createWorkspaceInstance(wspConfig, rep.getWorkspaceStateManager(wspName), rep, this);
        this.itemStateMgr = this.createSessionItemStateManager(this.wsp.getItemStateManager());
        this.hierMgr = this.itemStateMgr.getHierarchyMgr();
        this.itemMgr = this.createItemManager(this.itemStateMgr, this.hierMgr);
        this.accessMgr = this.createAccessManager(subject, this.hierMgr);
        this.versionMgr = this.createVersionManager(rep);
    }

    protected SessionItemStateManager createSessionItemStateManager(LocalItemStateManager manager) {
        return new SessionItemStateManager(this.rep.getRootNodeId(), manager, this.getNamespaceResolver());
    }

    protected WorkspaceImpl createWorkspaceInstance(WorkspaceConfig wspConfig, SharedItemStateManager stateMgr, RepositoryImpl rep, SessionImpl session) {
        return new WorkspaceImpl(wspConfig, stateMgr, rep, session);
    }

    protected ItemManager createItemManager(SessionItemStateManager itemStateMgr, HierarchyManager hierMgr) {
        return new ItemManager(itemStateMgr, hierMgr, this, this.ntMgr.getRootNodeDefinition(), this.rep.getRootNodeId());
    }

    protected VersionManager createVersionManager(RepositoryImpl rep) throws RepositoryException {
        return rep.getVersionManager();
    }

    protected AccessManager createAccessManager(Subject subject, HierarchyManager hierMgr) throws AccessDeniedException, RepositoryException {
        AccessManagerConfig amConfig = this.rep.getConfig().getAccessManagerConfig();
        try {
            AMContext ctx = new AMContext(new File(this.rep.getConfig().getHomeDir()), this.rep.getFileSystem(), subject, hierMgr, this.wsp.getName());
            AccessManager accessMgr = (AccessManager)amConfig.newInstance();
            accessMgr.init(ctx);
            return accessMgr;
        }
        catch (AccessDeniedException ade) {
            throw ade;
        }
        catch (Exception e) {
            String msg = "failed to instantiate AccessManager implementation: " + amConfig.getClassName();
            log.error(msg, (Throwable)e);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    protected void sanityCheck() throws RepositoryException {
        if (!this.alive) {
            throw new RepositoryException("this session has been closed");
        }
    }

    protected Subject getSubject() {
        return this.subject;
    }

    public AccessManager getAccessManager() {
        return this.accessMgr;
    }

    public NodeTypeManagerImpl getNodeTypeManager() {
        return this.ntMgr;
    }

    public ItemManager getItemManager() {
        return this.itemMgr;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.nsMappings;
    }

    protected SessionItemStateManager getItemStateManager() {
        return this.itemStateMgr;
    }

    public HierarchyManager getHierarchyManager() {
        return this.hierMgr;
    }

    public VersionManager getVersionManager() {
        return this.versionMgr;
    }

    public Node getNodeByUUID(UUID uuid) throws ItemNotFoundException, RepositoryException {
        NodeImpl node = this.getNodeById(new NodeId(uuid));
        if (node.isNodeType(QName.MIX_REFERENCEABLE)) {
            return node;
        }
        throw new ItemNotFoundException(uuid.toString());
    }

    public NodeImpl getNodeById(NodeId id) throws ItemNotFoundException, RepositoryException {
        this.sanityCheck();
        try {
            return (NodeImpl)this.getItemManager().getItem(id);
        }
        catch (AccessDeniedException ade) {
            throw new ItemNotFoundException(id.toString());
        }
    }

    protected String[] getWorkspaceNames() throws RepositoryException {
        ArrayList<String> list = new ArrayList<String>();
        String[] names = this.rep.getWorkspaceNames();
        for (int i = 0; i < names.length; ++i) {
            try {
                if (!this.getAccessManager().canAccess(names[i])) continue;
                list.add(names[i]);
                continue;
            }
            catch (NoSuchWorkspaceException nswe) {
                // empty catch block
            }
        }
        return list.toArray(new String[list.size()]);
    }

    protected void createWorkspace(String workspaceName) throws AccessDeniedException, RepositoryException {
        this.rep.createWorkspace(workspaceName);
    }

    protected void createWorkspace(String workspaceName, InputSource configTemplate) throws AccessDeniedException, RepositoryException {
        this.rep.createWorkspace(workspaceName, configTemplate);
    }

    protected void notifyLoggingOut() {
        SessionListener[] la = new SessionListener[this.listeners.size()];
        Iterator iter = this.listeners.values().iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            la[cnt++] = (SessionListener)iter.next();
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].loggingOut(this);
        }
    }

    protected void notifyLoggedOut() {
        SessionListener[] la = new SessionListener[this.listeners.size()];
        Iterator iter = this.listeners.values().iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            la[cnt++] = (SessionListener)iter.next();
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].loggedOut(this);
        }
    }

    public void addListener(SessionListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    public void removeListener(SessionListener listener) {
        this.listeners.remove(listener);
    }

    public void checkPermission(String absPath, String actions) throws AccessControlException, RepositoryException {
        Path targetPath;
        this.sanityCheck();
        String[] strings = actions.split(",");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < strings.length; ++i) {
            set.add(strings[i]);
        }
        try {
            targetPath = PathFormat.parse(absPath, this.getNamespaceResolver()).getNormalizedPath();
        }
        catch (MalformedPathException mpe) {
            String msg = "invalid path: " + absPath;
            log.debug(msg, (Throwable)mpe);
            throw new RepositoryException(msg);
        }
        if (!targetPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + absPath);
        }
        ItemId targetId = null;
        if (set.contains(READ_ACTION)) {
            try {
                targetId = this.hierMgr.resolvePath(targetPath);
                this.accessMgr.checkPermission(targetId, 1);
            }
            catch (PathNotFoundException pnfe) {
                throw new AccessControlException(READ_ACTION);
            }
            catch (AccessDeniedException re) {
                throw new AccessControlException(READ_ACTION);
            }
        }
        Path parentPath = null;
        ItemId parentId = null;
        if (set.contains(ADD_NODE_ACTION)) {
            try {
                parentPath = targetPath.getAncestor(1);
                parentId = this.hierMgr.resolvePath(parentPath);
                this.accessMgr.checkPermission(parentId, 2);
            }
            catch (PathNotFoundException pnfe) {
                throw new AccessControlException(ADD_NODE_ACTION);
            }
            catch (AccessDeniedException re) {
                throw new AccessControlException(ADD_NODE_ACTION);
            }
        }
        if (set.contains(REMOVE_ACTION)) {
            try {
                if (targetId == null) {
                    targetId = this.hierMgr.resolvePath(targetPath);
                }
                this.accessMgr.checkPermission(targetId, 4);
            }
            catch (PathNotFoundException pnfe) {
                throw new AccessControlException(REMOVE_ACTION);
            }
            catch (AccessDeniedException re) {
                throw new AccessControlException(REMOVE_ACTION);
            }
        }
        if (set.contains(SET_PROPERTY_ACTION)) {
            try {
                if (targetId == null) {
                    try {
                        targetId = this.hierMgr.resolvePath(targetPath);
                        this.accessMgr.checkPermission(targetId, 2);
                    }
                    catch (PathNotFoundException pnfe) {
                        if (parentPath == null) {
                            parentPath = targetPath.getAncestor(1);
                        }
                        if (parentId == null) {
                            parentId = this.hierMgr.resolvePath(parentPath);
                        }
                        this.accessMgr.checkPermission(parentId, 2);
                    }
                }
            }
            catch (PathNotFoundException pnfe) {
                throw new AccessControlException(SET_PROPERTY_ACTION);
            }
            catch (AccessDeniedException re) {
                throw new AccessControlException(SET_PROPERTY_ACTION);
            }
        }
    }

    public Workspace getWorkspace() {
        return this.wsp;
    }

    public Session impersonate(Credentials otherCredentials) throws LoginException, RepositoryException {
        this.sanityCheck();
        if (!(otherCredentials instanceof SimpleCredentials)) {
            String msg = "impersonate failed: incompatible credentials, SimpleCredentials expected";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        SimpleCredentials creds = (SimpleCredentials)otherCredentials;
        creds.setAttribute("org.apache.jackrabbit.core.security.impersonator", (Object)this.subject);
        try {
            Session session = this.rep.login(otherCredentials, this.getWorkspace().getName());
            return session;
        }
        catch (NoSuchWorkspaceException nswe) {
            String msg = "impersonate failed";
            log.error(msg, (Throwable)nswe);
            throw new RepositoryException(msg, (Throwable)nswe);
        }
        finally {
            creds.removeAttribute("org.apache.jackrabbit.core.security.impersonator");
        }
    }

    public Node getRootNode() throws RepositoryException {
        this.sanityCheck();
        return this.getItemManager().getRootNode();
    }

    public Node getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        try {
            return this.getNodeByUUID(UUID.fromString(uuid));
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException("Invalid UUID: " + uuid, (Throwable)e);
        }
    }

    public Item getItem(String absPath) throws PathNotFoundException, RepositoryException {
        this.sanityCheck();
        try {
            Path p = PathFormat.parse(absPath, this.getNamespaceResolver()).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + absPath);
            }
            return this.getItemManager().getItem(p);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(absPath);
        }
        catch (MalformedPathException mpe) {
            String msg = "invalid path:" + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        this.sanityCheck();
        try {
            Path p = PathFormat.parse(absPath, this.getNamespaceResolver()).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + absPath);
            }
            return this.getItemManager().itemExists(p);
        }
        catch (MalformedPathException mpe) {
            String msg = "invalid path:" + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.sanityCheck();
        this.getItemManager().getRootNode().save();
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        this.sanityCheck();
        if (!keepChanges) {
            this.itemStateMgr.disposeAllTransientItemStates();
            return;
        }
        this.getItemManager().getRootNode().refresh(keepChanges);
    }

    public boolean hasPendingChanges() throws RepositoryException {
        this.sanityCheck();
        return this.itemStateMgr.hasAnyTransientItemStates();
    }

    public void move(String srcAbsPath, String destAbsPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        NodeDefinitionImpl newTargetDef;
        NodeImpl destParentNode;
        Path.PathElement destName;
        Path destPath;
        NodeImpl srcParentNode;
        NodeImpl targetNode;
        Path.PathElement srcName;
        Path srcPath;
        this.sanityCheck();
        try {
            srcPath = PathFormat.parse(srcAbsPath, this.getNamespaceResolver()).getNormalizedPath();
            if (!srcPath.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + srcAbsPath);
            }
            srcName = srcPath.getNameElement();
            Path srcParentPath = srcPath.getAncestor(1);
            ItemImpl item = this.getItemManager().getItem(srcPath);
            if (!item.isNode()) {
                throw new PathNotFoundException(srcAbsPath);
            }
            targetNode = (NodeImpl)item;
            srcParentNode = (NodeImpl)this.getItemManager().getItem(srcParentPath);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(srcAbsPath);
        }
        catch (MalformedPathException mpe) {
            String msg = srcAbsPath + ": invalid path";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
        try {
            destPath = PathFormat.parse(destAbsPath, this.getNamespaceResolver()).getNormalizedPath();
            if (!destPath.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + destAbsPath);
            }
            if (srcPath.isAncestorOf(destPath)) {
                String msg = destAbsPath + ": invalid destination path (cannot be descendant of source path)";
                log.debug(msg);
                throw new RepositoryException(msg);
            }
            destName = destPath.getNameElement();
            Path destParentPath = destPath.getAncestor(1);
            destParentNode = (NodeImpl)this.getItemManager().getItem(destParentPath);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(destAbsPath);
        }
        catch (MalformedPathException mpe) {
            String msg = destAbsPath + ": invalid path";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
        int ind = destName.getIndex();
        if (ind > 0) {
            String msg = destAbsPath + ": invalid destination path (subscript in name element is not allowed)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        if (!srcParentNode.internalIsCheckedOut()) {
            String msg = srcAbsPath + ": cannot move a child of a checked-in node";
            log.debug(msg);
            throw new VersionException(msg);
        }
        if (!destParentNode.internalIsCheckedOut()) {
            String msg = destAbsPath + ": cannot move a target to a checked-in node";
            log.debug(msg);
            throw new VersionException(msg);
        }
        ItemImpl existing = null;
        try {
            existing = this.getItemManager().getItem(destPath);
            if (!existing.isNode()) {
                throw new ItemExistsException(existing.safeGetJCRPath());
            }
            if (!((NodeImpl)existing).getDefinition().allowsSameNameSiblings()) {
                throw new ItemExistsException(existing.safeGetJCRPath());
            }
        }
        catch (AccessDeniedException ade) {
            throw new ItemExistsException(destAbsPath);
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        NodeTypeImpl nt = (NodeTypeImpl)targetNode.getPrimaryNodeType();
        try {
            newTargetDef = destParentNode.getApplicableChildNodeDefinition(destName.getName(), nt.getQName());
        }
        catch (RepositoryException re) {
            String msg = destAbsPath + ": no definition found in parent node's node type for new node";
            log.debug(msg);
            throw new ConstraintViolationException(msg, (Throwable)re);
        }
        if (existing != null && !newTargetDef.allowsSameNameSiblings()) {
            throw new ItemExistsException(existing.safeGetJCRPath());
        }
        if (destParentNode.getDefinition().isProtected()) {
            String msg = destAbsPath + ": cannot add a child node to a protected node";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        if (srcParentNode.getDefinition().isProtected()) {
            String msg = srcAbsPath + ": cannot remove a child node from a protected node";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        srcParentNode.checkLock();
        destParentNode.checkLock();
        NodeId targetId = targetNode.getNodeId();
        int index = srcName.getIndex();
        if (index == 0) {
            index = 1;
        }
        if (srcParentNode.isSame(destParentNode)) {
            destParentNode.renameChildNode(srcName.getName(), index, targetId, destName.getName());
        } else {
            NodeState srcParentState = (NodeState)srcParentNode.getOrCreateTransientItemState();
            srcParentState.removeChildNodeEntry(srcName.getName(), index);
            NodeState targetState = (NodeState)targetNode.getOrCreateTransientItemState();
            targetState.setParentId(destParentNode.getNodeId());
            NodeState destParentState = (NodeState)destParentNode.getOrCreateTransientItemState();
            destParentState.addChildNodeEntry(destName.getName(), targetId);
        }
        targetNode.onRedefine(newTargetDef.unwrap().getId());
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        ItemImpl item;
        this.sanityCheck();
        try {
            Path p = PathFormat.parse(parentAbsPath, this.getNamespaceResolver()).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException("not an absolute path: " + parentAbsPath);
            }
            item = this.getItemManager().getItem(p);
        }
        catch (MalformedPathException mpe) {
            String msg = parentAbsPath + ": invalid path";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(parentAbsPath);
        }
        if (!item.isNode()) {
            throw new PathNotFoundException(parentAbsPath);
        }
        NodeImpl parent = (NodeImpl)item;
        if (!parent.internalIsCheckedOut()) {
            String msg = parentAbsPath + ": cannot add a child to a checked-in node";
            log.debug(msg);
            throw new VersionException(msg);
        }
        if (parent.getDefinition().isProtected()) {
            String msg = parentAbsPath + ": cannot add a child to a protected node";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        parent.checkLock();
        SessionImporter importer = new SessionImporter(parent, this, uuidBehavior);
        return new ImportHandler(importer, this.getNamespaceResolver(), this.rep.getNamespaceRegistry());
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, VersionException, InvalidSerializedDataException, LockException, RepositoryException {
        this.sanityCheck();
        ImportHandler handler = (ImportHandler)this.getImportContentHandler(parentAbsPath, uuidBehavior);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(in), (DefaultHandler)handler);
        }
        catch (SAXException se) {
            Exception e = se.getException();
            if (e != null && e instanceof RepositoryException) {
                throw (RepositoryException)((Object)e);
            }
            String msg = "failed to parse XML stream";
            log.debug(msg);
            throw new InvalidSerializedDataException(msg, (Throwable)se);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException("SAX parser configuration error", (Throwable)e);
        }
    }

    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        this.sanityCheck();
        Item item = this.getItem(absPath);
        if (!item.isNode()) {
            throw new PathNotFoundException(absPath);
        }
        new DocViewSAXEventGenerator((Node)item, noRecurse, skipBinary, contentHandler).serialize();
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        SAXTransformerFactory stf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            TransformerHandler th = stf.newTransformerHandler();
            th.setResult(new StreamResult(out));
            th.getTransformer().setParameter("method", "xml");
            th.getTransformer().setParameter("encoding", "UTF-8");
            th.getTransformer().setParameter("indent", "no");
            this.exportDocumentView(absPath, th, skipBinary, noRecurse);
        }
        catch (TransformerException te) {
            throw new RepositoryException((Throwable)te);
        }
        catch (SAXException se) {
            throw new RepositoryException((Throwable)se);
        }
    }

    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        this.sanityCheck();
        Item item = this.getItem(absPath);
        if (!item.isNode()) {
            throw new PathNotFoundException(absPath);
        }
        new SysViewSAXEventGenerator((Node)item, noRecurse, skipBinary, contentHandler).serialize();
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        SAXTransformerFactory stf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            TransformerHandler th = stf.newTransformerHandler();
            th.setResult(new StreamResult(out));
            th.getTransformer().setParameter("method", "xml");
            th.getTransformer().setParameter("encoding", "UTF-8");
            th.getTransformer().setParameter("indent", "no");
            this.exportSystemView(absPath, th, skipBinary, noRecurse);
        }
        catch (TransformerException te) {
            throw new RepositoryException((Throwable)te);
        }
        catch (SAXException se) {
            throw new RepositoryException((Throwable)se);
        }
    }

    public boolean isLive() {
        return this.alive;
    }

    public synchronized void logout() {
        if (!this.alive) {
            return;
        }
        this.itemStateMgr.disposeAllTransientItemStates();
        this.notifyLoggingOut();
        this.nsMappings.dispose();
        this.itemStateMgr.dispose();
        this.itemMgr.dispose();
        this.wsp.dispose();
        this.alive = false;
        if (this.loginContext != null) {
            try {
                this.loginContext.logout();
            }
            catch (javax.security.auth.login.LoginException le) {
                log.warn("failed to logout current subject: " + le.getMessage());
            }
            this.loginContext = null;
        }
        try {
            this.accessMgr.close();
        }
        catch (Exception e) {
            log.warn("error while closing AccessManager", (Throwable)e);
        }
        this.notifyLoggedOut();
    }

    public Repository getRepository() {
        return this.rep;
    }

    public ValueFactory getValueFactory() throws UnsupportedRepositoryOperationException, RepositoryException {
        if (this.valueFactory == null) {
            this.valueFactory = ValueFactoryImpl.getInstance();
        }
        return this.valueFactory;
    }

    public String getUserID() {
        return this.userId;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public void setNamespacePrefix(String prefix, String uri) throws NamespaceException, RepositoryException {
        this.nsMappings.setNamespacePrefix(prefix, uri);
    }

    public String[] getNamespacePrefixes() throws NamespaceException, RepositoryException {
        return this.nsMappings.getPrefixes();
    }

    public String getNamespaceURI(String prefix) throws NamespaceException, RepositoryException {
        return this.nsMappings.getURI(prefix);
    }

    public String getNamespacePrefix(String uri) throws NamespaceException, RepositoryException {
        return this.nsMappings.getPrefix(uri);
    }

    public void addLockToken(String lt) {
        this.addLockToken(lt, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLockToken(String lt, boolean notify) {
        Set set = this.lockTokens;
        synchronized (set) {
            if (this.lockTokens.add(lt) && notify) {
                try {
                    this.getLockManager().lockTokenAdded(this, lt);
                }
                catch (RepositoryException e) {
                    log.error("Lock manager not available.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLockTokens() {
        Set set = this.lockTokens;
        synchronized (set) {
            String[] result = new String[this.lockTokens.size()];
            this.lockTokens.toArray(result);
            return result;
        }
    }

    public void removeLockToken(String lt) {
        this.removeLockToken(lt, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLockToken(String lt, boolean notify) {
        Set set = this.lockTokens;
        synchronized (set) {
            if (this.lockTokens.remove(lt) && notify) {
                try {
                    this.getLockManager().lockTokenRemoved(this, lt);
                }
                catch (RepositoryException e) {
                    log.error("Lock manager not available.", (Throwable)e);
                }
            }
        }
    }

    public LockManager getLockManager() throws RepositoryException {
        return this.wsp.getLockManager();
    }

    public void dump(PrintStream ps) {
        ps.print("Session: ");
        if (this.userId == null) {
            ps.print("unknown");
        } else {
            ps.print(this.userId);
        }
        ps.println(" (" + this + ")");
        ps.println();
        this.itemMgr.dump(ps);
        ps.println();
        this.itemStateMgr.dump(ps);
    }
}

