/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.security.auth.Subject;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.SearchManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.SystemSession;
import org.apache.jackrabbit.core.TransactionException;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.XASessionImpl;
import org.apache.jackrabbit.core.config.FileSystemConfig;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.config.PersistenceManagerConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.fs.BasedFileSystem;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.virtual.VirtualNodeTypeStateManager;
import org.apache.jackrabbit.core.observation.DelegatingObservationDispatcher;
import org.apache.jackrabbit.core.observation.ObservationDispatcher;
import org.apache.jackrabbit.core.security.AuthContext;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.PMContext;
import org.apache.jackrabbit.core.state.PersistenceManager;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.version.VersionManager;
import org.apache.jackrabbit.core.version.VersionManagerImpl;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class RepositoryImpl
implements JackrabbitRepository,
SessionListener,
EventListener {
    private static Logger log = LoggerFactory.getLogger((Class)RepositoryImpl.class);
    private static final String REPOSITORY_LOCK = ".lock";
    public static final NodeId ROOT_NODE_ID = NodeId.valueOf("cafebabe-cafe-babe-cafe-babecafebabe");
    public static final NodeId SYSTEM_ROOT_NODE_ID = NodeId.valueOf("deadbeef-cafe-babe-cafe-babecafebabe");
    public static final NodeId VERSION_STORAGE_NODE_ID = NodeId.valueOf("deadbeef-face-babe-cafe-babecafebabe");
    public static final NodeId NODETYPES_NODE_ID = NodeId.valueOf("deadbeef-cafe-cafe-cafe-babecafebabe");
    private static final String PROPERTIES_RESOURCE = "rep.properties";
    private final Properties repProps;
    public static final String STATS_NODE_COUNT_PROPERTY = "jcr.repository.stats.nodes.count";
    public static final String STATS_PROP_COUNT_PROPERTY = "jcr.repository.stats.properties.count";
    private NodeId rootNodeId;
    private final NamespaceRegistryImpl nsReg;
    private final NodeTypeRegistry ntReg;
    private final VersionManager vMgr;
    private final VirtualNodeTypeStateManager virtNTMgr;
    private SearchManager systemSearchMgr;
    protected final RepositoryConfig repConfig;
    private final FileSystem repStore;
    private final FileSystem metaDataStore;
    private final DelegatingObservationDispatcher delegatingDispatcher = new DelegatingObservationDispatcher();
    private final HashMap wspInfos = new HashMap();
    private final ReferenceMap activeSessions = new ReferenceMap(2, 2);
    private long nodesCount = 0L;
    private long propsCount = 0L;
    private boolean disposed = false;
    private FileLock repLock;
    private final ReadWriteLock shutdownLock = new WriterPreferenceReadWriteLock();

    protected RepositoryImpl(RepositoryConfig repConfig) throws RepositoryException {
        log.info("Starting repository...");
        this.repConfig = repConfig;
        this.acquireRepositoryLock();
        this.repStore = repConfig.getFileSystemConfig().createFileSystem();
        String fsRootPath = "/meta";
        try {
            if (!this.repStore.exists(fsRootPath) || !this.repStore.isFolder(fsRootPath)) {
                this.repStore.createFolder(fsRootPath);
            }
        }
        catch (FileSystemException fse) {
            String msg = "failed to create folder for repository meta data";
            log.error(msg, (Throwable)fse);
            throw new RepositoryException(msg, (Throwable)fse);
        }
        this.metaDataStore = new BasedFileSystem(this.repStore, fsRootPath);
        this.rootNodeId = this.loadRootNodeId(this.metaDataStore);
        this.repProps = this.loadRepProps();
        this.nodesCount = Long.parseLong(this.repProps.getProperty(STATS_NODE_COUNT_PROPERTY, "0"));
        this.propsCount = Long.parseLong(this.repProps.getProperty(STATS_PROP_COUNT_PROPERTY, "0"));
        this.nsReg = this.createNamespaceRegistry(new BasedFileSystem(this.repStore, "/namespaces"));
        this.ntReg = this.createNodeTypeRegistry(this.nsReg, new BasedFileSystem(this.repStore, "/nodetypes"));
        Iterator iter = repConfig.getWorkspaceConfigs().iterator();
        while (iter.hasNext()) {
            WorkspaceConfig config = (WorkspaceConfig)iter.next();
            WorkspaceInfo info = this.createWorkspaceInfo(config);
            this.wspInfos.put(config.getName(), info);
        }
        this.vMgr = this.createVersionManager(repConfig.getVersioningConfig(), this.delegatingDispatcher);
        this.virtNTMgr = new VirtualNodeTypeStateManager(this.getNodeTypeRegistry(), this.delegatingDispatcher, NODETYPES_NODE_ID, SYSTEM_ROOT_NODE_ID);
        String wspName = repConfig.getDefaultWorkspaceName();
        try {
            this.initWorkspace((WorkspaceInfo)this.wspInfos.get(wspName));
        }
        catch (RepositoryException e) {
            log.error("Failed to initialize workspace '" + wspName + "'", (Throwable)e);
            log.error("Unable to start repository, forcing shutdown...");
            this.shutdown();
            throw e;
        }
        this.getSystemSearchManager(wspName);
        int maxIdleTime = repConfig.getWorkspaceMaxIdleTime();
        if (maxIdleTime != 0) {
            Thread wspJanitor = new Thread(new WorkspaceJanitor(maxIdleTime * 1000));
            wspJanitor.setName("WorkspaceJanitor");
            wspJanitor.setPriority(1);
            wspJanitor.setDaemon(true);
            wspJanitor.start();
        }
        this.virtNTMgr.setSession(this.getSystemSession(repConfig.getDefaultWorkspaceName()));
        log.info("Repository started");
    }

    protected VersionManager createVersionManager(VersioningConfig vConfig, DelegatingObservationDispatcher delegatingDispatcher) throws RepositoryException {
        FileSystem fs = vConfig.getFileSystemConfig().createFileSystem();
        PersistenceManager pm = RepositoryImpl.createPersistenceManager(vConfig.getHomeDir(), fs, vConfig.getPersistenceManagerConfig(), this.rootNodeId, this.nsReg, this.ntReg);
        return new VersionManagerImpl(pm, fs, this.ntReg, delegatingDispatcher, VERSION_STORAGE_NODE_ID, SYSTEM_ROOT_NODE_ID);
    }

    protected void acquireRepositoryLock() throws RepositoryException {
        File home = new File(this.repConfig.getHomeDir());
        File lock = new File(home, REPOSITORY_LOCK);
        if (lock.exists()) {
            log.warn("Existing lock file at " + lock.getAbsolutePath() + " detected. Repository was not shut down properly.");
        } else {
            try {
                lock.createNewFile();
            }
            catch (IOException e) {
                throw new RepositoryException("Unable to create lock file at " + lock.getAbsolutePath(), (Throwable)e);
            }
        }
        try {
            this.repLock = new RandomAccessFile(lock, "rw").getChannel().tryLock();
        }
        catch (IOException e) {
            throw new RepositoryException("Unable to lock file at " + lock.getAbsolutePath(), (Throwable)e);
        }
        if (this.repLock == null) {
            throw new RepositoryException("The repository home at " + home.getAbsolutePath() + " appears to be in use since the file at " + lock.getAbsolutePath() + " is locked by another process.");
        }
    }

    protected void releaseRepositoryLock() {
        if (this.repLock != null) {
            try {
                FileChannel channel = this.repLock.channel();
                this.repLock.release();
                channel.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.repLock = null;
        File home = new File(this.repConfig.getHomeDir());
        File lock = new File(home, REPOSITORY_LOCK);
        if (!lock.delete()) {
            log.error("Unable to release repository lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeId loadRootNodeId(FileSystem fs) throws RepositoryException {
        FileSystemResource uuidFile = new FileSystemResource(fs, "rootUUID");
        try {
            if (uuidFile.exists()) {
                try {
                    InputStream in = uuidFile.getInputStream();
                    char[] chars = new char[36];
                    InputStreamReader reader = new InputStreamReader(in);
                    try {
                        reader.read(chars);
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (IOException ioe) {}
                    }
                    return NodeId.valueOf(new String(chars));
                }
                catch (Exception e) {
                    String msg = "failed to load persisted repository state";
                    log.debug(msg);
                    throw new RepositoryException(msg, (Throwable)e);
                }
            }
            try {
                OutputStream out = uuidFile.getOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(out);
                try {
                    writer.write(ROOT_NODE_ID.toString());
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (IOException ioe) {}
                }
                return ROOT_NODE_ID;
            }
            catch (Exception e) {
                String msg = "failed to persist repository state";
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)e);
            }
        }
        catch (FileSystemException fse) {
            String msg = "failed to access repository state";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)fse);
        }
    }

    protected NamespaceRegistryImpl createNamespaceRegistry(FileSystem fs) throws RepositoryException {
        return new NamespaceRegistryImpl(fs);
    }

    protected NodeTypeRegistry createNodeTypeRegistry(NamespaceRegistry nsReg, FileSystem fs) throws RepositoryException {
        return NodeTypeRegistry.create(nsReg, fs);
    }

    public static RepositoryImpl create(RepositoryConfig config) throws RepositoryException {
        return new RepositoryImpl(config);
    }

    protected void sanityCheck() throws IllegalStateException {
        if (this.disposed) {
            throw new IllegalStateException("repository instance has been shut down");
        }
    }

    private void initWorkspace(WorkspaceInfo wspInfo) throws RepositoryException {
        if (!wspInfo.initialize()) {
            return;
        }
        SystemSession sysSession = wspInfo.getSystemSession();
        WorkspaceImpl wsp = (WorkspaceImpl)sysSession.getWorkspace();
        wsp.getObservationManager().addEventListener((EventListener)this, 15, "/", true, null, null, false);
        SearchManager searchMgr = wspInfo.getSearchManager();
        if (searchMgr != null) {
            wsp.getObservationManager().addEventListener((EventListener)searchMgr, 31, "/", true, null, null, false);
        }
    }

    private SearchManager getSystemSearchManager(String wspName) throws RepositoryException {
        if (this.systemSearchMgr == null) {
            try {
                if (this.repConfig.getSearchConfig() != null) {
                    SystemSession defSysSession = this.getSystemSession(wspName);
                    this.systemSearchMgr = new SearchManager(this.repConfig.getSearchConfig(), this.nsReg, this.ntReg, defSysSession.getItemStateManager(), SYSTEM_ROOT_NODE_ID, null, null);
                    ObservationManager obsMgr = defSysSession.getWorkspace().getObservationManager();
                    obsMgr.addEventListener((EventListener)this.systemSearchMgr, 31, "/" + NameFormat.format(QName.JCR_SYSTEM, defSysSession.getNamespaceResolver()), true, null, null, false);
                } else {
                    this.systemSearchMgr = null;
                }
            }
            catch (NoPrefixDeclaredException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return this.systemSearchMgr;
    }

    NamespaceRegistryImpl getNamespaceRegistry() {
        this.sanityCheck();
        return this.nsReg;
    }

    NodeTypeRegistry getNodeTypeRegistry() {
        this.sanityCheck();
        return this.ntReg;
    }

    VersionManager getVersionManager() {
        this.sanityCheck();
        return this.vMgr;
    }

    NodeId getRootNodeId() {
        this.sanityCheck();
        return this.rootNodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getWorkspaceNames() {
        HashMap hashMap = this.wspInfos;
        synchronized (hashMap) {
            return this.wspInfos.keySet().toArray(new String[this.wspInfos.keySet().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkspaceInfo getWorkspaceInfo(String workspaceName) throws IllegalStateException, NoSuchWorkspaceException {
        WorkspaceInfo wspInfo;
        this.sanityCheck();
        HashMap hashMap = this.wspInfos;
        synchronized (hashMap) {
            wspInfo = (WorkspaceInfo)this.wspInfos.get(workspaceName);
            if (wspInfo == null) {
                throw new NoSuchWorkspaceException(workspaceName);
            }
        }
        try {
            this.initWorkspace(wspInfo);
        }
        catch (RepositoryException e) {
            log.error("Unable to initialize workspace '" + workspaceName + "'", (Throwable)e);
            throw new NoSuchWorkspaceException(workspaceName);
        }
        return wspInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createWorkspace(String workspaceName) throws RepositoryException {
        HashMap hashMap = this.wspInfos;
        synchronized (hashMap) {
            if (this.wspInfos.containsKey(workspaceName)) {
                throw new RepositoryException("workspace '" + workspaceName + "' already exists.");
            }
            WorkspaceConfig config = this.repConfig.createWorkspaceConfig(workspaceName);
            WorkspaceInfo info = this.createWorkspaceInfo(config);
            this.wspInfos.put(workspaceName, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createWorkspace(String workspaceName, InputSource configTemplate) throws RepositoryException {
        HashMap hashMap = this.wspInfos;
        synchronized (hashMap) {
            if (this.wspInfos.containsKey(workspaceName)) {
                throw new RepositoryException("workspace '" + workspaceName + "' already exists.");
            }
            WorkspaceConfig config = this.repConfig.createWorkspaceConfig(workspaceName, configTemplate);
            WorkspaceInfo info = this.createWorkspaceInfo(config);
            this.wspInfos.put(workspaceName, info);
        }
    }

    SharedItemStateManager getWorkspaceStateManager(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getItemStateProvider();
    }

    ObservationDispatcher getObservationDispatcher(String workspaceName) throws NoSuchWorkspaceException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getObservationDispatcher();
    }

    SearchManager getSearchManager(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getSearchManager();
    }

    LockManager getLockManager(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getLockManager();
    }

    SystemSession getSystemSession(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.sanityCheck();
        return this.getWorkspaceInfo(workspaceName).getSystemSession();
    }

    protected final SessionImpl createSession(AuthContext loginContext, String workspaceName) throws NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        WorkspaceInfo wspInfo = this.getWorkspaceInfo(workspaceName);
        SessionImpl ses = this.createSessionInstance(loginContext, wspInfo.getConfig());
        this.onSessionCreated(ses);
        wspInfo.setIdleTimestamp(0L);
        return ses;
    }

    protected final SessionImpl createSession(Subject subject, String workspaceName) throws NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        WorkspaceInfo wspInfo = this.getWorkspaceInfo(workspaceName);
        SessionImpl ses = this.createSessionInstance(subject, wspInfo.getConfig());
        this.onSessionCreated(ses);
        wspInfo.setIdleTimestamp(0L);
        return ses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSessionCreated(SessionImpl session) {
        ReferenceMap referenceMap = this.activeSessions;
        synchronized (referenceMap) {
            session.addListener(this);
            this.activeSessions.put((Object)session, (Object)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.shutdownLock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Shutdown lock could not be acquired", e);
        }
        try {
            if (!this.disposed) {
                this.doShutdown();
            }
        }
        finally {
            this.shutdownLock.writeLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doShutdown() {
        SessionImpl[] sa;
        log.info("Shutting down repository...");
        ReferenceMap referenceMap = this.activeSessions;
        synchronized (referenceMap) {
            int cnt = 0;
            sa = new SessionImpl[this.activeSessions.size()];
            Iterator it = this.activeSessions.values().iterator();
            while (it.hasNext()) {
                sa[cnt] = (SessionImpl)it.next();
                ++cnt;
            }
        }
        for (int i = 0; i < sa.length; ++i) {
            if (sa[i] == null) continue;
            sa[i].logout();
        }
        HashMap i = this.wspInfos;
        synchronized (i) {
            Iterator it = this.wspInfos.values().iterator();
            while (it.hasNext()) {
                WorkspaceInfo wspInfo = (WorkspaceInfo)it.next();
                wspInfo.dispose();
            }
        }
        if (this.systemSearchMgr != null) {
            this.systemSearchMgr.close();
        }
        try {
            this.vMgr.close();
        }
        catch (Exception e) {
            log.error("Error while closing Version Manager.", (Throwable)e);
        }
        try {
            this.storeRepProps(this.repProps);
        }
        catch (RepositoryException e) {
            log.error("failed to persist repository properties", (Throwable)e);
        }
        try {
            this.repStore.close();
        }
        catch (FileSystemException e) {
            log.error("error while closing repository file system", (Throwable)e);
        }
        this.disposed = true;
        this.notifyAll();
        this.releaseRepositoryLock();
        log.info("Repository has been shutdown");
    }

    public RepositoryConfig getConfig() {
        return this.repConfig;
    }

    protected FileSystem getFileSystem() {
        return this.repStore;
    }

    protected void setDefaultRepositoryProperties(Properties props) throws RepositoryException {
        InputStream in = RepositoryImpl.class.getResourceAsStream("repository.properties");
        try {
            props.load(in);
            in.close();
            if (!props.containsKey(STATS_NODE_COUNT_PROPERTY)) {
                props.setProperty(STATS_NODE_COUNT_PROPERTY, Long.toString(this.nodesCount));
            }
            if (!props.containsKey(STATS_PROP_COUNT_PROPERTY)) {
                props.setProperty(STATS_PROP_COUNT_PROPERTY, Long.toString(this.propsCount));
            }
        }
        catch (IOException e) {
            String msg = "Failed to load repository properties: " + e.toString();
            log.error(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadRepProps() throws RepositoryException {
        FileSystemResource propFile = new FileSystemResource(this.metaDataStore, PROPERTIES_RESOURCE);
        try {
            Properties props = new Properties();
            if (propFile.exists()) {
                InputStream in = propFile.getInputStream();
                try {
                    props.load(in);
                }
                finally {
                    in.close();
                }
            }
            this.setDefaultRepositoryProperties(props);
            this.storeRepProps(props);
            return props;
        }
        catch (Exception e) {
            String msg = "failed to load repository properties";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeRepProps(Properties props) throws RepositoryException {
        FileSystemResource propFile = new FileSystemResource(this.metaDataStore, PROPERTIES_RESOURCE);
        try {
            propFile.makeParentDirs();
            OutputStream os = propFile.getOutputStream();
            try {
                props.store(os, null);
            }
            finally {
                os.close();
            }
        }
        catch (Exception e) {
            String msg = "failed to persist repository properties";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    private static PersistenceManager createPersistenceManager(File homeDir, FileSystem fs, PersistenceManagerConfig pmConfig, NodeId rootNodeId, NamespaceRegistry nsReg, NodeTypeRegistry ntReg) throws RepositoryException {
        try {
            PersistenceManager pm = (PersistenceManager)pmConfig.newInstance();
            pm.init(new PMContext(homeDir, fs, rootNodeId, nsReg, ntReg));
            return pm;
        }
        catch (Exception e) {
            String msg = "Cannot instantiate persistence manager " + pmConfig.getClassName();
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        try {
            this.shutdownLock.readLock().acquire();
        }
        catch (InterruptedException e) {
            throw new RepositoryException("Login lock could not be acquired", (Throwable)e);
        }
        try {
            AccessControlContext acc;
            Subject subject;
            this.sanityCheck();
            if (workspaceName == null) {
                workspaceName = this.repConfig.getDefaultWorkspaceName();
            }
            this.getWorkspaceInfo(workspaceName);
            if (credentials == null && (subject = Subject.getSubject(acc = AccessController.getContext())) != null) {
                SessionImpl sessionImpl = this.createSession(subject, workspaceName);
                return sessionImpl;
            }
            LoginModuleConfig lmc = this.repConfig.getLoginModuleConfig();
            AuthContext authCtx = lmc == null ? new AuthContext.JAAS(this.repConfig.getAppName(), credentials) : new AuthContext.Local(lmc.getLoginModule(), lmc.getParameters(), credentials);
            authCtx.login();
            SessionImpl sessionImpl = this.createSession(authCtx, workspaceName);
            return sessionImpl;
        }
        catch (SecurityException se) {
            throw new LoginException("Unable to access authentication information", (Throwable)se);
        }
        catch (javax.security.auth.login.LoginException le) {
            throw new LoginException(le.getMessage(), (Throwable)le);
        }
        catch (AccessDeniedException ade) {
            throw new LoginException("Workspace access denied", (Throwable)ade);
        }
        finally {
            this.shutdownLock.readLock().release();
        }
    }

    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, workspaceName);
    }

    public Session login() throws LoginException, RepositoryException {
        return this.login(null, null);
    }

    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        return this.login(credentials, null);
    }

    public String getDescriptor(String key) {
        return this.repProps.getProperty(key);
    }

    public String[] getDescriptorKeys() {
        Object[] keys = this.repProps.keySet().toArray(new String[this.repProps.keySet().size()]);
        Arrays.sort(keys);
        return keys;
    }

    public void loggingOut(SessionImpl session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loggedOut(SessionImpl session) {
        ReferenceMap referenceMap = this.activeSessions;
        synchronized (referenceMap) {
            this.activeSessions.remove((Object)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator events) {
        if (this.disposed) {
            return;
        }
        Properties properties = this.repProps;
        synchronized (properties) {
            while (events.hasNext()) {
                Event event = events.nextEvent();
                long type = event.getType();
                if ((type & 1L) == 1L) {
                    ++this.nodesCount;
                    this.repProps.setProperty(STATS_NODE_COUNT_PROPERTY, Long.toString(this.nodesCount));
                }
                if ((type & 2L) == 2L) {
                    --this.nodesCount;
                    this.repProps.setProperty(STATS_NODE_COUNT_PROPERTY, Long.toString(this.nodesCount));
                }
                if ((type & 4L) == 4L) {
                    ++this.propsCount;
                    this.repProps.setProperty(STATS_PROP_COUNT_PROPERTY, Long.toString(this.propsCount));
                }
                if ((type & 8L) != 8L) continue;
                --this.propsCount;
                this.repProps.setProperty(STATS_PROP_COUNT_PROPERTY, Long.toString(this.propsCount));
            }
        }
    }

    protected SessionImpl createSessionInstance(AuthContext loginContext, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        return new XASessionImpl(this, loginContext, wspConfig);
    }

    protected SessionImpl createSessionInstance(Subject subject, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException {
        return new XASessionImpl(this, subject, wspConfig);
    }

    protected WorkspaceInfo createWorkspaceInfo(WorkspaceConfig wspConfig) {
        return new WorkspaceInfo(wspConfig);
    }

    private class WorkspaceJanitor
    implements Runnable {
        private long maxIdleTime;
        private long checkInterval;

        WorkspaceJanitor(long maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
            this.checkInterval = (long)(0.1 * (double)maxIdleTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block14: while (true) {
                HashSet wspNames;
                RepositoryImpl repositoryImpl = RepositoryImpl.this;
                synchronized (repositoryImpl) {
                    try {
                        RepositoryImpl.this.wait(this.checkInterval);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (RepositoryImpl.this.disposed) {
                        return;
                    }
                }
                HashMap e = RepositoryImpl.this.wspInfos;
                synchronized (e) {
                    wspNames = new HashSet(RepositoryImpl.this.wspInfos.keySet());
                }
                wspNames.remove(RepositoryImpl.this.repConfig.getDefaultWorkspaceName());
                e = RepositoryImpl.this.activeSessions;
                synchronized (e) {
                    Iterator it = RepositoryImpl.this.activeSessions.values().iterator();
                    while (it.hasNext()) {
                        SessionImpl ses = (SessionImpl)it.next();
                        wspNames.remove(ses.getWorkspace().getName());
                    }
                }
                Iterator it = wspNames.iterator();
                while (true) {
                    WorkspaceInfo wspInfo;
                    if (!it.hasNext()) continue block14;
                    HashMap hashMap = RepositoryImpl.this.wspInfos;
                    synchronized (hashMap) {
                        wspInfo = (WorkspaceInfo)RepositoryImpl.this.wspInfos.get(it.next());
                    }
                    wspInfo.disposeIfIdle(this.maxIdleTime);
                }
                break;
            }
        }
    }

    protected class WorkspaceInfo {
        private final WorkspaceConfig config;
        private FileSystem fs;
        private PersistenceManager persistMgr;
        private SharedItemStateManager itemStateMgr;
        private ObservationDispatcher dispatcher;
        private SystemSession systemSession;
        private SearchManager searchMgr;
        private LockManagerImpl lockMgr;
        private boolean initialized;
        private final ReadWriteLock initLock = new ReentrantWriterPreferenceReadWriteLock();
        private long idleTimestamp;
        private final Mutex xaLock = new Mutex();

        protected WorkspaceInfo(WorkspaceConfig config) {
            this.config = config;
            this.idleTimestamp = 0L;
            this.initialized = false;
        }

        String getName() {
            return this.config.getName();
        }

        public WorkspaceConfig getConfig() {
            return this.config;
        }

        long getIdleTimestamp() {
            return this.idleTimestamp;
        }

        void setIdleTimestamp(long ts) {
            this.idleTimestamp = ts;
        }

        boolean isInitialized() {
            try {
                if (!this.initLock.readLock().attempt(0L)) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            boolean ret = this.initialized;
            this.initLock.readLock().release();
            return ret;
        }

        FileSystem getFileSystem() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            return this.fs;
        }

        PersistenceManager getPersistenceManager() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            return this.persistMgr;
        }

        SharedItemStateManager getItemStateProvider() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            return this.itemStateMgr;
        }

        ObservationDispatcher getObservationDispatcher() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            return this.dispatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SearchManager getSearchManager() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            WorkspaceInfo workspaceInfo = this;
            synchronized (workspaceInfo) {
                if (this.searchMgr == null) {
                    if (this.config.getSearchConfig() == null) {
                        return null;
                    }
                    this.searchMgr = new SearchManager(this.config.getSearchConfig(), RepositoryImpl.this.nsReg, RepositoryImpl.this.ntReg, this.itemStateMgr, RepositoryImpl.this.rootNodeId, RepositoryImpl.this.getSystemSearchManager(this.getName()), SYSTEM_ROOT_NODE_ID);
                }
                return this.searchMgr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LockManager getLockManager() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            WorkspaceInfo workspaceInfo = this;
            synchronized (workspaceInfo) {
                if (this.lockMgr == null) {
                    this.lockMgr = new LockManagerImpl(this.getSystemSession(), this.fs);
                }
                return this.lockMgr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SystemSession getSystemSession() throws RepositoryException {
            if (!this.isInitialized()) {
                throw new IllegalStateException("workspace '" + this.getName() + "' not initialized");
            }
            WorkspaceInfo workspaceInfo = this;
            synchronized (workspaceInfo) {
                if (this.systemSession == null) {
                    this.systemSession = SystemSession.create(RepositoryImpl.this, this.config);
                }
                return this.systemSession;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean initialize() throws RepositoryException {
            try {
                this.initLock.readLock().acquire();
            }
            catch (InterruptedException e) {
                throw new RepositoryException("Unable to aquire read lock.", (Throwable)e);
            }
            try {
                if (this.initialized) {
                    boolean e = false;
                    return e;
                }
            }
            finally {
                this.initLock.readLock().release();
            }
            try {
                this.initLock.writeLock().acquire();
            }
            catch (InterruptedException e) {
                throw new RepositoryException("Unable to aquire write lock.", (Throwable)e);
            }
            try {
                if (this.initialized) {
                    boolean e = false;
                    return e;
                }
                log.info("initializing workspace '" + this.getName() + "'...");
                FileSystemConfig fsConfig = this.config.getFileSystemConfig();
                this.fs = fsConfig.createFileSystem();
                this.persistMgr = RepositoryImpl.createPersistenceManager(new File(this.config.getHomeDir()), this.fs, this.config.getPersistenceManagerConfig(), RepositoryImpl.this.rootNodeId, RepositoryImpl.this.nsReg, RepositoryImpl.this.ntReg);
                try {
                    this.itemStateMgr = new SharedItemStateManager(this.persistMgr, RepositoryImpl.this.rootNodeId, RepositoryImpl.this.ntReg, true);
                    try {
                        this.itemStateMgr.addVirtualItemStateProvider(RepositoryImpl.this.vMgr.getVirtualItemStateProvider());
                        this.itemStateMgr.addVirtualItemStateProvider(RepositoryImpl.this.virtNTMgr.getVirtualItemStateProvider());
                    }
                    catch (Exception e) {
                        log.error("Unable to add vmgr: " + e.toString(), (Throwable)e);
                    }
                }
                catch (ItemStateException ise) {
                    String msg = "failed to instantiate shared item state manager";
                    log.debug(msg);
                    throw new RepositoryException(msg, (Throwable)ise);
                }
                this.dispatcher = new ObservationDispatcher();
                RepositoryImpl.this.delegatingDispatcher.addDispatcher(this.dispatcher);
                this.initialized = true;
                log.info("workspace '" + this.getName() + "' initialized");
                boolean bl = true;
                return bl;
            }
            finally {
                this.initLock.writeLock().release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disposeIfIdle(long maxIdleTime) {
            try {
                this.initLock.readLock().acquire();
            }
            catch (InterruptedException e) {
                return;
            }
            try {
                if (!this.initialized) {
                    return;
                }
                long currentTS = System.currentTimeMillis();
                if (this.idleTimestamp == 0L) {
                    this.idleTimestamp = currentTS;
                } else if (currentTS - this.idleTimestamp > maxIdleTime) {
                    log.info("disposing workspace '" + this.getName() + "' which has been idle for " + (currentTS - this.idleTimestamp) + " ms");
                    this.dispose();
                }
            }
            finally {
                this.initLock.readLock().release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispose() {
            try {
                this.initLock.writeLock().acquire();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Unable to aquire write lock.");
            }
            try {
                if (!this.initialized) {
                    return;
                }
                log.info("shutting down workspace '" + this.getName() + "'...");
                RepositoryImpl.this.delegatingDispatcher.removeDispatcher(this.dispatcher);
                this.dispatcher.dispose();
                this.dispatcher = null;
                if (this.searchMgr != null) {
                    this.searchMgr.close();
                    this.searchMgr = null;
                }
                if (this.systemSession != null) {
                    this.systemSession.removeListener(RepositoryImpl.this);
                    this.systemSession.logout();
                    this.systemSession = null;
                }
                this.itemStateMgr.dispose();
                this.itemStateMgr = null;
                try {
                    this.persistMgr.close();
                }
                catch (Exception e) {
                    log.error("error while closing persistence manager of workspace " + this.config.getName(), (Throwable)e);
                }
                this.persistMgr = null;
                if (this.lockMgr != null) {
                    this.lockMgr.close();
                    this.lockMgr = null;
                }
                try {
                    this.fs.close();
                }
                catch (FileSystemException fse) {
                    log.error("error while closing file system of workspace " + this.config.getName(), (Throwable)fse);
                }
                this.fs = null;
                this.idleTimestamp = 0L;
                this.initialized = false;
                log.info("workspace '" + this.getName() + "' has been shutdown");
            }
            finally {
                this.initLock.writeLock().release();
            }
        }

        void lockAcquire() throws TransactionException {
            try {
                this.xaLock.acquire();
            }
            catch (InterruptedException e) {
                throw new TransactionException("Error while acquiering lock", e);
            }
        }

        void lockRelease() {
            this.xaLock.release();
        }
    }
}

