/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemLifeCycleListener;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.LazyItemIterator;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.DateVersionSelector;
import org.apache.jackrabbit.core.version.InternalFreeze;
import org.apache.jackrabbit.core.version.InternalFrozenNode;
import org.apache.jackrabbit.core.version.InternalFrozenVersionHistory;
import org.apache.jackrabbit.core.version.LabelVersionSelector;
import org.apache.jackrabbit.core.version.VersionImpl;
import org.apache.jackrabbit.core.version.VersionSelector;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.NameException;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.PathFormat;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;
import org.apache.jackrabbit.util.ChildrenCollectorFilter;
import org.apache.jackrabbit.util.IteratorHelper;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeImpl
extends ItemImpl
implements Node {
    private static Logger log = LoggerFactory.getLogger((Class)NodeImpl.class);
    protected final QName primaryTypeName;
    protected NodeDefinition definition;
    protected static final short CREATED = 0;

    protected NodeImpl(ItemManager itemMgr, SessionImpl session, NodeId id, NodeState state, NodeDefinition definition, ItemLifeCycleListener[] listeners) {
        super(itemMgr, session, id, state, listeners);
        this.definition = definition;
        NodeTypeRegistry ntReg = session.getNodeTypeManager().getNodeTypeRegistry();
        if (ntReg.isRegistered(state.getNodeTypeName())) {
            this.primaryTypeName = state.getNodeTypeName();
        } else {
            log.warn("Fallback to nt:unstructured due to unknown node type '" + state.getNodeTypeName() + "' of node " + this.safeGetJCRPath());
            this.primaryTypeName = QName.NT_UNSTRUCTURED;
        }
    }

    protected PropertyId resolveRelativePropertyPath(String relPath) throws RepositoryException {
        try {
            if (relPath.indexOf(47) == -1) {
                NodeState thisState = (NodeState)this.state;
                QName propName = NameFormat.parse(relPath, this.session.getNamespaceResolver());
                if (thisState.hasPropertyName(propName)) {
                    return new PropertyId(thisState.getNodeId(), propName);
                }
                return null;
            }
            Path p = PathFormat.parse(this.getPrimaryPath(), relPath, this.session.getNamespaceResolver()).getCanonicalPath();
            try {
                ItemId id = this.session.getHierarchyManager().resolvePath(p);
                if (!id.denotesNode()) {
                    return (PropertyId)id;
                }
                return null;
            }
            catch (PathNotFoundException pnfe) {
                return null;
            }
        }
        catch (NameException e) {
            String msg = "failed to resolve path " + relPath + " relative to " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    protected NodeId resolveRelativeNodePath(String relPath) throws RepositoryException {
        try {
            Path.PathElement pe;
            Path p = PathFormat.parse(relPath, this.session.getNamespaceResolver());
            if (p.getLength() == 1 && (pe = p.getNameElement()).denotesName()) {
                NodeState.ChildNodeEntry cne;
                NodeState thisState = (NodeState)this.state;
                int index = pe.getIndex();
                if (index == 0) {
                    index = 1;
                }
                if ((cne = thisState.getChildNodeEntry(pe.getName(), index)) != null) {
                    return cne.getId();
                }
                return null;
            }
            p = Path.create(this.getPrimaryPath(), p, true);
            try {
                ItemId id = this.session.getHierarchyManager().resolvePath(p);
                if (id.denotesNode()) {
                    return (NodeId)id;
                }
                return null;
            }
            catch (PathNotFoundException pnfe) {
                return null;
            }
        }
        catch (MalformedPathException e) {
            String msg = "failed to resolve path " + relPath + " relative to " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    protected boolean hasPendingChanges() throws RepositoryException {
        if (this.isTransient()) {
            return true;
        }
        Iterator iter = this.stateMgr.getDescendantTransientItemStates((NodeId)this.id);
        return iter.hasNext();
    }

    protected synchronized ItemState getOrCreateTransientItemState() throws RepositoryException {
        if (!this.isTransient()) {
            try {
                NodeState transientState = this.stateMgr.createTransientNodeState((NodeState)this.state, 2);
                this.state = transientState;
            }
            catch (ItemStateException ise) {
                String msg = "failed to create transient state";
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)ise);
            }
        }
        return this.state;
    }

    protected InternalValue[] computeSystemGeneratedPropertyValues(QName name, PropertyDefinitionImpl def) throws RepositoryException {
        InternalValue[] genValues = null;
        NodeState thisState = (NodeState)this.state;
        NodeTypeImpl nt = (NodeTypeImpl)def.getDeclaringNodeType();
        if (nt.getQName().equals(QName.MIX_REFERENCEABLE)) {
            if (name.equals(QName.JCR_UUID)) {
                genValues = new InternalValue[]{InternalValue.create(thisState.getNodeId().getUUID().toString())};
            }
        } else if (nt.getQName().equals(QName.NT_HIERARCHYNODE)) {
            if (name.equals(QName.JCR_CREATED)) {
                genValues = new InternalValue[]{InternalValue.create(Calendar.getInstance())};
            }
        } else if (nt.getQName().equals(QName.NT_RESOURCE)) {
            if (name.equals(QName.JCR_LASTMODIFIED)) {
                genValues = new InternalValue[]{InternalValue.create(Calendar.getInstance())};
            }
        } else if (nt.getQName().equals(QName.NT_VERSION)) {
            if (name.equals(QName.JCR_CREATED)) {
                genValues = new InternalValue[]{InternalValue.create(Calendar.getInstance())};
            }
        } else if (nt.getQName().equals(QName.NT_BASE)) {
            if (name.equals(QName.JCR_PRIMARYTYPE)) {
                genValues = new InternalValue[]{InternalValue.create(this.primaryTypeName)};
            } else if (name.equals(QName.JCR_MIXINTYPES)) {
                Set mixins = thisState.getMixinTypeNames();
                ArrayList<InternalValue> values = new ArrayList<InternalValue>(mixins.size());
                Iterator iter = mixins.iterator();
                while (iter.hasNext()) {
                    values.add(InternalValue.create((QName)iter.next()));
                }
                genValues = values.toArray(new InternalValue[values.size()]);
            }
        }
        return genValues;
    }

    protected PropertyImpl getOrCreateProperty(String name, int type, boolean multiValued, boolean exactTypeMatch, BitSet status) throws ConstraintViolationException, RepositoryException {
        QName qName;
        try {
            qName = NameFormat.parse(name, this.session.getNamespaceResolver());
        }
        catch (IllegalNameException ine) {
            throw new RepositoryException("invalid property name: " + name, (Throwable)ine);
        }
        catch (UnknownPrefixException upe) {
            throw new RepositoryException("invalid property name: " + name, (Throwable)upe);
        }
        return this.getOrCreateProperty(qName, type, multiValued, exactTypeMatch, status);
    }

    protected synchronized PropertyImpl getOrCreateProperty(QName name, int type, boolean multiValued, boolean exactTypeMatch, BitSet status) throws ConstraintViolationException, RepositoryException {
        status.clear();
        try {
            PropertyId propId = new PropertyId(this.getNodeId(), name);
            return (PropertyImpl)this.itemMgr.getItem(propId);
        }
        catch (AccessDeniedException ade) {
            throw new ItemNotFoundException(name.toString());
        }
        catch (ItemNotFoundException e) {
            PropertyDefinitionImpl def = this.getApplicablePropertyDefinition(name, type, multiValued, exactTypeMatch);
            PropertyImpl prop = this.createChildProperty(name, type, def);
            status.set(0);
            return prop;
        }
    }

    protected synchronized PropertyImpl createChildProperty(QName name, int type, PropertyDefinitionImpl def) throws RepositoryException {
        PropertyState propState;
        if (((NodeState)this.state).hasChildNodeEntry(name)) {
            String msg = "there's already a child node with name " + name;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        try {
            propState = this.stateMgr.createTransientPropertyState(this.getNodeId(), name, 4);
            propState.setType(type);
            propState.setMultiValued(def.isMultiple());
            propState.setDefinitionId(def.unwrap().getId());
            InternalValue[] genValues = this.computeSystemGeneratedPropertyValues(name, def);
            InternalValue[] defValues = def.unwrap().getDefaultValues();
            if (genValues != null) {
                propState.setValues(genValues);
            } else if (defValues != null) {
                propState.setValues(defValues);
            }
        }
        catch (ItemStateException ise) {
            String msg = "failed to add property " + name + " to " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
        PropertyImpl prop = this.itemMgr.createPropertyInstance(propState, def);
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.addPropertyName(name);
        return prop;
    }

    protected synchronized NodeImpl createChildNode(QName name, NodeDefinitionImpl def, NodeTypeImpl nodeType, NodeId id) throws RepositoryException {
        NodeImpl node;
        NodeState nodeState;
        try {
            if (id == null) {
                id = new NodeId(UUID.randomUUID());
            }
            nodeState = this.stateMgr.createTransientNodeState(id, nodeType.getQName(), this.getNodeId(), 4);
            nodeState.setDefinitionId(def.unwrap().getId());
        }
        catch (ItemStateException ise) {
            String msg = "failed to add child node " + name + " to " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ise);
        }
        try {
            node = this.itemMgr.createNodeInstance(nodeState, def);
        }
        catch (RepositoryException re) {
            this.stateMgr.disposeTransientItemState(nodeState);
            throw re;
        }
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.addChildNodeEntry(name, nodeState.getNodeId());
        PropertyDefinition[] pda = nodeType.getAutoCreatedPropertyDefinitions();
        for (int i = 0; i < pda.length; ++i) {
            PropertyDefinitionImpl pd = (PropertyDefinitionImpl)pda[i];
            node.createChildProperty(pd.getQName(), pd.getRequiredType(), pd);
        }
        NodeDefinition[] nda = nodeType.getAutoCreatedNodeDefinitions();
        for (int i = 0; i < nda.length; ++i) {
            NodeDefinitionImpl nd = (NodeDefinitionImpl)nda[i];
            node.createChildNode(nd.getQName(), nd, (NodeTypeImpl)nd.getDefaultPrimaryType(), null);
        }
        return node;
    }

    protected void renameChildNode(QName oldName, int index, NodeId id, QName newName) throws RepositoryException {
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.renameChildNodeEntry(oldName, index, newName);
    }

    protected void removeChildProperty(String propName) throws RepositoryException {
        QName qName;
        try {
            qName = NameFormat.parse(propName, this.session.getNamespaceResolver());
        }
        catch (IllegalNameException ine) {
            throw new RepositoryException("invalid property name: " + propName, (Throwable)ine);
        }
        catch (UnknownPrefixException upe) {
            throw new RepositoryException("invalid property name: " + propName, (Throwable)upe);
        }
        this.removeChildProperty(qName);
    }

    protected void removeChildProperty(QName propName) throws RepositoryException {
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        if (!thisState.removePropertyName(propName)) {
            String msg = "failed to remove property " + propName + " of " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        PropertyId propId = new PropertyId(thisState.getNodeId(), propName);
        this.itemMgr.getItem(propId).setRemoved();
    }

    protected void removeChildNode(QName nodeName, int index) throws RepositoryException {
        NodeState.ChildNodeEntry entry;
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        if (index == 0) {
            index = 1;
        }
        if ((entry = thisState.getChildNodeEntry(nodeName, index)) == null) {
            String msg = "failed to remove child " + nodeName + " of " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        NodeId childId = entry.getId();
        NodeImpl childNode = (NodeImpl)this.itemMgr.getItem(childId);
        childNode.onRemove();
        if (!thisState.removeChildNodeEntry(nodeName, index)) {
            String msg = "failed to remove child " + nodeName + " of " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg);
        }
    }

    protected void onRedefine(NodeDefId defId) throws RepositoryException {
        NodeDefinitionImpl newDef = this.session.getNodeTypeManager().getNodeDefinition(defId);
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.setDefinitionId(defId);
        this.definition = newDef;
    }

    protected void onRemove() throws RepositoryException {
        AbstractCollection tmp;
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        if (thisState.hasChildNodeEntries()) {
            tmp = new ArrayList(thisState.getChildNodeEntries());
            for (int i = ((ArrayList)tmp).size() - 1; i >= 0; --i) {
                NodeState.ChildNodeEntry entry = (NodeState.ChildNodeEntry)((ArrayList)tmp).get(i);
                NodeId childId = entry.getId();
                NodeImpl childNode = (NodeImpl)this.itemMgr.getItem(childId);
                childNode.onRemove();
                thisState.removeChildNodeEntry(entry.getName(), entry.getIndex());
            }
        }
        tmp = new HashSet(thisState.getPropertyNames());
        Iterator iter = ((HashSet)tmp).iterator();
        while (iter.hasNext()) {
            QName propName = (QName)iter.next();
            thisState.removePropertyName(propName);
            PropertyId propId = new PropertyId(thisState.getNodeId(), propName);
            this.itemMgr.getItem(propId).setRemoved();
        }
        thisState.setParentId(null);
        this.itemMgr.getItem(this.id).setRemoved();
    }

    protected NodeImpl internalAddNode(String relPath, NodeTypeImpl nodeType) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        return this.internalAddNode(relPath, nodeType, null);
    }

    protected NodeImpl internalAddNode(String relPath, NodeTypeImpl nodeType, NodeId id) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        NodeImpl parentNode;
        Path parentPath;
        QName nodeName;
        try {
            Path nodePath = PathFormat.parse(this.getPrimaryPath(), relPath, this.session.getNamespaceResolver()).getCanonicalPath();
            if (nodePath.getNameElement().getIndex() != 0) {
                String msg = "illegal subscript specified: " + nodePath;
                log.debug(msg);
                throw new RepositoryException(msg);
            }
            nodeName = nodePath.getNameElement().getName();
            parentPath = nodePath.getAncestor(1);
        }
        catch (MalformedPathException e) {
            String msg = "failed to resolve path " + relPath + " relative to " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        try {
            ItemImpl parent = this.itemMgr.getItem(parentPath);
            if (!parent.isNode()) {
                String msg = "cannot add a node to property " + parentPath;
                log.debug(msg);
                throw new ConstraintViolationException(msg);
            }
            parentNode = (NodeImpl)parent;
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(relPath);
        }
        if (!parentNode.internalIsCheckedOut()) {
            String msg = this.safeGetJCRPath() + ": cannot add a child to a checked-in node";
            log.debug(msg);
            throw new VersionException(msg);
        }
        parentNode.checkLock();
        return parentNode.internalAddChildNode(nodeName, nodeType, id);
    }

    protected NodeImpl internalAddChildNode(QName nodeName, NodeTypeImpl nodeType) throws ItemExistsException, ConstraintViolationException, RepositoryException {
        return this.internalAddChildNode(nodeName, nodeType, null);
    }

    protected NodeImpl internalAddChildNode(QName nodeName, NodeTypeImpl nodeType, NodeId id) throws ItemExistsException, ConstraintViolationException, RepositoryException {
        NodeState thisState;
        NodeDefinitionImpl def;
        Path nodePath;
        try {
            nodePath = Path.create(this.getPrimaryPath(), nodeName, true);
        }
        catch (MalformedPathException e) {
            String msg = "internal error: invalid path " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        try {
            QName nodeTypeName = null;
            if (nodeType != null) {
                nodeTypeName = nodeType.getQName();
            }
            def = this.getApplicableChildNodeDefinition(nodeName, nodeTypeName);
        }
        catch (RepositoryException re) {
            String msg = "no definition found in parent node's node type for new node";
            log.debug(msg);
            throw new ConstraintViolationException(msg, (Throwable)re);
        }
        if (nodeType == null) {
            nodeType = (NodeTypeImpl)def.getDefaultPrimaryType();
        }
        if ((thisState = (NodeState)this.state).hasPropertyName(nodeName)) {
            throw new ItemExistsException(this.itemMgr.safeGetJCRPath(nodePath));
        }
        NodeState.ChildNodeEntry cne = thisState.getChildNodeEntry(nodeName, 1);
        if (cne != null) {
            if (!def.allowsSameNameSiblings()) {
                throw new ItemExistsException(this.itemMgr.safeGetJCRPath(nodePath));
            }
            NodeId newId = cne.getId();
            if (!((NodeImpl)this.itemMgr.getItem(newId)).getDefinition().allowsSameNameSiblings()) {
                throw new ItemExistsException(this.itemMgr.safeGetJCRPath(nodePath));
            }
        }
        if (this.definition.isProtected()) {
            String msg = this.safeGetJCRPath() + ": cannot add a child to a protected node";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        return this.createChildNode(nodeName, def, nodeType, id);
    }

    private void setMixinTypesProperty(Set mixinNames) throws RepositoryException {
        PropertyImpl prop;
        NodeState thisState = (NodeState)this.state;
        if (thisState.hasPropertyName(QName.JCR_MIXINTYPES)) {
            prop = (PropertyImpl)this.itemMgr.getItem(new PropertyId(thisState.getNodeId(), QName.JCR_MIXINTYPES));
        } else {
            PropertyDefinitionImpl def = this.getApplicablePropertyDefinition(QName.JCR_MIXINTYPES, 7, true, true);
            prop = this.createChildProperty(QName.JCR_MIXINTYPES, 7, def);
        }
        if (mixinNames.isEmpty()) {
            this.removeChildProperty(QName.JCR_MIXINTYPES);
            return;
        }
        InternalValue[] vals = new InternalValue[mixinNames.size()];
        Iterator iter = mixinNames.iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            vals[cnt++] = InternalValue.create((QName)iter.next());
        }
        prop.internalSetValue(vals, 7);
    }

    public Set getMixinTypeNames() {
        return ((NodeState)this.state).getMixinTypeNames();
    }

    public EffectiveNodeType getEffectiveNodeType() throws RepositoryException {
        NodeTypeRegistry ntReg = this.session.getNodeTypeManager().getNodeTypeRegistry();
        Set set = ((NodeState)this.state).getMixinTypeNames();
        QName[] types = new QName[set.size() + 1];
        set.toArray(types);
        types[types.length - 1] = this.primaryTypeName;
        try {
            return ntReg.getEffectiveNodeType(types);
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "internal error: failed to build effective node type for node " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ntce);
        }
    }

    protected NodeDefinitionImpl getApplicableChildNodeDefinition(QName nodeName, QName nodeTypeName) throws ConstraintViolationException, RepositoryException {
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        NodeDef cnd = this.getEffectiveNodeType().getApplicableChildNodeDef(nodeName, nodeTypeName, ntMgr.getNodeTypeRegistry());
        return ntMgr.getNodeDefinition(cnd.getId());
    }

    protected PropertyDefinitionImpl getApplicablePropertyDefinition(QName propertyName, int type, boolean multiValued, boolean exactTypeMatch) throws ConstraintViolationException, RepositoryException {
        PropDef pd;
        if (exactTypeMatch || type == 0) {
            pd = this.getEffectiveNodeType().getApplicablePropertyDef(propertyName, type, multiValued);
        } else {
            try {
                pd = this.getEffectiveNodeType().getApplicablePropertyDef(propertyName, type, multiValued);
            }
            catch (ConstraintViolationException cve) {
                pd = this.getEffectiveNodeType().getApplicablePropertyDef(propertyName, 0, multiValued);
            }
        }
        return this.session.getNodeTypeManager().getPropertyDefinition(pd.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makePersistent() throws InvalidItemStateException {
        if (!this.isTransient()) {
            log.debug(this.safeGetJCRPath() + " (" + this.id + "): there's no transient state to persist");
            return;
        }
        NodeState transientState = (NodeState)this.state;
        NodeState persistentState = (NodeState)transientState.getOverlayedState();
        if (persistentState == null) {
            persistentState = this.stateMgr.createNew(transientState);
        }
        NodeState nodeState = persistentState;
        synchronized (nodeState) {
            if (transientState.isStale()) {
                String msg = this.safeGetJCRPath() + ": the node cannot be saved because it has been modified externally.";
                log.debug(msg);
                throw new InvalidItemStateException(msg);
            }
            persistentState.setParentId(transientState.getParentId());
            persistentState.setMixinTypeNames(transientState.getMixinTypeNames());
            persistentState.setDefinitionId(transientState.getDefinitionId());
            persistentState.setChildNodeEntries(transientState.getChildNodeEntries());
            persistentState.setPropertyNames(transientState.getPropertyNames());
            this.stateMgr.store(persistentState);
        }
        this.stateMgr.disconnectTransientItemState(transientState);
        this.state = persistentState;
        this.status = 0;
    }

    protected void restoreTransient(NodeState transientState) throws RepositoryException {
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        if (transientState.getStatus() == 4 && thisState.getStatus() != 4) {
            thisState.setStatus(4);
            this.stateMgr.disconnectTransientItemState(thisState);
        }
        thisState.setParentId(transientState.getParentId());
        thisState.setMixinTypeNames(transientState.getMixinTypeNames());
        thisState.setDefinitionId(transientState.getDefinitionId());
        thisState.setChildNodeEntries(transientState.getChildNodeEntries());
        thisState.setPropertyNames(transientState.getPropertyNames());
    }

    public void addMixin(QName mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        EffectiveNodeType entExisting;
        this.sanityCheck();
        if (!this.internalIsCheckedOut()) {
            String msg = this.safeGetJCRPath() + ": cannot add a mixin node type to a checked-in node";
            log.debug(msg);
            throw new VersionException(msg);
        }
        if (this.definition.isProtected()) {
            String msg = this.safeGetJCRPath() + ": cannot add a mixin node type to a protected node";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        this.checkLock();
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        NodeTypeImpl mixin = ntMgr.getNodeType(mixinName);
        if (!mixin.isMixin()) {
            throw new RepositoryException(mixinName + ": not a mixin node type");
        }
        NodeTypeImpl primaryType = ntMgr.getNodeType(this.primaryTypeName);
        if (primaryType.isDerivedFrom(mixinName)) {
            throw new RepositoryException(mixinName + ": already contained in primary node type");
        }
        NodeTypeRegistry ntReg = ntMgr.getNodeTypeRegistry();
        try {
            HashSet<QName> set = new HashSet<QName>(((NodeState)this.state).getMixinTypeNames());
            set.add(this.primaryTypeName);
            entExisting = ntReg.getEffectiveNodeType(set.toArray(new QName[set.size()]));
            if (entExisting.includesNodeType(mixinName)) {
                throw new RepositoryException(mixinName + ": already contained in mixin types");
            }
            set.add(mixinName);
            ntReg.getEffectiveNodeType(set.toArray(new QName[set.size()]));
        }
        catch (NodeTypeConflictException ntce) {
            throw new ConstraintViolationException(ntce.getMessage());
        }
        try {
            NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
            HashSet<QName> mixins = new HashSet<QName>(thisState.getMixinTypeNames());
            mixins.add(mixinName);
            thisState.setMixinTypeNames(mixins);
            this.setMixinTypesProperty(mixins);
            PropertyDefinition[] pda = mixin.getAutoCreatedPropertyDefinitions();
            for (int i = 0; i < pda.length; ++i) {
                PropertyDefinitionImpl pd = (PropertyDefinitionImpl)pda[i];
                NodeTypeImpl declaringNT = (NodeTypeImpl)pd.getDeclaringNodeType();
                if (entExisting.includesNodeType(declaringNT.getQName())) continue;
                this.createChildProperty(pd.getQName(), pd.getRequiredType(), pd);
            }
            NodeDefinition[] nda = mixin.getAutoCreatedNodeDefinitions();
            for (int i = 0; i < nda.length; ++i) {
                NodeDefinitionImpl nd = (NodeDefinitionImpl)nda[i];
                NodeTypeImpl declaringNT = (NodeTypeImpl)nd.getDeclaringNodeType();
                if (entExisting.includesNodeType(declaringNT.getQName())) continue;
                this.createChildNode(nd.getQName(), nd, (NodeTypeImpl)nd.getDefaultPrimaryType(), null);
            }
        }
        catch (RepositoryException re) {
            try {
                this.removeMixin(mixinName);
            }
            catch (RepositoryException re1) {
                // empty catch block
            }
            throw re;
        }
    }

    public void removeMixin(QName mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        PropertyIterator iter;
        EffectiveNodeType entRemaining;
        this.sanityCheck();
        if (!this.internalIsCheckedOut()) {
            String msg = this.safeGetJCRPath() + ": cannot remove a mixin node type from a checked-in node";
            log.debug(msg);
            throw new VersionException(msg);
        }
        if (this.definition.isProtected()) {
            String msg = this.safeGetJCRPath() + ": cannot remove a mixin node type from a protected node";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        this.checkLock();
        if (!((NodeState)this.state).getMixinTypeNames().contains(mixinName)) {
            throw new NoSuchNodeTypeException();
        }
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        NodeTypeRegistry ntReg = ntMgr.getNodeTypeRegistry();
        HashSet remainingMixins = new HashSet(((NodeState)this.state).getMixinTypeNames());
        remainingMixins.remove(mixinName);
        try {
            HashSet<QName> set = new HashSet<QName>(remainingMixins);
            set.add(this.primaryTypeName);
            entRemaining = ntReg.getEffectiveNodeType(set.toArray(new QName[set.size()]));
        }
        catch (NodeTypeConflictException ntce) {
            throw new ConstraintViolationException(ntce.getMessage());
        }
        NodeTypeImpl mixin = ntMgr.getNodeType(mixinName);
        if ((QName.MIX_REFERENCEABLE.equals(mixinName) || mixin.isDerivedFrom(QName.MIX_REFERENCEABLE)) && !entRemaining.includesNodeType(QName.MIX_REFERENCEABLE) && (iter = this.getReferences()).hasNext()) {
            throw new ConstraintViolationException(mixinName + " can not be removed: the node is being referenced" + " through at least one property of type REFERENCE");
        }
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.setMixinTypeNames(remainingMixins);
        this.setMixinTypesProperty(remainingMixins);
        if (mixin.getChildNodeDefinitions().length == 0 && mixin.getPropertyDefinitions().length == 0) {
            return;
        }
        HashSet set = new HashSet(thisState.getPropertyNames());
        Iterator iter2 = set.iterator();
        while (iter2.hasNext()) {
            QName propName = (QName)iter2.next();
            PropertyImpl prop = (PropertyImpl)this.itemMgr.getItem(new PropertyId(thisState.getNodeId(), propName));
            NodeTypeImpl declaringNT = (NodeTypeImpl)prop.getDefinition().getDeclaringNodeType();
            if (entRemaining.includesNodeType(declaringNT.getQName())) continue;
            this.removeChildProperty(propName);
        }
        ArrayList list = new ArrayList(thisState.getChildNodeEntries());
        for (int i = list.size() - 1; i >= 0; --i) {
            NodeState.ChildNodeEntry entry = (NodeState.ChildNodeEntry)list.get(i);
            NodeImpl node = (NodeImpl)this.itemMgr.getItem(entry.getId());
            NodeTypeImpl declaringNT = (NodeTypeImpl)node.getDefinition().getDeclaringNodeType();
            if (entRemaining.includesNodeType(declaringNT.getQName())) continue;
            this.removeChildNode(entry.getName(), entry.getIndex());
        }
    }

    public boolean isNodeType(QName ntName) throws RepositoryException {
        this.sanityCheck();
        if (ntName.equals(this.primaryTypeName)) {
            return true;
        }
        if (((NodeState)this.state).getMixinTypeNames().contains(ntName)) {
            return true;
        }
        return this.getEffectiveNodeType().includesNodeType(ntName);
    }

    public UUID internalGetUUID() {
        return ((NodeId)this.id).getUUID();
    }

    protected void checkSetProperty() throws VersionException, LockException, RepositoryException {
        if (!this.internalIsCheckedOut()) {
            String msg = this.safeGetJCRPath() + ": cannot set property of a checked-in node";
            log.debug(msg);
            throw new VersionException(msg);
        }
        this.checkLock();
    }

    protected Property internalSetProperty(QName name, InternalValue value) throws ValueFormatException, RepositoryException {
        int type = value == null ? 0 : value.getType();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, false, true, status);
        try {
            if (value == null) {
                prop.internalSetValue(null, type);
            } else {
                prop.internalSetValue(new InternalValue[]{value}, type);
            }
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    protected Property internalSetProperty(QName name, InternalValue[] values) throws ValueFormatException, RepositoryException {
        int type = values == null || values.length == 0 || values[0] == null ? 0 : values[0].getType();
        return this.internalSetProperty(name, values, type);
    }

    protected Property internalSetProperty(QName name, InternalValue[] values, int type) throws ValueFormatException, RepositoryException {
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, true, true, status);
        try {
            prop.internalSetValue(values, type);
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public NodeImpl getNode(QName name) throws ItemNotFoundException, RepositoryException {
        return this.getNode(name, 1);
    }

    public NodeImpl getNode(QName name, int index) throws ItemNotFoundException, RepositoryException {
        NodeState.ChildNodeEntry cne;
        this.sanityCheck();
        NodeState thisState = (NodeState)this.state;
        if (index == 0) {
            index = 1;
        }
        if ((cne = thisState.getChildNodeEntry(name, index)) == null) {
            throw new ItemNotFoundException();
        }
        try {
            return (NodeImpl)this.itemMgr.getItem(cne.getId());
        }
        catch (AccessDeniedException ade) {
            throw new ItemNotFoundException();
        }
    }

    public boolean hasNode(QName name) throws RepositoryException {
        return this.hasNode(name, 1);
    }

    public boolean hasNode(QName name, int index) throws RepositoryException {
        NodeState.ChildNodeEntry cne;
        this.sanityCheck();
        NodeState thisState = (NodeState)this.state;
        if (index == 0) {
            index = 1;
        }
        if ((cne = thisState.getChildNodeEntry(name, index)) == null) {
            return false;
        }
        return this.itemMgr.itemExists(cne.getId());
    }

    public PropertyImpl getProperty(QName name) throws ItemNotFoundException, RepositoryException {
        this.sanityCheck();
        PropertyId propId = new PropertyId(this.getNodeId(), name);
        try {
            return (PropertyImpl)this.itemMgr.getItem(propId);
        }
        catch (AccessDeniedException ade) {
            throw new ItemNotFoundException(name.toString());
        }
    }

    public boolean hasProperty(QName name) throws RepositoryException {
        this.sanityCheck();
        NodeState thisState = (NodeState)this.state;
        if (!thisState.hasPropertyName(name)) {
            return false;
        }
        PropertyId propId = new PropertyId(thisState.getNodeId(), name);
        return this.itemMgr.itemExists(propId);
    }

    public synchronized NodeImpl addNode(QName nodeName, QName nodeTypeName, UUID uuid) throws ItemExistsException, NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.sanityCheck();
        if (!this.internalIsCheckedOut()) {
            String msg = this.safeGetJCRPath() + ": cannot add node to a checked-in node";
            log.debug(msg);
            throw new VersionException(msg);
        }
        this.checkLock();
        NodeTypeImpl nt = null;
        if (nodeTypeName != null) {
            nt = this.session.getNodeTypeManager().getNodeType(nodeTypeName);
        }
        return this.internalAddChildNode(nodeName, nt, uuid == null ? null : new NodeId(uuid));
    }

    public PropertyImpl setProperty(QName name, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        int type = values == null || values.length == 0 || values[0] == null ? 0 : values[0].getType();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, true, false, status);
        try {
            prop.setValue(values);
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public PropertyImpl setProperty(QName name, Value[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, true, true, status);
        try {
            if (prop.getDefinition().getRequiredType() == 0 && type != 0) {
                prop.setValue(ValueHelper.convert(values, type, this.session.getValueFactory()));
            } else {
                prop.setValue(values);
            }
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public PropertyImpl setProperty(QName name, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        int type = 0;
        if (value != null) {
            type = value.getType();
        }
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, false, false, status);
        try {
            prop.setValue(value);
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public QName getQName() throws RepositoryException {
        return this.session.getHierarchyManager().getName(this.id);
    }

    public NodeId getNodeId() {
        return (NodeId)this.id;
    }

    public synchronized void orderBefore(Path.PathElement srcName, Path.PathElement dstName) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        this.sanityCheck();
        if (!this.getPrimaryNodeType().hasOrderableChildNodes()) {
            throw new UnsupportedRepositoryOperationException("child node ordering not supported on node " + this.safeGetJCRPath());
        }
        if (srcName.equals(dstName)) {
            return;
        }
        if (!this.hasNode(srcName.getName(), srcName.getIndex())) {
            String name;
            try {
                name = srcName.toJCRName(this.session.getNamespaceResolver());
            }
            catch (NoPrefixDeclaredException npde) {
                name = srcName.toString();
            }
            throw new ItemNotFoundException(this.safeGetJCRPath() + " has no child node with name " + name);
        }
        if (dstName != null && !this.hasNode(dstName.getName(), dstName.getIndex())) {
            String name;
            try {
                name = dstName.toJCRName(this.session.getNamespaceResolver());
            }
            catch (NoPrefixDeclaredException npde) {
                name = dstName.toString();
            }
            throw new ItemNotFoundException(this.safeGetJCRPath() + " has no child node with name " + name);
        }
        if (!this.internalIsCheckedOut()) {
            String msg = this.safeGetJCRPath() + ": cannot change child node ordering of a checked-in node";
            log.debug(msg);
            throw new VersionException(msg);
        }
        if (this.definition.isProtected()) {
            String msg = this.safeGetJCRPath() + ": cannot change child node ordering of a protected node";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        this.checkLock();
        ArrayList list = new ArrayList(((NodeState)this.state).getChildNodeEntries());
        int srcInd = -1;
        int destInd = -1;
        for (int i = 0; i < list.size(); ++i) {
            NodeState.ChildNodeEntry entry = (NodeState.ChildNodeEntry)list.get(i);
            if (srcInd == -1 && entry.getName().equals(srcName.getName()) && (entry.getIndex() == srcName.getIndex() || srcName.getIndex() == 0 && entry.getIndex() == 1)) {
                srcInd = i;
            }
            if (destInd == -1 && dstName != null) {
                if (!entry.getName().equals(dstName.getName()) || entry.getIndex() != dstName.getIndex() && (dstName.getIndex() != 0 || entry.getIndex() != 1)) continue;
                destInd = i;
                if (srcInd == -1) continue;
                break;
            }
            if (srcInd != -1) break;
        }
        if (destInd == -1 ? srcInd == list.size() - 1 : destInd - srcInd == 1) {
            return;
        }
        if (destInd == -1) {
            list.add(list.remove(srcInd));
        } else if (srcInd < destInd) {
            list.add(destInd, list.get(srcInd));
            list.remove(srcInd);
        } else {
            list.add(destInd, list.remove(srcInd));
        }
        NodeState thisState = (NodeState)this.getOrCreateTransientItemState();
        thisState.setChildNodeEntries(list);
    }

    public boolean isNode() {
        return true;
    }

    public String getName() throws RepositoryException {
        this.sanityCheck();
        if (this.state.getParentId() == null) {
            return "";
        }
        QName name = this.session.getHierarchyManager().getName(this.id);
        try {
            return NameFormat.format(name, this.session.getNamespaceResolver());
        }
        catch (NoPrefixDeclaredException npde) {
            String msg = "internal error: encountered unregistered namespace " + name.getNamespaceURI();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)npde);
        }
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.sanityCheck();
        visitor.visit((Node)this);
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        NodeId parentId = this.state.getParentId();
        if (parentId == null) {
            String msg = "root node doesn't have a parent";
            log.debug(msg);
            throw new ItemNotFoundException(msg);
        }
        return (Node)this.itemMgr.getItem(parentId);
    }

    public synchronized Node addNode(String relPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.sanityCheck();
        return this.internalAddNode(relPath, null);
    }

    public synchronized Node addNode(String relPath, String nodeTypeName) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.sanityCheck();
        NodeTypeImpl nt = (NodeTypeImpl)this.session.getNodeTypeManager().getNodeType(nodeTypeName);
        return this.internalAddNode(relPath, nt);
    }

    public void orderBefore(String srcName, String destName) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        Path.PathElement beforeName;
        Path.PathElement insertName;
        try {
            Path p = PathFormat.parse(srcName, this.session.getNamespaceResolver());
            if (p.isAbsolute() || p.getLength() != 1 || p.getDepth() != 1) {
                throw new RepositoryException("invalid name: " + srcName);
            }
            insertName = p.getNameElement();
        }
        catch (MalformedPathException e) {
            String msg = "invalid name: " + srcName;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        if (destName != null) {
            try {
                Path p = PathFormat.parse(destName, this.session.getNamespaceResolver());
                if (p.isAbsolute() || p.getLength() != 1 || p.getDepth() != 1) {
                    throw new RepositoryException("invalid name: " + destName);
                }
                beforeName = p.getNameElement();
            }
            catch (MalformedPathException e) {
                String msg = "invalid name: " + destName;
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)e);
            }
        } else {
            beforeName = null;
        }
        this.orderBefore(insertName, beforeName);
    }

    public Property setProperty(String name, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        int type = values == null || values.length == 0 || values[0] == null ? 0 : values[0].getType();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, true, false, status);
        try {
            if (prop.getDefinition().getRequiredType() == 0 && type != 0) {
                prop.setValue(ValueHelper.convert(values, type, this.session.getValueFactory()));
            } else {
                prop.setValue(values);
            }
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public Property setProperty(String name, Value[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, true, true, status);
        try {
            if (prop.getDefinition().getRequiredType() == 0 && type != 0) {
                prop.setValue(ValueHelper.convert(values, type, this.session.getValueFactory()));
            } else {
                prop.setValue(values);
            }
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public Property setProperty(String name, String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, 1, true, false, status);
        try {
            prop.setValue(values);
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public Property setProperty(String name, String[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, true, true, status);
        try {
            if (prop.getDefinition().getRequiredType() == 0 && type != 0) {
                prop.setValue(ValueHelper.convert(values, type, this.session.getValueFactory()));
            } else {
                prop.setValue(values);
            }
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public Property setProperty(String name, String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, 1, false, false, status);
        try {
            prop.setValue(value);
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public Property setProperty(String name, String value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, false, true, status);
        try {
            if (prop.getDefinition().getRequiredType() == 0 && type != 0) {
                prop.setValue(ValueHelper.convert(value, type, this.session.getValueFactory()));
            } else {
                prop.setValue(value);
            }
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public Property setProperty(String name, Value value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, false, true, status);
        try {
            if (prop.getDefinition().getRequiredType() == 0 && type != 0) {
                prop.setValue(ValueHelper.convert(value, type, this.session.getValueFactory()));
            } else {
                prop.setValue(value);
            }
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public Property setProperty(String name, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        int type = 0;
        if (value != null) {
            type = value.getType();
        }
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, type, false, false, status);
        try {
            if (prop.getDefinition().getRequiredType() == 0 && type != 0) {
                prop.setValue(ValueHelper.convert(value, type, this.session.getValueFactory()));
            } else {
                prop.setValue(value);
            }
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public Property setProperty(String name, InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, 2, false, false, status);
        try {
            prop.setValue(value);
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public Property setProperty(String name, boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, 6, false, false, status);
        try {
            prop.setValue(value);
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public Property setProperty(String name, double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, 4, false, false, status);
        try {
            prop.setValue(value);
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public Property setProperty(String name, long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, 3, false, false, status);
        try {
            prop.setValue(value);
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public Property setProperty(String name, Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, 5, false, false, status);
        try {
            prop.setValue(value);
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public Property setProperty(String name, Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetProperty();
        BitSet status = new BitSet();
        PropertyImpl prop = this.getOrCreateProperty(name, 9, false, true, status);
        try {
            prop.setValue(value);
        }
        catch (RepositoryException re) {
            if (status.get(0)) {
                this.removeChildProperty(name);
            }
            throw re;
        }
        return prop;
    }

    public Node getNode(String relPath) throws PathNotFoundException, RepositoryException {
        this.sanityCheck();
        NodeId id = this.resolveRelativeNodePath(relPath);
        if (id == null) {
            throw new PathNotFoundException(relPath);
        }
        try {
            return (Node)this.itemMgr.getItem(id);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(relPath);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(relPath);
        }
    }

    public NodeIterator getNodes() throws RepositoryException {
        this.sanityCheck();
        try {
            return this.itemMgr.getChildNodes((NodeId)this.id);
        }
        catch (ItemNotFoundException infe) {
            String msg = "failed to list the child nodes of " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)infe);
        }
        catch (AccessDeniedException ade) {
            String msg = "failed to list the child nodes of " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ade);
        }
    }

    public PropertyIterator getProperties() throws RepositoryException {
        this.sanityCheck();
        try {
            return this.itemMgr.getChildProperties((NodeId)this.id);
        }
        catch (ItemNotFoundException infe) {
            String msg = "failed to list the child properties of " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)infe);
        }
        catch (AccessDeniedException ade) {
            String msg = "failed to list the child properties of " + this.safeGetJCRPath();
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ade);
        }
    }

    public Property getProperty(String relPath) throws PathNotFoundException, RepositoryException {
        this.sanityCheck();
        PropertyId id = this.resolveRelativePropertyPath(relPath);
        if (id == null) {
            throw new PathNotFoundException(relPath);
        }
        try {
            return (Property)this.itemMgr.getItem(id);
        }
        catch (ItemNotFoundException infe) {
            throw new PathNotFoundException(relPath);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(relPath);
        }
    }

    public boolean hasNode(String relPath) throws RepositoryException {
        this.sanityCheck();
        NodeId id = this.resolveRelativeNodePath(relPath);
        if (id != null) {
            return this.itemMgr.itemExists(id);
        }
        return false;
    }

    public boolean hasNodes() throws RepositoryException {
        this.sanityCheck();
        return this.itemMgr.hasChildNodes((NodeId)this.id);
    }

    public boolean hasProperties() throws RepositoryException {
        this.sanityCheck();
        return this.itemMgr.hasChildProperties((NodeId)this.id);
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        QName ntName;
        try {
            ntName = NameFormat.parse(nodeTypeName, this.session.getNamespaceResolver());
        }
        catch (IllegalNameException ine) {
            throw new RepositoryException("invalid node type name: " + nodeTypeName, (Throwable)ine);
        }
        catch (UnknownPrefixException upe) {
            throw new RepositoryException("invalid node type name: " + nodeTypeName, (Throwable)upe);
        }
        return this.isNodeType(ntName);
    }

    public NodeType getPrimaryNodeType() throws RepositoryException {
        this.sanityCheck();
        return this.session.getNodeTypeManager().getNodeType(this.primaryTypeName);
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        this.sanityCheck();
        Set mixinNames = ((NodeState)this.state).getMixinTypeNames();
        if (mixinNames.isEmpty()) {
            return new NodeType[0];
        }
        NodeType[] nta = new NodeType[mixinNames.size()];
        Iterator iter = mixinNames.iterator();
        int i = 0;
        while (iter.hasNext()) {
            nta[i++] = this.session.getNodeTypeManager().getNodeType((QName)iter.next());
        }
        return nta;
    }

    public void addMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        QName ntName;
        try {
            ntName = NameFormat.parse(mixinName, this.session.getNamespaceResolver());
        }
        catch (IllegalNameException ine) {
            throw new RepositoryException("invalid mixin type name: " + mixinName, (Throwable)ine);
        }
        catch (UnknownPrefixException upe) {
            throw new RepositoryException("invalid mixin type name: " + mixinName, (Throwable)upe);
        }
        this.addMixin(ntName);
    }

    public void removeMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        QName ntName;
        try {
            ntName = NameFormat.parse(mixinName, this.session.getNamespaceResolver());
        }
        catch (IllegalNameException ine) {
            throw new RepositoryException("invalid mixin type name: " + mixinName, (Throwable)ine);
        }
        catch (UnknownPrefixException upe) {
            throw new RepositoryException("invalid mixin type name: " + mixinName, (Throwable)upe);
        }
        this.removeMixin(ntName);
    }

    public boolean canAddMixin(String mixinName) throws NoSuchNodeTypeException, RepositoryException {
        QName ntName;
        this.sanityCheck();
        if (!this.internalIsCheckedOut()) {
            return false;
        }
        if (this.definition.isProtected()) {
            return false;
        }
        try {
            this.checkLock();
        }
        catch (LockException le) {
            return false;
        }
        try {
            ntName = NameFormat.parse(mixinName, this.session.getNamespaceResolver());
        }
        catch (IllegalNameException ine) {
            throw new RepositoryException("invalid mixin type name: " + mixinName, (Throwable)ine);
        }
        catch (UnknownPrefixException upe) {
            throw new RepositoryException("invalid mixin type name: " + mixinName, (Throwable)upe);
        }
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        NodeTypeImpl mixin = ntMgr.getNodeType(ntName);
        if (!mixin.isMixin()) {
            return false;
        }
        NodeTypeImpl primaryType = ntMgr.getNodeType(this.primaryTypeName);
        if (primaryType.isDerivedFrom(ntName)) {
            return false;
        }
        NodeTypeRegistry ntReg = ntMgr.getNodeTypeRegistry();
        try {
            HashSet<QName> set = new HashSet<QName>(((NodeState)this.state).getMixinTypeNames());
            set.add(this.primaryTypeName);
            EffectiveNodeType entExisting = ntReg.getEffectiveNodeType(set.toArray(new QName[set.size()]));
            if (entExisting.includesNodeType(ntName)) {
                return false;
            }
            set.add(ntName);
            ntReg.getEffectiveNodeType(set.toArray(new QName[set.size()]));
        }
        catch (NodeTypeConflictException ntce) {
            return false;
        }
        return true;
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        this.sanityCheck();
        PropertyId id = this.resolveRelativePropertyPath(relPath);
        if (id != null) {
            return this.itemMgr.itemExists(id);
        }
        return false;
    }

    public PropertyIterator getReferences() throws RepositoryException {
        this.sanityCheck();
        try {
            NodeReferencesId targetId = new NodeReferencesId((NodeId)this.id);
            if (this.stateMgr.hasNodeReferences(targetId)) {
                NodeReferences refs = this.stateMgr.getNodeReferences(targetId);
                List idList = refs.getReferences();
                return new LazyItemIterator(this.itemMgr, idList);
            }
            return IteratorHelper.EMPTY;
        }
        catch (ItemStateException e) {
            String msg = "Unable to retrieve REFERENCE properties that refer to " + this.id;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        this.sanityCheck();
        return this.definition;
    }

    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        this.sanityCheck();
        ArrayList nodes = new ArrayList();
        this.accept((ItemVisitor)new ChildrenCollectorFilter(namePattern, nodes, true, false, 1));
        return new IteratorHelper(Collections.unmodifiableList(nodes));
    }

    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        this.sanityCheck();
        ArrayList properties = new ArrayList();
        this.accept((ItemVisitor)new ChildrenCollectorFilter(namePattern, properties, false, true, 1));
        return new IteratorHelper(Collections.unmodifiableList(properties));
    }

    public Item getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        this.sanityCheck();
        String name = this.getPrimaryNodeType().getPrimaryItemName();
        if (name == null) {
            throw new ItemNotFoundException();
        }
        if (this.hasProperty(name)) {
            return this.getProperty(name);
        }
        if (this.hasNode(name)) {
            return this.getNode(name);
        }
        throw new ItemNotFoundException();
    }

    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.sanityCheck();
        if (!this.isNodeType(QName.MIX_REFERENCEABLE)) {
            throw new UnsupportedRepositoryOperationException();
        }
        return this.internalGetUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCorrespondingNodePath(String workspaceName) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        SessionImpl srcSession = null;
        try {
            String relPath;
            srcSession = this.rep.createSession(this.session.getSubject(), workspaceName);
            NodeImpl m1 = this;
            while (m1.getDepth() != 0 && !m1.isNodeType(QName.MIX_REFERENCEABLE)) {
                m1 = (NodeImpl)m1.getParent();
            }
            if (m1.getDepth() == 0) {
                if (!srcSession.getItemManager().itemExists(this.getPrimaryPath())) {
                    throw new ItemNotFoundException(this.safeGetJCRPath());
                }
                String string = this.getPath();
                return string;
            }
            Node m2 = srcSession.getNodeByUUID(m1.getUUID());
            if (m1 == this) {
                String string = m2.getPath();
                return string;
            }
            try {
                Path p = m1.getPrimaryPath().computeRelativePath(this.getPrimaryPath());
                relPath = PathFormat.format(p, srcSession.getNamespaceResolver());
            }
            catch (NameException be) {
                String msg = "internal error: failed to determine relative path";
                log.error(msg, (Throwable)be);
                throw new RepositoryException(msg, (Throwable)be);
            }
            if (!m2.hasNode(relPath)) {
                throw new ItemNotFoundException();
            }
            String string = m2.getNode(relPath).getPath();
            return string;
        }
        finally {
            if (srcSession != null) {
                srcSession.logout();
            }
        }
    }

    public int getIndex() throws RepositoryException {
        this.sanityCheck();
        NodeId parentId = this.state.getParentId();
        if (parentId == null) {
            return 1;
        }
        try {
            NodeState parent = (NodeState)this.stateMgr.getItemState(parentId);
            NodeState.ChildNodeEntry parentEntry = parent.getChildNodeEntry(this.getNodeId());
            return parentEntry.getIndex();
        }
        catch (ItemStateException ise) {
            String msg = "internal error: failed to determine index";
            log.error(msg, (Throwable)ise);
            throw new RepositoryException(msg, (Throwable)ise);
        }
    }

    public Version checkin() throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        this.sanityCheck();
        this.checkVersionable();
        if (!this.internalIsCheckedOut()) {
            String msg = this.safeGetJCRPath() + ": Node is already checked-in. ignoring.";
            log.debug(msg);
            return this.getBaseVersion();
        }
        if (this.hasPendingChanges()) {
            String msg = "Unable to checkin node. Node has pending changes: " + this.safeGetJCRPath();
            log.debug(msg);
            throw new InvalidItemStateException(msg);
        }
        this.checkLock();
        Version v = this.session.getVersionManager().checkin(this);
        Property prop = this.internalSetProperty(QName.JCR_ISCHECKEDOUT, InternalValue.create(false));
        prop.save();
        prop = this.internalSetProperty(QName.JCR_BASEVERSION, InternalValue.create(new UUID(v.getUUID())));
        prop.save();
        prop = this.internalSetProperty(QName.JCR_PREDECESSORS, InternalValue.EMPTY_ARRAY, 9);
        prop.save();
        return v;
    }

    public void checkout() throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.sanityCheck();
        this.checkVersionable();
        if (this.internalIsCheckedOut()) {
            String msg = this.safeGetJCRPath() + ": Node is already checked-out. ignoring.";
            log.debug(msg);
            return;
        }
        this.checkLock();
        Property prop = this.internalSetProperty(QName.JCR_ISCHECKEDOUT, InternalValue.create(true));
        prop.save();
        prop = this.internalSetProperty(QName.JCR_PREDECESSORS, new InternalValue[]{InternalValue.create(new UUID(this.getBaseVersion().getUUID()))});
        prop.save();
    }

    public void update(String srcWorkspaceName) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        this.internalMerge(srcWorkspaceName, null, false);
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        ArrayList failedIds = new ArrayList();
        this.internalMerge(srcWorkspace, failedIds, bestEffort);
        return new LazyItemIterator(this.itemMgr, failedIds);
    }

    public void cancelMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.internalFinishMerge(version, true);
    }

    public void doneMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.internalFinishMerge(version, false);
    }

    public boolean isCheckedOut() throws RepositoryException {
        this.sanityCheck();
        return this.internalIsCheckedOut();
    }

    public void restore(String versionName, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.sanityCheck();
        this.checkSessionHasPending();
        this.checkLock();
        Version v = this.getVersionHistory().getVersion(versionName);
        DateVersionSelector gvs = new DateVersionSelector(v.getCreated());
        this.internalRestore(v, (VersionSelector)gvs, removeExisting);
    }

    public void restore(Version version, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.sanityCheck();
        this.checkSessionHasPending();
        this.checkVersionable();
        this.checkLock();
        if (!version.getContainingHistory().isSame((Item)this.getVersionHistory())) {
            throw new VersionException("Unable to restore version. Not same version history.");
        }
        this.internalRestore(version, (VersionSelector)new DateVersionSelector(version.getCreated()), removeExisting);
    }

    public void restore(Version version, String relPath, boolean removeExisting) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.sanityCheck();
        this.checkSessionHasPending();
        this.checkLock();
        if (this.hasNode(relPath)) {
            this.getNode(relPath).restore(version, removeExisting);
        } else {
            NodeImpl node;
            block8: {
                try {
                    InternalFrozenNode fn = ((VersionImpl)version).getFrozenNode();
                    node = (NodeImpl)this.session.getNodeByUUID(fn.getFrozenUUID());
                    if (removeExisting) {
                        try {
                            Path dstPath = PathFormat.parse(this.getPrimaryPath(), relPath, this.session.getNamespaceResolver()).getCanonicalPath();
                            this.session.move(node.getPath(), PathFormat.format(dstPath, this.session.getNamespaceResolver()));
                            node = (NodeImpl)this.session.getNodeByUUID(fn.getFrozenUUID());
                            break block8;
                        }
                        catch (MalformedPathException e) {
                            throw new RepositoryException((Throwable)e);
                        }
                        catch (NoPrefixDeclaredException e) {
                            throw new RepositoryException("InternalError.", (Throwable)e);
                        }
                    }
                    throw new ItemExistsException("Unable to restore version. Versionable node already exists.");
                }
                catch (ItemNotFoundException e) {
                    node = this.addNode(relPath, ((VersionImpl)version).getFrozenNode());
                }
            }
            node.internalRestore(version, (VersionSelector)new DateVersionSelector(version.getCreated()), removeExisting);
        }
    }

    public void restoreByLabel(String versionLabel, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.sanityCheck();
        this.checkSessionHasPending();
        this.checkLock();
        Version v = this.getVersionHistory().getVersionByLabel(versionLabel);
        if (v == null) {
            throw new VersionException("No version for label " + versionLabel + " found.");
        }
        this.internalRestore(v, (VersionSelector)new LabelVersionSelector(versionLabel), removeExisting);
    }

    public VersionHistory getVersionHistory() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.sanityCheck();
        this.checkVersionable();
        NodeId id = NodeId.valueOf(this.getProperty(QName.JCR_VERSIONHISTORY).getString());
        this.session.getVersionManager().getVersionHistory(id);
        return (VersionHistory)this.getProperty(QName.JCR_VERSIONHISTORY).getNode();
    }

    public Version getBaseVersion() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.sanityCheck();
        this.checkVersionable();
        NodeId id = NodeId.valueOf(this.getProperty(QName.JCR_BASEVERSION).getString());
        this.session.getVersionManager().getVersion(id);
        return (Version)this.getProperty(QName.JCR_BASEVERSION).getNode();
    }

    private void checkVersionable() throws UnsupportedRepositoryOperationException, RepositoryException {
        if (!this.isNodeType(QName.MIX_VERSIONABLE)) {
            String msg = "Unable to perform versioning operation on non versionable node: " + this.safeGetJCRPath();
            log.debug(msg);
            throw new UnsupportedRepositoryOperationException(msg);
        }
    }

    private void checkSessionHasPending() throws InvalidItemStateException, RepositoryException {
        if (this.session.hasPendingChanges()) {
            String msg = "Unable to perform operation. Session has pending changes.";
            log.debug(msg);
            throw new InvalidItemStateException(msg);
        }
    }

    private NodeImpl getCorrespondingNode(SessionImpl srcSession) throws AccessDeniedException, RepositoryException {
        NodeImpl m1 = this;
        while (!m1.isNodeType(QName.MIX_REFERENCEABLE)) {
            if (m1.getDepth() == 0) {
                try {
                    return (NodeImpl)srcSession.getItem(this.getPath());
                }
                catch (PathNotFoundException e) {
                    return null;
                }
            }
            m1 = (NodeImpl)m1.getParent();
        }
        try {
            String relPath;
            NodeImpl m2 = (NodeImpl)srcSession.getNodeByUUID(m1.getUUID());
            if (m1 == this) {
                return m2;
            }
            try {
                Path p = m1.getPrimaryPath().computeRelativePath(this.getPrimaryPath());
                relPath = PathFormat.format(p, srcSession.getNamespaceResolver());
            }
            catch (NameException be) {
                String msg = "internal error: failed to determine relative path";
                log.error(msg, (Throwable)be);
                throw new RepositoryException(msg, (Throwable)be);
            }
            if (!m2.hasNode(relPath)) {
                return null;
            }
            return (NodeImpl)m2.getNode(relPath);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    private NodeImpl doMergeTest(SessionImpl srcSession, List failedIds, boolean bestEffort) throws RepositoryException, AccessDeniedException {
        NodeImpl srcNode = this.getCorrespondingNode(srcSession);
        if (srcNode == null) {
            return null;
        }
        if (!this.isNodeType(QName.MIX_VERSIONABLE) || failedIds == null) {
            return srcNode;
        }
        if (!srcNode.isNodeType(QName.MIX_VERSIONABLE)) {
            return null;
        }
        VersionImpl v = (VersionImpl)this.getBaseVersion();
        VersionImpl vp = (VersionImpl)srcNode.getBaseVersion();
        if (vp.isMoreRecent(v) && !this.isCheckedOut()) {
            return srcNode;
        }
        if (v.isSame(vp) || v.isMoreRecent(vp)) {
            return null;
        }
        if (bestEffort) {
            Set set = this.internalGetMergeFailed();
            set.add(srcNode.getBaseVersion().getUUID());
            this.internalSetMergeFailed(set);
            failedIds.add(this.state.getId());
            return null;
        }
        String msg = "Unable to merge nodes. Violating versions. " + this.safeGetJCRPath();
        log.debug(msg);
        throw new MergeException(msg);
    }

    private void internalFinishMerge(Version version, boolean cancel) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.sanityCheck();
        if (this.hasPendingChanges()) {
            String msg = "Unable to finish merge. Node has pending changes: " + this.safeGetJCRPath();
            log.debug(msg);
            throw new InvalidItemStateException(msg);
        }
        this.checkVersionable();
        this.checkLock();
        if (!this.internalIsCheckedOut()) {
            String msg = "Unable to finish merge. Node is checked-in: " + this.safeGetJCRPath();
            log.error(msg);
            throw new VersionException(msg);
        }
        Set failed = this.internalGetMergeFailed();
        if (!failed.remove(version.getUUID())) {
            String msg = "Unable to finish merge. Specified version is not in jcr:mergeFailed property: " + this.safeGetJCRPath();
            log.error(msg);
            throw new VersionException(msg);
        }
        this.internalSetMergeFailed(failed);
        if (!cancel) {
            Value[] vals = this.getProperty(QName.JCR_PREDECESSORS).getValues();
            InternalValue[] v = new InternalValue[vals.length + 1];
            for (int i = 0; i < vals.length; ++i) {
                v[i] = InternalValue.create(UUID.fromString(vals[i].getString()));
            }
            v[vals.length] = InternalValue.create(UUID.fromString(version.getUUID()));
            this.internalSetProperty(QName.JCR_PREDECESSORS, v);
        }
        this.save();
    }

    private Set internalGetMergeFailed() throws RepositoryException {
        HashSet<String> set = new HashSet<String>();
        if (this.hasProperty(QName.JCR_MERGEFAILED)) {
            Value[] vals = this.getProperty(QName.JCR_MERGEFAILED).getValues();
            for (int i = 0; i < vals.length; ++i) {
                set.add(vals[i].getString());
            }
        }
        return set;
    }

    private void internalSetMergeFailed(Set set) throws RepositoryException {
        if (set.isEmpty()) {
            this.internalSetProperty(QName.JCR_MERGEFAILED, (InternalValue[])null);
        } else {
            InternalValue[] vals = new InternalValue[set.size()];
            Iterator iter = set.iterator();
            int i = 0;
            while (iter.hasNext()) {
                String uuid = (String)iter.next();
                vals[i++] = InternalValue.create(UUID.fromString(uuid));
            }
            this.internalSetProperty(QName.JCR_MERGEFAILED, vals);
        }
    }

    protected boolean internalIsCheckedOut() throws RepositoryException {
        if (this.isNew()) {
            return true;
        }
        NodeImpl node = this;
        while (!node.hasProperty(QName.JCR_ISCHECKEDOUT)) {
            if (node.getDepth() == 0) {
                return true;
            }
            node = (NodeImpl)node.getParent();
        }
        return node.getProperty(QName.JCR_ISCHECKEDOUT).getBoolean();
    }

    private NodeImpl addNode(QName name, InternalFrozenNode frozen) throws ItemExistsException, PathNotFoundException, ConstraintViolationException, NoSuchNodeTypeException, RepositoryException {
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        NodeTypeImpl nt = ntMgr.getNodeType(frozen.getFrozenPrimaryType());
        UUID uuid = frozen.getFrozenUUID();
        NodeImpl node = this.internalAddChildNode(name, nt, new NodeId(uuid));
        QName[] mxNames = frozen.getFrozenMixinTypes();
        for (int i = 0; i < mxNames.length; ++i) {
            node.addMixin(mxNames[i]);
        }
        return node;
    }

    private NodeImpl addNode(String relPath, InternalFrozenNode frozen) throws ItemExistsException, PathNotFoundException, ConstraintViolationException, NoSuchNodeTypeException, RepositoryException {
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        NodeTypeImpl nt = ntMgr.getNodeType(frozen.getFrozenPrimaryType());
        UUID uuid = frozen.getFrozenUUID();
        NodeImpl node = this.internalAddNode(relPath, nt, new NodeId(uuid));
        QName[] mxNames = frozen.getFrozenMixinTypes();
        for (int i = 0; i < mxNames.length; ++i) {
            node.addMixin(mxNames[i]);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalMerge(String srcWorkspaceName, List failedIds, boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        boolean removeExisting = true;
        boolean replaceExisting = false;
        this.sanityCheck();
        this.checkSessionHasPending();
        if (srcWorkspaceName.equals(this.session.getWorkspace().getName())) {
            return;
        }
        SessionImpl srcSession = null;
        try {
            srcSession = this.rep.createSession(this.session.getSubject(), srcWorkspaceName);
            try {
                this.internalMerge(srcSession, failedIds, bestEffort, removeExisting, replaceExisting);
            }
            catch (RepositoryException e) {
                try {
                    this.session.refresh(false);
                }
                catch (RepositoryException e1) {
                    // empty catch block
                }
                throw e;
            }
            this.session.save();
        }
        finally {
            if (srcSession != null) {
                srcSession.logout();
            }
        }
    }

    private void internalMerge(SessionImpl srcSession, List failedIds, boolean bestEffort, boolean removeExisting, boolean replaceExisting) throws LockException, RepositoryException {
        PropertyImpl p;
        NodeImpl srcNode = this.doMergeTest(srcSession, failedIds, bestEffort);
        if (srcNode == null) {
            NodeIterator iter = this.getNodes();
            while (iter.hasNext()) {
                NodeImpl n = (NodeImpl)iter.nextNode();
                n.internalMerge(srcSession, failedIds, bestEffort, removeExisting, replaceExisting);
            }
            return;
        }
        this.checkLock();
        PropertyIterator iter = this.getProperties();
        while (iter.hasNext()) {
            p = (PropertyImpl)iter.nextProperty();
            if (srcNode.hasProperty(p.getQName())) continue;
            p.internalRemove(true);
        }
        iter = srcNode.getProperties();
        while (iter.hasNext()) {
            p = (PropertyImpl)iter.nextProperty();
            if (p.getQName().equals(QName.JCR_PRIMARYTYPE) || p.getQName().equals(QName.JCR_MIXINTYPES) || p.getQName().equals(QName.JCR_UUID)) continue;
            if (p.getDefinition().isMultiple()) {
                this.internalSetProperty(p.getQName(), p.internalGetValues());
                continue;
            }
            this.internalSetProperty(p.getQName(), p.internalGetValue());
        }
        NodeIterator niter = this.getNodes();
        while (niter.hasNext()) {
            NodeImpl n = (NodeImpl)niter.nextNode();
            Path.PathElement name = n.getPrimaryPath().getNameElement();
            int idx = name.getIndex();
            if (idx == 0) {
                idx = 1;
            }
            if (srcNode.hasNode(name.getName(), idx)) continue;
            n.internalRemove(true);
        }
        niter = srcNode.getNodes();
        while (niter.hasNext()) {
            int idx;
            Path.PathElement name;
            NodeId childId;
            NodeImpl dstNode;
            NodeImpl child;
            block19: {
                child = (NodeImpl)niter.nextNode();
                dstNode = null;
                childId = child.getNodeId();
                name = child.getPrimaryPath().getNameElement();
                idx = name.getIndex();
                if (idx == 0) {
                    idx = 1;
                }
                if (child.isNodeType(QName.MIX_REFERENCEABLE)) {
                    try {
                        dstNode = this.session.getNodeById(childId);
                        if (dstNode.getParent().isSame((Item)srcNode)) break block19;
                        if (removeExisting) {
                            dstNode.internalRemove(false);
                            dstNode = null;
                        } else if (!replaceExisting) {
                            throw new ItemExistsException("Unable to update node: " + dstNode.safeGetJCRPath());
                        }
                    }
                    catch (ItemNotFoundException e) {}
                } else {
                    childId = null;
                }
            }
            if (dstNode == null && this.hasNode(name.getName(), idx)) {
                dstNode = this.getNode(name.getName(), idx);
            }
            if (dstNode == null) {
                dstNode = this.internalAddChildNode(name.getName(), (NodeTypeImpl)child.getPrimaryNodeType(), childId);
                NodeType[] mixins = child.getMixinNodeTypes();
                for (int i = 0; i < mixins.length; ++i) {
                    dstNode.addMixin(mixins[i].getName());
                }
                dstNode.internalMerge(srcSession, null, bestEffort, removeExisting, replaceExisting);
                continue;
            }
            dstNode.internalMerge(srcSession, failedIds, bestEffort, removeExisting, replaceExisting);
        }
    }

    private void internalRestore(Version version, VersionSelector vsel, boolean removeExisting) throws UnsupportedRepositoryOperationException, RepositoryException {
        try {
            this.internalRestore((VersionImpl)version, vsel, removeExisting);
        }
        catch (RepositoryException e) {
            try {
                log.error("reverting changes applied during restore...");
                this.session.refresh(false);
            }
            catch (RepositoryException e1) {
                // empty catch block
            }
            throw e;
        }
        this.session.save();
    }

    protected Version[] internalRestore(VersionImpl version, VersionSelector vsel, boolean removeExisting) throws RepositoryException {
        if (version.isRootVersion()) {
            throw new VersionException("Restore of root version not allowed.");
        }
        this.internalSetProperty(QName.JCR_ISCHECKEDOUT, InternalValue.create(true));
        HashSet<VersionImpl> restored = new HashSet<VersionImpl>();
        this.restoreFrozenState(version.getFrozenNode(), vsel, restored, removeExisting);
        restored.add(version);
        UUID uuid = ((NodeId)version.getId()).getUUID();
        this.internalSetProperty(QName.JCR_BASEVERSION, InternalValue.create(uuid));
        this.internalSetProperty(QName.JCR_PREDECESSORS, InternalValue.EMPTY_ARRAY, 9);
        this.internalSetProperty(QName.JCR_MERGEFAILED, (InternalValue[])null);
        this.internalSetProperty(QName.JCR_ISCHECKEDOUT, InternalValue.create(false));
        return restored.toArray(new Version[restored.size()]);
    }

    void restoreFrozenState(InternalFrozenNode freeze, VersionSelector vsel, Set restored, boolean removeExisting) throws RepositoryException {
        Object prop;
        if (this.isNodeType(QName.MIX_REFERENCEABLE)) {
            UUID uuid = freeze.getFrozenUUID();
            if (!this.internalGetUUID().equals(uuid)) {
                throw new ItemExistsException("Unable to restore version of " + this.safeGetJCRPath() + ". UUID changed.");
            }
        }
        if (!freeze.getFrozenPrimaryType().equals(this.primaryTypeName)) {
            throw new ItemExistsException("Unable to restore version of " + this.safeGetJCRPath() + ". PrimaryType changed.");
        }
        QName[] mixinNames = freeze.getFrozenMixinTypes();
        this.setMixinTypesProperty(new HashSet<QName>(Arrays.asList(mixinNames)));
        PropertyState[] props = freeze.getFrozenProperties();
        HashSet<QName> propNames = new HashSet<QName>();
        for (int i = 0; i < props.length; ++i) {
            prop = props[i];
            propNames.add(((PropertyState)prop).getName());
            if (((PropertyState)prop).isMultiValued()) {
                this.internalSetProperty(props[i].getName(), ((PropertyState)prop).getValues());
                continue;
            }
            this.internalSetProperty(props[i].getName(), ((PropertyState)prop).getValues()[0]);
        }
        PropertyIterator piter = this.getProperties();
        while (piter.hasNext()) {
            prop = (PropertyImpl)piter.nextProperty();
            if (((PropertyImpl)prop).getQName().equals(QName.JCR_VERSIONHISTORY) || ((PropertyImpl)prop).getQName().equals(QName.JCR_PREDECESSORS) || ((PropertyImpl)prop).getDefinition().getOnParentVersion() != 1 && ((PropertyImpl)prop).getDefinition().getOnParentVersion() != 2 || propNames.contains(((PropertyImpl)prop).getQName())) continue;
            this.removeChildProperty(((PropertyImpl)prop).getQName());
        }
        NodeTypeManagerImpl ntMgr = this.session.getNodeTypeManager();
        for (int j = 0; j < mixinNames.length; ++j) {
            NodeTypeImpl mixin = ntMgr.getNodeType(mixinNames[j]);
            PropertyDefinition[] pda = mixin.getAutoCreatedPropertyDefinitions();
            for (int i = 0; i < pda.length; ++i) {
                PropertyDefinitionImpl pd = (PropertyDefinitionImpl)pda[i];
                if (this.hasProperty(pd.getQName())) continue;
                this.createChildProperty(pd.getQName(), pd.getRequiredType(), pd);
            }
        }
        NodeIterator iter = this.getNodes();
        while (iter.hasNext()) {
            UUID vhUUID;
            NodeImpl n = (NodeImpl)iter.nextNode();
            if (n.getDefinition().getOnParentVersion() == 1) {
                n.internalRemove(true);
                continue;
            }
            if (n.getDefinition().getOnParentVersion() != 2) continue;
            UUID uUID = vhUUID = n.hasProperty(QName.JCR_VERSIONHISTORY) ? new UUID(n.getProperty(QName.JCR_VERSIONHISTORY).getString()) : null;
            if (vhUUID != null && freeze.hasFrozenHistory(vhUUID)) continue;
            n.internalRemove(true);
        }
        InternalFreeze[] frozenNodes = freeze.getFrozenChildNodes();
        for (int i = 0; i < frozenNodes.length; ++i) {
            InternalFreeze f;
            InternalFreeze child = frozenNodes[i];
            NodeImpl restoredChild = null;
            if (child instanceof InternalFrozenNode) {
                f = (InternalFrozenNode)child;
                if (f.getFrozenUUID() != null) {
                    try {
                        NodeImpl existing = (NodeImpl)this.session.getNodeByUUID(f.getFrozenUUID());
                        if (!removeExisting) {
                            throw new ItemExistsException("Unable to restore node, item already exists outside of restored tree: " + existing.safeGetJCRPath());
                        }
                        existing.remove();
                    }
                    catch (ItemNotFoundException e) {
                        // empty catch block
                    }
                }
                restoredChild = this.addNode(f.getName(), (InternalFrozenNode)f);
                restoredChild.restoreFrozenState((InternalFrozenNode)f, vsel, restored, removeExisting);
            } else if (child instanceof InternalFrozenVersionHistory) {
                f = (InternalFrozenVersionHistory)child;
                VersionHistory history = (VersionHistory)this.session.getNodeById(f.getVersionHistoryId());
                NodeId nodeId = NodeId.valueOf(history.getVersionableUUID());
                String oldVersion = "jcr:dummy";
                if (this.itemMgr.itemExists(nodeId)) {
                    NodeImpl n = this.session.getNodeById(nodeId);
                    if (removeExisting) {
                        String dstPath = this.getPath() + "/" + n.getName();
                        if (!n.getPath().equals(dstPath)) {
                            this.session.move(n.getPath(), dstPath);
                        }
                        oldVersion = n.getBaseVersion().getName();
                    } else if (n.getParent().isSame((Item)this)) {
                        n.internalRemove(true);
                    } else {
                        throw new ItemExistsException("Unable to restore node, item already exists outside of restored tree: " + n.safeGetJCRPath());
                    }
                }
                VersionImpl v = (VersionImpl)vsel.select(history);
                if (!this.itemMgr.itemExists(nodeId)) {
                    if (v == null) {
                        Version[] vs = history.getRootVersion().getSuccessors();
                        if (vs.length == 0) {
                            String msg = "Unable to select appropariate version for " + child.getName() + " using " + vsel;
                            log.error(msg);
                            throw new VersionException(msg);
                        }
                        v = (VersionImpl)vs[0];
                    }
                    restoredChild = this.addNode(child.getName(), v.getFrozenNode());
                } else {
                    restoredChild = this.session.getNodeById(nodeId);
                    if (v == null || oldVersion == null || v.getName().equals(oldVersion)) {
                        v = null;
                    }
                }
                if (v != null) {
                    try {
                        restoredChild.internalRestore(v, vsel, removeExisting);
                    }
                    catch (RepositoryException e) {
                        log.error("Error while restoring node: " + e.toString());
                        log.error("  child path: " + restoredChild.safeGetJCRPath());
                        log.error("  selected version: " + v.getName());
                        StringBuffer avail = new StringBuffer();
                        VersionIterator vi = history.getAllVersions();
                        while (vi.hasNext()) {
                            avail.append(vi.nextVersion().getName());
                            if (!vi.hasNext()) continue;
                            avail.append(", ");
                        }
                        log.error("  available versions: " + avail);
                        log.error("  versionselector: " + vsel);
                        throw e;
                    }
                    restored.add(v);
                }
            }
            if (restoredChild == null || !this.getPrimaryNodeType().hasOrderableChildNodes()) continue;
            this.orderBefore(restoredChild.getPrimaryPath().getNameElement(), null);
        }
    }

    protected void internalCopyPropertyFrom(PropertyImpl prop) throws RepositoryException {
        if (prop.getDefinition().isMultiple()) {
            Value[] values = prop.getValues();
            InternalValue[] ivalues = new InternalValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                ivalues[i] = InternalValue.create(values[i], this.session.getNamespaceResolver());
            }
            this.internalSetProperty(prop.getQName(), ivalues);
        } else {
            InternalValue value = InternalValue.create(prop.getValue(), this.session.getNamespaceResolver());
            this.internalSetProperty(prop.getQName(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock lock(boolean isDeep, boolean isSessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        LockManager lockMgr;
        this.sanityCheck();
        if (this.hasPendingChanges()) {
            String msg = "Unable to lock node. Node has pending changes: " + this.safeGetJCRPath();
            log.debug(msg);
            throw new InvalidItemStateException(msg);
        }
        this.checkLockable();
        LockManager lockManager = lockMgr = this.session.getLockManager();
        synchronized (lockManager) {
            Lock lock = lockMgr.lock(this, isDeep, isSessionScoped);
            boolean succeeded = false;
            try {
                this.internalSetProperty(QName.JCR_LOCKOWNER, InternalValue.create(this.getSession().getUserID()));
                this.internalSetProperty(QName.JCR_LOCKISDEEP, InternalValue.create(isDeep));
                this.save();
                succeeded = true;
            }
            finally {
                if (!succeeded) {
                    try {
                        lockMgr.unlock(this);
                        this.refresh(false);
                    }
                    catch (RepositoryException re) {
                        log.error("error while cleaning up after failed lock attempt", (Throwable)re);
                    }
                }
            }
            return lock;
        }
    }

    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        this.sanityCheck();
        if (this.isNew()) {
            throw new LockException("Node not locked: " + this.safeGetJCRPath());
        }
        return this.session.getLockManager().getLock(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        LockManager lockMgr;
        this.sanityCheck();
        if (this.hasPendingChanges()) {
            String msg = "Unable to unlock node. Node has pending changes: " + this.safeGetJCRPath();
            log.debug(msg);
            throw new InvalidItemStateException(msg);
        }
        this.checkLockable();
        LockManager lockManager = lockMgr = this.session.getLockManager();
        synchronized (lockManager) {
            if (lockMgr.holdsLock(this)) {
                this.internalSetProperty(QName.JCR_LOCKOWNER, (InternalValue)null);
                this.internalSetProperty(QName.JCR_LOCKISDEEP, (InternalValue)null);
                this.save();
            }
            lockMgr.unlock(this);
        }
    }

    public boolean holdsLock() throws RepositoryException {
        this.sanityCheck();
        if (!this.isNodeType(QName.MIX_LOCKABLE) || this.isNew()) {
            return false;
        }
        return this.session.getLockManager().holdsLock(this);
    }

    public boolean isLocked() throws RepositoryException {
        this.sanityCheck();
        if (this.isNew()) {
            return false;
        }
        return this.session.getLockManager().isLocked(this);
    }

    private void checkLockable() throws LockException, RepositoryException {
        if (!this.isNodeType(QName.MIX_LOCKABLE)) {
            String msg = "Unable to perform locking operation on non-lockable node: " + this.safeGetJCRPath();
            log.debug(msg);
            throw new LockException(msg);
        }
    }

    protected void checkLock() throws LockException, RepositoryException {
        if (this.isNew()) {
            return;
        }
        this.session.getLockManager().checkLock(this);
    }
}

