/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.ext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.NewspaperTable;
import org.apache.myfaces.component.html.ext.HtmlDataTable;
import org.apache.myfaces.custom.column.HtmlColumn;
import org.apache.myfaces.custom.column.HtmlSimpleColumn;
import org.apache.myfaces.custom.crosstable.UIColumns;
import org.apache.myfaces.renderkit.html.util.ColumnInfo;
import org.apache.myfaces.renderkit.html.util.RowInfo;
import org.apache.myfaces.renderkit.html.util.TableContext;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlTableRendererBase;
import org.apache.myfaces.shared_tomahawk.util.ArrayUtils;

public class HtmlTableRenderer
extends HtmlTableRendererBase {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$ext$HtmlTableRenderer == null ? (class$org$apache$myfaces$renderkit$html$ext$HtmlTableRenderer = HtmlTableRenderer.class$("org.apache.myfaces.renderkit.html.ext.HtmlTableRenderer")) : class$org$apache$myfaces$renderkit$html$ext$HtmlTableRenderer));
    public static final String DETAIL_STAMP_FACET_NAME = "detailStamp";
    private static final String BODY_STYLE_CLASS = "bodyStyleClass";
    private static final String BODY_STYLE = "bodyStyle";
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$ext$HtmlTableRenderer;

    protected int getNewspaperColumns(UIComponent component) {
        if (component instanceof NewspaperTable) {
            NewspaperTable newspaperTable = (NewspaperTable)component;
            return newspaperTable.getNewspaperColumns();
        }
        return super.getNewspaperColumns(component);
    }

    protected UIComponent getNewspaperTableSpacer(UIComponent component) {
        if (component instanceof NewspaperTable) {
            NewspaperTable newspaperTable = (NewspaperTable)component;
            return newspaperTable.getSpacer();
        }
        return super.getNewspaperTableSpacer(component);
    }

    protected boolean hasNewspaperTableSpacer(UIComponent component) {
        if (null != this.getNewspaperTableSpacer(component)) {
            return true;
        }
        return super.hasNewspaperTableSpacer(component);
    }

    protected boolean isNewspaperHorizontalOrientation(UIComponent component) {
        if (component instanceof NewspaperTable) {
            NewspaperTable newspaperTable = (NewspaperTable)component;
            return "horizontal".equals(newspaperTable.getNewspaperOrientation());
        }
        return super.isNewspaperHorizontalOrientation(component);
    }

    protected void startTable(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        boolean embedded = this.isEmbeddedTable(uiComponent);
        if (!embedded) {
            super.startTable(facesContext, uiComponent);
        }
    }

    protected String determineHeaderFooterTag(FacesContext facesContext, UIComponent component, boolean header) {
        if (this.isEmbeddedTable(component)) {
            return null;
        }
        return super.determineHeaderFooterTag(facesContext, component, header);
    }

    protected String determineHeaderCellTag(FacesContext facesContext, UIComponent component) {
        if (this.isEmbeddedTable(component)) {
            return "td";
        }
        return "th";
    }

    protected void renderTableHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, UIComponent facet, String styleClass, String colElementName, int colspan) throws IOException {
        if (this.isEmbeddedTable(component)) {
            colElementName = "td";
        }
        super.renderTableHeaderOrFooterRow(facesContext, writer, component, facet, styleClass, colElementName, colspan);
    }

    protected boolean isEmbeddedTable(UIComponent uiComponent) {
        boolean embedded = false;
        if (uiComponent instanceof HtmlDataTable) {
            HtmlDataTable table = (HtmlDataTable)uiComponent;
            embedded = table.isEmbedded();
        }
        return embedded;
    }

    protected boolean isDetailStampAfterRow(UIComponent uiComponent) {
        if (uiComponent instanceof HtmlDataTable) {
            return "after".equals(((HtmlDataTable)uiComponent).getDetailStampLocation());
        }
        return true;
    }

    protected void endTable(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        boolean embedded = this.isEmbeddedTable(uiComponent);
        if (!embedded) {
            super.endTable(facesContext, uiComponent);
        }
    }

    protected void beforeRow(FacesContext facesContext, UIData uiData) throws IOException {
        super.beforeRow(facesContext, uiData);
        if (!this.isDetailStampAfterRow((UIComponent)uiData)) {
            this.renderDetailRow(facesContext, uiData);
        }
    }

    protected void afterRow(FacesContext facesContext, UIData uiData) throws IOException {
        super.afterRow(facesContext, uiData);
        if (this.isDetailStampAfterRow((UIComponent)uiData)) {
            this.renderDetailRow(facesContext, uiData);
        }
    }

    private void renderDetailRow(FacesContext facesContext, UIData uiData) throws IOException {
        HtmlDataTable htmlDataTable;
        UIComponent detailStampFacet = uiData.getFacet(DETAIL_STAMP_FACET_NAME);
        if (uiData instanceof HtmlDataTable && (htmlDataTable = (HtmlDataTable)uiData).isCurrentDetailExpanded()) {
            boolean embedded = false;
            if (detailStampFacet != null) {
                embedded = this.isEmbeddedTable(detailStampFacet);
            }
            ResponseWriter writer = facesContext.getResponseWriter();
            if (!embedded) {
                writer.startElement("tr", (UIComponent)uiData);
                writer.startElement("td", (UIComponent)uiData);
                int childCount = 0;
                Iterator childIter = uiData.getChildren().iterator();
                while (childIter.hasNext()) {
                    UIComponent childComp = (UIComponent)childIter.next();
                    if (childComp instanceof UIColumns) {
                        UIColumns v = (UIColumns)childComp;
                        childCount += v.getRowCount();
                        continue;
                    }
                    ++childCount;
                }
                writer.writeAttribute("colspan", (Object)new Integer(childCount), null);
            }
            if (detailStampFacet != null) {
                RendererUtils.renderChild(facesContext, detailStampFacet);
            }
            if (!embedded) {
                writer.endElement("td");
                writer.endElement("tr");
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (uiComponent instanceof HtmlDataTable) {
            HtmlDataTable htmlDataTable = (HtmlDataTable)uiComponent;
            if (htmlDataTable.isRenderedIfEmpty() || htmlDataTable.getRowCount() > 0) {
                super.encodeBegin(facesContext, uiComponent);
            }
        } else {
            super.encodeBegin(facesContext, uiComponent);
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof HtmlDataTable) {
            HtmlDataTable htmlDataTable = (HtmlDataTable)component;
            if (htmlDataTable.isRenderedIfEmpty() || htmlDataTable.getRowCount() > 0) {
                super.encodeChildren(facesContext, component);
            }
        } else {
            super.encodeChildren(facesContext, component);
        }
    }

    private boolean isGroupedTable(UIData uiData) {
        if (uiData instanceof HtmlDataTable) {
            List children = this.getChildren((UIComponent)uiData);
            int size = this.getChildCount((UIComponent)uiData);
            for (int j = 0; j < size; ++j) {
                HtmlSimpleColumn column;
                UIComponent child = (UIComponent)children.get(j);
                if (!(child instanceof HtmlSimpleColumn) || !(column = (HtmlSimpleColumn)child).isGroupBy()) continue;
                return true;
            }
        }
        return false;
    }

    protected void beforeBody(FacesContext facesContext, UIData uiData) throws IOException {
        if (this.isGroupedTable(uiData)) {
            this.createColumnInfos((HtmlDataTable)uiData, facesContext);
        }
        super.beforeBody(facesContext, uiData);
    }

    private void createColumnInfos(HtmlDataTable htmlDataTable, FacesContext facesContext) throws IOException {
        int first = htmlDataTable.getFirst();
        int rows = htmlDataTable.getRows();
        int currentRowSpan = -1;
        int currentRowInfoIndex = -1;
        TableContext tableContext = htmlDataTable.getTableContext();
        RowInfo rowInfo = null;
        ColumnInfo columnInfo = null;
        HtmlSimpleColumn currentColumn = null;
        HashMap groupHashTable = new HashMap();
        int last = rows <= 0 ? htmlDataTable.getRowCount() : first + rows;
        List children = this.getChildren((UIComponent)htmlDataTable);
        int nChildren = this.getChildCount((UIComponent)htmlDataTable);
        int size = nChildren;
        for (int j = 0; j < size; ++j) {
            UIComponent child = (UIComponent)children.get(j);
            if (!(child instanceof HtmlSimpleColumn) || !(currentColumn = (HtmlSimpleColumn)child).isGroupBy()) continue;
            groupHashTable.put(new Integer(j), null);
        }
        boolean groupEndReached = false;
        for (int rowIndex = first; last == -1 || rowIndex < last; ++rowIndex) {
            htmlDataTable.setRowIndex(rowIndex);
            rowInfo = new RowInfo();
            if (!htmlDataTable.isRowAvailable()) break;
            Set groupIndexList = groupHashTable.keySet();
            ArrayList<Object> currentColumnContent = null;
            Iterator it = groupIndexList.iterator();
            while (it.hasNext()) {
                currentColumnContent = new ArrayList<Object>();
                Integer currentIndex = (Integer)it.next();
                currentColumn = (HtmlSimpleColumn)children.get(currentIndex);
                if (currentColumn.isGroupByValueSet()) {
                    currentColumnContent.add(currentColumn.getGroupByValue());
                } else {
                    List currentColumnChildren = currentColumn.getChildren();
                    if (currentColumnChildren != null) {
                        this.collectChildrenValues(currentColumnContent, currentColumnChildren.iterator());
                    }
                }
                if (!this.isListEqual(currentColumnContent, (List)groupHashTable.get(currentIndex)) && currentRowInfoIndex > -1) {
                    groupEndReached = true;
                    groupHashTable.put(currentIndex, currentColumnContent);
                    continue;
                }
                if (currentRowInfoIndex != -1) continue;
                groupHashTable.put(currentIndex, currentColumnContent);
            }
            ++currentRowSpan;
            int size2 = nChildren;
            for (int j = 0; j < size2; ++j) {
                columnInfo = new ColumnInfo();
                if (groupHashTable.containsKey(new Integer(j))) {
                    if (currentRowSpan > 0) {
                        if (groupEndReached) {
                            ((ColumnInfo)((RowInfo)tableContext.getRowInfos().get(currentRowInfoIndex - currentRowSpan + 1)).getColumnInfos().get(j)).setRowSpan(currentRowSpan);
                            columnInfo.setStyle(htmlDataTable.getRowGroupStyle());
                            columnInfo.setStyleClass(htmlDataTable.getRowGroupStyleClass());
                        } else {
                            columnInfo.setRendered(false);
                        }
                    } else {
                        columnInfo.setStyle(htmlDataTable.getRowGroupStyle());
                        columnInfo.setStyleClass(htmlDataTable.getRowGroupStyleClass());
                    }
                } else if (groupEndReached) {
                    ((ColumnInfo)((RowInfo)tableContext.getRowInfos().get(currentRowInfoIndex)).getColumnInfos().get(j)).setStyle(htmlDataTable.getRowGroupStyle());
                    ((ColumnInfo)((RowInfo)tableContext.getRowInfos().get(currentRowInfoIndex)).getColumnInfos().get(j)).setStyleClass(htmlDataTable.getRowGroupStyleClass());
                }
                rowInfo.getColumnInfos().add(columnInfo);
            }
            if (groupEndReached) {
                currentRowSpan = 0;
                groupEndReached = false;
            }
            tableContext.getRowInfos().add(rowInfo);
            ++currentRowInfoIndex;
        }
        if (currentRowInfoIndex > -1) {
            int size3 = nChildren;
            for (int j = 0; j < size3; ++j) {
                if (groupHashTable.containsKey(new Integer(j))) {
                    ((ColumnInfo)((RowInfo)tableContext.getRowInfos().get(currentRowInfoIndex - currentRowSpan)).getColumnInfos().get(j)).setRowSpan(currentRowSpan + 1);
                    continue;
                }
                ((ColumnInfo)((RowInfo)tableContext.getRowInfos().get(currentRowInfoIndex)).getColumnInfos().get(j)).setStyle(htmlDataTable.getRowGroupStyle());
                ((ColumnInfo)((RowInfo)tableContext.getRowInfos().get(currentRowInfoIndex)).getColumnInfos().get(j)).setStyleClass(htmlDataTable.getRowGroupStyleClass());
            }
        }
        htmlDataTable.setRowIndex(-1);
    }

    protected void collectChildrenValues(List container, Iterator iterChildren) {
        while (iterChildren.hasNext()) {
            UIComponent child = (UIComponent)iterChildren.next();
            if (!child.isRendered()) continue;
            if (child instanceof ValueHolder) {
                Object value = ((ValueHolder)child).getValue();
                container.add(value);
            }
            this.collectChildrenValues(container, child.getFacetsAndChildren());
        }
    }

    protected boolean isListEqual(List list1, List list2) {
        if (list1 == list2) {
            return list1 != null && list1.size() > 0;
        }
        if (list1 == null || list2 == null || list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            Object o1 = list1.get(i);
            Object o2 = list2.get(i);
            if (o1 != null && !o1.equals(o2)) {
                return false;
            }
            if (o2 == null || o2.equals(o1)) continue;
            return false;
        }
        return true;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (uiComponent instanceof HtmlDataTable) {
            HtmlDataTable htmlDataTable = (HtmlDataTable)uiComponent;
            if (htmlDataTable.isRenderedIfEmpty() || htmlDataTable.getRowCount() > 0) {
                super.encodeEnd(facesContext, uiComponent);
            }
        } else {
            super.encodeEnd(facesContext, uiComponent);
        }
    }

    protected void renderRowStart(FacesContext facesContext, ResponseWriter writer, UIData uiData, HtmlTableRendererBase.Styles styles, int rowStyleIndex) throws IOException {
        super.renderRowStart(facesContext, writer, uiData, styles, rowStyleIndex);
        HtmlDataTable table = (HtmlDataTable)uiData;
        this.renderRowAttribute(writer, "onclick", table.getRowOnClick());
        this.renderRowAttribute(writer, "ondblclick", table.getRowOnDblClick());
        this.renderRowAttribute(writer, "onkeydown", table.getRowOnKeyDown());
        this.renderRowAttribute(writer, "onkeypress", table.getRowOnKeyPress());
        this.renderRowAttribute(writer, "onkeyup", table.getRowOnKeyUp());
        this.renderRowAttribute(writer, "onmousedown", table.getRowOnMouseDown());
        this.renderRowAttribute(writer, "onmousemove", table.getRowOnMouseMove());
        this.renderRowAttribute(writer, "onmouseout", table.getRowOnMouseOut());
        this.renderRowAttribute(writer, "onmouseover", table.getRowOnMouseOver());
        this.renderRowAttribute(writer, "onmouseup", table.getRowOnMouseUp());
    }

    protected void renderRowStyle(FacesContext facesContext, ResponseWriter writer, UIData uiData, HtmlTableRendererBase.Styles styles, int rowStyleIndex) throws IOException {
        String rowStyle;
        String rowStyleClass;
        if (uiData instanceof HtmlDataTable) {
            HtmlDataTable datatable = (HtmlDataTable)uiData;
            rowStyleClass = datatable.getRowStyleClass();
            rowStyle = datatable.getRowStyle();
        } else {
            rowStyleClass = (String)uiData.getAttributes().get("rowStyleClass");
            rowStyle = (String)uiData.getAttributes().get("rowStyle");
        }
        if (rowStyleClass == null) {
            super.renderRowStyle(facesContext, writer, uiData, styles, rowStyleIndex);
        } else {
            writer.writeAttribute("class", (Object)rowStyleClass, null);
        }
        if (rowStyle != null) {
            writer.writeAttribute("style", (Object)rowStyle, null);
        }
    }

    protected void renderRowAttribute(ResponseWriter writer, String htmlAttribute, Object value) throws IOException {
        if (value != null) {
            writer.writeAttribute(htmlAttribute, value, null);
        }
    }

    protected void encodeColumnChild(FacesContext facesContext, ResponseWriter writer, UIData uiData, UIComponent component, HtmlTableRendererBase.Styles styles, int columnStyleIndex) throws IOException {
        columnStyleIndex = this.getColumnStyleIndex(uiData, columnStyleIndex);
        super.encodeColumnChild(facesContext, writer, uiData, component, styles, columnStyleIndex);
        if (component instanceof UIColumns) {
            UIColumns columns = (UIColumns)component;
            int colSize = columns.getRowCount();
            for (int k = 0; k < colSize; ++k) {
                columns.setRowIndex(k);
                this.renderColumnBody(facesContext, writer, uiData, component, styles, columnStyleIndex + k);
            }
            columns.setRowIndex(-1);
        }
    }

    private int getColumnStyleIndex(UIData uiData, int columnStyleIndex) {
        int colStyleIndex = 0;
        for (int i = 0; i < columnStyleIndex; ++i) {
            UIComponent child = (UIComponent)uiData.getChildren().get(i % uiData.getChildCount());
            if (child instanceof UIColumns) {
                colStyleIndex += ((UIColumns)child).getRowCount();
                continue;
            }
            ++colStyleIndex;
        }
        return colStyleIndex;
    }

    protected void renderColumnBody(FacesContext facesContext, ResponseWriter writer, UIData uiData, UIComponent component, HtmlTableRendererBase.Styles styles, int columnStyleIndex) throws IOException {
        if (this.isGroupedTable(uiData)) {
            HtmlDataTable htmlDataTable = (HtmlDataTable)uiData;
            List tableChildren = htmlDataTable.getChildren();
            int first = htmlDataTable.getFirst();
            int rowInfoIndex = htmlDataTable.getRowIndex() - first;
            int columnInfoIndex = tableChildren.indexOf(component);
            RowInfo rowInfo = (RowInfo)htmlDataTable.getTableContext().getRowInfos().get(rowInfoIndex);
            ColumnInfo columnInfo = (ColumnInfo)rowInfo.getColumnInfos().get(columnInfoIndex);
            if (!columnInfo.isRendered()) {
                return;
            }
            if (component instanceof HtmlColumn && this.amISpannedOver(null, component)) {
                return;
            }
            writer.startElement("td", (UIComponent)uiData);
            String styleClass = null;
            if (component instanceof HtmlColumn) {
                styleClass = ((HtmlColumn)component).getStyleClass();
            }
            if (columnInfo.getStyleClass() != null) {
                styleClass = columnInfo.getStyleClass();
            }
            if (styles.hasColumnStyle() && styleClass == null) {
                styleClass = styles.getColumnStyle(columnStyleIndex);
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            if (columnInfo.getStyle() != null) {
                writer.writeAttribute("style", (Object)columnInfo.getStyle(), null);
            }
            if (columnInfo.getRowSpan() > 1) {
                writer.writeAttribute("rowspan", (Object)new Integer(columnInfo.getRowSpan()).toString(), null);
                if (columnInfo.getStyle() == null) {
                    writer.writeAttribute("style", (Object)"vertical-align:top", null);
                }
            }
            this.renderHtmlColumnAttributes(writer, component, null);
            RendererUtils.renderChild(facesContext, component);
            writer.endElement("td");
        } else if (component instanceof HtmlColumn) {
            if (this.amISpannedOver(null, component)) {
                return;
            }
            writer.startElement("td", (UIComponent)uiData);
            String styleClass = ((HtmlColumn)component).getStyleClass();
            if (styles.hasColumnStyle() && styleClass == null) {
                styleClass = styles.getColumnStyle(columnStyleIndex);
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            this.renderHtmlColumnAttributes(writer, component, null);
            RendererUtils.renderChild(facesContext, component);
            writer.endElement("td");
        } else {
            super.renderColumnBody(facesContext, writer, uiData, component, styles, columnStyleIndex);
        }
    }

    protected void renderColumnChildHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, String styleClass, boolean header) throws IOException {
        super.renderColumnChildHeaderOrFooterRow(facesContext, writer, uiComponent, styleClass, header);
        if (uiComponent instanceof UIColumns) {
            UIColumns columns = (UIColumns)uiComponent;
            int size = columns.getRowCount();
            for (int i = 0; i < size; ++i) {
                columns.setRowIndex(i);
                if (header) {
                    this.renderColumnHeaderCell(facesContext, writer, (UIComponent)columns, columns.getHeader(), styleClass, 0);
                    continue;
                }
                this.renderColumnFooterCell(facesContext, writer, (UIComponent)columns, columns.getFooter(), styleClass, 0);
            }
            columns.setRowIndex(-1);
        }
    }

    protected void renderColumnHeaderCell(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, UIComponent facet, String headerStyleClass, int colspan) throws IOException {
        if (uiComponent instanceof HtmlColumn) {
            String styleClass;
            HtmlColumn column = (HtmlColumn)uiComponent;
            if (this.amISpannedOver("header", uiComponent)) {
                return;
            }
            writer.startElement(this.determineHeaderCellTag(facesContext, uiComponent.getParent()), uiComponent);
            String columnId = column.getColumnId();
            if (columnId != null) {
                writer.writeAttribute("id", (Object)columnId, null);
            }
            if (colspan > 1) {
                writer.writeAttribute("colspan", (Object)new Integer(colspan), null);
            }
            if ((styleClass = ((HtmlColumn)uiComponent).getHeaderstyleClass()) == null) {
                styleClass = headerStyleClass;
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            this.renderHtmlColumnAttributes(writer, uiComponent, "header");
            if (facet != null) {
                RendererUtils.renderChild(facesContext, facet);
            }
            writer.endElement(this.determineHeaderCellTag(facesContext, uiComponent.getParent()));
        } else {
            super.renderColumnHeaderCell(facesContext, writer, uiComponent, facet, headerStyleClass, colspan);
        }
    }

    protected void renderColumnFooterCell(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, UIComponent facet, String footerStyleClass, int colspan) throws IOException {
        if (uiComponent instanceof HtmlColumn) {
            String styleClass;
            if (this.amISpannedOver("footer", uiComponent)) {
                return;
            }
            writer.startElement("td", uiComponent);
            if (colspan > 1) {
                writer.writeAttribute("colspan", (Object)new Integer(colspan), null);
            }
            if ((styleClass = ((HtmlColumn)uiComponent).getFooterstyleClass()) == null) {
                styleClass = footerStyleClass;
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            this.renderHtmlColumnAttributes(writer, uiComponent, "footer");
            if (facet != null) {
                RendererUtils.renderChild(facesContext, facet);
            }
            writer.endElement("td");
        } else {
            super.renderColumnFooterCell(facesContext, writer, uiComponent, facet, footerStyleClass, colspan);
        }
    }

    protected void renderHtmlColumnAttributes(ResponseWriter writer, UIComponent uiComponent, String prefix) throws IOException {
        String[] attrs = (String[])ArrayUtils.concat(HTML.COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_STYLE, new String[]{"colspan"});
        int size = attrs.length;
        for (int i = 0; i < size; ++i) {
            String attributeName = attrs[i];
            String compAttrName = prefix != null ? prefix + attributeName : attributeName;
            HtmlRendererUtils.renderHTMLAttribute(writer, uiComponent, compAttrName, attributeName);
        }
        String compAttrName = prefix != null ? prefix + "style" : "style";
        HtmlRendererUtils.renderHTMLAttribute(writer, uiComponent, compAttrName, "style");
        HtmlRendererUtils.renderHTMLAttribute(writer, uiComponent, "width", "width");
    }

    protected int determineChildColSpan(UIComponent uiComponent) {
        int result = super.determineChildColSpan(uiComponent);
        if (uiComponent instanceof UIColumns) {
            result += ((UIColumns)uiComponent).getRowCount();
        }
        return result;
    }

    protected boolean hasFacet(boolean header, UIComponent uiComponent) {
        boolean result = super.hasFacet(header, uiComponent);
        if (!result && uiComponent instanceof UIColumns) {
            UIColumns columns = (UIColumns)uiComponent;
            result = header ? columns.getHeader() != null : columns.getFooter() != null;
        }
        return result;
    }

    protected void renderColumnFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String footerStyleClass) throws IOException {
        if (this.determineRenderFacet(component, false)) {
            super.renderColumnFooterRow(facesContext, writer, component, footerStyleClass);
        }
    }

    protected void renderColumnHeaderRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String headerStyleClass) throws IOException {
        if (this.determineRenderFacet(component, true)) {
            super.renderColumnHeaderRow(facesContext, writer, component, headerStyleClass);
        }
    }

    protected boolean determineRenderFacet(UIComponent component, boolean header) {
        Iterator it = this.getChildren(component).iterator();
        while (it.hasNext()) {
            UIComponent facet;
            UIComponent uiComponent = (UIComponent)it.next();
            if (!uiComponent.isRendered() || this.determineChildColSpan(uiComponent) <= 0 || (facet = header ? (UIComponent)uiComponent.getFacets().get("header") : (UIComponent)uiComponent.getFacets().get("footer")) == null || !facet.isRendered()) continue;
            return true;
        }
        return false;
    }

    protected void beforeColumn(FacesContext facesContext, UIData uiData, int columnIndex) throws IOException {
        super.beforeColumn(facesContext, uiData, columnIndex);
        if (uiData instanceof HtmlDataTable) {
            HtmlDataTable dataTable = (HtmlDataTable)uiData;
            this.putSortedReqScopeParam(facesContext, dataTable, columnIndex);
        }
    }

    protected void beforeColumnHeaderOrFooter(FacesContext facesContext, UIData uiData, boolean header, int columnIndex) throws IOException {
        super.beforeColumnHeaderOrFooter(facesContext, uiData, header, columnIndex);
        if (header && uiData instanceof HtmlDataTable) {
            HtmlDataTable dataTable = (HtmlDataTable)uiData;
            this.putSortedReqScopeParam(facesContext, dataTable, columnIndex);
        }
    }

    protected void putSortedReqScopeParam(FacesContext facesContext, HtmlDataTable dataTable, int columnIndex) {
        String sortedColumnVar = dataTable.getSortedColumnVar();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        if (columnIndex == dataTable.getSortColumnIndex()) {
            if (sortedColumnVar != null) {
                requestMap.put(sortedColumnVar, Boolean.TRUE);
            }
        } else if (sortedColumnVar != null) {
            requestMap.remove(sortedColumnVar);
        }
    }

    protected boolean amISpannedOver(String prefix, UIComponent component) {
        UIComponent table = component.getParent();
        int span = 0;
        Iterator it = table.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent columnComponent = (UIComponent)it.next();
            if (!(columnComponent instanceof HtmlColumn)) continue;
            if (span > 0) {
                --span;
            }
            if (columnComponent == component) {
                return span > 0;
            }
            if (span != 0) continue;
            try {
                if (prefix == null && ((HtmlColumn)columnComponent).getColspan() != null) {
                    span = Integer.parseInt(((HtmlColumn)columnComponent).getColspan());
                }
                if ("header".equals(prefix) && ((HtmlColumn)columnComponent).getHeadercolspan() != null) {
                    span = Integer.parseInt(((HtmlColumn)columnComponent).getHeadercolspan());
                }
                if (!"footer".equals(prefix) || ((HtmlColumn)columnComponent).getFootercolspan() == null) continue;
                span = Integer.parseInt(((HtmlColumn)columnComponent).getFootercolspan());
            }
            catch (NumberFormatException ex) {
                log.warn((Object)("Invalid " + (prefix == null ? "" : prefix) + "colspan attribute ignored"));
            }
        }
        return false;
    }

    protected void inBodyStart(FacesContext facesContext, UIData uiData) throws IOException {
        String bodyStyle;
        String bodyStyleClass;
        if (uiData instanceof HtmlDataTable) {
            bodyStyleClass = ((HtmlDataTable)uiData).getBodyStyleClass();
            bodyStyle = ((HtmlDataTable)uiData).getBodyStyle();
        } else {
            bodyStyleClass = (String)uiData.getAttributes().get(BODY_STYLE_CLASS);
            bodyStyle = (String)uiData.getAttributes().get(BODY_STYLE);
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        if (bodyStyleClass != null) {
            writer.writeAttribute("class", (Object)bodyStyleClass, BODY_STYLE_CLASS);
        }
        if (bodyStyle != null) {
            writer.writeAttribute("style", (Object)bodyStyle, BODY_STYLE);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

