/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree2;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;
import javax.servlet.http.Cookie;
import org.apache.myfaces.custom.tree2.HtmlTree;
import org.apache.myfaces.custom.tree2.ToggleExpandedEvent;
import org.apache.myfaces.custom.tree2.TreeNode;
import org.apache.myfaces.custom.tree2.TreeState;
import org.apache.myfaces.custom.tree2.TreeWalker;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class HtmlTreeRenderer
extends Renderer {
    protected static final String TOGGLE_SPAN = "org.apache.myfaces.tree.TOGGLE_SPAN";
    protected static final String ROOT_NODE_ID = "0";
    private static final String NAV_COMMAND = "org.apache.myfaces.tree.NAV_COMMAND";
    private static final String ENCODING = "UTF-8";
    private static final String ATTRIB_DELIM = ";";
    private static final String ATTRIB_KEYVAL = "=";
    private static final String NODE_STATE_EXPANDED = "x";
    private static final String NODE_STATE_CLOSED = "c";
    private static final String SEPARATOR = String.valueOf(':');
    private static final String IMAGE_PREFIX = "t2";
    private static final String TOGGLE_ID = "t2g";
    private static final int NOTHING = 0;
    private static final int CHILDREN = 1;
    private static final int EXPANDED = 2;
    private static final int LINES = 4;
    private static final int LAST = 8;
    private int counter = 0;
    static /* synthetic */ Class class$org$apache$myfaces$custom$tree2$HtmlTreeRenderer;

    public boolean getRendersChildren() {
        return true;
    }

    private void restoreStateFromCookies(FacesContext context, UIComponent component) {
        String nodeId = null;
        HtmlTree tree = (HtmlTree)component;
        TreeState state = tree.getDataModel().getTreeState();
        Map cookieMap = context.getExternalContext().getRequestCookieMap();
        Cookie treeCookie = (Cookie)cookieMap.get(component.getId());
        if (treeCookie == null || treeCookie.getValue() == null) {
            return;
        }
        String nodeState = null;
        Map attrMap = this.getCookieAttr(treeCookie);
        Iterator i = attrMap.keySet().iterator();
        while (i.hasNext()) {
            nodeId = (String)i.next();
            nodeState = (String)attrMap.get(nodeId);
            if (NODE_STATE_EXPANDED.equals(nodeState)) {
                if (state.isNodeExpanded(nodeId)) continue;
                state.toggleExpanded(nodeId);
                continue;
            }
            if (!NODE_STATE_CLOSED.equals(nodeState) || !state.isNodeExpanded(nodeId)) continue;
            state.toggleExpanded(nodeId);
        }
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        String nodeId = null;
        HtmlTree tree = (HtmlTree)component;
        if (tree.isClientSideToggle() && tree.isPreserveToggle()) {
            this.restoreStateFromCookies(context, component);
        } else {
            nodeId = (String)context.getExternalContext().getRequestParameterMap().get(tree.getId() + SEPARATOR + NAV_COMMAND);
            if (nodeId == null || nodeId.equals("")) {
                return;
            }
            component.queueEvent((FacesEvent)new ToggleExpandedEvent(component, nodeId));
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.encodeJavascript(context, component);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        HtmlTree tree = (HtmlTree)component;
        if (!component.isRendered()) {
            return;
        }
        if (tree.getValue() == null) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        String clientId = null;
        if (component.getId() != null && !component.getId().startsWith("_id")) {
            clientId = component.getClientId(context);
        }
        boolean isOuterSpanUsed = false;
        if (clientId != null) {
            isOuterSpanUsed = true;
            out.startElement("span", component);
            out.writeAttribute("id", (Object)clientId, "id");
        }
        boolean clientSideToggle = tree.isClientSideToggle();
        boolean showRootNode = tree.isShowRootNode();
        TreeState state = tree.getDataModel().getTreeState();
        TreeWalker walker = tree.getDataModel().getTreeWalker();
        walker.reset();
        walker.setTree(tree);
        walker.setCheckState(!clientSideToggle);
        if (showRootNode) {
            if (walker.next()) {
                this.encodeTree(context, out, tree, walker);
            }
        } else {
            walker.next();
            TreeNode rootNode = tree.getNode();
            String rootNodeId = tree.getNodeId();
            if (!state.isNodeExpanded(rootNodeId)) {
                state.toggleExpanded(rootNodeId);
            }
            for (int i = 0; i < rootNode.getChildCount(); ++i) {
                if (!walker.next()) continue;
                this.encodeTree(context, out, tree, walker);
            }
        }
        tree.setNodeId(null);
        if (isOuterSpanUsed) {
            out.endElement("span");
        }
    }

    protected void encodeTree(FacesContext context, ResponseWriter out, HtmlTree tree, TreeWalker walker) throws IOException {
        boolean clientSideToggle = tree.isClientSideToggle();
        HtmlRendererUtils.writePrettyLineSeparator(context);
        this.beforeNodeEncode(context, out, tree);
        this.encodeCurrentNode(context, out, tree);
        this.afterNodeEncode(context, out);
        if (clientSideToggle) {
            String spanId = "org.apache.myfaces.tree.TOGGLE_SPAN:" + tree.getClientId(context) + ":" + tree.getNodeId();
            out.startElement("span", (UIComponent)tree);
            out.writeAttribute("id", (Object)spanId, null);
            if (tree.isNodeExpanded()) {
                out.writeAttribute("style", (Object)"display:block", null);
            } else {
                out.writeAttribute("style", (Object)"display:none", null);
            }
        }
        TreeNode node = tree.getNode();
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!walker.next()) continue;
            this.encodeTree(context, out, tree, walker);
        }
        if (clientSideToggle) {
            out.endElement("span");
        }
    }

    protected void encodeCurrentNode(FacesContext context, ResponseWriter out, HtmlTree tree) throws IOException {
        int i;
        TreeNode node = tree.getNode();
        boolean showRootNode = tree.isShowRootNode();
        boolean showNav = tree.isShowNav();
        boolean showLines = tree.isShowLines();
        boolean clientSideToggle = tree.isClientSideToggle();
        if (clientSideToggle) {
            showNav = true;
        }
        UIComponent nodeTypeFacet = tree.getFacet(node.getType());
        UIComponent nodeImgFacet = null;
        if (nodeTypeFacet == null) {
            throw new IllegalArgumentException("Unable to locate facet with the name: " + node.getType());
        }
        String[] pathInfo = tree.getPathInformation(tree.getNodeId());
        int paddingLevel = pathInfo.length - 1;
        int n = i = showRootNode ? 0 : 1;
        while (i < paddingLevel) {
            boolean lastChild = tree.isLastChild(pathInfo[i]);
            String lineSrc = !lastChild && showLines ? this.getImageSrc(context, (UIComponent)tree, "line-trunk.gif", true) : this.getImageSrc(context, (UIComponent)tree, "spacer.gif", true);
            String altString = !lastChild && showLines ? "line trunk" : "spacer";
            out.startElement("td", (UIComponent)tree);
            out.writeAttribute("width", (Object)"19", null);
            out.writeAttribute("height", (Object)"100%", null);
            out.writeAttribute("style", (Object)("background-image:" + lineSrc + ATTRIB_DELIM), null);
            out.startElement("img", (UIComponent)tree);
            out.writeURIAttribute("src", (Object)lineSrc, null);
            out.writeAttribute("width", (Object)"19", null);
            out.writeAttribute("height", (Object)"18", null);
            out.writeAttribute("border", (Object)ROOT_NODE_ID, null);
            out.writeAttribute("alt", (Object)altString, null);
            out.endElement("img");
            out.endElement("td");
            ++i;
        }
        if (showNav) {
            nodeImgFacet = this.encodeNavigation(context, out, tree);
        }
        out.startElement("td", (UIComponent)tree);
        if (nodeImgFacet != null) {
            RendererUtils.renderChild(context, nodeImgFacet);
        }
        RendererUtils.renderChild(context, nodeTypeFacet);
        out.endElement("td");
    }

    protected void beforeNodeEncode(FacesContext context, ResponseWriter out, HtmlTree tree) throws IOException {
        out.startElement("table", (UIComponent)tree);
        out.writeAttribute("cellpadding", (Object)ROOT_NODE_ID, null);
        out.writeAttribute("cellspacing", (Object)ROOT_NODE_ID, null);
        out.writeAttribute("border", (Object)ROOT_NODE_ID, null);
        out.startElement("tr", (UIComponent)tree);
    }

    protected void afterNodeEncode(FacesContext context, ResponseWriter out) throws IOException {
        out.endElement("tr");
        out.endElement("table");
    }

    private UIComponent encodeNavigation(FacesContext context, ResponseWriter out, HtmlTree tree) throws IOException {
        TreeNode node = tree.getNode();
        String nodeId = tree.getNodeId();
        String spanId = "org.apache.myfaces.tree.TOGGLE_SPAN:" + tree.getClientId(context) + ":" + nodeId;
        boolean showLines = tree.isShowLines();
        boolean clientSideToggle = tree.isClientSideToggle();
        UIComponent nodeTypeFacet = tree.getFacet(node.getType());
        String navSrc = null;
        String altSrc = null;
        UIComponent nodeImgFacet = null;
        int bitMask = 0;
        if ((bitMask += node.isLeaf() ? 0 : 1) == 1) {
            bitMask += tree.isNodeExpanded() ? 2 : 0;
        }
        bitMask += tree.isLastChild(tree.getNodeId()) ? 8 : 0;
        switch (bitMask += showLines ? 4 : 0) {
            case 0: 
            case 8: {
                navSrc = "spacer.gif";
                break;
            }
            case 4: {
                navSrc = "line-middle.gif";
                break;
            }
            case 12: {
                navSrc = "line-last.gif";
                break;
            }
            case 1: 
            case 9: {
                navSrc = "nav-plus.gif";
                altSrc = "nav-minus.gif";
                break;
            }
            case 5: {
                navSrc = "nav-plus-line-middle.gif";
                altSrc = "nav-minus-line-middle.gif";
                break;
            }
            case 13: {
                navSrc = "nav-plus-line-last.gif";
                altSrc = "nav-minus-line-last.gif";
                break;
            }
            case 3: 
            case 11: {
                navSrc = "nav-minus.gif";
                altSrc = "nav-plus.gif";
                break;
            }
            case 7: {
                navSrc = "nav-minus-line-middle.gif";
                altSrc = "nav-plus-line-middle.gif";
                break;
            }
            case 15: {
                navSrc = "nav-minus-line-last.gif";
                altSrc = "nav-plus-line-last.gif";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                throw new IllegalStateException("Encountered a node [" + nodeId + "] + with an illogical state.  " + "Node is expanded but it is also considered a leaf (a leaf cannot be considered expanded.");
            }
            default: {
                throw new IllegalArgumentException("Invalid bit mask of " + bitMask);
            }
        }
        String navSrcUrl = this.getImageSrc(context, (UIComponent)tree, navSrc, false);
        navSrc = this.getImageSrc(context, (UIComponent)tree, navSrc, true);
        altSrc = this.getImageSrc(context, (UIComponent)tree, altSrc, true);
        out.startElement("td", (UIComponent)tree);
        out.writeAttribute("width", (Object)"19", null);
        out.writeAttribute("height", (Object)"100%", null);
        out.writeAttribute("valign", (Object)"top", null);
        if ((bitMask & 4) != 0 && (bitMask & 8) == 0) {
            out.writeURIAttribute("style", (Object)("background-image:" + this.getImageSrc(context, (UIComponent)tree, "line-trunk.gif", true) + ATTRIB_DELIM), null);
        }
        UIGraphic image = new UIGraphic();
        String imageId = IMAGE_PREFIX + this.counter++;
        image.setId(imageId);
        image.setUrl(navSrcUrl);
        Map imageAttrs = image.getAttributes();
        imageAttrs.put("width", "19");
        imageAttrs.put("height", "18");
        imageAttrs.put("border", ROOT_NODE_ID);
        imageAttrs.put("alt", "Nav control image");
        if (clientSideToggle) {
            UIComponent collapseFacet;
            String expandImgSrc = "";
            String collapseImgSrc = "";
            String nodeImageId = "";
            UIComponent expandFacet = nodeTypeFacet.getFacet("expand");
            if (expandFacet != null) {
                UIGraphic expandImg = (UIGraphic)expandFacet;
                expandImgSrc = context.getApplication().getViewHandler().getResourceURL(context, expandImg.getUrl());
                if (expandImg.isRendered()) {
                    expandImg.setId(imageId + NODE_STATE_EXPANDED);
                    expandImg.setParent((UIComponent)tree);
                    nodeImageId = expandImg.getClientId(context);
                    nodeImgFacet = expandFacet;
                }
            }
            if ((collapseFacet = nodeTypeFacet.getFacet("collapse")) != null) {
                UIGraphic collapseImg = (UIGraphic)collapseFacet;
                collapseImgSrc = context.getApplication().getViewHandler().getResourceURL(context, collapseImg.getUrl());
                if (collapseImg.isRendered()) {
                    collapseImg.setId(imageId + NODE_STATE_CLOSED);
                    collapseImg.setParent((UIComponent)tree);
                    nodeImageId = collapseImg.getClientId(context);
                    nodeImgFacet = collapseFacet;
                }
            }
            image.setParent((UIComponent)tree);
            if (node.getChildCount() > 0) {
                String onClick = "treeNavClick('" + spanId + "', '" + image.getClientId(context) + "', '" + navSrc + "', '" + altSrc + "', '" + nodeImageId + "', '" + expandImgSrc + "', '" + collapseImgSrc + "', '" + tree.getId() + "', '" + nodeId + "');";
                imageAttrs.put("onclick", onClick);
                imageAttrs.put("style", "cursor:hand;cursor:pointer");
            }
            RendererUtils.renderChild(context, (UIComponent)image);
        } else if (node.getChildCount() > 0) {
            UICommand expandControl = tree.getExpandControl();
            expandControl.getChildren().clear();
            expandControl.setId(TOGGLE_ID);
            UIParameter param = new UIParameter();
            param.setName(tree.getId() + ':' + NAV_COMMAND);
            param.setValue((Object)tree.getNodeId());
            expandControl.getChildren().add(param);
            expandControl.getChildren().add(image);
            RendererUtils.renderChild(context, (UIComponent)expandControl);
        } else {
            RendererUtils.renderChild(context, (UIComponent)image);
        }
        out.endElement("td");
        return nodeImgFacet;
    }

    private void encodeJavascript(FacesContext context, UIComponent component) throws IOException {
        String javascriptLocation = ((HtmlTree)component).getJavascriptLocation();
        AddResource addResource = AddResourceFactory.getInstance(context);
        if (javascriptLocation == null) {
            addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$tree2$HtmlTreeRenderer == null ? (class$org$apache$myfaces$custom$tree2$HtmlTreeRenderer = HtmlTreeRenderer.class$("org.apache.myfaces.custom.tree2.HtmlTreeRenderer")) : class$org$apache$myfaces$custom$tree2$HtmlTreeRenderer, "javascript/tree.js");
            addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$tree2$HtmlTreeRenderer == null ? (class$org$apache$myfaces$custom$tree2$HtmlTreeRenderer = HtmlTreeRenderer.class$("org.apache.myfaces.custom.tree2.HtmlTreeRenderer")) : class$org$apache$myfaces$custom$tree2$HtmlTreeRenderer, "javascript/cookielib.js");
        } else {
            addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, javascriptLocation + "/tree.js");
            addResource.addJavaScriptAtPosition(context, AddResource.HEADER_BEGIN, javascriptLocation + "/cookielib.js");
        }
    }

    private String getImageSrc(FacesContext context, UIComponent component, String imageName, boolean withContextPath) {
        String imageLocation = ((HtmlTree)component).getImageLocation();
        AddResource addResource = AddResourceFactory.getInstance(context);
        if (imageLocation == null) {
            return addResource.getResourceUri(context, class$org$apache$myfaces$custom$tree2$HtmlTreeRenderer == null ? (class$org$apache$myfaces$custom$tree2$HtmlTreeRenderer = HtmlTreeRenderer.class$("org.apache.myfaces.custom.tree2.HtmlTreeRenderer")) : class$org$apache$myfaces$custom$tree2$HtmlTreeRenderer, "images/" + imageName, withContextPath);
        }
        return addResource.getResourceUri(context, imageLocation + "/" + imageName, withContextPath);
    }

    protected boolean getBoolean(UIComponent component, String attributeName, boolean defaultValue) {
        Boolean booleanAttr = (Boolean)component.getAttributes().get(attributeName);
        if (booleanAttr == null) {
            return defaultValue;
        }
        return booleanAttr;
    }

    private Map getCookieAttr(Cookie cookie) {
        HashMap<String, String> attribMap = new HashMap<String, String>();
        try {
            String cookieValue = URLDecoder.decode(cookie.getValue(), ENCODING);
            String[] attribArray = cookieValue.split(ATTRIB_DELIM);
            for (int j = 0; j < attribArray.length; ++j) {
                int index = attribArray[j].indexOf(ATTRIB_KEYVAL);
                String name = attribArray[j].substring(0, index);
                String value = attribArray[j].substring(index + 1);
                attribMap.put(name, value);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error parsing tree cookies", e);
        }
        return attribMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

